# API設計書

## 概要

本ドキュメントは、LEGACY CMS（バージョン2.1）の管理画面用Web APIの仕様を定義しています。このシステムはZend Framework 1.xベースのMVCアーキテクチャを採用しており、コンテンツ管理、ユーザー管理、アセット管理、メール管理等の機能を提供します。

## 共通仕様

### ベースURL

```
/admin/{controller}/{action}
```

### 認証方式

セッションベースの認証を採用しています。ログイン後にセッションが生成され、以降のリクエストではセッションCookieによる認証が行われます。

### 共通ヘッダー

| ヘッダー名 | 必須 | 説明 |
| --- | --- | --- |
| Cookie | ○ | セッションID（PHPSESSID） |
| Content-Type | 条件付き | POST時は `application/x-www-form-urlencoded` |
| Accept | - | text/html（レスポンスはHTML形式） |

### 共通エラーレスポンス

| ステータスコード | 説明 |
| --- | --- |
| 302 | Found - 未認証時にログインページへリダイレクト |
| 403 | Forbidden - 権限エラー（privileges errorページへフォワード） |
| 404 | Not Found - リソース未検出 |
| 500 | Internal Server Error - サーバーエラー |

### 権限システム（ACL）

本システムはACL（Access Control List）ベースの権限管理を採用しています。各APIエンドポイントへのアクセスには対応する権限が必要です。

| 権限コード | 説明 |
| --- | --- |
| gadmin | 管理画面基本アクセス |
| carticles | 記事管理 |
| carticlenew | 記事新規作成 |
| carticleedit | 記事編集 |
| carticlepublish | 記事公開 |
| carticledelete | 記事削除 |
| cpages | ページ管理 |
| cpagenew | ページ新規作成 |
| cpageedit | ページ編集 |
| cpagepublish | ページ公開 |
| cpagedelete | ページ削除 |
| uusers | ユーザー管理 |
| uview | ユーザー閲覧 |
| uusernew | ユーザー新規作成 |
| uuseredit | ユーザー編集 |
| uuserdelete | ユーザー削除 |
| fassets | アセット管理 |
| fassetupload | アセットアップロード |
| fassetedit | アセット編集 |
| fassetdelete | アセット削除 |
| ffoldernew | フォルダ新規作成 |
| ffolderedit | フォルダ編集 |
| ffolderdelete | フォルダ削除 |
| mmail | メール管理 |
| mmailnew | メール新規作成 |
| mmailedit | メール編集 |
| mmailsend | メール送信 |
| mmaildelete | メール削除 |
| mlistedit | メーリングリスト編集 |
| mlistnew | メーリングリスト新規作成 |
| mlistdelete | メーリングリスト削除 |
| mlistpublish | メーリングリスト公開 |
| ccomments | コメント管理 |
| ccommentpublish | コメント承認 |
| ccommentdelete | コメント削除 |

## API一覧

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| 認証 | /admin/auth/login | GET/POST | ログイン |
| 認証 | /admin/auth/logout | GET | ログアウト |
| 認証 | /admin/auth/forgot | GET/POST | パスワードリセット |
| 記事 | /admin/articles/index | GET | 記事管理ダッシュボード |
| 記事 | /admin/articles/manage | GET | 記事一覧取得 |
| 記事 | /admin/articles/new | GET/POST | 記事新規作成 |
| 記事 | /admin/articles/edit | GET | 記事編集画面 |
| 記事 | /admin/articles/save | POST | 記事保存 |
| 記事 | /admin/articles/publish | POST | 記事公開 |
| 記事 | /admin/articles/delete | POST | 記事削除 |
| 記事 | /admin/articles/category | GET | カテゴリ編集 |
| 記事 | /admin/articles/categorysave | POST | カテゴリ保存 |
| 記事 | /admin/articles/categorydelete | POST | カテゴリ削除 |
| 記事 | /admin/articles/categorynew | POST | カテゴリ新規作成 |
| ページ | /admin/pages/index | GET | ページ管理ダッシュボード |
| ページ | /admin/pages/manage | GET | ページ一覧取得 |
| ページ | /admin/pages/new | GET/POST | ページ新規作成 |
| ページ | /admin/pages/edit | GET | ページ編集画面 |
| ページ | /admin/pages/save | POST | ページ保存 |
| ページ | /admin/pages/publish | POST | ページ公開 |
| ページ | /admin/pages/delete | POST | ページ削除 |
| ユーザー | /admin/users/index | GET | ユーザー管理ダッシュボード |
| ユーザー | /admin/users/manage | GET | ユーザー一覧取得 |
| ユーザー | /admin/users/view | GET | ユーザー詳細 |
| ユーザー | /admin/users/new | GET/POST | ユーザー新規作成 |
| ユーザー | /admin/users/save | POST | ユーザー保存 |
| ユーザー | /admin/users/delete | POST | ユーザー削除 |
| ユーザー | /admin/users/password | POST | パスワード変更 |
| アセット | /admin/assets/index | GET | アセット一覧（フォルダブラウズ） |
| アセット | /admin/assets/upload | GET | アップロード画面 |
| アセット | /admin/assets/receive | POST | ファイルアップロード処理 |
| アセット | /admin/assets/download | GET | アセットダウンロード |
| アセット | /admin/assets/open | GET | アセット表示（インライン） |
| アセット | /admin/assets/thumb | GET | サムネイル生成・取得 |
| アセット | /admin/assets/asset | GET/POST | アセット編集 |
| アセット | /admin/assets/delete | POST | アセット削除 |
| アセット | /admin/assets/properties | GET | アセットプロパティ |
| アセット | /admin/assets/foldernew | POST | フォルダ新規作成 |
| アセット | /admin/assets/folder | GET/POST | フォルダ編集 |
| アセット | /admin/assets/folderdelete | POST | フォルダ削除 |
| アセット | /admin/assets/folderproperties | GET | フォルダプロパティ |
| アセット | /admin/assets/imageinsert | GET | 画像挿入（エディタ用） |
| アセット | /admin/assets/imagepreview | GET | 画像プレビュー |
| アセット | /admin/assets/thumbpreview | GET | サムネイルプレビュー |
| アセット | /admin/assets/linkinsert | GET | リンク挿入（エディタ用） |
| メール | /admin/mail/manage | GET | メール一覧 |
| メール | /admin/mail/edit | GET | メール編集 |
| メール | /admin/mail/save | POST | メール保存 |
| メール | /admin/mail/delete | POST | メール削除 |
| メール | /admin/mail/maillist | POST | メーリングリストへのメール作成 |
| メール | /admin/mail/mailrole | POST | ロールへのメール作成 |
| メール | /admin/mail/mailuser | POST | ユーザーへのメール作成 |
| メール | /admin/mail/sendtest | POST | テストメール送信 |
| メール | /admin/mail/send | POST | メール送信 |
| メール | /admin/mail/group | GET | メーリングリスト編集 |
| メール | /admin/mail/groupsave | POST | メーリングリスト保存 |
| メール | /admin/mail/groupdelete | POST | メーリングリスト削除 |
| メール | /admin/mail/grouppublish | POST | メーリングリスト公開 |
| メール | /admin/mail/groupnew | POST | メーリングリスト新規作成 |
| コメント | /admin/comments/manage | GET | コメント一覧 |
| コメント | /admin/comments/publish | POST | コメント承認 |
| コメント | /admin/comments/delete | POST | コメント削除 |
| タグ | /admin/tags/show | GET | タグ一覧 |
| タグ | /admin/tags/new | POST | タグ追加 |
| タグ | /admin/tags/delete | POST | タグ削除 |
| タグ | /admin/tags/tab | GET | タグタブ情報 |
| 添付 | /admin/attachments/show | GET | 添付ファイル一覧 |
| 添付 | /admin/attachments/new | POST | 添付ファイル追加 |
| 添付 | /admin/attachments/delete | POST | 添付ファイル削除 |
| 添付 | /admin/attachments/tab | GET | 添付タブ情報 |
| イベント | /admin/events/manage | GET | イベント一覧 |
| イベント | /admin/events/new | GET/POST | イベント新規作成 |
| イベント | /admin/events/edit | GET | イベント編集 |
| イベント | /admin/events/save | POST | イベント保存 |
| イベント | /admin/events/delete | POST | イベント削除 |
| イベント | /admin/events/publish | POST | イベント公開 |
| 設定 | /admin/settings/index | GET | 設定画面 |
| 設定 | /admin/settings/profile | POST | プロフィール更新 |
| 設定 | /admin/settings/password | POST | パスワード変更 |
| 設定 | /admin/settings/details | GET | ユーザー詳細 |

## 各APIエンドポイント定義

### 認証

#### 1. ログイン

ユーザー認証を行い、セッションを開始します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET/POST /admin/auth/login` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ（POST）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| username | string | ○ | NotEmpty | ユーザー名またはメールアドレス |
| password | string | ○ | NotEmpty | パスワード |

**レスポンス（成功時）**

ステータスコード: `302 Found`

ダッシュボードページへリダイレクト

**レスポンス（エラー時）**

ログインページに戻り、エラーメッセージを表示

#### 2. ログアウト

現在のセッションを終了します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/auth/logout` |
| 認証 | 必要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `302 Found`

ログインページへリダイレクト

#### 3. パスワードリセット

パスワードリセットメールを送信します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET/POST /admin/auth/forgot` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ（POST）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| email | string | ○ | EmailAddress | 登録済みメールアドレス |

**レスポンス（成功時）**

パスワードリセットメールが送信され、確認メッセージを表示

---

### 記事管理

#### 4. 記事一覧取得

記事の一覧を取得します。ページネーション、フィルタリング機能付き。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/articles/manage` |
| 認証 | 必要 |
| 権限 | carticles |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| page | integer | - | 1 | ページ番号 |
| items | integer | - | 15 | 1ページあたりの表示件数 |
| range | integer | - | 5 | ページネーションの範囲 |
| status | string | - | - | ステータスフィルタ |
| category | integer | - | - | カテゴリフィルタ |
| author | integer | - | - | 著者フィルタ |

**レスポンス（成功時）**

HTML形式の記事一覧ページ

#### 5. 記事新規作成

新規記事を作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET/POST /admin/articles/new` |
| 認証 | 必要 |
| 権限 | carticles, carticlenew |

**リクエストボディ（POST）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| title | string | ○ | NotEmpty | 記事タイトル |
| category | integer | ○ | NotEmpty | カテゴリID |
| image | string | - | - | メイン画像キー |
| summary | string | - | - | 要約（HTML可） |
| body | string | - | - | 本文（HTML可） |

**レスポンス（成功時）**

記事編集ページへリダイレクト

#### 6. 記事保存

既存記事を更新します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/articles/save` |
| 認証 | 必要 |
| 権限 | carticles, carticleedit |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| id | integer | ○ | - | 記事ID |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| title | string | ○ | NotEmpty | 記事タイトル |
| alias | string | ○ | NotEmpty, Alnum | URL用エイリアス |
| category | integer | ○ | NotEmpty | カテゴリID |
| image | string | - | - | メイン画像キー |
| summary | string | - | - | 要約（HTML可） |
| body | string | - | - | 本文（HTML可） |

**レスポンス（成功時）**

HTML形式のダイアログ（「Article Saved」メッセージ）

#### 7. 記事公開

記事を公開状態に変更します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/articles/publish` |
| 認証 | 必要 |
| 権限 | carticles, carticlepublish |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| id | integer | ○ | - | 記事ID |
| confirm | integer | ○ | - | 確認フラグ（1で実行） |

**レスポンス（成功時）**

HTML形式のダイアログ（「Article Published」メッセージ）

#### 8. 記事削除

記事を削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/articles/delete` |
| 認証 | 必要 |
| 権限 | carticles, carticledelete |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| id | integer | ○ | - | 記事ID |
| confirm | integer | ○ | - | 確認フラグ（1で実行） |

**レスポンス（成功時）**

HTML形式のダイアログ（「Article Deleted」メッセージ）

#### 9. カテゴリ新規作成

記事カテゴリを新規作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/articles/categorynew` |
| 認証 | 必要 |
| 権限 | carticles, ccategorynew |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| categorytitle | string | ○ | NotEmpty, Alnum | カテゴリ名 |

**レスポンス（成功時）**

HTML形式のダイアログ（「Category Created」メッセージ）

---

### ユーザー管理

#### 10. ユーザー一覧取得

ユーザーの一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/users/manage` |
| 認証 | 必要 |
| 権限 | uusers |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| page | integer | - | 1 | ページ番号 |
| items | integer | - | 15 | 1ページあたりの表示件数 |
| range | integer | - | 5 | ページネーションの範囲 |
| status | string | - | - | ステータスフィルタ |
| role | integer | - | - | ロールフィルタ |

**レスポンス（成功時）**

HTML形式のユーザー一覧ページ

#### 11. ユーザー新規作成

新規ユーザーを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET/POST /admin/users/new` |
| 認証 | 必要 |
| 権限 | uusers, uusernew |

**リクエストボディ（POST）**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| first | string | ○ | NotEmpty | 名 |
| last | string | ○ | NotEmpty | 姓 |
| alias | string | ○ | NotEmpty, Alnum, NoRecordExists | ユーザー名 |
| email | string | ○ | NotEmpty, EmailAddress, NoRecordExists | メールアドレス |
| password | string | ○ | NotEmpty, StringLength(8) | パスワード（8文字以上） |
| password2 | string | ○ | Identical(password) | パスワード確認 |
| role | integer | ○ | NotEmpty | ロールID |
| format | string | - | - | メール形式（text/html） |

**レスポンス（成功時）**

ユーザー編集ページへリダイレクト

#### 12. ユーザー保存

既存ユーザーを更新します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/users/save` |
| 認証 | 必要 |
| 権限 | uusers, uuseredit |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| id | integer | ○ | - | ユーザーID |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| first | string | ○ | NotEmpty | 名 |
| last | string | ○ | NotEmpty | 姓 |
| alias | string | ○ | NotEmpty, Alnum, NoRecordExists | ユーザー名 |
| email | string | ○ | NotEmpty, EmailAddress, NoRecordExists | メールアドレス |
| role | integer | ○ | NotEmpty | ロールID |
| phone | string | - | - | 電話番号 |
| blurb | string | - | - | 自己紹介 |

**レスポンス（成功時）**

HTML形式のダイアログ（「User Saved」メッセージ）

#### 13. ユーザー削除

ユーザーを削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/users/delete` |
| 認証 | 必要 |
| 権限 | uusers, uuserdelete |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| id | integer | ○ | - | ユーザーID |
| confirm | integer | ○ | - | 確認フラグ（1で実行） |

**レスポンス（成功時）**

HTML形式のダイアログ（「User Deleted」メッセージ）

#### 14. パスワード変更（ユーザー管理者用）

指定ユーザーのパスワードを変更します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/users/password` |
| 認証 | 必要 |
| 権限 | uusers, uuseredit |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| id | integer | ○ | - | ユーザーID |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| password | string | ○ | NotEmpty, StringLength(8) | 新パスワード（8文字以上） |
| password2 | string | ○ | Identical(password) | パスワード確認 |

**レスポンス（成功時）**

HTML形式のダイアログ（「Password Changed」メッセージ）

---

### アセット管理

#### 15. アセット一覧（フォルダブラウズ）

指定フォルダ内のアセットとサブフォルダを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/assets/index` |
| 認証 | 必要 |
| 権限 | fassets |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| folder | integer | - | 0 | フォルダID（0=ルート） |
| type | string | - | - | アセットタイプフィルタ |
| method | string | - | - | 選択方式 |
| field | string | - | - | 対象フィールド名 |

**レスポンス（成功時）**

HTML形式のアセットブラウザページ

#### 16. ファイルアップロード

ファイルをアップロードします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/assets/receive` |
| 認証 | 必要 |
| 権限 | fassets, fassetupload |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| folder | integer | - | 0 | アップロード先フォルダID |

**リクエストボディ（multipart/form-data）**

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| Filedata | file | ○ | アップロードファイル |

**レスポンス（成功時）**

```
1
```

**レスポンス（エラー時）**

```
0
```

#### 17. アセットダウンロード

アセットをダウンロードします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/assets/download` |
| 認証 | 必要 |
| 権限 | fassets |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| key | string | ○ | - | アセットキー（MD5ハッシュ） |

**レスポンス（成功時）**

バイナリデータ（Content-Disposition: attachment）

#### 18. サムネイル取得

画像のサムネイルを生成・取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/assets/thumb` |
| 認証 | 必要 |
| 権限 | fassets |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| key | string | ○ | - | アセットキー |
| width | integer | ○ | - | サムネイル幅 |
| height | integer | ○ | - | サムネイル高さ |
| type | string | - | adaptive | リサイズタイプ（adaptive/resize） |

**レスポンス（成功時）**

画像バイナリデータ（Content-Type: image/xxx）

#### 19. アセット削除

アセットを削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/assets/delete` |
| 認証 | 必要 |
| 権限 | fassets, fassetdelete |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| id | integer | ○ | - | アセットID |
| confirm | integer | ○ | - | 確認フラグ（1で実行） |

**レスポンス（成功時）**

HTML形式のダイアログ（「Asset Deleted」メッセージ）

#### 20. フォルダ新規作成

新規フォルダを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/assets/foldernew` |
| 認証 | 必要 |
| 権限 | fassets, ffoldernew |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| parent | integer | ○ | - | 親フォルダID |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| foldertitle | string | ○ | NotEmpty | フォルダ名 |

**レスポンス（成功時）**

HTML形式のダイアログ（「Folder Created」メッセージ）

#### 21. フォルダ削除

フォルダを削除します（空のフォルダのみ削除可能）。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/assets/folderdelete` |
| 認証 | 必要 |
| 権限 | fassets, ffolderdelete |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| folder | integer | ○ | - | フォルダID |
| confirm | integer | ○ | - | 確認フラグ（1で実行） |

**レスポンス（成功時）**

HTML形式のダイアログ（「Folder Deleted」メッセージ）

**レスポンス（エラー時）**

HTML形式のダイアログ（「Folders With Contents Cannot Be Deleted」メッセージ）

---

### メール管理

#### 22. メール一覧

メールの一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/mail/manage` |
| 認証 | 必要 |
| 権限 | mmail |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| page | integer | - | 1 | ページ番号 |
| items | integer | - | 15 | 1ページあたりの表示件数 |
| range | integer | - | 5 | ページネーションの範囲 |

**レスポンス（成功時）**

HTML形式のメール一覧ページ

#### 23. メール保存

メールを保存します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/mail/save` |
| 認証 | 必要 |
| 権限 | mmail, mmailedit |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| id | integer | ○ | - | メールID |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| slave | integer | ○ | NotEmpty | 送信先ID |
| subject | string | ○ | NotEmpty | 件名 |
| text | string | - | - | テキスト本文 |
| html | string | - | - | HTML本文 |

**レスポンス（成功時）**

HTML形式のダイアログ（「Mail Saved」メッセージ）

#### 24. メール送信

メールを送信します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/mail/send` |
| 認証 | 必要 |
| 権限 | mmail, mmailsend |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| id | integer | ○ | - | メールID |
| confirm | integer | ○ | - | 確認フラグ（1で実行） |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| slave | integer | ○ | NotEmpty | 送信先ID |
| subject | string | ○ | NotEmpty | 件名 |
| text | string | - | - | テキスト本文 |
| html | string | - | - | HTML本文 |

**レスポンス（成功時）**

HTML形式のダイアログ（「Mail Sent」メッセージ）

#### 25. メーリングリスト新規作成

メーリングリストを新規作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/mail/groupnew` |
| 認証 | 必要 |
| 権限 | mmail, mlistnew |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| grouptitle | string | ○ | NotEmpty, Alnum, NoRecordExists | リスト名 |
| groupopen | string | ○ | NotEmpty | 公開タイプ（Y/N） |

**レスポンス（成功時）**

HTML形式のダイアログ（「Mailing List Created」メッセージ）

---

### タグ管理

#### 26. タグ一覧

指定コンテンツに紐づくタグ一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/tags/show` |
| 認証 | 必要 |
| 権限 | なし（コンテンツ権限に依存） |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| slave | integer | ○ | - | コンテンツID |
| type | string | ○ | - | コンテンツタイプ（A=記事, P=ページ等） |
| status | string | - | - | 編集可否ステータス |

**レスポンス（成功時）**

HTML形式のタグリスト

#### 27. タグ追加

コンテンツにタグを追加します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/tags/new` |
| 認証 | 必要 |
| 権限 | なし（コンテンツ権限に依存） |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| tag | string | ○ | NotEmpty, Alnum | タグ名 |
| type | string | ○ | NotEmpty | コンテンツタイプ |
| slave | integer | ○ | NotEmpty | コンテンツID |

**レスポンス（成功時）**

HTML形式のダイアログ（「Tag Added」メッセージ）

**レスポンス（エラー時）**

HTML形式のダイアログ（「Duplicate Tag」メッセージ - 重複時）

---

### 添付ファイル管理

#### 28. 添付ファイル一覧

指定コンテンツに紐づく添付ファイル一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/attachments/show` |
| 認証 | 必要 |
| 権限 | なし（コンテンツ権限に依存） |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| slave | integer | ○ | - | コンテンツID |
| type | string | ○ | - | コンテンツタイプ |
| status | string | - | - | 編集可否ステータス |

**レスポンス（成功時）**

HTML形式の添付ファイルリスト

#### 29. 添付ファイル追加

コンテンツに添付ファイルを追加します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/attachments/new` |
| 認証 | 必要 |
| 権限 | なし（コンテンツ権限に依存） |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| asset | string | ○ | NotEmpty | アセットキー |
| type | string | ○ | NotEmpty | コンテンツタイプ |
| slave | integer | ○ | NotEmpty | コンテンツID |

**レスポンス（成功時）**

HTML形式のダイアログ（「Attachment Added」メッセージ）

---

### 設定

#### 30. プロフィール更新

ログインユーザーのプロフィールを更新します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/settings/profile` |
| 認証 | 必要 |
| 権限 | gadmin |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| first | string | ○ | NotEmpty | 名 |
| last | string | ○ | NotEmpty | 姓 |
| alias | string | ○ | NotEmpty, Alnum, NoRecordExists | ユーザー名 |
| email | string | ○ | NotEmpty, EmailAddress, NoRecordExists | メールアドレス |
| phone | string | - | - | 電話番号 |
| blurb | string | - | - | 自己紹介 |

**レスポンス（成功時）**

HTML形式のダイアログ（「Profile Updated」メッセージ）

#### 31. パスワード変更（自分用）

ログインユーザーのパスワードを変更します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/settings/password` |
| 認証 | 必要 |
| 権限 | gadmin |

**リクエストボディ**

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| oldpassword | string | ○ | NotEmpty | 現在のパスワード |
| password | string | ○ | NotEmpty, StringLength(8) | 新パスワード（8文字以上） |
| password2 | string | ○ | Identical(password) | パスワード確認 |

**レスポンス（成功時）**

HTML形式のダイアログ（「Password Changed」メッセージ）

**レスポンス（エラー時）**

HTML形式のダイアログ（「Invalid Current Password」メッセージ - パスワード不一致時）

## 備考

### URLルーティング規則

本システムはZend Framework 1.xの標準的なルーティング規則に従っています。

```
/admin/{controller}/{action}/param1/value1/param2/value2/...
```

- `{controller}`: コントローラー名（小文字、複数形が一般的）
- `{action}`: アクション名（小文字）
- パラメータはスラッシュ区切りのキー/バリューペア

### セキュリティ考慮事項

1. **パスワードハッシュ**: MD5 + ソルト方式（`md5(sitekey + password + usersalt)`）
2. **入力検証**: Zend_Filter_Input によるサーバーサイドバリデーション
3. **権限制御**: ACLベースのロールベースアクセス制御
4. **セッション管理**: PHP標準のセッション管理

### レスポンス形式

本システムはRESTful APIではなく、従来型のWebアプリケーションです。
- 成功時: HTML形式のページまたはAjaxダイアログ用HTML断片
- エラー時: エラーメッセージを含むHTML形式のレスポンス
- リダイレクト: 302リダイレクト

### ファイルタイプ判定

アセット管理では以下のMIMEタイプを識別しています。

| タイプ | MIMEタイプ |
| --- | --- |
| image | image/jpeg, image/gif, image/png, image/bmp |
| video | video/x-flv |
| audio | audio/mpeg |
| flash | application/x-shockwave-flash |
| other | 上記以外 |
