# Legacy CMS

## 概要

Legacy CMSは、Zend Framework 1をベースとしたPHP製コンテンツ管理システム（CMS）です。小規模なデジタルエージェンシー向けに開発され、記事、イベント、リソース、ページなどの多様なコンテンツタイプを管理できる多機能CMSです。過去のプロジェクト実績として公開されており、新規プロジェクトでの本番利用は推奨されていません。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| 記事管理 | カテゴリ分類、タグ付け、コメント機能を持つ記事の作成・編集・公開 |
| イベント管理 | 会場情報、カテゴリ、日時を管理するイベントの作成・編集・公開 |
| ページ管理 | 静的ページの作成・編集・公開、SEOフレンドリーなスラッグ対応 |
| リソース管理 | 書籍、製品などのリソース情報管理、ブランド・カテゴリ分類 |
| アセット管理 | 画像・ファイルのアップロード、フォルダ管理、サムネイル生成 |
| ユーザー管理 | ロールベースのアクセス制御（RBAC）、ユーザープロファイル管理 |
| メール配信 | メーリングリスト管理、ニュースレター配信機能 |
| コメント機能 | 各コンテンツへのコメント投稿、承認制コメント管理 |
| 全文検索 | Zend Search Luceneによる全文検索機能 |
| ローテーター | 画像スライドショー（バナーローテーター）管理 |
| YouTube連携 | YouTube動画の埋め込み・管理機能 |
| Twitter連携 | Twitterフィード連携機能 |

## 技術スタック

### コア

- フレームワーク: Zend Framework 1.12.20
- 言語: PHP 5.2 - 7.x
- データベース: MySQL (MyISAM, utf8mb4)
- Webサーバー: Apache（mod_rewrite必須）

### 主要ライブラリ

- zendframework/zendframework1: MVCフレームワーク
- deresh/thumb: 画像サムネイル生成
- james-heinrich/getid3: メディアファイルメタデータ取得
- Zend_Search_Lucene: 全文検索エンジン
- FCKeditor: WYSIWYGエディタ
- Dojo Toolkit: JavaScriptフレームワーク

## ディレクトリ構成

```
legacycms-master/
├── application/               # アプリケーションコード
│   ├── bootstrap.php          # アプリケーションブートストラップ
│   ├── initializer.php        # 初期化クラス
│   ├── configs/               # 設定ファイル
│   │   └── config.example.ini # 設定テンプレート
│   ├── helpers/               # アクションヘルパー
│   ├── layouts/               # レイアウトテンプレート
│   ├── models/                # モデルクラス
│   │   ├── Articles.php
│   │   ├── Pages.php
│   │   ├── Comments.php
│   │   └── ...
│   └── modules/               # モジュール
│       ├── admin/             # 管理画面モジュール
│       │   ├── controllers/
│       │   └── views/
│       └── default/           # フロントエンドモジュール
│           ├── controllers/
│           └── views/
├── bin/                       # CLIスクリプト
│   └── install.php            # インストールスクリプト
├── library/                   # カスタムライブラリ
│   └── CMS/
│       ├── Acl/               # アクセス制御
│       ├── Controller/        # カスタムコントローラ
│       ├── Password/          # パスワード強度チェック
│       └── Wordcloud/         # ワードクラウド生成
├── public/                    # 公開ディレクトリ（ドキュメントルート）
│   ├── index.php              # エントリーポイント
│   ├── .htaccess              # Apache設定
│   ├── _captcha/              # CAPTCHA画像
│   ├── _scripts/              # JavaScript (Dojo, FCKeditor等)
│   └── _styles/               # CSS
├── assets/                    # アセットディレクトリ（要作成）
├── cache/                     # キャッシュディレクトリ（要作成）
├── composer.json              # Composer設定
├── database.sql               # データベーススキーマ
├── LICENSE                    # MITライセンス
└── README.md                  # プロジェクトREADME
```

## セットアップ

### 必要条件

- PHP 5.2以上（PHP 7推奨）
- MySQL 5.x以上
- Apache 2.x（mod_rewrite有効）
- Composer

### インストール手順

1. **リポジトリのクローン**
   ```bash
   git clone https://github.com/harrybarnard/legacycms.git
   cd legacycms
   ```

2. **依存関係のインストール**
   ```bash
   composer install
   ```

3. **設定ファイルの準備**
   ```bash
   cp application/configs/config.example.ini application/configs/config.ini
   ```
   `config.ini`を編集し、以下を設定:
   - データベース接続情報（development/production）
   - サイト情報（名前、URL、メール等）
   - SMTPサーバー設定
   - 検索インデックス・アセットの保存パス

4. **データベースの作成**
   ```bash
   mysql -u <username> -p <database_name> < database.sql
   ```

5. **ディレクトリの作成と権限設定**
   ```bash
   mkdir -p cache assets search/site-index
   chmod 777 cache assets search/site-index
   ```

6. **Apache仮想ホスト設定**
   ```apache
   <VirtualHost *:80>
       ServerName legacycms.local
       DocumentRoot /path/to/legacycms/public

       SetEnv APPLICATION_ENV "development"

       <Directory /path/to/legacycms/public>
           DirectoryIndex index.php
           AllowOverride All
           Order allow,deny
           Allow from all
       </Directory>
   </VirtualHost>
   ```

7. **管理者ユーザーの作成**
   ```bash
   php bin/install.php -e <admin-email> -p <admin-password>
   ```

## 開発

### 環境設定

開発環境では`APPLICATION_ENV`を`development`に設定することで、詳細なエラー表示が有効になります。

### モジュール構成

- **default**: フロントエンド用モジュール（公開サイト）
- **admin**: 管理画面用モジュール（/admin でアクセス）

### ビューヘルパー

管理画面用のビューヘルパーは`application/modules/admin/views/helpers/`に配置されています。

### カスタムライブラリ

`library/CMS/`配下にプロジェクト固有のライブラリが配置されています:

- `CMS_Acl_Factory`: アクセス制御リストの生成
- `CMS_Controller_Action_*`: カスタムコントローラアクション
- `CMS_Password_Strength`: パスワード強度チェック
- `CMS_Wordcloud_Wordcloud`: ワードクラウド生成

### PHP拡張機能

以下のPHP拡張が必要です:
- PDO MySQL
- GD
