---
generated_at: 2026-02-11 17:58:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **PHP 7推奨の記述**：元READMEでは7はallow_failuresであり推奨とは明記されていない
  2. **Twitter連携機能の詳細**：twitter.iniの存在のみで機能詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/legacycms-master/README.md`（元README）
- E-02: `/Users/tomoka.baba/Work/legacycms-master/composer.json`
- E-03: `/Users/tomoka.baba/Work/legacycms-master/.travis.yml`
- E-04: `/Users/tomoka.baba/Work/legacycms-master/database.sql`
- E-05: `/Users/tomoka.baba/Work/legacycms-master/application/bootstrap.php`
- E-06: `/Users/tomoka.baba/Work/legacycms-master/application/initializer.php`
- E-07: `/Users/tomoka.baba/Work/legacycms-master/bin/install.php`
- E-08: `/Users/tomoka.baba/Work/legacycms-master/application/configs/config.example.ini`
- E-09: `/Users/tomoka.baba/Work/legacycms-master/public/index.php`
- E-10: `/Users/tomoka.baba/Work/legacycms-master/application/models/` (ディレクトリ)
- E-11: `/Users/tomoka.baba/Work/legacycms-master/application/modules/admin/controllers/` (ディレクトリ)
- E-12: `/Users/tomoka.baba/Work/legacycms-master/library/CMS/` (ディレクトリ)
- E-13: `/Users/tomoka.baba/Work/legacycms-master/public/_scripts/` (ディレクトリ)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトはZend Framework 1ベースのCMS | E-02, E-05, E-06 | ○ |
| C-02 | Zend Framework 1.12.20を使用 | E-02 | ○ |
| C-03 | PHP 5.2-7.xをサポート | E-03 | ○ |
| C-04 | MySQLデータベースを使用 | E-04, E-08 | ○ |
| C-05 | Apache + mod_rewrite必須 | E-01 | ○ |
| C-06 | 記事管理機能がある | E-04, E-10, E-11 | ○ |
| C-07 | イベント管理機能がある | E-04, E-10, E-11 | ○ |
| C-08 | ページ管理機能がある | E-04, E-10, E-11 | ○ |
| C-09 | リソース管理機能がある | E-04, E-10, E-11 | ○ |
| C-10 | アセット管理機能がある | E-04, E-10, E-11 | ○ |
| C-11 | ユーザー管理・RBAC機能がある | E-04, E-11, E-12 | ○ |
| C-12 | メール配信機能がある | E-04, E-10, E-11 | ○ |
| C-13 | コメント機能がある | E-04, E-10, E-11 | ○ |
| C-14 | Zend Search Luceneによる全文検索 | E-07, E-08 | ○ |
| C-15 | ローテーター機能がある | E-04, E-11 | ○ |
| C-16 | YouTube連携機能がある | E-10 (YouTube.php, YouTube3.php) | ○ |
| C-17 | Twitter連携機能がある | E-10 (Twitter.php), configs/twitter.ini | △ |
| C-18 | deresh/thumbライブラリを使用 | E-02 | ○ |
| C-19 | james-heinrich/getid3ライブラリを使用 | E-02 | ○ |
| C-20 | FCKeditorを使用 | E-13 | ○ |
| C-21 | Dojo Toolkitを使用 | E-13 | ○ |
| C-22 | install.phpでスーパーユーザー作成 | E-07 | ○ |
| C-23 | install.phpで検索インデックス作成 | E-07 | ○ |
| C-24 | ディレクトリ構成が正確 | ファイルシステム確認 | ○ |
| C-25 | adminとdefaultの2モジュール構成 | E-06, ディレクトリ確認 | ○ |
| C-26 | カスタムライブラリCMS_*が存在 | E-12 | ○ |
| C-27 | PDO MySQLとGD拡張が必要 | E-01 | ○ |
| C-28 | PHP 7が推奨される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Twitter連携機能の詳細**: `application/models/Twitter.php`と`configs/twitter.ini`の存在から連携機能があることは確認できるが、実際の機能詳細（ツイート表示、投稿等）は未確認
  - 候補：Twitter.phpの内部実装確認 / フロントエンドビューの確認
- **PHP 7推奨の根拠**: `.travis.yml`ではPHP 7はallow_failuresに含まれており、明確な推奨とは言えない。元READMEにもPHP 7推奨の記述はない
  - 候補：開発者への確認 / 実際の動作テスト結果

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: ディレクトリ構成、基本的な技術スタック
- 0（低リスク）: データベーススキーマに基づく機能一覧
- 1（中リスク）: PHP 7推奨の記述 - travis.ymlとの整合性要確認
- 0（低リスク）: セットアップ手順 - 元READMEと一致

## 6) レビュアーチェックリスト（最小）
- [ ] PHP 7での動作推奨が妥当か確認（travis.ymlではallow_failures）
- [ ] Twitter連携機能の詳細が必要な場合はTwitter.phpを確認
- [ ] 実際のインストール手順が記載通りに動作するか検証
- [ ] 必要条件（PHP拡張等）の完全性を確認
