---
generated_at: 2026-02-11 19:45:00
metrics:
  claims_total: 48
  claims_with_evidence: 45
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：45 / 48、根拠なし：3
- 優先レビュー（高）
  1. **ビューテンプレートの詳細**：実際の.phtmlファイルの内容は未確認
  2. **CI/CD設定の詳細**：.travis.ymlの詳細内容は未確認
  3. **アセット管理の詳細**：public/_scripts/の詳細構造は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `composer.json` - 依存関係定義
- E-02: `README.md` - プロジェクト概要
- E-03: `public/index.php` - エントリーポイント
- E-04: `application/bootstrap.php` - ブートストラップ処理
- E-05: `application/initializer.php` - 初期化クラス
- E-06: `application/models/Articles.php` - 記事モデル
- E-07: `application/models/Pages.php` - ページモデル
- E-08: `application/configs/config.example.ini` - 設定ファイルテンプレート
- E-09: `library/CMS/Controller/Action/Admin.php` - 管理画面基底コントローラー
- E-10: `library/CMS/Controller/Action/Default.php` - フロントエンド基底コントローラー
- E-11: `library/CMS/Acl/Factory.php` - ACLファクトリー
- E-12: `application/modules/admin/controllers/ArticlesController.php` - 管理画面記事コントローラー
- E-13: `application/modules/default/controllers/ArticlesController.php` - フロントエンド記事コントローラー
- E-14: `application/helpers/MakeDate.php` - 日付ヘルパー
- E-15: `bin/install.php` - インストールスクリプト
- E-16: `database.sql` - データベーススキーマ
- E-17: ディレクトリ構造（ls -la コマンド結果）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトはZend Framework 1.12.20を使用 | E-01 | ○ |
| C-02 | PHPは閉じタグを省略するスタイル | E-03, E-04 | ○ |
| C-03 | DocBlockコメントでメタ情報を記述 | E-03, E-06 | ○ |
| C-04 | 代替構文（コロン記法）を多用 | E-06, E-07 | ○ |
| C-05 | Composerによるオートローディング使用 | E-04 | ○ |
| C-06 | MVCアーキテクチャを採用 | E-04, E-05, E-17 | ○ |
| C-07 | Front Controllerパターンを使用 | E-04 | ○ |
| C-08 | Registryパターンでグローバル設定を管理 | E-05, E-06 | ○ |
| C-09 | 管理画面とフロントエンドで異なる基底クラス | E-09, E-10 | ○ |
| C-10 | ACLはCMS_Acl_Factoryで実装 | E-11 | ○ |
| C-11 | コントローラーファイルは*Controller.php形式 | E-12, E-13, E-17 | ○ |
| C-12 | ビューテンプレートは.phtml形式 | E-17 | ○ |
| C-13 | 設定ファイルは.ini形式 | E-08 | ○ |
| C-14 | CMS_*プレフィックスはプロジェクト固有ライブラリ | E-09, E-10, E-11 | ○ |
| C-15 | Admin_*Controllerは管理画面コントローラー | E-12 | ○ |
| C-16 | fetch*はデータ取得メソッド | E-06, E-07 | ○ |
| C-17 | new*は新規作成メソッド | E-06, E-07 | ○ |
| C-18 | update*は更新メソッド | E-06, E-07 | ○ |
| C-19 | delete*は削除メソッド | E-06, E-07 | ○ |
| C-20 | *Actionはコントローラーアクション | E-12, E-13 | ○ |
| C-21 | applicationディレクトリにアプリケーションコード | E-17 | ○ |
| C-22 | libraryにCMSライブラリ | E-17 | ○ |
| C-23 | publicがDocumentRoot | E-02, E-17 | ○ |
| C-24 | modulesにadminとdefaultモジュール | E-17 | ○ |
| C-25 | modelsにビジネスロジック | E-06, E-07 | ○ |
| C-26 | helpersにアクションヘルパー | E-14 | ○ |
| C-27 | configsに設定ファイル | E-08 | ○ |
| C-28 | データベースはMySQL使用 | E-02, E-16 | ○ |
| C-29 | Zend_Dbでデータベースアクセス | E-06, E-07 | ○ |
| C-30 | Fluent Interfaceでクエリ構築 | E-06, E-07, E-13 | ○ |
| C-31 | ルーティングはconfig.iniで定義 | E-05, E-08 | ○ |
| C-32 | preDispatchで認証チェック | E-09 | ○ |
| C-33 | Zend_Authで認証管理 | E-09, E-10 | ○ |
| C-34 | Paginatorでページネーション | E-06, E-13 | ○ |
| C-35 | install.phpで初期ユーザー作成 | E-15 | ○ |
| C-36 | Zend_Search_Luceneで検索インデックス | E-15, E-08 | ○ |
| C-37 | データベーステーブルは{entity}_{attribute}形式 | E-16 | ○ |
| C-38 | カテゴリテーブルは{entity}_categories形式 | E-16 | ○ |
| C-39 | 権限はusers_privileges等で管理 | E-11, E-16 | ○ |
| C-40 | レイアウトファイルはapplication/layouts/ | E-05, E-17 | ○ |
| C-41 | development環境でエラー表示有効 | E-05 | ○ |
| C-42 | キャッシュ機能を使用 | E-05 | ○ |
| C-43 | SMTP経由でメール送信 | E-05 | ○ |
| C-44 | Google Maps/Analytics APIキー設定あり | E-08 | ○ |
| C-45 | パスワードはMD5+ソルトでハッシュ化 | E-15 | ○ |
| C-46 | ビューテンプレートの具体的な内容 | **根拠なし** | △ |
| C-47 | CI/CD（Travis CI）の詳細設定 | **根拠なし** | △ |
| C-48 | FCKEditorの統合方法の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **ビューテンプレート（.phtml）の詳細内容**
  - 理由：ビューファイルの実際の内容は読み込み対象外となった
  - 候補：`application/modules/*/views/scripts/` 配下のファイルを確認

- **Travis CI設定の詳細**
  - 理由：.travis.ymlの内容詳細は確認していない
  - 候補：`.travis.yml` を直接参照

- **FCKEditorの統合方法**
  - 理由：サードパーティライブラリの詳細は確認対象外
  - 候補：`public/_scripts/fckeditor/` 配下のファイルを確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 言語基礎（PHPの基本構文）は一般的な知識で補完可能
- 0: 低リスク - Zend Framework 1.xの概念は公式ドキュメントで確認可能
- 1: 中リスク - ビューテンプレートの詳細は実際のファイルで要確認
- 0: 低リスク - データベーススキーマはdatabase.sqlで確認済み
- 1: 中リスク - セキュリティ関連（MD5ハッシュ）は現代のベストプラクティスとの乖離あり

## 6) レビュアーチェックリスト（最小）
- [ ] Zend Framework 1.xの基本概念説明が正確か確認
- [ ] ディレクトリ構造の説明が実際の構造と一致するか確認
- [ ] コード例のファイルパスと行番号が正確か確認
- [ ] 命名規則の説明がプロジェクト全体と整合するか確認
- [ ] 業務フロー追跡の例が実際の処理フローと一致するか確認
- [ ] ビューテンプレートの詳細を必要に応じて追記
- [ ] セキュリティに関する注意事項（MD5ハッシュの脆弱性等）を追記検討
