# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph "Client Layer"
        Browser[Web Browser]
        Flash[Flash Uploader]
    end

    subgraph "Web Server Layer"
        Apache[Apache HTTP Server]
        ModRewrite[mod_rewrite]
    end

    subgraph "Application Layer"
        subgraph "Entry Point"
            Index[public/index.php]
            Bootstrap[bootstrap.php]
            Initializer[Initializer Plugin]
        end

        subgraph "Front Controller"
            FC[Zend_Controller_Front]
            Router[Router]
            Dispatcher[Dispatcher]
        end

        subgraph "Modules"
            subgraph "Admin Module"
                AdminCtrl[Admin Controllers]
                AdminViews[Admin Views]
            end
            subgraph "Default Module"
                DefaultCtrl[Default Controllers]
                DefaultViews[Default Views]
            end
        end

        subgraph "Models"
            Articles[Articles]
            Pages[Pages]
            Events[Events]
            Users[Users]
            Search[Search]
            Comments[Comments]
            Assets[Assets]
            Mail[Mail]
        end

        subgraph "CMS Library"
            AclFactory[CMS_Acl_Factory]
            BaseControllers[Base Controllers]
            Plugins[Controller Plugins]
        end

        subgraph "Layouts"
            MainLayout[main.phtml]
            AdminLayout[admin.phtml]
            AuthLayout[admin-auth.phtml]
        end
    end

    subgraph "Infrastructure Layer"
        ZendFW[Zend Framework 1.12]
        Composer[Composer Dependencies]
    end

    subgraph "Data Layer"
        MySQL[(MySQL Database)]
        Lucene[Zend_Search_Lucene Index]
        FileCache[File Cache]
        AssetStorage[Asset Storage]
    end

    subgraph "External Services"
        SMTP[SMTP Server]
        GoogleMaps[Google Maps API]
        GoogleAnalytics[Google Analytics]
        YouTube[YouTube API]
        Twitter[Twitter API]
    end

    Browser --> Apache
    Flash --> Apache
    Apache --> ModRewrite
    ModRewrite --> Index
    Index --> Bootstrap
    Bootstrap --> Initializer
    Initializer --> FC
    FC --> Router
    Router --> Dispatcher
    Dispatcher --> AdminCtrl
    Dispatcher --> DefaultCtrl
    AdminCtrl --> AdminViews
    DefaultCtrl --> DefaultViews
    AdminCtrl --> Articles
    AdminCtrl --> Pages
    AdminCtrl --> Events
    AdminCtrl --> Users
    AdminCtrl --> Comments
    AdminCtrl --> Assets
    AdminCtrl --> Mail
    DefaultCtrl --> Articles
    DefaultCtrl --> Pages
    DefaultCtrl --> Events
    DefaultCtrl --> Search
    AdminCtrl --> AclFactory
    AdminCtrl --> BaseControllers
    Articles --> MySQL
    Pages --> MySQL
    Events --> MySQL
    Users --> MySQL
    Comments --> MySQL
    Assets --> MySQL
    Assets --> AssetStorage
    Mail --> MySQL
    Mail --> SMTP
    Search --> Lucene
    AdminViews --> MainLayout
    AdminViews --> AdminLayout
    DefaultViews --> MainLayout
    AclFactory --> MySQL
    ZendFW --> MySQL
    Initializer --> FileCache
```

## レイヤー構成図

```mermaid
graph TB
    subgraph "Presentation Layer"
        Views[View Scripts .phtml]
        Layouts[Layout Templates]
        Helpers[View Helpers]
    end

    subgraph "Controller Layer"
        FrontController[Front Controller]
        ActionControllers[Action Controllers]
        ActionHelpers[Action Helpers]
        ControllerPlugins[Controller Plugins]
    end

    subgraph "Model Layer"
        DomainModels[Domain Models]
        DataAccess[Data Access via Zend_Db]
    end

    subgraph "Infrastructure Layer"
        ZendFramework[Zend Framework Components]
        CMSLibrary[CMS Custom Library]
        ExternalLibs[External Libraries]
    end

    subgraph "Data Store"
        Database[(MySQL)]
        SearchIndex[Lucene Index]
        FileSystem[File System]
    end

    Views --> Layouts
    Views --> Helpers
    FrontController --> ActionControllers
    ActionControllers --> Views
    ActionControllers --> ActionHelpers
    ActionControllers --> ControllerPlugins
    ActionControllers --> DomainModels
    DomainModels --> DataAccess
    DataAccess --> ZendFramework
    ZendFramework --> Database
    DomainModels --> SearchIndex
    DomainModels --> FileSystem
    ControllerPlugins --> CMSLibrary
    ActionControllers --> CMSLibrary
```

## モジュール構成図

```mermaid
graph LR
    subgraph "Admin Module"
        direction TB
        AuthCtrl[AuthController]
        IndexCtrl[IndexController]
        ArticlesCtrl[ArticlesController]
        PagesCtrl[PagesController]
        EventsCtrl[EventsController]
        UsersCtrl[UsersController]
        AssetsCtrl[AssetsController]
        MailCtrl[MailController]
        CommentsCtrl[CommentsController]
        RotatorsCtrl[RotatorsController]
        ResourcesCtrl[ResourcesController]
        SettingsCtrl[SettingsController]
        ErrorCtrl[ErrorController]
    end

    subgraph "Default Module"
        direction TB
        DefIndexCtrl[IndexController]
        DefArticlesCtrl[ArticlesController]
        DefPagesCtrl[PagesController]
        DefEventsCtrl[EventsController]
        DefAssetsCtrl[AssetsController]
        DefCommentsCtrl[CommentsController]
        DefProductsCtrl[ProductsController]
        DefSettingsCtrl[SettingsController]
        DefAuthCtrl[AuthController]
        DefTwitterCtrl[TwitterController]
        DefErrorCtrl[ErrorController]
    end

    subgraph "Shared Models"
        direction TB
        ArticlesModel[Articles]
        PagesModel[Pages]
        EventsModel[Events]
        UsersModel[Users]
        CommentsModel[Comments]
        AssetsModel[Attachments]
        MailModel[Mail]
        SearchModel[Search]
        TagsModel[Tags]
        RotatorsModel[Rotators]
        MusicModel[Music]
        YouTubeModel[YouTube3]
        TwitterModel[Twitter]
    end

    ArticlesCtrl --> ArticlesModel
    PagesCtrl --> PagesModel
    EventsCtrl --> EventsModel
    UsersCtrl --> UsersModel
    CommentsCtrl --> CommentsModel
    AssetsCtrl --> AssetsModel
    MailCtrl --> MailModel
    RotatorsCtrl --> RotatorsModel

    DefArticlesCtrl --> ArticlesModel
    DefPagesCtrl --> PagesModel
    DefEventsCtrl --> EventsModel
    DefCommentsCtrl --> CommentsModel
    DefAssetsCtrl --> AssetsModel
```

## コントローラー継承階層

```mermaid
classDiagram
    class Zend_Controller_Action {
        +preDispatch()
        +postDispatch()
        +init()
    }

    class CMS_Controller_Action_Default {
        +preDispatch()
    }

    class CMS_Controller_Action_Admin {
        +setRefer()
        +preDispatch()
    }

    class CMS_Controller_Action_Auth {
        +preDispatch()
    }

    class CMS_Controller_Action_Error {
        +preDispatch()
    }

    class Admin_IndexController {
        +indexAction()
    }

    class Admin_AuthController {
        +loginAction()
        +logoutAction()
        +passwordAction()
    }

    class Admin_ArticlesController {
        +indexAction()
        +articleAction()
        +newAction()
        +deleteAction()
    }

    class Default_IndexController {
        +indexAction()
        +searchAction()
        +contactAction()
    }

    Zend_Controller_Action <|-- CMS_Controller_Action_Default
    Zend_Controller_Action <|-- CMS_Controller_Action_Admin
    Zend_Controller_Action <|-- CMS_Controller_Action_Auth
    Zend_Controller_Action <|-- CMS_Controller_Action_Error

    CMS_Controller_Action_Admin <|-- Admin_IndexController
    CMS_Controller_Action_Auth <|-- Admin_AuthController
    CMS_Controller_Action_Admin <|-- Admin_ArticlesController
    CMS_Controller_Action_Default <|-- Default_IndexController
```

## データベース ER図

```mermaid
erDiagram
    users ||--o{ articles : writes
    users ||--o{ pages : writes
    users ||--o{ events : creates
    users ||--o{ comments : posts
    users ||--o{ mail : sends
    users ||--|| users_profiles : has
    users }o--|| users_roles : has
    users_roles ||--o{ users_privileges : grants
    users_resources ||--o{ users_privileges : defines

    articles }o--|| articles_categories : belongs_to
    articles ||--o{ comments : has
    articles ||--o{ tags : tagged_with
    articles ||--o{ attachments : has

    pages ||--o{ tags : tagged_with

    events }o--|| events_categories : belongs_to
    events }o--|| events_venues : held_at
    events ||--o{ comments : has
    events ||--o{ tags : tagged_with

    resources }o--|| resources_categories : belongs_to
    resources }o--|| resources_types : is_type_of
    resources }o--|| resources_brands : branded_by
    resources ||--o{ comments : has

    assets }o--|| assets_folders : stored_in
    attachments }o--|| assets : references

    mail }o--|| mail_groups : sent_to
    mail_groups ||--o{ mail_subscriptions : has
    users ||--o{ mail_subscriptions : subscribes_to

    rotators ||--o{ rotators_slides : contains

    users {
        int user_id PK
        int user_role FK
        varchar user_alias
        varchar user_email
        varchar user_password
        varchar user_salt
        varchar user_status
    }

    articles {
        int article_id PK
        int article_category FK
        int article_user FK
        text article_title
        text article_content
        varchar article_status
    }

    pages {
        int page_id PK
        int page_user FK
        varchar page_slug UK
        varchar page_title
        text page_content
        varchar page_status
    }

    events {
        int event_id PK
        int event_venue FK
        int event_category FK
        int event_user FK
        varchar event_title
        datetime event_date
        varchar event_status
    }

    comments {
        int comment_id PK
        varchar comment_type
        int comment_slave
        int comment_user FK
        text comment_content
        varchar comment_approved
    }
```

## リクエスト処理フロー

```mermaid
sequenceDiagram
    participant Client
    participant Apache
    participant Index as index.php
    participant Bootstrap
    participant Init as Initializer
    participant FC as FrontController
    participant Router
    participant Controller
    participant Model
    participant View
    participant Layout

    Client->>Apache: HTTP Request
    Apache->>Index: Route via mod_rewrite
    Index->>Bootstrap: require bootstrap.php
    Bootstrap->>Init: new Initializer()
    Init->>Init: initPhpConfig()
    Init->>FC: registerPlugin(Initializer)
    FC->>FC: dispatch()

    Note over Init: routeStartup()
    Init->>Init: initDb()
    Init->>Init: initHelpers()
    Init->>Init: initView()
    Init->>Init: initPlugins()
    Init->>Init: initRoutes()
    Init->>Init: initControllers()

    FC->>Router: route(request)
    Router->>FC: module/controller/action
    FC->>Controller: dispatch to action

    Controller->>Controller: preDispatch()
    Controller->>Model: business logic
    Model->>Model: database operations
    Model->>Controller: return data
    Controller->>View: assign variables
    Controller->>Controller: postDispatch()

    View->>Layout: render in layout
    Layout->>FC: return response
    FC->>Apache: send response
    Apache->>Client: HTTP Response
```

## 認証・認可フロー

```mermaid
sequenceDiagram
    participant User
    participant AdminCtrl as Admin Controller
    participant PreDispatch
    participant ZendAuth as Zend_Auth
    participant AuthAdapter as Auth Adapter
    participant AclFactory as CMS_Acl_Factory
    participant ZendAcl as Zend_Acl
    participant DB as MySQL

    User->>AdminCtrl: Access admin page
    AdminCtrl->>PreDispatch: preDispatch()
    PreDispatch->>ZendAuth: hasIdentity()

    alt Not Authenticated
        ZendAuth-->>PreDispatch: false
        PreDispatch->>User: Redirect to login
        User->>AdminCtrl: Submit login form
        AdminCtrl->>AuthAdapter: authenticate()
        AuthAdapter->>DB: SELECT from users
        DB-->>AuthAdapter: user record
        AuthAdapter->>AuthAdapter: verify MD5(key+password+salt)

        alt Valid Credentials
            AuthAdapter-->>ZendAuth: success
            ZendAuth->>ZendAuth: store identity in session
            AdminCtrl->>User: Redirect to dashboard
        else Invalid Credentials
            AuthAdapter-->>AdminCtrl: failure
            AdminCtrl->>User: Show error message
        end
    else Authenticated
        ZendAuth-->>PreDispatch: true
        PreDispatch->>AclFactory: createGlobalAcl()
        AclFactory->>DB: SELECT roles, resources, privileges
        DB-->>AclFactory: ACL data
        AclFactory->>ZendAcl: build ACL
        ZendAcl-->>PreDispatch: ACL object
        PreDispatch->>ZendAcl: isAllowed(role, resource)

        alt Allowed
            ZendAcl-->>PreDispatch: true
            PreDispatch-->>AdminCtrl: continue
            AdminCtrl->>User: Render page
        else Denied
            ZendAcl-->>PreDispatch: false
            PreDispatch->>User: Forward to privileges error
        end
    end
```

## 検索インデックス更新フロー

```mermaid
flowchart TD
    A[Content Updated] --> B{Content Type}
    B -->|Article| C[Articles::updateArticle]
    B -->|Page| D[Pages::updatePage]
    B -->|Resource| E[Resources::updateResource]

    C --> F{Is Published?}
    D --> F
    E --> F

    F -->|Yes| G[Create Search Entry]
    F -->|No| H[Skip Indexing]

    G --> I[Search::updateEntry]
    I --> J[Delete Existing Entry]
    J --> K[Create New Entry]

    K --> L[Zend_Search_Lucene::open]
    L --> M[Create Document]
    M --> N[Add Fields: key, date, title, url, contents]
    N --> O[index.addDocument]
    O --> P[Index Updated]

    H --> Q[Done]
    P --> Q
```
