# インフラ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph "Client Layer"
        Browser[Web Browser]
    end

    subgraph "Web Server Layer"
        Apache[Apache HTTP Server<br/>mod_rewrite enabled]
    end

    subgraph "Application Layer"
        PHP[PHP Runtime<br/>5.2 - 7.x]
        ZF[Zend Framework 1.12.20]
        App[Legacy CMS Application]
    end

    subgraph "Data Layer"
        MySQL[(MySQL Database<br/>MyISAM Engine)]
        Assets[Assets Storage<br/>/srv/legacycms/assets/]
        Search[Lucene Search Index<br/>/srv/legacycms/search/]
        Cache[Cache Directory]
    end

    subgraph "External Services"
        SMTP[SMTP Server]
        GMap[Google Maps API]
        GA[Google Analytics]
        YouTube[YouTube API]
        Twitter[Twitter API]
    end

    Browser -->|HTTP/HTTPS| Apache
    Apache -->|mod_php / FastCGI| PHP
    PHP --> ZF
    ZF --> App
    App -->|PDO_MySQL| MySQL
    App -->|File I/O| Assets
    App -->|Zend_Search_Lucene| Search
    App -->|File I/O| Cache
    App -->|SMTP| SMTP
    App -->|REST API| GMap
    App -->|JavaScript| GA
    App -->|REST API| YouTube
    App -->|REST API| Twitter
```

## リクエストフロー図

```mermaid
sequenceDiagram
    participant Client as Web Browser
    participant Apache as Apache Server
    participant htaccess as .htaccess<br/>(mod_rewrite)
    participant PHP as PHP Runtime
    participant Bootstrap as bootstrap.php
    participant FC as Front Controller<br/>(Zend)
    participant Controller as Controller
    participant Model as Model
    participant DB as MySQL

    Client->>Apache: HTTP Request
    Apache->>htaccess: URL Rewrite Check
    htaccess->>Apache: Rewrite to index.php
    Apache->>PHP: Execute index.php
    PHP->>Bootstrap: Load bootstrap.php
    Bootstrap->>FC: Initialize Front Controller
    FC->>Controller: Dispatch Request
    Controller->>Model: Data Request
    Model->>DB: SQL Query
    DB-->>Model: Result Set
    Model-->>Controller: Data
    Controller-->>FC: View Data
    FC-->>PHP: Rendered HTML
    PHP-->>Apache: Response
    Apache-->>Client: HTTP Response
```

## ディレクトリ構造図

```mermaid
graph LR
    subgraph "Application Root"
        Root[legacycms/]
    end

    subgraph "Application Code"
        App[application/]
        Configs[configs/]
        Helpers[helpers/]
        Layouts[layouts/]
        Models[models/]
        Modules[modules/]
    end

    subgraph "Public Assets"
        Public[public/]
        Scripts[_scripts/]
        Styles[_styles/]
        Index[index.php]
    end

    subgraph "Storage"
        Assets2[assets/]
        SearchDir[search/]
        CacheDir[cache/]
    end

    subgraph "Libraries"
        Library[library/]
        Vendor[vendor/]
    end

    Root --> App
    Root --> Public
    Root --> Assets2
    Root --> SearchDir
    Root --> CacheDir
    Root --> Library
    Root --> Vendor

    App --> Configs
    App --> Helpers
    App --> Layouts
    App --> Models
    App --> Modules

    Public --> Scripts
    Public --> Styles
    Public --> Index
```

## データベース構成図

```mermaid
erDiagram
    users ||--o{ articles : creates
    users ||--o{ events : creates
    users ||--o{ pages : creates
    users ||--o{ resources : creates
    users ||--o{ comments : posts
    users ||--o{ mail : sends
    users }|--|| users_roles : has
    users ||--o| users_profiles : has

    articles }|--|| articles_categories : belongs_to
    articles ||--o{ tags : has
    articles ||--o{ comments : has
    articles ||--o{ attachments : has

    events }|--|| events_venues : held_at
    events }|--|| events_categories : belongs_to
    events ||--o{ comments : has

    resources }|--|| resources_categories : belongs_to
    resources }|--|| resources_types : is_type
    resources }|--o| resources_brands : branded_by

    pages ||--o{ tags : has

    mail }|--|| mail_groups : belongs_to
    mail_groups ||--o{ mail_subscriptions : has
    users ||--o{ mail_subscriptions : subscribes

    assets }|--|| assets_folders : stored_in

    rotators ||--o{ rotators_slides : contains
```

## ネットワーク構成図

```mermaid
graph TB
    subgraph "Internet"
        User[End User]
    end

    subgraph "DMZ / Public Network"
        LB[Load Balancer<br/>Optional]
        Web1[Web Server<br/>Apache + PHP]
    end

    subgraph "Internal Network"
        DB1[(MySQL Server)]
        FileStore[File Storage<br/>NFS/Local]
    end

    subgraph "External APIs"
        ExtAPI[External Services<br/>Google, YouTube, Twitter]
    end

    User -->|HTTP:80/HTTPS:443| LB
    LB --> Web1
    Web1 -->|MySQL:3306| DB1
    Web1 -->|NFS/Local| FileStore
    Web1 -->|HTTPS:443| ExtAPI
```

## 環境別構成図

```mermaid
graph TB
    subgraph "Development Environment"
        DevLocal[Local Machine]
        DevApache[Apache<br/>localhost]
        DevMySQL[MySQL<br/>localhost]
        DevEnv[APPLICATION_ENV<br/>= development]
    end

    subgraph "Production Environment"
        ProdServer[Production Server]
        ProdApache[Apache<br/>Virtual Host]
        ProdMySQL[MySQL<br/>Separate or Same Host]
        ProdEnv[APPLICATION_ENV<br/>= production]
    end

    DevLocal --> DevApache
    DevApache --> DevMySQL
    DevApache --> DevEnv

    ProdServer --> ProdApache
    ProdApache --> ProdMySQL
    ProdApache --> ProdEnv
```

## 依存関係図

```mermaid
graph TD
    subgraph "Application Dependencies"
        CMS[Legacy CMS]
        ZF1[Zend Framework 1.12.20]
        Thumb[deresh/thumb v1.0]
        GetID3[james-heinrich/getid3 v1.9.15]
        Composer[Composer]
    end

    subgraph "System Dependencies"
        PHP[PHP 5.2-7.x]
        PDO[PDO_MySQL Extension]
        GD[GD Extension]
        Apache[Apache HTTP Server]
        ModRewrite[mod_rewrite]
        MySQL[MySQL Server]
    end

    CMS --> ZF1
    CMS --> Thumb
    CMS --> GetID3
    ZF1 --> Composer
    Thumb --> Composer
    GetID3 --> Composer

    CMS --> PHP
    PHP --> PDO
    PHP --> GD
    CMS --> Apache
    Apache --> ModRewrite
    CMS --> MySQL
```
