# インフラ設計書

## 概要

本ドキュメントは、Legacy PHP Content Management System（Legacy CMS）のインフラストラクチャ構成について記載する。本システムは従来型のLAMPスタック（Linux/Apache/MySQL/PHP）上で動作するWebアプリケーションであり、Zend Framework 1.xをベースとしたMVCアーキテクチャを採用している。

## システム構成

### 全体構成

本システムは以下の構成要素から成る単純なモノリシックアーキテクチャを採用している：

1. **Webサーバー層**: Apache HTTP Server（mod_rewrite必須）
2. **アプリケーション層**: PHP（PDO MySQL拡張、GD拡張必須）
3. **データベース層**: MySQL（MyISAMエンジン）
4. **ストレージ層**: ファイルシステム（assets、search index、cache）

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| Web/APサーバー | Apache + PHP統合サーバー | 要件に応じて設定 | 1台（最小構成） |
| DBサーバー | MySQL データベースサーバー | 要件に応じて設定 | 1台（最小構成） |

**補足**:
- 本システムはコンテナ化やクラウドネイティブ構成は採用していない
- 推奨PHPバージョン: 5.2 - 7.x（Travis CI設定より）
- HHVMも動作可能（ただし一部制限あり）

### ネットワーク構成

| 項目 | 設定値 |
| --- | --- |
| プロトコル | HTTP（HTTPS推奨） |
| ポート | 80（標準）|
| DocumentRoot | `/path/to/legacycmsroot/public` |

**Apache VirtualHost設定例**:
```apache
<VirtualHost *:80>
    ServerName legacycms.local
    DocumentRoot /path/to/legacycmsroot/public

    SetEnv APPLICATION_ENV "development"

    <Directory /path/to/legacycmsroot/public>
        DirectoryIndex index.php
        AllowOverride All
        Order allow,deny
        Allow from all
    </Directory>
</VirtualHost>
```

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Apache HTTP Server | 2.2+ / 2.4+ | Webサーバー、URL Rewrite |
| PHP | 5.2 - 7.x | アプリケーション実行環境 |
| MySQL | 5.x+ | リレーショナルデータベース |
| Zend Framework | 1.12.20 | PHPフレームワーク |
| Composer | - | 依存関係管理 |
| Memcached | - | セッション/キャッシュ（テスト環境） |

### PHP必須拡張モジュール

| 拡張モジュール | 用途 |
| --- | --- |
| PDO_MySQL | データベース接続 |
| GD | 画像処理（サムネイル生成等） |

### Apacheモジュール

| モジュール | 用途 |
| --- | --- |
| mod_rewrite | URL書き換え（必須） |
| mod_security | セキュリティ（オフ設定可） |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| SMTP Server | メール送信 | SMTP |
| Google Maps API | 地図表示（イベント会場表示） | HTTPS REST API |
| Google Analytics | アクセス解析 | JavaScript |
| YouTube API | 動画コンテンツ連携 | HTTPS REST API |
| Twitter API | ソーシャル連携 | HTTPS REST API |

## スケーリング設計

本システムは元来、小規模デジタルエージェンシー向けに設計されたため、水平スケーリングの仕組みは組み込まれていない。

### 現状の制約
- ステートフルなセッション管理
- ファイルシステムベースのアセット管理
- Lucene検索インデックスのローカルファイルシステム保存

### スケーリング対応案（将来的な拡張）
| 方式 | 対応内容 |
| --- | --- |
| 垂直スケーリング | サーバーリソース増強 |
| 読み取りレプリカ | MySQLレプリケーション |
| ロードバランサー | セッション共有化が前提 |

## 可用性設計

本システムには冗長構成やフェイルオーバーの仕組みは組み込まれていない。

### 現状
- 単一サーバー構成を前提
- データベースのレプリケーション機能なし
- アプリケーション層の冗長化なし

### 推奨改善策
- MySQLマスター/スレーブレプリケーション
- 定期的なデータベースバックアップ
- 監視システムの導入

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| MySQL Database | mysqldump | 運用要件に応じて設定 | 運用要件に応じて設定 |
| Assets Directory | ファイルシステムバックアップ | 運用要件に応じて設定 | 運用要件に応じて設定 |
| Search Index | ファイルシステムバックアップ | 運用要件に応じて設定 | 運用要件に応じて設定 |
| Application Code | バージョン管理（Git） | コミット毎 | 無期限 |

**バックアップ対象ディレクトリ**:
- `/srv/legacycms/assets/` - アセットファイル
- `/srv/legacycms/search/` - Lucene検索インデックス
- `cache/` - キャッシュファイル（再生成可能）

## 監視設計

本システムには組み込みの監視機能は存在しない。以下の監視項目を外部ツールで実装することを推奨する。

### 推奨監視項目

| 監視項目 | 監視内容 | 閾値例 |
| --- | --- | --- |
| HTTPレスポンス | ステータスコード、レスポンスタイム | 200応答、3秒以内 |
| MySQL接続 | 接続数、クエリ実行時間 | 運用要件に応じて設定 |
| ディスク使用量 | assets、search、cacheディレクトリ | 80%以下 |
| PHPエラー | error_log監視 | エラー発生時通知 |

## ディレクトリ構成

```
legacycms/
├── application/           # アプリケーションコード
│   ├── configs/          # 設定ファイル
│   ├── helpers/          # ヘルパークラス
│   ├── layouts/          # レイアウトテンプレート
│   ├── models/           # モデルクラス
│   └── modules/          # コントローラーモジュール
├── assets/               # アップロードファイル（書き込み権限必要）
├── bin/                  # CLIスクリプト
├── cache/                # キャッシュディレクトリ（書き込み権限必要）
├── library/              # ライブラリ
├── public/               # DocumentRoot
│   ├── _captcha/        # CAPTCHA画像
│   ├── _scripts/        # JavaScript
│   ├── _styles/         # CSS
│   └── index.php        # エントリーポイント
├── search/               # Lucene検索インデックス
│   └── site-index/      # サイトインデックス（書き込み権限必要）
└── vendor/               # Composer依存パッケージ
```

## 環境設定

### 環境変数

| 変数名 | 説明 | 設定例 |
| --- | --- | --- |
| APPLICATION_ENV | 実行環境 | development / production |

### 設定ファイル

| ファイル | 説明 |
| --- | --- |
| application/configs/config.ini | メイン設定ファイル |
| application/configs/pages.ini | ページ設定 |
| application/configs/articles.ini | 記事設定 |
| application/configs/events.ini | イベント設定 |
| application/configs/youtube.ini | YouTube連携設定 |
| application/configs/twitter.ini | Twitter連携設定 |
| application/configs/products.ini | 製品設定 |

## 備考

### レガシーシステムに関する注意事項

1. **本番環境での使用は非推奨**: 作者自身が本番環境での新規使用を推奨していない
2. **セキュリティ**: Zend Framework 1.xはメンテナンス終了しており、セキュリティリスクが存在
3. **PHPバージョン**: PHP 5.2から対応しているが、古いPHPバージョンにはセキュリティ脆弱性あり
4. **データベースエンジン**: MyISAMエンジンを使用（トランザクション非対応）

### 推奨される改善

- PHP 8.x以上へのアップグレード
- Zend Framework 3またはLaminasへの移行
- InnoDBエンジンへの移行
- コンテナ化（Docker）の検討
- CI/CDパイプラインの構築
