---
generated_at: 2026-02-11 18:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **監査ログ機能の有無**：コード内に明示的なログ機能が見つからないが、未発見の可能性あり
  2. **HSTS設定**：サーバー設定ファイルが確認できていない
  3. **セッション有効期限**：PHP設定ファイルが確認できていない
  4. **HTTPSの実装詳細**：インフラ設定に依存するため確認不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `library/CMS/Controller/Action/Auth.php` - 認証ベースコントローラー
- E-02: `application/modules/admin/controllers/AuthController.php` - 認証コントローラー実装
- E-03: `library/CMS/Acl/Factory.php` - ACLファクトリー
- E-04: `library/CMS/Controller/Action/Admin.php` - 管理画面ベースコントローラー
- E-05: `library/CMS/Password/Strength.php` - パスワード強度チェック
- E-06: `application/modules/admin/controllers/UsersController.php` - ユーザー管理コントローラー
- E-07: `application/initializer.php` - アプリケーション初期化
- E-08: `application/bootstrap.php` - ブートストラップ
- E-09: `application/configs/config.example.ini` - 設定ファイルテンプレート
- E-10: `database.sql` - データベーススキーマ
- E-11: `application/models/Articles.php` - 記事モデル（SQLインジェクション対策確認用）
- E-12: `application/modules/admin/controllers/ArticlesController.php` - 記事コントローラー（入力検証確認用）
- E-13: 各種ビューファイル - XSSエスケープ確認用

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Zend_Authコンポーネントによるデータベース認証 | E-02 | ○ |
| C-02 | MD5(CONCAT(site_key, password, user_salt))によるパスワードハッシュ | E-02 | ○ |
| C-03 | セッション名がPHPSESSID | E-04 | ○ |
| C-04 | Flash対応のためURLからセッションID受付 | E-04 | ○ |
| C-05 | Remember Me機能で平文パスワードをCookieに保存 | E-02 | ○ |
| C-06 | パスワード強度チェック機能の存在 | E-05 | ○ |
| C-07 | Zend_AclによるRBAC実装 | E-03, E-04 | ○ |
| C-08 | ロールテーブル（users_roles）の存在 | E-10 | ○ |
| C-09 | リソーステーブル（users_resources）の存在 | E-10 | ○ |
| C-10 | 権限テーブル（users_privileges）の存在 | E-10 | ○ |
| C-11 | Administrator, User, Guestの3ロール | E-10 | ○ |
| C-12 | コントローラー内でのACL権限チェック | E-06, E-12 | ○ |
| C-13 | SMTP SSL/TLS暗号化（ポート465） | E-07 | ○ |
| C-14 | site.keyによるパスワードハッシュ | E-09, E-02 | ○ |
| C-15 | config.iniでの機密情報管理 | E-09 | ○ |
| C-16 | $this->escape()による出力エスケープ | E-13 | ○ |
| C-17 | Zend_Filter_Inputによる入力検証 | E-02, E-06, E-12 | ○ |
| C-18 | Zend_Dbのプリペアドステートメント使用 | E-03, E-06, E-11 | ○ |
| C-19 | CSRF対策トークンが未実装 | E-02, E-06, E-12 | ○ |
| C-20 | confirmパラメータによる2段階確認 | E-06, E-12 | ○ |
| C-21 | パスワード最小長4文字 | E-02 | ○ |
| C-22 | ユーザー固有ソルト（8文字） | E-02, E-06 | ○ |
| C-23 | データベースパスワードはconfig.iniで管理 | E-09 | ○ |
| C-24 | strip_tagsによる一部の入力サニタイズ | E-13 | ○ |
| C-25 | 監査ログ機能が未実装 | **根拠なし（未発見）** | △ |
| C-26 | HSTS未実装 | **根拠なし（サーバー設定未確認）** | △ |
| C-27 | セッション有効期限はPHP設定に依存 | **根拠なし（PHP設定未確認）** | △ |
| C-28 | HTTPSはインフラ依存 | **根拠なし（インフラ設定未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- 監査ログ機能の実装有無
  - 候補：カスタムログクラス / Zend_Log設定 / ログ出力コード
- サーバー設定ファイル（HSTS、HTTPS設定）
  - 候補：.htaccess / nginx.conf / Apache設定
- PHP設定ファイル
  - 候補：php.ini / session設定
- セキュリティポリシー文書
  - 候補：内部セキュリティガイドライン / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 2: **高リスク - MD5ハッシュ使用** - 現代のセキュリティ標準では脆弱とされるアルゴリズム
- 2: **高リスク - Remember Me Cookieに平文パスワード** - 重大なセキュリティ脆弱性
- 2: **高リスク - CSRF対策未実装** - クロスサイトリクエストフォージェリ脆弱性
- 1: **中リスク - URLからのセッションID受付** - セッションハイジャックリスク
- 1: **中リスク - パスワード最小長4文字** - 弱いパスワードポリシー
- 0: **低リスク - 監査ログ未実装** - 運用上の追跡困難

## 6) レビュアーチェックリスト（最小）
- [ ] MD5ハッシュのリスク評価と移行計画の確認
- [ ] Remember Me Cookie実装の修正要否確認
- [ ] CSRF対策の導入計画確認
- [ ] Flash対応セッションID処理の必要性確認（現代では不要の可能性大）
- [ ] 監査ログ機能の実装有無を追加調査
- [ ] サーバー設定（HSTS、HTTPS）の確認
- [ ] パスワードポリシーの強化検討
- [ ] セキュリティテスト（ペネトレーションテスト）の実施状況確認
