---
generated_at: 2026-02-11 18:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 12
  claims_without_evidence: 6
confidence_derived: 0.67
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.67**
  - 根拠あり：12 / 18、根拠なし：6
- 優先レビュー（高）
  1. **カバレッジ目標値**：組織のテスト方針に基づく目標値が不明
  2. **不具合管理フロー**：既存の運用方針の確認が必要
  3. **テスト環境構成（ステージング）**：インフラ設計書の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.travis.yml` - Travis CI設定ファイル
- E-02: `composer.json` - Composerパッケージ定義
- E-03: `README.md` - プロジェクト説明文書
- E-04: `database.sql` - データベーススキーマ定義
- E-05: `application/models/` - モデルクラス群
- E-06: `library/CMS/` - CMSライブラリクラス群
- E-07: `application/modules/admin/controllers/` - 管理画面コントローラ群
- E-08: `application/configs/config.example.ini` - 設定ファイルテンプレート
- E-09: `bin/install.php` - インストールスクリプト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Zend Framework 1.12.20ベースのCMSである | E-02 | ○ |
| C-02 | PHP 5.2から7までをサポート | E-01 | ○ |
| C-03 | Travis CIを使用している | E-01 | ○ |
| C-04 | アプリケーション固有のテストコードが存在しない | E-01, E-05 | ○ |
| C-05 | MySQL/PostgreSQL/Memcachedをサービスとして使用 | E-01 | ○ |
| C-06 | PHPUnitをテストフレームワークとして推奨 | E-01 | ○ |
| C-07 | モデルクラス（Articles, Pages等）が存在 | E-05 | ○ |
| C-08 | CMS_Acl_Factoryがアクセス制御を担当 | E-06 | ○ |
| C-09 | CMS_Password_Strengthがパスワード強度検証を担当 | E-06 | ○ |
| C-10 | ヘルパークラス（SearchIndex, Strings等）が存在 | E-05 | ○ |
| C-11 | database.sqlでテーブル構造が定義されている | E-04 | ○ |
| C-12 | TestConfiguration.travis.phpをCI環境で使用 | E-01 | ○ |
| C-13 | カバレッジ目標：行カバレッジ60%以上 | **根拠なし** | △ |
| C-14 | カバレッジ目標：分岐カバレッジ50%以上 | **根拠なし** | △ |
| C-15 | 不具合重要度定義（Critical/High/Medium/Low） | **根拠なし** | △ |
| C-16 | ステージング環境の構成 | **根拠なし** | △ |
| C-17 | プルリクエスト時のテスト自動化フロー | **根拠なし** | △ |
| C-18 | テストレベル・種別の分類 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標値（C-13, C-14）**：組織・プロジェクトの品質方針文書が未発見。一般的なベストプラクティスに基づく推奨値を記載
  - 候補：品質管理方針書 / プロジェクト計画書 / 開発標準ガイドライン

- **不具合管理フロー・重要度定義（C-15）**：既存の運用ドキュメントが未発見。一般的なプラクティスを記載
  - 候補：運用マニュアル / インシデント管理規定 / GitHub Issueテンプレート

- **ステージング環境構成（C-16）**：インフラ関連ドキュメントが未発見
  - 候補：インフラ設計書 / 環境構成図 / デプロイメントガイド

- **テスト自動化フロー（C-17）**：CI/CD詳細設定が不明
  - 候補：追加のCI/CD設定ファイル / デプロイメントスクリプト

- **テストレベル・種別（C-18）**：テスト計画書が未発見。業界標準（ISTQB等）に基づく分類を記載
  - 候補：テスト計画書 / 品質保証計画書

## 5) リスクフラグ（レビュー観点）
- **リスクレベル 1（中リスク）**：カバレッジ目標値
  - 理由：組織の品質基準に合致しない可能性
  - 推奨：プロジェクトマネージャー・品質管理者との合意形成

- **リスクレベル 1（中リスク）**：テスト環境構成
  - 理由：実際のインフラ構成と乖離する可能性
  - 推奨：インフラチームとの構成確認

- **リスクレベル 0（低リスク）**：テストツール選定
  - 理由：既存のTravis CI設定に基づいており、妥当性が高い

- **リスクレベル 0（低リスク）**：テスト対象コンポーネント特定
  - 理由：ソースコード解析に基づいており、網羅性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標値がプロジェクト/組織の品質方針と整合しているか確認
- [ ] 不具合管理フローが既存の運用ルールと整合しているか確認
- [ ] テスト環境構成が実際のインフラ構成と一致しているか確認
- [ ] PHP 5.2サポートに関するテスト戦略が現実的か確認（レガシーバージョンのサポート継続判断）
- [ ] 推奨アクションの優先度・実施時期について合意形成
- [ ] CI/CDパイプラインの詳細設計について開発チームと協議
