# テスト方針書

## 概要

本ドキュメントは、Legacy PHP Content Management System（LegacyCMS）のテスト方針を定義するものである。本プロジェクトはZend Framework 1ベースのPHP CMSアプリケーションであり、PHP 5.2から7までの複数バージョンをサポートする。現時点ではアプリケーション固有のテストコードは存在しないため、本書では今後実装すべきテスト戦略と推奨事項を定義する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | モデルクラス、ヘルパー、ライブラリの個別機能検証 | 開発者 |
| 結合テスト | コントローラとモデル間の連携、データベースアクセスの検証 | 開発者 |
| システムテスト | CMSの主要機能（記事管理、ページ管理、アセット管理等）のエンドツーエンド検証 | QA担当者 |
| 受入テスト | ユーザー観点での機能要件充足確認 | プロダクトオーナー/ユーザー |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | CMS機能（記事CRUD、ページ管理、ユーザー認証等）の動作確認 | 開発完了後、マージ前 |
| 性能テスト | 大量データ時のレスポンスタイム、メモリ使用量の確認 | リリース前 |
| セキュリティテスト | SQLインジェクション、XSS、CSRF等の脆弱性検査 | リリース前 |
| 回帰テスト | 既存機能への影響がないことの確認 | 変更時、リリース前 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 単体テスト・結合テスト実行 | Linux/Apache/MySQL/PHP (LAMP) |
| CI環境（Travis CI） | 自動テスト実行 | PHP 5.2, 5.3, 5.4, 5.5, 5.6, 7, HHVM / MySQL / PostgreSQL / Memcached |
| ステージング環境 | システムテスト・受入テスト | 本番同等構成 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| PHPUnit | 単体テスト・結合テストフレームワーク | 3.x-5.x（PHP バージョンに応じて選択） |
| Zend_Test | Zend Framework 1向けコントローラテスト | Zend Framework 1.12.20同梱 |
| Zend_Search_Lucene | 検索インデックステスト | Zend Framework 1.12.20同梱 |
| Travis CI | 継続的インテグレーション | クラウドサービス |
| PHPCodeSniffer | コード規約チェック | 推奨 |
| PHPStan/Psalm | 静的解析 | 推奨（PHP 7以上） |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 60%以上（モデル・ライブラリクラス） |
| 分岐カバレッジ | 50%以上（モデル・ライブラリクラス） |
| コントローラカバレッジ | 主要アクションの80%以上 |

## テストデータ

### テストデータ準備方針

1. **データベーステストデータ**
   - `database.sql`をベースに初期データを投入
   - テスト用フィクスチャをPHPで定義
   - 各テストケースでトランザクションを使用し、テスト後にロールバック

2. **テスト用設定ファイル**
   - `tests/TestConfiguration.php`で環境固有の設定を管理
   - CI環境向けには`tests/TestConfiguration.travis.php`を使用

3. **ファイルアップロードテストデータ**
   - `tests/fixtures/`ディレクトリにテスト用画像・ファイルを配置

### 主要テスト対象

| コンポーネント | テスト優先度 | 理由 |
| --- | --- | --- |
| モデルクラス（Articles, Pages, Comments等） | 高 | ビジネスロジックの中核 |
| CMS_Acl_Factory | 高 | アクセス制御の要 |
| CMS_Password_Strength | 高 | セキュリティ関連機能 |
| ヘルパークラス（SearchIndex, Strings等） | 中 | 共通機能 |
| コントローラ（認証、記事、ページ管理） | 中 | ユーザーインターフェース |

## 不具合管理

### 不具合管理フロー

1. **発見**: テスト実行時またはユーザー報告
2. **記録**: GitHubのIssueに登録（重要度・影響範囲を明記）
3. **トリアージ**: 優先度を決定（Critical/High/Medium/Low）
4. **修正**: 修正ブランチを作成し、修正を実施
5. **検証**: テストを追加し、修正を確認
6. **クローズ**: レビュー・マージ後にIssueをクローズ

### 重要度定義

| 重要度 | 定義 | 対応期限 |
| --- | --- | --- |
| Critical | システム停止、データ損失 | 即時対応 |
| High | 主要機能の動作不良 | 24時間以内 |
| Medium | 機能の一部に問題 | 次回リリースまで |
| Low | 軽微な問題、改善要望 | バックログ管理 |

## CI/CD連携

### Travis CI構成

現在のTravis CI設定（`.travis.yml`）の概要:

1. **対応PHPバージョン**
   - PHP 5.2, 5.3, 5.4, 5.5, 5.6, 7, HHVM

2. **サービス依存**
   - Memcached

3. **データベース準備**
   - MySQL: `zftest`データベースを作成
   - PostgreSQL: `zftest`データベースを作成

4. **テスト実行**
   - `tests/runalltests.php`を実行

5. **許容失敗**
   - PHP 7およびHHVMはallow_failuresに設定

### 推奨CI/CDパイプライン

```
[コードコミット]
    |
    v
[静的解析] --> PHPCodeSniffer, PHPStan
    |
    v
[単体テスト] --> PHPUnit
    |
    v
[結合テスト] --> Zend_Test (データベース連携)
    |
    v
[カバレッジレポート生成]
    |
    v
[デプロイ判定]
```

### テスト自動化の推奨事項

1. **プルリクエスト時**
   - 全テストを実行
   - カバレッジが目標値を下回る場合は警告

2. **mainブランチマージ時**
   - 全テストを実行
   - ステージング環境へ自動デプロイ

3. **リリースタグ作成時**
   - 全テスト + セキュリティスキャン
   - 本番環境デプロイ承認フロー

## 備考

### 現状の課題

1. **アプリケーション固有のテストが未実装**
   - 現在のTravis CI設定はZend Framework本体のテストを実行
   - アプリケーション固有のモデル・コントローラテストは存在しない

2. **PHP 5.2サポート**
   - PHP 5.2はPHPUnitの最新版をサポートしない
   - `tests/php52_install_dependencies.sh`で専用の依存関係をインストール

3. **レガシーコード**
   - 一部のコードは現代のPHP開発のベストプラクティスに沿っていない
   - テスト実装と併せてリファクタリングを検討

### 推奨アクション

1. **PHPUnitテストスイートの新規作成**
   - `tests/unit/`ディレクトリにモデル・ヘルパーの単体テストを配置
   - `tests/integration/`ディレクトリにコントローラテストを配置

2. **テストフィクスチャの整備**
   - データベーステスト用のフィクスチャクラスを作成
   - トランザクション制御による独立性の確保

3. **CI設定の更新**
   - アプリケーション固有テストの実行を追加
   - カバレッジレポートの生成・アップロード

### 参考資料

- Zend Framework 1 Documentation: https://framework.zend.com/manual/1.12/en/
- PHPUnit Documentation: https://phpunit.de/documentation.html
- Travis CI PHP Guide: https://docs.travis-ci.com/user/languages/php/
