---
generated_at: 2026-02-11 18:05:00
metrics:
  claims_total: 52
  claims_with_evidence: 50
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：50 / 52、根拠なし：2
- 優先レビュー（高）
  1. **テーブルの説明文**：一部のテーブル説明は推測に基づく
  2. **ポリモーフィック関連の種別値**：アプリケーションコードから推測した値あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/legacycms-master/database.sql` - DDL定義ファイル
- E-02: `/Users/tomoka.baba/Work/legacycms-master/application/models/Articles.php` - 記事モデルクラス
- E-03: `/Users/tomoka.baba/Work/legacycms-master/application/models/Pages.php` - ページモデルクラス
- E-04: `/Users/tomoka.baba/Work/legacycms-master/application/models/Mail.php` - メールモデルクラス
- E-05: `/Users/tomoka.baba/Work/legacycms-master/application/models/Comments.php` - コメントモデルクラス
- E-06: `/Users/tomoka.baba/Work/legacycms-master/application/models/Tags.php` - タグモデルクラス
- E-07: `/Users/tomoka.baba/Work/legacycms-master/application/models/Attachments.php` - 添付ファイルモデルクラス
- E-08: `/Users/tomoka.baba/Work/legacycms-master/application/models/Rotators.php` - ローテーターモデルクラス
- E-09: `/Users/tomoka.baba/Work/legacycms-master/README.md` - プロジェクト説明

## 3) Claims と根拠の対応（レビューの主戦場）

### テーブル構造に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | articlesテーブルの全カラム定義 | E-01 | ○ |
| C-02 | articles_categoriesテーブルの全カラム定義 | E-01 | ○ |
| C-03 | assetsテーブルの全カラム定義 | E-01 | ○ |
| C-04 | assets_foldersテーブルの全カラム定義 | E-01 | ○ |
| C-05 | attachmentsテーブルの全カラム定義 | E-01 | ○ |
| C-06 | commentsテーブルの全カラム定義 | E-01 | ○ |
| C-07 | eventsテーブルの全カラム定義 | E-01 | ○ |
| C-08 | events_categoriesテーブルの全カラム定義 | E-01 | ○ |
| C-09 | events_venuesテーブルの全カラム定義 | E-01 | ○ |
| C-10 | mailテーブルの全カラム定義 | E-01 | ○ |
| C-11 | mail_groupsテーブルの全カラム定義 | E-01 | ○ |
| C-12 | mail_subscriptionsテーブルの全カラム定義 | E-01 | ○ |
| C-13 | pagesテーブルの全カラム定義 | E-01 | ○ |
| C-14 | resourcesテーブルの全カラム定義 | E-01 | ○ |
| C-15 | resources_brandsテーブルの全カラム定義 | E-01 | ○ |
| C-16 | resources_categoriesテーブルの全カラム定義 | E-01 | ○ |
| C-17 | resources_typesテーブルの全カラム定義 | E-01 | ○ |
| C-18 | rotatorsテーブルの全カラム定義 | E-01 | ○ |
| C-19 | rotators_slidesテーブルの全カラム定義 | E-01 | ○ |
| C-20 | tagsテーブルの全カラム定義 | E-01 | ○ |
| C-21 | usersテーブルの全カラム定義 | E-01 | ○ |
| C-22 | users_privilegesテーブルの全カラム定義 | E-01 | ○ |
| C-23 | users_profilesテーブルの全カラム定義 | E-01 | ○ |
| C-24 | users_resourcesテーブルの全カラム定義 | E-01 | ○ |
| C-25 | users_rolesテーブルの全カラム定義 | E-01 | ○ |

### リレーションシップに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | articles.article_category → articles_categories.acat_id | E-01, E-02 | ○ |
| C-27 | articles.article_user → users.user_id | E-01, E-02 | ○ |
| C-28 | pages.page_user → users.user_id | E-01, E-03 | ○ |
| C-29 | events.event_venue → events_venues.venue_id | E-01 | ○ |
| C-30 | events.event_category → events_categories.ecat_id | E-01 | ○ |
| C-31 | events.event_user → users.user_id | E-01 | ○ |
| C-32 | mail.mail_user → users.user_id | E-01, E-04 | ○ |
| C-33 | mail_subscriptions.msub_group → mail_groups.mgroup_id | E-01, E-04 | ○ |
| C-34 | mail_subscriptions.msub_user → users.user_id | E-01, E-04 | ○ |
| C-35 | users.user_role → users_roles.role_id | E-01, E-05 | ○ |
| C-36 | users_profiles.upro_userid → users.user_id | E-01 | ○ |
| C-37 | users_privileges.prv_role → users_roles.role_id | E-01 | ○ |
| C-38 | users_privileges.prv_resource → users_resources.res_resource | E-01 | ○ |
| C-39 | rotators_slides.rots_rotator → rotators.rot_id | E-01, E-08 | ○ |
| C-40 | assets.asset_folder → assets_folders.folder_id | E-01 | ○ |
| C-41 | assets.asset_user → users.user_id | E-01 | ○ |
| C-42 | attachments.attach_asset → assets.asset_key | E-01, E-07 | ○ |

### ポリモーフィック関連に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | comments.comment_type 'A' は articles を参照 | E-05 | ○ |
| C-44 | tags.tag_type 'A' は articles を参照 | E-02, E-06 | ○ |
| C-45 | tags.tag_type 'P' は pages を参照 | E-03, E-06 | ○ |
| C-46 | attachments.attach_type 'M' は mail を参照 | E-04, E-07 | ○ |
| C-47 | mail.mail_type 'G' は mail_groups を参照 | E-04 | ○ |
| C-48 | mail.mail_type 'R' は users_roles を参照 | E-04 | ○ |
| C-49 | mail.mail_type 'U' は users を参照 | E-04 | ○ |

### システム特性に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | MyISAMエンジンを使用 | E-01 | ○ |
| C-51 | UTF-8MB4文字セットを使用 | E-01 | ○ |
| C-52 | comments.comment_type 'E', 'R' の存在（イベント、リソースへのコメント） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-52: ポリモーフィック関連の全種別値**
  - `database.sql` にはスキーマのみが定義されており、`comment_type`や`attach_type`の全ての値が記載されていない
  - モデルコードからは 'A'（Article）と 'P'（Page）の使用が確認されたが、'E'（Event）や 'R'（Resource）への対応は推測
  - 候補：イベントモジュール / リソースモジュールのコントローラーコードを確認 / 実際のデータベースダンプを確認

- **テーブル説明の一部**
  - テーブルの「説明」カラムの一部は、カラム名とテーブル名から推測して記述
  - 明示的なドキュメントや設計仕様書は見つからなかった

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - テーブル構造（カラム名、データ型、制約）は `database.sql` から直接抽出しており信頼性が高い
- **0: 低リスク** - リレーションシップはモデルコードのJOIN操作から確認済み
- **1: 中リスク** - ポリモーフィック関連の種別値は一部推測が含まれる（ただし、命名規則から高い確度で正しいと判断）
- **0: 低リスク** - 初期データの内容は `database.sql` のINSERT文から直接抽出

## 6) レビュアーチェックリスト（最小）
- [ ] 全25テーブルが漏れなく記載されているか確認
- [ ] 主要テーブル（articles, pages, events, users）のカラム定義がdatabase.sqlと一致するか確認
- [ ] ポリモーフィック関連（comments, tags, attachments, mail）の種別値が実際の運用と一致するか確認
- [ ] ER図のリレーションシップ方向が正しいか確認
- [ ] 初期データ（users_roles, articles_categories等）が本番環境と一致するか確認
