# バッチ設計書 1-install.php

## 概要

本ドキュメントは、LEGACY CMSの初期インストールを行うバッチ処理`install.php`の設計仕様を記載したものである。このバッチは、CMSの初回セットアップ時に実行され、検索インデックスの作成とスーパー管理者ユーザーの作成を行う。

### 本バッチの処理概要

このバッチは、LEGACY CMSを新規環境に導入する際に必要な初期設定を自動的に行うものである。CLIから実行され、管理者のメールアドレスとパスワードを引数として受け取り、システムの基盤となる設定を完了させる。

**業務上の目的・背景**：新規にCMSを導入する際、手動でデータベースに管理者ユーザーを作成したり、検索インデックスを構築したりする作業は煩雑でエラーが発生しやすい。このバッチを使用することで、初期セットアップ作業を標準化し、確実かつ迅速にCMS環境を構築することができる。また、セキュリティ上重要なパスワードのハッシュ化やソルト生成を正しく行うことで、安全な初期設定を保証する。

**バッチの実行タイミング**：CMSの初回インストール時に1回のみ実行される。通常は開発者またはシステム管理者がCLIから手動で実行する。既存環境への再実行は想定されていない。

**主要な処理内容**：
1. Zend Frameworkアプリケーションの初期化とデータベース接続の確立
2. Zend_Search_Luceneによるサイト検索インデックスの新規作成
3. コマンドライン引数からメールアドレスとパスワードを取得
4. ランダムなソルト値の生成（8文字の英数字）
5. パスワードのハッシュ化（サイトキー + パスワード + ソルトをMD5化）
6. usersテーブルへのスーパー管理者ユーザーレコードの挿入
7. users_profilesテーブルへのユーザープロファイルレコードの挿入

**前後の処理との関連**：このバッチはCMSセットアップの最終段階で実行される。事前にデータベーススキーマ（database.sql）が適用されている必要がある。また、config.iniファイルにデータベース接続情報とサイトキーが設定されている必要がある。後続処理として、作成された管理者アカウントを使用してCMS管理画面にログインし、各種設定を行う。

**影響範囲**：このバッチが影響を与えるのは、検索インデックスディレクトリ（config.iniで指定されたパス）、usersテーブル、users_profilesテーブルである。初回実行時のみ使用が想定されているため、既存データへの影響は考慮されていない。

## バッチ種別

初期設定 / インストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（初回インストール時のみ） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動（CLI） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベーススキーマ適用済み | database.sqlが実行され、users、users_profilesテーブルが存在すること |
| 設定ファイル配置済み | application/configs/config.iniが存在し、DB接続情報とサイトキーが設定されていること |
| Composerインストール済み | vendor/autoload.phpが存在すること |
| 検索インデックスディレクトリ作成権限 | config.iniで指定されたsearch.search.syspathに書き込み権限があること |
| PHPのCLI実行環境 | php-cliがインストールされていること |

### 実行可否判定

コマンドライン引数として-e（メールアドレス）と-p（パスワード）の両方が指定されている場合のみ実行される。引数が不足している場合は、Zend_Console_Getoptにより使用方法が表示され、処理は終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -e / --email | string | Yes | なし | スーパー管理者のメールアドレス |
| -p / --password | string | Yes | なし | スーパー管理者のパスワード（平文） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| application/configs/config.ini | INI | データベース接続情報、サイトキー、検索インデックスパスを含む設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| usersテーブル | DB | スーパー管理者ユーザーレコード |
| users_profilesテーブル | DB | スーパー管理者のプロファイルレコード |
| 検索インデックスディレクトリ | ファイル | Zend_Search_Luceneインデックスファイル群 |
| 標準出力 | テキスト | 完了メッセージ「Installation Complete!」 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | site-index（ディレクトリ） |
| 出力先 | config.iniのsearch.search.syspathで指定されたパス |
| 文字コード | バイナリ（Luceneインデックス形式） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. アプリケーション初期化
   └─ APPLICATION_PATH、APPLICATION_ENVを定義し、Zend_Applicationを初期化
2. データベース接続確立
   └─ config.iniを読み込み、dbリソースをブートストラップ
3. 検索インデックス作成
   └─ Zend_Search_Lucene::createで新規インデックスを作成しコミット
4. コマンドライン引数解析
   └─ Zend_Console_Getoptで-eと-pオプションを解析
5. ソルト生成
   └─ generatePassword関数で8文字のランダム文字列を生成
6. パスワードハッシュ化
   └─ サイトキー + パスワード + ソルトをMD5でハッシュ化
7. ユーザーキー生成
   └─ メールアドレス + パスワードをMD5でハッシュ化
8. usersテーブルへの挿入
   └─ エイリアス「admin」、ロール3（Administrator）、ステータス「active」で挿入
9. users_profilesテーブルへの挿入
   └─ 名「Super」、姓「Admin」、国「GB」で挿入
10. 完了メッセージ出力
    └─ 「Installation Complete!」を標準出力に表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Zend_Application初期化]
    B --> C[DB接続確立]
    C --> D[検索インデックス作成]
    D --> E[コマンドライン引数解析]
    E --> F{引数は有効?}
    F -->|No| G[使用方法表示して終了]
    F -->|Yes| H[ソルト生成]
    H --> I[パスワードハッシュ化]
    I --> J[usersテーブル挿入]
    J --> K[users_profilesテーブル挿入]
    K --> L[完了メッセージ出力]
    L --> M[バッチ終了]
    G --> N[異常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー作成 | users | INSERT | スーパー管理者ユーザーレコードの挿入 |
| プロファイル作成 | users_profiles | INSERT | スーパー管理者のプロファイルレコードの挿入 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_alias | 'admin' | 固定値 |
| INSERT | user_email | コマンドライン引数-eの値 | |
| INSERT | user_role | 3 | Administrator権限 |
| INSERT | user_password | MD5(サイトキー + パスワード + ソルト) | ハッシュ化済み |
| INSERT | user_key | MD5(メールアドレス + パスワード) | 認証キー |
| INSERT | user_salt | generatePassword()の戻り値 | 8文字のランダム文字列 |
| INSERT | user_date | NOW() | 現在日時 |
| INSERT | user_mailformat | 'text' | 固定値 |
| INSERT | user_status | 'active' | 固定値 |

#### users_profiles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | upro_userid | 直前にusersテーブルに挿入されたuser_id | lastInsertId()で取得 |
| INSERT | upro_first | 'Super' | 固定値 |
| INSERT | upro_last | 'Admin' | 固定値 |
| INSERT | upro_country | 'GB' | 固定値（イギリス） |
| INSERT | upro_date | NOW() | 現在日時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | Zend_Console_Getopt_Exception | コマンドライン引数が不正な場合 | 使用方法を表示して終了 |
| なし | Zend_Db_Exception | データベース接続エラー | 設定ファイルのDB接続情報を確認 |
| なし | Zend_Search_Lucene_Exception | インデックス作成エラー | 出力ディレクトリの権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

バッチ失敗時は以下の手順でリカバリを行う：
1. エラーメッセージを確認し、原因を特定する
2. usersテーブルに部分的にデータが挿入されている場合は削除する
3. 検索インデックスディレクトリが作成されている場合は削除する
4. 問題を解決した後、再度バッチを実行する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（自動コミット） |
| コミットタイミング | 各INSERT文実行時に自動コミット |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1レコード（初回のみ） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

初回インストール時に1回のみ実行されるバッチであるため、排他制御は実装されていない。同時実行された場合、usersテーブルに複数の管理者レコードが作成される可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 終了ログ | バッチ正常終了時 | 「Installation Complete!」を標準出力に出力 |
| エラーログ | 引数エラー時 | 使用方法を標準出力に出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | なし | なし |

インストールバッチは初回のみ実行されるため、定常的な監視は設定されていない。

## 備考

- パスワードのハッシュ化にMD5を使用しているが、現代のセキュリティ基準ではbcryptやArgon2の使用が推奨される
- user_roleの値「3」はusers_rolesテーブルのAdministratorロールに対応する
- generatePassword関数はsrand()を使用しているが、これは暗号学的に安全な乱数生成ではない
- 本バッチはZend Framework 1.x系を前提としている
