# バッチ設計書 2-buildFlashStorage.sh

## 概要

本ドキュメントは、Dojo ToolkitのFlashストレージコンポーネントをビルドするシェルスクリプト`buildFlashStorage.sh`の設計仕様を記載したものである。このバッチは、ActionScriptソースファイル（Storage.as）をmtascコンパイラを使用してSWFファイル（Storage.swf）にコンパイルする。

### 本バッチの処理概要

このバッチは、Dojo ToolkitのdojoxストレージAPIで使用されるFlashストレージコンポーネントをビルドするものである。Flash（SWF）形式のLocalSharedObjectを利用することで、JavaScriptからブラウザのローカルストレージにデータを永続化する機能を提供する。

**業務上の目的・背景**：Dojo Toolkitのdojox.storageモジュールは、クロスブラウザでのローカルデータ永続化を実現するためにFlash LocalSharedObjectを利用している。HTML5 LocalStorageが普及する以前は、Flashを使用したストレージがクロスブラウザ互換性を持つ唯一の実用的な選択肢であった。このバッチは、そのFlashコンポーネントをソースからビルドする際に使用される。本CMSではDojo Toolkitをフロントエンドライブラリとして使用しており、Flashストレージ機能が必要な場合にこのビルドプロセスが実行される。

**バッチの実行タイミング**：Storage.asファイルに変更が加えられた際、または開発環境を新規にセットアップする際に手動で実行される。通常の運用では実行する必要はなく、ビルド済みのStorage.swfが同梱されている場合はこのスクリプトの実行は不要である。

**主要な処理内容**：
1. mtasc（Motion-Twin ActionScript 2 Compiler）を使用してStorage.asをコンパイル
2. DojoExternalInterfaceクラスをリンク（../flashディレクトリから参照）
3. Flash Player 8形式でSWFファイルを生成
4. SWFのサイズ（215x138ピクセル）とフレームレート（10fps）を設定
5. カスタムトレースハンドラ（DojoExternalInterface.trace）を設定

**前後の処理との関連**：このバッチは独立して実行可能であり、前提となるバッチは存在しない。生成されたStorage.swfは、Webブラウザ上でdojox.storage.FlashStorageProviderによって読み込まれ、JavaScriptとFlash間のブリッジとして機能する。storage_dialog.swfと連携して動作する。

**影響範囲**：このバッチが影響を与えるのは、同一ディレクトリ内のStorage.swfファイルのみである。既存のStorage.swfが存在する場合は上書きされる。ビルド後のSWFファイルは、dojox.storageを使用するすべてのWebページに影響を与える可能性がある。

## バッチ種別

ビルド処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時のみ） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動（シェル） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| mtascインストール済み | Motion-Twin ActionScript 2 Compilerがインストールされ、PATHが通っていること |
| Storage.as存在 | 同一ディレクトリにStorage.asファイルが存在すること |
| DojoExternalInterface存在 | ../flash/ディレクトリにDojoExternalInterface.asが存在すること |
| 書き込み権限 | 同一ディレクトリにStorage.swfを書き込む権限があること |

### 実行可否判定

特別な実行可否判定ロジックは存在しない。mtascコマンドが見つからない場合はシェルエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Storage.as | ActionScript 2 | メインのFlashストレージクラスソースファイル |
| DojoExternalInterface.as | ActionScript 2 | JavaScript-Flash間通信を行うインターフェースクラス（../flashディレクトリ） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Storage.swf | SWF | コンパイル済みFlashファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Storage.swf |
| 出力先 | 同一ディレクトリ（public/_scripts/dojo/dojox/storage/） |
| Flash Player バージョン | 8 |
| ステージサイズ | 215x138ピクセル |
| フレームレート | 10fps |

## 処理フロー

### 処理シーケンス

```
1. mtascコンパイラ起動
   └─ コマンドラインオプションを解析
2. トレースハンドラ設定
   └─ DojoExternalInterface.traceをカスタムトレースハンドラとして設定
3. クラスパス設定
   └─ ../flashディレクトリをクラスパスに追加
4. ソースファイルコンパイル
   └─ Storage.asをエントリーポイント（-main）としてコンパイル
5. SWFファイル生成
   └─ 指定されたサイズ・バージョンでStorage.swfを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[mtascコンパイラ起動]
    B --> C{ソースファイル存在?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[クラスパス解決]
    E --> F{依存クラス存在?}
    F -->|No| D
    F -->|Yes| G[ActionScriptコンパイル]
    G --> H{コンパイル成功?}
    H -->|No| D
    H -->|Yes| I[Storage.swf出力]
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

### テーブル別操作詳細

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 127 | コマンド未検出 | mtascがインストールされていない | mtascをインストールしPATHを通す |
| 1 | コンパイルエラー | ソースコードに構文エラーがある | Storage.asの構文を修正 |
| 1 | ファイル未検出 | Storage.asまたは依存ファイルが存在しない | 必要なファイルを配置 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

バッチ失敗時は以下の手順でリカバリを行う：
1. mtascのインストール状態とPATH設定を確認する
2. Storage.asおよび../flash/DojoExternalInterface.asの存在を確認する
3. 出力先ディレクトリへの書き込み権限を確認する
4. ActionScriptの構文エラーがある場合はソースコードを修正する
5. 問題を解決した後、再度バッチを実行する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

データベース操作を行わないため、トランザクション制御は不要。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

ファイルシステム上の操作のみであり、特別な排他制御は実装されていない。同時実行した場合、出力ファイルの競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| コンパイル出力 | コンパイル時 | mtascの標準出力（警告・エラーメッセージ） |
| エラーログ | エラー発生時 | mtascの標準エラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | なし | なし |

開発時のみ使用されるビルドスクリプトであるため、定常的な監視は設定されていない。

## 備考

- mtasc（Motion-Twin ActionScript 2 Compiler）はオープンソースのActionScript 2コンパイラ
- このスクリプトはDojo Toolkit（サードパーティライブラリ）の一部として提供されている
- コード内のTODOコメントにより、将来的にはDojoの汎用ビルドスクリプトに統合することが示唆されている
- Storage.asはFlash LocalSharedObjectを使用してブラウザにデータを永続化するクラス
- DojoExternalInterfaceはFlashのExternalInterfaceをラップし、JavaScriptとの通信を簡素化するクラス
- Flash Player 8以上が対象プラットフォーム
- 現代のWebアプリケーションではHTML5 LocalStorageが利用可能であり、このFlashベースのストレージは主にレガシーブラウザ対応のために残されている
- storage_dialog.swfは設定ダイアログ用の別コンポーネントであり、このスクリプトではビルドされない
