---
generated_at: 2026-02-11 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：2-buildFlashStorage.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：処理内容からの推測であり、明示的な要件定義なし
  2. **DojoExternalInterface.asの存在**：../flashディレクトリ内のファイルは未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/legacycms-master/public/_scripts/dojo/dojox/storage/buildFlashStorage.sh`（メインスクリプト）
- E-02: `/Users/tomoka.baba/Work/legacycms-master/public/_scripts/dojo/dojox/storage/Storage.as`（ActionScriptソース）
- E-03: `/Users/tomoka.baba/Work/legacycms-master/docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | mtascコンパイラを使用してSWFを生成 | E-01（4行目：mtasc ... -swf Storage.swf） | ○ |
| C-02 | Flash Player 8形式で出力 | E-01（4行目：-version 8） | ○ |
| C-03 | SWFサイズは215x138ピクセル | E-01（4行目：-header 215:138:10） | ○ |
| C-04 | フレームレートは10fps | E-01（4行目：-header 215:138:10） | ○ |
| C-05 | カスタムトレースハンドラはDojoExternalInterface.trace | E-01（4行目：-trace DojoExternalInterface.trace） | ○ |
| C-06 | -mainオプションでエントリーポイントを指定 | E-01（4行目：-main） | ○ |
| C-07 | クラスパスは../flash | E-01（4行目：-cp ../flash） | ○ |
| C-08 | 出力ファイル名はStorage.swf | E-01（4行目：-swf Storage.swf） | ○ |
| C-09 | 入力ファイルはStorage.as | E-01（4行目：Storage.as） | ○ |
| C-10 | コマンドライン引数は受け付けない | E-01（スクリプト全体に引数処理なし） | ○ |
| C-11 | TODOコメントでDojo汎用ビルドスクリプト統合を示唆 | E-01（2行目：# TODO: FIXME: Get rid of this and hook it into Dojo's general build script） | ○ |
| C-12 | mtascが必要という前提条件 | E-01（3行目：# You must have mtasc to run this）、E-03（備考欄） | ○ |
| C-13 | サードパーティ（Dojo Toolkit）のスクリプト | E-03（備考欄：「サードパーティ（Dojo Toolkit）のスクリプト」） | ○ |
| C-14 | 配置場所はpublic/_scripts/dojo/dojox/storage/ | E-03（備考欄）、E-01（ファイルパス） | ○ |
| C-15 | Storage.asはLocalSharedObjectを使用 | E-02（66行目：SharedObject.getLocal） | ○ |
| C-16 | JavaScriptとFlash間の通信を行う | E-02（20-34行目：DojoExternalInterface.addCallback） | ○ |
| C-17 | dojox.storage._onStatusコールバックを呼び出す | E-02（79-80行目、160-161行目等：DojoExternalInterface.call） | ○ |
| C-18 | storage_dialog.swfと連携する | E-02（39-41行目、218-220行目：loadMovie storage_dialog.swf） | ○ |
| C-19 | バッチ種別はビルド | E-03（カテゴリ「ビルド」） | ○ |
| C-20 | DojoExternalInterfaceをインポート | E-02（1行目：import DojoExternalInterface） | ○ |
| C-21 | DojoExternalInterface.asは../flashに存在 | **根拠なし**（../flashディレクトリ内は未確認） | △ |
| C-22 | パフォーマンス要件は数秒以内 | **根拠なし**（処理内容からの推測） | △ |

## 4) 不足情報（Unknown / Missing）
- ../flash/DojoExternalInterface.asファイルの存在確認ができなかった
  - 候補：public/_scripts/dojo/dojox/flash/DojoExternalInterface.as / flash/DojoExternalInterface.as
- mtascコンパイラの詳細ドキュメント
  - 候補：外部ドキュメント / Dojo Toolkit公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの内容は単純で、オプションの意味は明確
- 1: 中リスク - DojoExternalInterface.asの存在は未確認（C-21）
- 0: 低リスク - Storage.asの機能はソースコードから詳細に確認済み
- 1: 中リスク - パフォーマンス要件は推測による（C-22）
- 0: 低リスク - バッチ一覧との整合性は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ../flash/DojoExternalInterface.asファイルが実際に存在することを確認
- [ ] mtascコンパイラが開発環境にインストール可能か確認（Motion-Twin ActionScript Compilerは現在メンテナンスされていない可能性）
- [ ] このFlashストレージ機能が現在も必要か確認（HTML5 LocalStorage対応ブラウザが一般的になった現在、レガシー機能の可能性）
- [ ] storage_dialog.swfのビルド方法が別途ドキュメント化されているか確認
