---
generated_at: 2026-02-11 20:15:00
metrics:
  claims_total: 134
  claims_with_evidence: 134
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：admin-view-helpers 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：134 / 134、根拠なし：0
- 優先レビュー（高）
  1. **MakeDate - 日付フォーマット処理**：異常系テストケースの期待結果が実装依存
  2. **RGetType/MUserDetails - 存在しないID処理**：エラーハンドリングの実装確認が必要
  3. **MakeImageSize - ファイル不在処理**：実行時エラーの挙動確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/views/helpers/AStats.php`
- E-02: `application/modules/admin/views/helpers/MakeDate.php`
- E-03: `application/modules/admin/views/helpers/ECatCount.php`
- E-04: `application/modules/admin/views/helpers/EditCatSelect.php`
- E-05: `application/modules/admin/views/helpers/TagCount.php`
- E-06: `application/modules/admin/views/helpers/Acatselect.php`
- E-07: `application/modules/admin/views/helpers/EVenueSelect.php`
- E-08: `application/modules/admin/views/helpers/MReleaseSelect.php`
- E-09: `application/modules/admin/views/helpers/UStats.php`
- E-10: `application/modules/admin/views/helpers/YtDuration.php`
- E-11: `application/modules/admin/views/helpers/URolexSelect.php`
- E-12: `application/modules/admin/views/helpers/RGetType.php`
- E-13: `application/modules/admin/views/helpers/MListSelect.php`
- E-14: `application/modules/admin/views/helpers/RStats.php`
- E-15: `application/modules/admin/views/helpers/URoleCount.php`
- E-16: `application/modules/admin/views/helpers/CommentCount.php`
- E-17: `application/modules/admin/views/helpers/EcountriesOptions.php`
- E-18: `application/modules/admin/views/helpers/RCatSelect.php`
- E-19: `application/modules/admin/views/helpers/MSubscriberCount.php`
- E-20: `application/modules/admin/views/helpers/URoleSelect.php`
- E-21: `application/modules/admin/views/helpers/MStats.php`
- E-22: `application/modules/admin/views/helpers/UStatusCount.php`
- E-23: `application/modules/admin/views/helpers/RotStats.php`
- E-24: `application/modules/admin/views/helpers/MSubStatusAll.php`
- E-25: `application/modules/admin/views/helpers/MgetTo.php`
- E-26: `application/modules/admin/views/helpers/CountriesOptions.php`
- E-27: `application/modules/admin/views/helpers/MGroupCount.php`
- E-28: `application/modules/admin/views/helpers/RotSlideCount.php`
- E-29: `application/modules/admin/views/helpers/CslaveDetails.php`
- E-30: `application/modules/admin/views/helpers/RenderMessages.php`
- E-31: `application/modules/admin/views/helpers/ACatCount.php`
- E-32: `application/modules/admin/views/helpers/CCount.php`
- E-33: `application/modules/admin/views/helpers/AssetType.php`
- E-34: `application/modules/admin/views/helpers/MUserDetails.php`
- E-35: `application/modules/admin/views/helpers/CStats.php`
- E-36: `application/modules/admin/views/helpers/EDate.php`
- E-37: `application/modules/admin/views/helpers/RCatCount.php`
- E-38: `application/modules/admin/views/helpers/RBrandSelect.php`
- E-39: `application/modules/admin/views/helpers/GetFExt.php`
- E-40: `application/modules/admin/views/helpers/YtStats.php`
- E-41: `application/modules/admin/views/helpers/UPrvForm.php`
- E-42: `application/modules/admin/views/helpers/EStats.php`
- E-43: `application/modules/admin/views/helpers/MakeImageSize.php`
- E-44: `application/modules/admin/views/helpers/MStatusCount.php`
- E-45: `application/modules/admin/views/helpers/MsStats.php`
- E-46: `application/modules/admin/views/helpers/BaseUrl.php`
- E-47: `application/modules/admin/views/helpers/ECatSelect.php`
- E-48: `application/modules/admin/views/helpers/MakeFileSize.php`
- E-49: `application/modules/admin/views/helpers/AssetFile.php`
- E-50: `application/modules/admin/views/helpers/PStats.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### 統計ヘルパー（Stats系）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AStats.aStats: 記事統計情報を取得しHTML文字列を返却 | E-01 | ○ |
| C-02 | AStats.aStats: 記事0件時にすべて0のHTML返却 | E-01 | ○ |
| C-23 | UStats.uStats: ユーザー統計情報を取得 | E-09 | ○ |
| C-36 | RStats.rStats: リソース統計情報を取得 | E-14 | ○ |
| C-51 | MStats.mStats: メール統計情報を取得 | E-21 | ○ |
| C-55 | RotStats.rotStats: ローテーター統計情報を取得 | E-23 | ○ |
| C-92 | CStats.cStats: コメント統計情報を取得 | E-35 | ○ |
| C-105 | YtStats.ytStats: YouTube統計情報を取得 | E-40 | ○ |
| C-111 | EStats.eStats: イベント統計情報を取得 | E-42 | ○ |
| C-118 | MsStats.msStats: 音楽統計情報を取得 | E-45 | ○ |
| C-133 | PStats.pStats: ページ統計情報を取得 | E-50 | ○ |

### 日付・時間処理ヘルパー
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | MakeDate.MakeDate: 日付フォーマット変換 | E-02 | ○ |
| C-06 | MakeDate.MakeDate: 無効日付時のエラー処理 | E-02 | ○ |
| C-25 | YtDuration.YtDuration: 秒数を分:秒形式に変換 | E-10 | ○ |
| C-26 | YtDuration.YtDuration: 0秒の処理 | E-10 | ○ |
| C-94 | EDate.EDate: イベント日付フォーマット | E-36 | ○ |

### セレクトボックス生成ヘルパー
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | EditCatSelect.editCatSelect: カテゴリ選択オプション生成 | E-04 | ○ |
| C-15 | Acatselect.Acatselect: 記事カテゴリセレクト生成 | E-06 | ○ |
| C-17 | EVenueSelect.EVenueSelect: 会場セレクト生成 | E-07 | ○ |
| C-21 | MReleaseSelect.MReleaseSelect: リリースセレクト生成 | E-08 | ○ |
| C-29 | URolexSelect.URolexSelect: ロールセレクト生成 | E-11 | ○ |
| C-34 | MListSelect.MListSelect: メーリングリストセレクト生成 | E-13 | ○ |
| C-45 | RCatSelect.rcatSelect: リソースカテゴリセレクト生成 | E-18 | ○ |
| C-49 | URoleSelect.URoleSelect: ロールセレクト生成 | E-20 | ○ |
| C-99 | RBrandSelect.rbrandSelect: ブランドセレクト生成 | E-38 | ○ |
| C-121 | ECatSelect.ECatSelect: イベントカテゴリセレクト生成 | E-47 | ○ |

### カウント系ヘルパー
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | ECatCount.ECatCount: イベントカテゴリカウント | E-03 | ○ |
| C-13 | TagCount.tagCount: タグカウント | E-05 | ○ |
| C-38 | URoleCount.URoleCount: ロール別ユーザーカウント | E-15 | ○ |
| C-40 | CommentCount.commentCount: コメントカウント | E-16 | ○ |
| C-47 | MSubscriberCount.MSubscriberCount: 購読者カウント | E-19 | ○ |
| C-53 | UStatusCount.UStatusCount: ステータス別ユーザーカウント | E-22 | ○ |
| C-67 | MGroupCount.MGroupCount: グループ別メールカウント | E-27 | ○ |
| C-69 | RotSlideCount.rotSlideCount: スライドカウント | E-28 | ○ |
| C-80 | ACatCount.acatCount: 記事カテゴリカウント | E-31 | ○ |
| C-82 | CCount.CCount: コメントカウント | E-32 | ○ |
| C-97 | RCatCount.rcatCount: リソースカテゴリカウント | E-37 | ○ |
| C-116 | MStatusCount.MStatusCount: メールステータスカウント | E-44 | ○ |

### ファイル・アセット処理ヘルパー
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | AssetType.Assettype: MIMEタイプ判定 | E-33 | ○ |
| C-101 | GetFExt.getFExt: ファイル拡張子抽出 | E-39 | ○ |
| C-113 | MakeImageSize.MakeImageSize: 画像サイズ取得 | E-43 | ○ |
| C-124 | MakeFileSize.MakeFileSize: ファイルサイズ変換 | E-48 | ○ |
| C-130 | AssetFile.AssetFile: アセットファイル名取得 | E-49 | ○ |

### データ取得・表示ヘルパー
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | RGetType.rgetType: リソースタイプ名取得 | E-12 | ○ |
| C-57 | MSubStatusAll.MSubStatusAll: 購読状態確認 | E-24 | ○ |
| C-61 | MgetTo.MgetTo: 宛先リンク生成 | E-25 | ○ |
| C-71 | CslaveDetails.cslaveDetails: スレーブ詳細取得 | E-29 | ○ |
| C-76 | RenderMessages.RenderMessages: エラーメッセージ表示 | E-30 | ○ |
| C-90 | MUserDetails.MUserDetails: ユーザー詳細取得 | E-34 | ○ |
| C-107 | UPrvForm.UPrvForm: 権限フォーム生成 | E-41 | ○ |

### ユーティリティヘルパー
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | EcountriesOptions.EcountriesOptions: 国名リスト生成 | E-17 | ○ |
| C-65 | CountriesOptions.countriesOptions: 国コード付きリスト生成 | E-26 | ○ |
| C-120 | BaseUrl.baseUrl: ベースURL取得 | E-46 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - すべてのテストケースはソースコードを直接解析して生成されており、根拠が明確に存在する

## 5) リスクフラグ（レビュー観点）

### 高リスク（2）
- **RGetType.rgetType / MUserDetails.MUserDetails**: 存在しないIDを渡した場合の配列アクセスエラー
  - コード上で`$tArray[0]`/`$userArray['0']`に直接アクセスしており、結果が空の場合に未定義インデックスエラーが発生する可能性
- **MakeImageSize.MakeImageSize**: 存在しないファイルパスを渡した場合のgetimagesize()エラー
  - ファイル存在チェックなしでgetimagesize()を呼び出している

### 中リスク（1）
- **MSubStatusAll.MSubStatusAll**: `&`演算子の使用
  - 論理演算子`&&`ではなくビット演算子`&`が使用されている（意図的かどうか要確認）
- **echo出力 vs return**: 一部のヘルパーはechoで直接出力し、他はreturnで値を返す
  - テスト時の検証方法が異なる点に注意が必要

### 低リスク（0）
- 各ヘルパーのsetViewメソッドは共通パターンで実装されており、基本的なテストで十分

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-AVH-004〜007, UT-AVH-033, UT-AVH-091, UT-AVH-114〜115）の期待結果が実際の実装と一致するか確認
- [ ] MSubStatusAllの`&`演算子が意図通りかコード上で確認
- [ ] DB依存のテストケースについて、テスト環境でのモック方針を確認
- [ ] echo出力系ヘルパーのテスト方法（出力バッファリング等）を確認
- [ ] UPrvFormのACL依存処理について、CMS_Acl_Factoryのモック方針を確認
