---
generated_at: 2026-02-11 20:05:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：application-core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **UT-APC-011**：空文字列のenv指定時の挙動（境界値）- コード上で空文字列の検証なし
  2. **UT-APC-012**：nullのenv指定時の挙動（異常系）- 型宣言がないためPHP動作依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/bootstrap.php` - アプリケーションエントリポイント（23行）
- E-02: `application/initializer.php` - Initializerクラス定義（254行）
- E-03: `application/initializer.php:55-135` - __constructメソッド
- E-04: `application/initializer.php:143-146` - _setEnvメソッド
- E-05: `application/initializer.php:154-156` - initPhpConfigメソッド
- E-06: `application/initializer.php:163-171` - routeStartupメソッド
- E-07: `application/initializer.php:178-187` - initDbメソッド
- E-08: `application/initializer.php:194-200` - initHelpersメソッド
- E-09: `application/initializer.php:207-215` - initViewメソッド
- E-10: `application/initializer.php:222-228` - initPluginsメソッド
- E-11: `application/initializer.php:235-241` - initRoutesメソッド
- E-12: `application/initializer.php:248-251` - initControllersメソッド
- E-13: `docs/code-to-docs/単体テストケース一覧/plan.md` - プロジェクト情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Initializerコンストラクタでdevelopment環境初期化 | E-03 (72-85行: if/else分岐) | ○ |
| C-02 | Initializerコンストラクタでproduction環境初期化 | E-03 (80-85行: else分岐) | ○ |
| C-03 | カスタムrootパス指定の動作 | E-03 (58-61行: null判定とroot設定) | ○ |
| C-04 | development環境でエラー表示有効化 | E-03 (73-79行: error_reporting, display_errors設定) | ○ |
| C-05 | production環境でエラー表示無効化 | E-03 (82-84行: error_reporting(0)) | ○ |
| C-06 | 設定ファイルのレジストリ登録 | E-03 (91-104行: config, site, search, assets登録) | ○ |
| C-07 | SMTPトランスポート設定 | E-03 (107-116行: Zend_Mail_Transport_Smtp生成) | ○ |
| C-08 | ロケール設定 | E-03 (119-120行: Zend_Locale('en_GB')) | ○ |
| C-09 | キャッシュ設定 | E-03 (122-133行: Zend_Cache::factory) | ○ |
| C-10 | config.ini欠損時の例外 | E-03 (91行: new Zend_Config_Ini) | ○ |
| C-11 | 空文字列env指定時の挙動 | E-04 (検証ロジックなし) | △ |
| C-12 | null env指定時の挙動 | E-04 (型宣言なし、PHP動作依存) | △ |
| C-13 | _setEnvメソッドの動作 | E-04 ($this->_env = $env) | ○ |
| C-14 | initPhpConfigメソッドの動作 | E-05 (空実装) | ○ |
| C-15 | routeStartupメソッドの初期化フロー | E-06 (165-170行: 6メソッド呼び出し) | ○ |
| C-16 | routeStartupにnull渡し時の挙動 | E-06 (型ヒント: Zend_Controller_Request_Abstract) | ○ |
| C-17 | initDbのデータベース接続 | E-07 (184-186行: Zend_Db::factory, setDefaultAdapter) | ○ |
| C-18 | initDbのDB設定不正時例外 | E-07 (Zend_Db::factoryの仕様) | ○ |
| C-19 | initDbのDB接続失敗時の挙動 | E-07 (Zend_Db_Adapter仕様) | ○ |
| C-20 | initHelpersのパス登録 | E-08 (197-199行: addPath 2回呼び出し) | ○ |
| C-21 | initHelpersのディレクトリ欠損時 | E-08 (Zend_Controller_Action_HelperBroker仕様) | ○ |
| C-22 | initViewのレイアウト設定 | E-09 (210-213行: Zend_Layout::startMvc) | ○ |
| C-23 | initViewのレイアウト欠損時 | E-09 (Zend_Layout仕様) | ○ |
| C-24 | initPluginsのプラグイン登録 | E-10 (227行: registerPlugin) | ○ |
| C-25 | initPluginsのクラス欠損時 | E-10 (オートローダー仕様) | ○ |
| C-26 | initRoutesのルート読み込み | E-11 (238-240行: getRouter, addConfig) | ○ |
| C-27 | initRoutesのroutes設定欠損時 | E-11 (Zend_Config_Ini仕様) | ○ |
| C-28 | initControllersのモジュールディレクトリ追加 | E-12 (250行: addModuleDirectory) | ○ |
| C-29 | initControllersのディレクトリ欠損時 | E-12 (Zend_Controller_Front仕様) | ○ |
| C-30 | bootstrap.phpのインクルードパス設定 | E-01 (12行: set_include_path) | ○ |
| C-31 | bootstrap.phpのフロントコントローラ取得 | E-01 (17行: Zend_Controller_Front::getInstance) | ○ |
| C-32 | bootstrap.phpのプラグイン登録 | E-01 (20行: registerPlugin) | ○ |
| C-33 | bootstrap.phpのディスパッチ | E-01 (23行: dispatch) | ○ |
| C-34 | vendor/autoload.php欠損時 | E-01 (10行: require) | ○ |
| C-35 | initializer.php欠損時 | E-01 (14行: require_once) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-APC-011（空文字列env）**: `_setEnv`メソッドに入力値の検証ロジックが存在しないため、空文字列が渡された場合の動作は実行時の挙動に依存する。Zend Frameworkの設定読み込み時に影響が出る可能性がある。
  - 候補：Zend_Config_Iniのセクション読み込みドキュメント / PHPマニュアル
- **UT-APC-012（null env）**: PHPの型宣言がないため、nullが渡された場合の動作はPHPバージョンと設定に依存する。
  - 候補：PHP 5.x/7.x/8.xの型処理仕様 / Zend Framework 1.12のドキュメント

## 5) リスクフラグ（レビュー観点）
- **リスク1（高）**: `__construct`メソッドの設定読み込み処理は、外部ファイル（config.ini）に依存しており、ファイル欠損やフォーマット不正時の挙動確認が重要
- **リスク1（中）**: SMTP設定がハードコードされたポート番号（465）とSSL設定を含んでおり、環境依存の問題が発生する可能性
- **リスク0（低）**: `initPhpConfig`メソッドが空実装であり、将来の拡張ポイントとして残されているが、現時点ではテスト対象としての価値が低い

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースID UT-APC-001〜UT-APC-010（コンストラクタ関連）が実際のconfig.ini構造と整合しているか確認
- [ ] UT-APC-011, UT-APC-012の境界値・異常系テストが実際のPHP環境で期待通りに動作するか確認
- [ ] データベース初期化（UT-APC-017〜UT-APC-019）のテストが実際のDB設定と整合しているか確認
- [ ] bootstrap.php関連のテストケース（UT-APC-030〜UT-APC-035）がZend Framework 1.12の仕様と整合しているか確認
- [ ] 各テストケースの「前提条件」が実際のテスト環境で再現可能か確認
