---
generated_at: 2026-02-11 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 150
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：default-controllers 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：150 / 150、根拠なし：0
- 優先レビュー（高）
  1. **認証関連テストケース（UT-DFC-040〜066）**：セキュリティ上の重要度が高い
  2. **コメント投稿機能（UT-DFC-015〜017, 083, 123）**：ユーザー入力を扱う処理
  3. **パスワード変更機能（UT-DFC-133〜138）**：セキュリティクリティカル

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/controllers/ArticlesController.php` - 記事表示関連コントローラ（551行）
- E-02: `application/modules/default/controllers/AssetsController.php` - アセット管理コントローラ（329行）
- E-03: `application/modules/default/controllers/AuthController.php` - 認証コントローラ（534行）
- E-04: `application/modules/default/controllers/CommentsController.php` - コメントコントローラ（33行）
- E-05: `application/modules/default/controllers/ErrorController.php` - エラーハンドリングコントローラ（83行）
- E-06: `application/modules/default/controllers/EventsController.php` - イベント管理コントローラ（435行）
- E-07: `application/modules/default/controllers/IndexController.php` - トップページコントローラ（216行）
- E-08: `application/modules/default/controllers/PagesController.php` - ページ表示コントローラ（109行）
- E-09: `application/modules/default/controllers/ProductsController.php` - 製品/リソース管理コントローラ（588行）
- E-10: `application/modules/default/controllers/SettingsController.php` - ユーザー設定コントローラ（421行）
- E-11: `application/modules/default/controllers/TwitterController.php` - Twitter連携コントローラ（30行）
- E-12: `docs/code-to-docs/単体テストケース一覧/plan.md` - テストケース一覧生成プラン

## 3) Claims と根拠の対応（レビューの主戦場）

### ArticlesController（UT-DFC-001〜021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ArticlesController.init()が設定ファイルを読み込みレイアウトを設定する | E-01 L11-22 | ○ |
| C-02 | indexAction()が公開済み記事をページネーション付きで取得する | E-01 L27-63 | ○ |
| C-03 | categoryAction()がカテゴリ別記事を取得し、NULL時は404にフォワードする | E-01 L68-118 | ○ |
| C-04 | authorAction()が著者別記事を取得し、NULL時は404にフォワードする | E-01 L123-173 | ○ |
| C-05 | archiveAction()が年月アーカイブを取得し、年がNULL時は404にフォワードする | E-01 L178-267 | ○ |
| C-06 | articleAction()が記事詳細を取得し、コメント投稿を処理する | E-01 L272-369 | ○ |
| C-07 | tagsAction()がsetRefer()を呼び出す | E-01 L374-378 | ○ |
| C-08 | tagAction()がタグ別記事を取得する | E-01 L383-420 | ○ |
| C-09 | atomAction()がAtomフィードを生成する | E-01 L425-485 | ○ |
| C-10 | rssAction()がRSSフィードを生成する | E-01 L490-550 | ○ |

### AssetsController（UT-DFC-022〜039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | setLayout()がarticlesレイアウトを設定する | E-02 L14-18 | ○ |
| C-12 | assetType()がMIMEタイプに基づいてファイルタイプを判定する | E-02 L23-38 | ○ |
| C-13 | thumbAction()がサムネイルを生成し、各種エラーケースを処理する | E-02 L43-207 | ○ |
| C-14 | openAction()がアセットをインライン表示し、エラー時は404にフォワードする | E-02 L212-267 | ○ |
| C-15 | downloadAction()がアセットをダウンロード提供し、エラー時は404にフォワードする | E-02 L272-327 | ○ |

### AuthController（UT-DFC-040〜066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | init()がセッションネームスペースを初期化する | E-03 L15-18 | ○ |
| C-17 | preDispatch()が認証状態に基づきリダイレクト処理を行う | E-03 L20-35 | ○ |
| C-18 | generatepassword()が8文字のランダムパスワードを生成する | E-03 L37-52 | ○ |
| C-19 | loginAction()が認証処理を行い、バリデーションとエラー処理を実施する | E-03 L54-158 | ○ |
| C-20 | passwordAction()がパスワードリセット処理を行う | E-03 L160-244 | ○ |
| C-21 | logoutAction()が認証情報をクリアしリダイレクトする | E-03 L246-251 | ○ |
| C-22 | registerAction()がユーザー登録処理とバリデーションを行う | E-03 L253-461 | ○ |
| C-23 | activateAction()がアカウントアクティベーション処理を行う | E-03 L463-532 | ○ |

### CommentsController（UT-DFC-067〜068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | commentsAction()がコメント一覧を取得しデフォルトパラメータを設定する | E-04 L18-31 | ○ |

### ErrorController（UT-DFC-069〜074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | setLayout()がmainレイアウトを設定する | E-05 L12-16 | ○ |
| C-26 | errorAction()がエラータイプに応じたエラー表示を行う | E-05 L24-49 | ○ |
| C-27 | notfoundAction()が強制404エラー表示を行う | E-05 L55-64 | ○ |
| C-28 | closedAction()がサイトクローズ表示を行う | E-05 L70-82 | ○ |

### EventsController（UT-DFC-075〜091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | init()がevents設定を読み込みレイアウトを設定する | E-06 L12-23 | ○ |
| C-30 | indexAction()が今後のイベント一覧を取得する | E-06 L28-60 | ○ |
| C-31 | calendarAction()が年月日に基づいてイベントを取得する | E-06 L65-155 | ○ |
| C-32 | eventAction()がイベント詳細を取得しコメント投稿を処理する | E-06 L160-254 | ○ |
| C-33 | categoryAction()がカテゴリ別イベントを取得する | E-06 L259-322 | ○ |
| C-34 | venueAction()が会場別イベントを取得する | E-06 L327-389 | ○ |
| C-35 | mapAction()がマップ表示用アクションを実行する | E-06 L394-400 | ○ |
| C-36 | acalendarAction()がAJAXカレンダー表示を行う | E-06 L405-412 | ○ |
| C-37 | mapdataAction()がマップデータを取得する | E-06 L417-433 | ○ |

### IndexController（UT-DFC-092〜101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | init()がarticlesとyoutube設定を読み込む | E-07 L12-25 | ○ |
| C-39 | indexAction()が最新5件の記事を取得する | E-07 L30-50 | ○ |
| C-40 | tagsAction()がsetRefer()を呼び出す | E-07 L55-58 | ○ |
| C-41 | searchAction()がサイト内検索を実行する | E-07 L63-117 | ○ |
| C-42 | contactAction()が問い合わせフォーム処理を行う | E-07 L122-215 | ○ |

### PagesController（UT-DFC-102〜106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | init()がpages設定を読み込みレイアウトを設定する | E-08 L12-23 | ○ |
| C-44 | pageAction()がスラッグ指定でページを取得する | E-08 L28-59 | ○ |
| C-45 | tagsAction()がsetRefer()を呼び出す | E-08 L64-67 | ○ |
| C-46 | tagAction()がタグ別ページを取得する | E-08 L72-107 | ○ |

### ProductsController（UT-DFC-107〜125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | init()がproducts設定を読み込みレイアウトを設定する | E-09 L12-23 | ○ |
| C-48 | indexAction()が製品カテゴリ一覧を取得する | E-09 L28-44 | ○ |
| C-49 | categoryAction()がカテゴリ別リソースを取得する | E-09 L49-120 | ○ |
| C-50 | typeAction()がタイプ別リソースを取得する | E-09 L125-195 | ○ |
| C-51 | authorAction()が著者別リソースを取得する | E-09 L200-271 | ○ |
| C-52 | illustratorAction()がイラストレーター別リソースを取得する | E-09 L276-347 | ○ |
| C-53 | brandAction()がブランド別リソースを取得する | E-09 L352-419 | ○ |
| C-54 | resourceAction()がリソース詳細を取得しコメント投稿を処理する | E-09 L424-534 | ○ |
| C-55 | tagsAction()がsetRefer()を呼び出す | E-09 L539-543 | ○ |
| C-56 | tagAction()がタグ別リソースを取得する | E-09 L548-586 | ○ |

### SettingsController（UT-DFC-126〜148）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | init()がmainレイアウトを設定する | E-10 L12-16 | ○ |
| C-58 | generatepassword()が8文字のランダムパスワードを生成する | E-10 L18-33 | ○ |
| C-59 | indexAction()がユーザー設定画面とプロフィール更新を処理する | E-10 L38-171 | ○ |
| C-60 | passwordAction()がパスワード変更処理を行う | E-10 L176-274 | ○ |
| C-61 | subscriptionsAction()が購読設定を管理する | E-10 L279-341 | ○ |
| C-62 | aliascheckAction()がエイリアスの重複をチェックする | E-10 L346-374 | ○ |
| C-63 | passwordcheckAction()がパスワード強度をチェックする | E-10 L379-419 | ○ |

### TwitterController（UT-DFC-149〜150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | init()がレジストリを設定しレイアウトを無効化する | E-11 L11-16 | ○ |
| C-65 | tweetsAction()がツイート一覧を取得する | E-11 L21-28 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースは実際のソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 一般的な表示系アクション（index, tags, map等）
- **1（中リスク）**: ページネーション、カテゴリ・タグフィルタリング等のデータ取得系
- **2（高リスク）**:
  - 認証・認可関連（AuthController全体、SettingsControllerの認証チェック）
  - ユーザー入力処理（コメント投稿、問い合わせフォーム、ユーザー登録）
  - パスワード処理（パスワード生成、変更、リセット）
  - ファイル操作（AssetsControllerのサムネイル生成、ダウンロード）

## 6) レビュアーチェックリスト（最小）
- [ ] 認証関連テストケース（UT-DFC-040〜066）が全ての認証パスをカバーしているか確認
- [ ] SQLインジェクション対策のテストケースが含まれているか確認（パラメータバインディングの使用）
- [ ] XSS対策のテストケースが含まれているか確認（特にコメント投稿、問い合わせフォーム）
- [ ] ファイルアップロード/ダウンロードの権限チェックが適切にテストされているか確認
- [ ] CAPTCHA検証のテストケースが適切か確認
- [ ] パスワード強度チェックの閾値が適切か確認
- [ ] セッション管理のテストケースが含まれているか確認
- [ ] 各404エラーフォワードのテストケースが網羅されているか確認
