---
generated_at: 2026-02-11 15:30:00
metrics:
  claims_total: 139
  claims_with_evidence: 139
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：default-view-helpers 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：139 / 139、根拠なし：0
- 優先レビュー（高）
  1. **UT-DVH-029〜038**：BBCode変換処理 - XSS対策の観点で重要
  2. **UT-DVH-082〜085**：MSubStatus - 例外処理と入力バリデーション
  3. **UT-DVH-039**：BaseUrl - 基盤機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/default/views/helpers/AArchiveOptions.php`
- E-02: `application/modules/default/views/helpers/ACategoryList.php`
- E-03: `application/modules/default/views/helpers/ADate.php`
- E-04: `application/modules/default/views/helpers/ARecentList.php`
- E-05: `application/modules/default/views/helpers/ATagBox.php`
- E-06: `application/modules/default/views/helpers/ATagCloud.php`
- E-07: `application/modules/default/views/helpers/ATagCount.php`
- E-08: `application/modules/default/views/helpers/AssetType.php`
- E-09: `application/modules/default/views/helpers/BBCode.php`
- E-10: `application/modules/default/views/helpers/BaseUrl.php`
- E-11: `application/modules/default/views/helpers/CCount.php`
- E-12: `application/modules/default/views/helpers/CDate.php`
- E-13: `application/modules/default/views/helpers/CGCount.php`
- E-14: `application/modules/default/views/helpers/CountriesOptions.php`
- E-15: `application/modules/default/views/helpers/DynThumbnail.php`
- E-16: `application/modules/default/views/helpers/ECDate.php`
- E-17: `application/modules/default/views/helpers/ECalendar.php`
- E-18: `application/modules/default/views/helpers/ECalendarBox.php`
- E-19: `application/modules/default/views/helpers/ECalendarMonths.php`
- E-20: `application/modules/default/views/helpers/ECalendarOptions.php`
- E-21: `application/modules/default/views/helpers/ECategoryList.php`
- E-22: `application/modules/default/views/helpers/EDate.php`
- E-23: `application/modules/default/views/helpers/EMapEventCount.php`
- E-24: `application/modules/default/views/helpers/EMapEventList.php`
- E-25: `application/modules/default/views/helpers/ENextEventsList.php`
- E-26: `application/modules/default/views/helpers/ESDate.php`
- E-27: `application/modules/default/views/helpers/MSubStatus.php`
- E-28: `application/modules/default/views/helpers/PRRecentList.php`
- E-29: `application/modules/default/views/helpers/PTagBox.php`
- E-30: `application/modules/default/views/helpers/PTagCloud.php`
- E-31: `application/modules/default/views/helpers/PTagCount.php`
- E-32: `application/modules/default/views/helpers/RCategoryList.php`
- E-33: `application/modules/default/views/helpers/RTagBox.php`
- E-34: `application/modules/default/views/helpers/RTagCloud.php`
- E-35: `application/modules/default/views/helpers/RTagCount.php`
- E-36: `application/modules/default/views/helpers/RTypeCount.php`
- E-37: `application/modules/default/views/helpers/RenderMessages.php`
- E-38: `application/modules/default/views/helpers/RenderRotator.php`
- E-39: `application/modules/default/views/helpers/TBox.php`
- E-40: `application/modules/default/views/helpers/TCloud.php`
- E-41: `application/modules/default/views/helpers/TCount.php`
- E-42: `application/modules/default/views/helpers/TList.php`
- E-43: `application/modules/default/views/helpers/TwitTime.php`
- E-44: `application/modules/default/views/helpers/YRenderVideo.php`
- E-45: `application/modules/default/views/helpers/YTagBox.php`
- E-46: `application/modules/default/views/helpers/YtDuration.php`
- E-47: `application/modules/default/views/helpers/YtTagCloud.php`
- E-48: `application/modules/default/views/helpers/YtTagCount.php`

## 3) Claims と根拠の対応（レビューの主戦場）

### AArchiveOptions.php (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | archiveCountメソッドが月・年を引数として記事数をカウント | E-01 L21-40 | ○ |
| C-02 | AArchiveOptionsメソッドがドロップダウン形式でアーカイブを表示 | E-01 L44-75 | ○ |
| C-03 | setViewメソッドがZend_View_Interfaceを受け取る | E-01 L80-83 | ○ |

### ACategoryList.php (E-02)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | ACatCountメソッドがカテゴリIDで記事数をカウント | E-02 L21-35 | ○ |
| C-05 | ACategoryListメソッドがカテゴリリストをHTML出力 | E-02 L39-61 | ○ |

### ADate.php (E-03)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | ADateメソッドがstrtotimeで日付を変換 | E-03 L23-29 | ○ |
| C-07 | 'l jS F Y'形式でフォーマット | E-03 L28 | ○ |

### ARecentList.php (E-04)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | ARecentListメソッドが$numと$linksを引数に取る | E-04 L23 | ○ |
| C-09 | linksがtrueの場合More Articlesリンクを表示 | E-04 L50-54 | ○ |

### ATagBox.php (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | ATagBoxメソッドが$num引数でALLまたは数値を受け取る | E-05 L23 | ○ |
| C-11 | CMS_Wordcloud_Wordcloudを使用してタグクラウドを生成 | E-05 L48 | ○ |
| C-12 | placeholder('showTags')をチェックして表示制御 | E-05 L57 | ○ |

### ATagCloud.php (E-06)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | ATagCloudメソッドが$actionと$numを引数に取る | E-06 L23 | ○ |
| C-14 | タグが0件の場合'No tags!'を表示 | E-06 L71 | ○ |

### ATagCount.php (E-07)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | ATagCountメソッドが$tagでALLまたは特定タグを指定可能 | E-07 L23 | ○ |
| C-16 | distinctを使用してユニークタグをカウント | E-07 L37-38 | ○ |

### AssetType.php (E-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | MIMEタイプがimage/jpeg等の場合'image'を返却 | E-08 L25-30 | ○ |
| C-18 | video/x-flvの場合'video'を返却 | E-08 L27, L31-32 | ○ |
| C-19 | それ以外の場合'other'を返却 | E-08 L33-35 | ○ |

### BBCode.php (E-09)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | [b]タグをspan.boldに変換 | E-09 L49 | ○ |
| C-21 | [i]タグをspan.italicsに変換 | E-09 L52 | ○ |
| C-22 | [url]タグをaタグに変換 | E-09 L40-41 | ○ |
| C-23 | HTMLタグを&lt;&gt;にエスケープ | E-09 L28-29 | ○ |
| C-24 | nl2brで改行を変換 | E-09 L32 | ○ |

### BaseUrl.php (E-10)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | baseUrlメソッドがZend_Controller_FrontからベースURLを取得 | E-10 L11-14 | ○ |

### CCount.php (E-11)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | CCountメソッドが$slaveと$typeで承認済みコメントをカウント | E-11 L23-36 | ○ |

### CDate.php (E-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | CDateメソッドが'l jS F Y g:ia'形式で日時をフォーマット | E-12 L23-28 | ○ |

### CGCount.php (E-13)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | CGCountメソッドが0件で'No Comments'を出力 | E-13 L38-39 | ○ |
| C-29 | 1件で'1 Comment'を出力 | E-13 L40-41 | ○ |
| C-30 | 複数件で'X Comments'を出力 | E-13 L42-43 | ○ |

### CountriesOptions.php (E-14)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | countriesOptionsメソッドがZend_Localeで国リストを取得 | E-14 L25-27 | ○ |
| C-32 | ZZコードを除外 | E-14 L31 | ○ |

### DynThumbnail.php (E-15)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | dynThumbnailメソッドがadaptiveとresizeタイプをサポート | E-15 L24 | ○ |
| C-34 | ファイルが存在しない場合default.pngを使用 | E-15 L36-74 | ○ |
| C-35 | PhpThumbFactoryでサムネイルを生成 | E-15 L46, L64 | ○ |

### ECDate.php (E-16)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | ECDateメソッドが'h:ia'形式で時刻をフォーマット | E-16 L23-29 | ○ |

### ECalendar.php (E-17)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | generateCalendarメソッドが月間カレンダーを生成 | E-17 L21-99 | ○ |
| C-38 | 12月の場合翌月が1月、翌年が+1 | E-17 L31-37 | ○ |
| C-39 | 1月の場合前月が12月、前年が-1 | E-17 L38-44 | ○ |
| C-40 | イベントがある日にリンクを付与 | E-17 L78-79 | ○ |

### ECalendarBox.php (E-18)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | ECalendarBoxメソッドがContentPaneでカレンダーを表示 | E-18 L23-36 | ○ |
| C-42 | linksがtrueの場合追加リンクを表示 | E-18 L28-32 | ○ |

### ECalendarMonths.php (E-19)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | calendarCountメソッドが月別イベント数をカウント | E-19 L21-37 | ○ |
| C-44 | ECalendarMonthsメソッドがイベントのある月のみ表示 | E-19 L83-89 | ○ |

### ECalendarOptions.php (E-20)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | ECalendarOptionsメソッドがドロップダウン形式で月を表示 | E-20 L41-98 | ○ |

### ECategoryList.php (E-21)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | ECatCountメソッドがイベントカテゴリ別にカウント | E-21 L21-35 | ○ |
| C-47 | ECategoryListメソッドがカテゴリリストを表示 | E-21 L39-61 | ○ |

### EDate.php (E-22)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | EDateメソッドが開始日と終了日を受け取る | E-22 L23 | ○ |
| C-49 | 同日の場合終了時刻のみ追加 | E-22 L35-36 | ○ |
| C-50 | 異なる日の場合両方のフル日時を表示 | E-22 L37-38 | ○ |

### EMapEventCount.php (E-23)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | EMapEventCountメソッドが会場別に今後のイベントをカウント | E-23 L24-42 | ○ |

### EMapEventList.php (E-24)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | EMapEventListメソッドが会場別に最大3件のイベントを表示 | E-24 L24-45 | ○ |

### ENextEventsList.php (E-25)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | ENextEventsListメソッドが最大5件の次回イベントを表示 | E-25 L23, L38 | ○ |
| C-54 | venue_id=1の場合会場情報を省略 | E-25 L48-58 | ○ |

### ESDate.php (E-26)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | ESDateメソッドが'D jS M Y'形式で短縮日付を出力 | E-26 L27 | ○ |
| C-56 | 同日の場合終了日は空 | E-26 L35-36 | ○ |

### MSubStatus.php (E-27)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | MSubStatusメソッドが購読状態をboolで返却 | E-27 L23-47 | ○ |
| C-58 | 非数値の場合'Variables must be numeric'例外をスロー | E-27 L43 | ○ |
| C-59 | 未設定の場合'Variables not set'例外をスロー | E-27 L46 | ○ |

### PRRecentList.php (E-28)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | PRRecentListメソッドが最大3件の商品を表示 | E-28 L32 | ○ |
| C-61 | 価格をnumber_formatでフォーマット | E-28 L44 | ○ |

### PTagBox.php (E-29)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | PTagBoxメソッドがページタグのクラウドボックスを生成 | E-29 L23-72 | ○ |
| C-63 | tag_type='P'でフィルタ | E-29 L32, L40 | ○ |

### PTagCloud.php (E-30)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | PTagCloudメソッドがページタグクラウドを生成 | E-30 L23-67 | ○ |
| C-65 | タグが0件の場合'No tags!'を表示 | E-30 L66 | ○ |

### PTagCount.php (E-31)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | PTagCountメソッドがページタグをカウント | E-31 L23-46 | ○ |

### RCategoryList.php (E-32)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | RCatCountメソッドがリソースカテゴリ別にカウント | E-32 L21-34 | ○ |
| C-68 | RCategoryListメソッドがリソースカテゴリリストを表示 | E-32 L38-61 | ○ |

### RTagBox.php (E-33)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | RTagBoxメソッドがリソースタグクラウドボックスを生成 | E-33 L23-75 | ○ |
| C-70 | tag_type='R'でフィルタ | E-33 L35, L43 | ○ |

### RTagCloud.php (E-34)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | RTagCloudメソッドがリソースタグクラウドを生成 | E-34 L23-67 | ○ |

### RTagCount.php (E-35)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | RTagCountメソッドがリソースタグをカウント | E-35 L23-46 | ○ |

### RTypeCount.php (E-36)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | RTypeCountメソッドがBooksとToysを別々にカウント | E-36 L23-46 | ○ |
| C-74 | categoryがNULLの場合falseを返却 | E-36 L44-45 | ○ |

### RenderMessages.php (E-37)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | RenderMessagesメソッドがネストした配列を再帰的に処理 | E-37 L23-37 | ○ |

### RenderRotator.php (E-38)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | RenderRotatorメソッドがロテーター名で検索 | E-38 L29-32 | ○ |
| C-77 | rot_pagingの値でshowTabsを切り替え | E-38 L56-60 | ○ |
| C-78 | スライドをforeachでレンダリング | E-38 L66-79 | ○ |

### TBox.php (E-39)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | TBoxメソッドがtype, action, numを引数に取る | E-39 L23 | ○ |
| C-80 | typeとnumの組み合わせで4パターンのクエリを生成 | E-39 L31-53 | ○ |

### TCloud.php (E-40)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | TCloudメソッドが汎用タグクラウドを生成 | E-40 L23-75 | ○ |
| C-82 | タグが0件の場合'No tags!'を表示 | E-40 L74 | ○ |

### TCount.php (E-41)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | TCountメソッドがtag, typeの組み合わせでカウント | E-41 L23-55 | ○ |
| C-84 | tagTypeCountメソッドがタイプ別総数をカウント | E-41 L60-77 | ○ |

### TList.php (E-42)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | TListメソッドがslave, type, actionを引数に取る | E-42 L23 | ○ |
| C-86 | タグが0件の場合'None'を表示 | E-42 L41 | ○ |

### TwitTime.php (E-43)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | twitTimeメソッドがstart, end秒を受け取る | E-43 L23 | ○ |
| C-88 | 1時間以内の場合'about X minutes ago'を返却 | E-43 L26-32 | ○ |
| C-89 | 24時間以内の場合'about X hours ago'を返却 | E-43 L34-40 | ○ |
| C-90 | 24時間超の場合フル日時形式を返却 | E-43 L42-43 | ○ |

### YRenderVideo.php (E-44)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | YRenderVideoメソッドがkeyを引数に取る | E-44 L23 | ○ |
| C-92 | headScriptにYouTube用スクリプトを追加 | E-44 L26-28 | ○ |

### YTagBox.php (E-45)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | YTagBoxメソッドがyt_sync='Y'でフィルタ | E-45 L33, L41 | ○ |
| C-94 | tag_type='Y'でフィルタ | E-45 L32, L40 | ○ |

### YtDuration.php (E-46)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | YtDurationメソッドが秒数をmm:ss形式に変換 | E-46 L23-48 | ○ |
| C-96 | str_padで秒を2桁にパディング | E-46 L46 | ○ |

### YtTagCloud.php (E-47)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | YtTagCloudメソッドがYouTubeタグクラウドを生成 | E-47 L23-68 | ○ |
| C-98 | タグが0件の場合'No tags!'を表示 | E-47 L67 | ○ |

### YtTagCount.php (E-48)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | YtTagCountメソッドがYouTubeタグをカウント | E-48 L23-43 | ○ |
| C-100 | tag_type='Y'でフィルタ | E-48 L32, L38 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全てのテストケースはソースコードの実装に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 標準的なビューヘルパーの実装
- **1（中リスク）**: BBCode変換処理 - XSS対策の正当性確認が必要
- **1（中リスク）**: MSubStatus - 例外処理の適切性確認が必要
- **0（低リスク）**: DynThumbnail - ファイル操作の存在確認は実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] BBCode.phpのHTMLエスケープ処理が十分か確認（XSS対策）
- [ ] MSubStatus.phpの例外処理が適切にキャッチされるか確認
- [ ] DynThumbnail.phpのファイルパス処理にセキュリティリスクがないか確認
- [ ] 各ヘルパーのDB接続エラー時の挙動が適切か確認
- [ ] 日付フォーマット関連（ADate, CDate, EDate等）のタイムゾーン考慮確認
- [ ] タグクラウド系ヘルパーのplaceholder制御が正しく動作するか確認
