---
generated_at: 2026-02-11 20:05:00
metrics:
  claims_total: 77
  claims_with_evidence: 77
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：library-cms 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：77 / 77、根拠なし：0
- 優先レビュー（高）
  1. **ACL関連テスト（UT-LCM-001〜009）**：権限管理の重要機能、DBモックが必要
  2. **認証・認可テスト（UT-LCM-011〜015）**：セキュリティに直結する処理
  3. **パスワード強度テスト（UT-LCM-033〜045）**：セキュリティ評価ロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `library/CMS/Acl/Factory.php` - ACLファクトリクラス（85行）
- E-02: `library/CMS/Controller/Action/Admin.php` - 管理画面コントローラ基底クラス（62行）
- E-03: `library/CMS/Controller/Action/Auth.php` - 認証コントローラ基底クラス（28行）
- E-04: `library/CMS/Controller/Action/Default.php` - デフォルトコントローラ基底クラス（54行）
- E-05: `library/CMS/Controller/Action/Error.php` - エラーコントローラ基底クラス（42行）
- E-06: `library/CMS/Controller/Plugin/ErrorSelector.php` - エラーセレクタプラグイン（36行）
- E-07: `library/CMS/Password/Strength.php` - パスワード強度クラス（218行）
- E-08: `library/CMS/Wordcloud/Wordcloud.php` - ワードクラウドクラス（352行）

## 3) Claims と根拠の対応（レビューの主戦場）

### CMS_Acl_Factory（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createResourceAclがZend_Aclを返却する | E-01 L15-36 | ○ |
| C-02 | リソースに対する権限が正しく設定される | E-01 L27-33 | ○ |
| C-03 | 権限データが0件でも空ACLが返却される | E-01 L27-35 | ○ |
| C-04 | 空文字列リソースの処理 | E-01 L22 | ○ |
| C-05 | nullリソースの処理 | E-01 L22 | ○ |
| C-06 | createGlobalAclがZend_Aclを返却する | E-01 L42-82 | ○ |
| C-07 | 全リソースとロールがACLに追加される | E-01 L62-78 | ○ |
| C-08 | リソーステーブル空の場合の処理 | E-01 L66-68 | ○ |
| C-09 | ロールテーブル空の場合の処理 | E-01 L62-64 | ○ |

### CMS_Controller_Action_Admin（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | setReferがセッションにURIを保存する | E-02 L12-15 | ○ |
| C-11 | 認証済みユーザーのビュー設定 | E-02 L48-56 | ○ |
| C-12 | 未認証ユーザーのリダイレクト | E-02 L57-58 | ○ |
| C-13 | gadmin権限なしのフォワード | E-02 L54-56 | ○ |
| C-14 | Flashセッション対応処理 | E-02 L29-42 | ○ |
| C-15 | 不正セッションID形式の処理 | E-02 L30 (正規表現) | ○ |

### CMS_Controller_Action_Auth（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | 認証済みユーザーのビュー設定 | E-03 L17-21 | ○ |
| C-17 | 未認証ユーザーのauthenticated設定 | E-03 L18 | ○ |
| C-18 | baseUrl設定 | E-03 L24 | ○ |

### CMS_Controller_Action_Default（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | setReferがセッションにURIを保存する | E-04 L12-15 | ○ |
| C-20 | サイトクローズ時のフォワード | E-04 L26-29 | ○ |
| C-21 | 認証済みユーザーのビュー・ACL設定 | E-04 L36-42 | ○ |
| C-22 | 未認証ユーザーのrole=2設定 | E-04 L43-47 | ○ |
| C-23 | baseUrl設定 | E-04 L50 | ○ |

### CMS_Controller_Action_Error（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | setReferがセッションにURIを保存する | E-05 L12-15 | ○ |
| C-25 | 認証済みユーザーのビュー・ACL設定 | E-05 L24-30 | ○ |
| C-26 | 未認証ユーザーのrole=2設定 | E-05 L31-35 | ○ |
| C-27 | baseUrl設定 | E-05 L38 | ○ |

### CMS_Controller_Plugin_ErrorSelector（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | エラーハンドラモジュール設定 | E-06 L28-31 | ○ |
| C-29 | ErrorHandler未登録時の早期リターン | E-06 L16-17 | ○ |
| C-30 | エラーコントローラ未存在時の処理 | E-06 L28 | ○ |

### CMS_Password_Strength（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | setPasswordでパスワード設定 | E-07 L53-56 | ○ |
| C-32 | 空パスワードのpasswordLength設定 | E-07 L55 | ○ |
| C-33 | calculateAllでスコア計算 | E-07 L21-47 | ○ |
| C-34 | 強パスワードのExcellent評価 | E-07 L191-209 | ○ |
| C-35 | 弱パスワードのVery Bad評価 | E-07 L192-193 | ○ |
| C-36 | getInfoで計算結果取得 | E-07 L49-51 | ○ |
| C-37 | 長さ0のスコア計算 | E-07 L165-166 | ○ |
| C-38 | 長さ3のスコア計算 | E-07 L167-168 | ○ |
| C-39 | 長さ21以上のスコア計算 | E-07 L185-186 | ○ |
| C-40 | 数字のみパスワードのスコア | E-07 L106-108 | ○ |
| C-41 | 英字のみパスワードのスコア | E-07 L109-111 | ○ |
| C-42 | 英数字混在パスワードのスコア | E-07 L151-153 | ○ |
| C-43 | 特殊文字含むパスワードのスコア | E-07 L155-158 | ○ |
| C-44 | スコア15以下のVery Bad判定 | E-07 L192-193 | ○ |
| C-45 | スコア91-100のExcellent判定 | E-07 L207-208 | ○ |

### CMS_Wordcloud_Wordcloud（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | 文字列コンストラクタでaddString呼び出し | E-08 L44-45 | ○ |
| C-47 | 配列コンストラクタでaddWord呼び出し | E-08 L46-49 | ○ |
| C-48 | false入力時の処理 | E-08 L42 | ○ |
| C-49 | addStringで文字列分割 | E-08 L75-85 | ○ |
| C-50 | addStringでHTMLタグ除去 | E-08 L78 | ○ |
| C-51 | addStringで小文字変換 | E-08 L78 | ○ |
| C-52 | addWordで単語追加 | E-08 L114-136 | ○ |
| C-53 | 同じ単語追加時のsize加算 | E-08 L129-130 | ○ |
| C-54 | 属性配列での単語追加 | E-08 L119-121 | ○ |
| C-55 | word属性なし時のエラー | E-08 L122-123 | ○ |
| C-56 | shuffleCloudでシャッフル | E-08 L144-155 | ○ |
| C-57 | 空配列のシャッフル | E-08 L148 | ○ |
| C-58 | getClassFromPercentでクラス9判定 | E-08 L165-166 | ○ |
| C-59 | getClassFromPercentでクラス0判定 | E-08 L183-184 | ○ |
| C-60 | getClassFromPercentで境界値判定 | E-08 L171-172 | ○ |
| C-61 | setLimitで制限設定 | E-08 L196-202 | ○ |
| C-62 | 空制限値の処理 | E-08 L198 | ○ |
| C-63 | limitCloudで制限適用 | E-08 L210-222 | ○ |
| C-64 | removeWordで削除対象追加 | E-08 L232-235 | ○ |
| C-65 | removeWordsで単語除外 | E-08 L243-253 | ○ |
| C-66 | orderByでソート設定 | E-08 L264-267 | ○ |
| C-67 | orderCloudで昇順ソート | E-08 L279-291 | ○ |
| C-68 | orderCloudで降順ソート | E-08 L279-291 | ○ |
| C-69 | getMaxで最大値取得 | E-08 L299-313 | ○ |
| C-70 | 空配列の最大値取得 | E-08 L302 | ○ |
| C-71 | showCloudでHTML出力 | E-08 L343-344 | ○ |
| C-72 | showCloudで配列出力 | E-08 L341-342 | ○ |
| C-73 | showCloudでソート適用 | E-08 L323-328 | ○ |
| C-74 | showCloudで制限適用 | E-08 L329-331 | ○ |
| C-75 | showCloudで除外適用 | E-08 L332-334 | ○ |
| C-76 | 空配列のshowCloud | E-08 L336 | ○ |
| C-77 | notifyでデバッグ出力 | E-08 L97-104 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースがソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースがソースコードの実装に基づいており、根拠が明確です
- 注意点：
  - ACL関連テスト（UT-LCM-001〜009）はDBアクセスを伴うため、統合テスト環境が必要
  - セッション関連テスト（UT-LCM-010, 014, 015, 019, 024）はセッションモックが必要
  - Zend Frameworkのモック設定が各テストで必要

## 6) レビュアーチェックリスト（最小）
- [ ] ACL生成ロジックのテストケースがDBスキーマと整合しているか確認
- [ ] 認証・認可テストが実際のセキュリティ要件を満たしているか確認
- [ ] パスワード強度の閾値がセキュリティポリシーと一致しているか確認
- [ ] Wordcloudのエッジケース（大量データ、特殊文字）が網羅されているか確認
- [ ] Zend Framework 1.x固有のテスト手法が適切か確認
