---
generated_at: 2026-02-11 12:00:00
metrics:
  claims_total: 178
  claims_with_evidence: 178
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：models単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：178 / 178、根拠なし：0
- 優先レビュー（高）
  1. **外部API連携テスト（YouTube/Twitter）**：実際のAPI動作確認が必要
  2. **検索インデックス操作テスト（Search）**：Zend_Search_Luceneの動作確認が必要
  3. **カスケード削除テスト**：関連データの削除が正しく行われるか確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/models/Articles.php` - Articlesモデルクラス（397行）
- E-02: `application/models/Attachments.php` - Attachmentsモデルクラス（60行）
- E-03: `application/models/Comments.php` - Commentsモデルクラス（106行）
- E-04: `application/models/Mail.php` - Mailモデルクラス（456行）
- E-05: `application/models/Music.php` - Musicモデルクラス（256行）
- E-06: `application/models/Pages.php` - Pagesモデルクラス（253行）
- E-07: `application/models/Rotators.php` - Rotatorsモデルクラス（192行）
- E-08: `application/models/Search.php` - Searchモデルクラス（134行）
- E-09: `application/models/Tags.php` - Tagsモデルクラス（44行）
- E-10: `application/models/Twitter.php` - Twitterモデルクラス（33行）
- E-11: `application/models/YouTube.php` - YouTubeモデルクラス（367行）
- E-12: `application/models/YouTube3.php` - YouTube3モデルクラス（120行）
- E-13: `docs/code-to-docs/単体テストケース一覧/plan.md` - 生成プラン

## 3) Claims と根拠の対応（レビューの主戦場）

### Articles モデル（C-01 〜 C-34）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | __construct: Zend_Registryを取得し設定ファイルを読み込む | E-01 L29-35 | ○ |
| C-02 | makeDate: 日付フォーマット処理（date指定あり） | E-01 L15-23 | ○ |
| C-03 | makeDate: 日付フォーマット処理（date=NULL） | E-01 L20-22 | ○ |
| C-04 | getFilter: categoryパラメータ処理 | E-01 L46-58 | ○ |
| C-05 | getFilter: authorパラメータ処理 | E-01 L60-72 | ○ |
| C-06 | getFilter: sortパラメータ処理 | E-01 L74-78 | ○ |
| C-07 | getFilter: sortデフォルト値 | E-01 L76-78 | ○ |
| C-08 | getFilter: orderパラメータ処理 | E-01 L80-91 | ○ |
| C-09 | getFilter: orderデフォルト値 | E-01 L88-91 | ○ |
| C-10 | fetchArticles: ページネーター返却 | E-01 L101-162 | ○ |
| C-11 | fetchArticles: categoryフィルタ | E-01 L114-116 | ○ |
| C-12 | fetchArticles: authorフィルタ | E-01 L118-120 | ○ |
| C-13 | fetchArticles: pageデフォルト値 | E-01 L138-142 | ○ |
| C-14 | fetchArticles: itemsデフォルト値 | E-01 L144-148 | ○ |
| C-15 | fetchCategories: カテゴリ一覧取得 | E-01 L168-175 | ○ |
| C-16 | fetchArticle: 単一記事取得 | E-01 L181-196 | ○ |
| C-17 | fetchArticle: NULL ID例外 | E-01 L183, L194 | ○ |
| C-18 | fetchArticle: 非数値ID例外 | E-01 L183, L194 | ○ |
| C-19 | fetchCategory: 単一カテゴリ取得 | E-01 L202-216 | ○ |
| C-20 | fetchCategory: NULL ID例外 | E-01 L204, L214 | ○ |
| C-21 | newArticle: 記事作成 | E-01 L222-237 | ○ |
| C-22 | newArticle: NULL title例外 | E-01 L224, L235 | ○ |
| C-23 | newArticle: 非数値category例外 | E-01 L224, L235 | ○ |
| C-24 | newCategory: カテゴリ作成 | E-01 L243-254 | ○ |
| C-25 | newCategory: NULL title例外 | E-01 L245, L252 | ○ |
| C-26 | deleteArticle: 記事削除（カスケード） | E-01 L260-277 | ○ |
| C-27 | deleteArticle: NULL ID例外 | E-01 L262, L275 | ○ |
| C-28 | deleteCategory: カテゴリ削除・記事移動 | E-01 L283-308 | ○ |
| C-29 | deleteCategory: ID=1例外 | E-01 L285, L306 | ○ |
| C-30 | updateArticle: 記事更新 | E-01 L314-369 | ○ |
| C-31 | updateArticle: comments値変換 | E-01 L316-320 | ○ |
| C-32 | updateArticle: 検索インデックス更新 | E-01 L349-367 | ○ |
| C-33 | updateArticleStatus: ステータス更新 | E-01 L375-383 | ○ |
| C-34 | updateCategory: カテゴリ更新 | E-01 L389-396 | ○ |

### Attachments モデル（C-35 〜 C-44）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | __construct: 初期化 | E-02 L14-17 | ○ |
| C-36 | deleteAttachment: 添付削除 | E-02 L19-30 | ○ |
| C-37 | deleteAttachment: NULL ID例外 | E-02 L21, L27 | ○ |
| C-38 | deleteAttachment: 非数値ID例外 | E-02 L21, L27 | ○ |
| C-39 | deleteSlaveAttachment: 一括削除 | E-02 L32-43 | ○ |
| C-40 | deleteSlaveAttachment: NULL type例外 | E-02 L34, L40 | ○ |
| C-41 | deleteSlaveAttachment: 非数値slave例外 | E-02 L34, L40 | ○ |
| C-42 | fetchAttachments: 一覧取得 | E-02 L45-59 | ○ |
| C-43 | fetchAttachments: typeフィルタ | E-02 L50-52 | ○ |
| C-44 | fetchAttachments: slaveフィルタ | E-02 L53-55 | ○ |

### Comments モデル（C-45 〜 C-54）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | __construct: 初期化 | E-03 L14-17 | ○ |
| C-46 | fetchComments: ページネーター返却 | E-03 L24-79 | ○ |
| C-47 | fetchComments: typeフィルタ | E-03 L37-39 | ○ |
| C-48 | fetchComments: slaveフィルタ | E-03 L41-43 | ○ |
| C-49 | fetchComments: statusフィルタ | E-03 L49-51 | ○ |
| C-50 | fetchComments: pageデフォルト値 | E-03 L55-59 | ○ |
| C-51 | deleteComment: コメント削除 | E-03 L81-92 | ○ |
| C-52 | deleteComment: NULL ID例外 | E-03 L83, L89 | ○ |
| C-53 | deleteSlaveComment: 一括削除 | E-03 L94-105 | ○ |
| C-54 | deleteSlaveComment: NULL type例外 | E-03 L96, L102 | ○ |

### Mail モデル（C-55 〜 C-85）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | __construct: 初期化 | E-04 L29-32 | ○ |
| C-56 | makeDate: 日付フォーマット処理 | E-04 L15-23 | ○ |
| C-57 | getFilter: groupパラメータ処理 | E-04 L43-55 | ○ |
| C-58 | getFilter: roleパラメータ処理 | E-04 L57-69 | ○ |
| C-59 | getFilter: userパラメータ処理 | E-04 L71-83 | ○ |
| C-60 | getFilter: statusパラメータ処理 | E-04 L99-105 | ○ |
| C-61 | fetchMails: ページネーター返却 | E-04 L134-211 | ○ |
| C-62 | fetchMails: groupフィルタ | E-04 L146-149 | ○ |
| C-63 | fetchMails: roleフィルタ | E-04 L151-154 | ○ |
| C-64 | fetchMails: statusフィルタ | E-04 L165-171 | ○ |
| C-65 | fetchGroups: グループ一覧取得 | E-04 L217-224 | ○ |
| C-66 | fetchSubscriptions: 購読一覧取得 | E-04 L230-243 | ○ |
| C-67 | fetchSubscriptions: groupフィルタ | E-04 L235-237 | ○ |
| C-68 | fetchUsers: ユーザー一覧取得 | E-04 L249-264 | ○ |
| C-69 | fetchUsers: roleフィルタ | E-04 L256-258 | ○ |
| C-70 | fetchMail: 単一メール取得 | E-04 L270-284 | ○ |
| C-71 | fetchMail: NULL ID例外 | E-04 L272, L282 | ○ |
| C-72 | fetchGroup: 単一グループ取得 | E-04 L290-304 | ○ |
| C-73 | fetchGroup: NULL ID例外 | E-04 L292, L302 | ○ |
| C-74 | newMail: メール作成 | E-04 L310-328 | ○ |
| C-75 | newMail: NULL subject例外 | E-04 L312, L326 | ○ |
| C-76 | newGroup: グループ作成 | E-04 L334-346 | ○ |
| C-77 | newGroup: NULL title例外 | E-04 L336, L344 | ○ |
| C-78 | deleteMail: メール削除 | E-04 L352-366 | ○ |
| C-79 | deleteMail: NULL ID例外 | E-04 L354, L364 | ○ |
| C-80 | deleteGroup: グループ削除・メール移動 | E-04 L372-400 | ○ |
| C-81 | deleteGroup: ID=1例外 | E-04 L374, L398 | ○ |
| C-82 | updateMail: メール更新 | E-04 L406-418 | ○ |
| C-83 | updateGroup: グループ更新 | E-04 L424-442 | ○ |
| C-84 | updateGroup: default値変換 | E-04 L426-430 | ○ |
| C-85 | updateGroupStatus: ステータス更新 | E-04 L448-455 | ○ |

### Music モデル（C-86 〜 C-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | __construct: 初期化 | E-05 L29-35 | ○ |
| C-87 | makeDate: 日付フォーマット処理 | E-05 L15-23 | ○ |
| C-88 | getFilter: sortパラメータ処理 | E-05 L46-50 | ○ |
| C-89 | getFilter: sortデフォルト値 | E-05 L48-50 | ○ |
| C-90 | fetchTracks: ページネーター返却 | E-05 L73-123 | ○ |
| C-91 | fetchTracks: sortがtrackの場合 | E-05 L89-90 | ○ |
| C-92 | fetchPlaylist: playlist=all | E-05 L132-164 | ○ |
| C-93 | fetchPlaylist: playlist=random | E-05 L166-175 | ○ |
| C-94 | fetchPlaylist: limitパラメータ | E-05 L160-162 | ○ |
| C-95 | fetchTrack: 単一トラック取得 | E-05 L183-196 | ○ |
| C-96 | fetchTrack: NULL ID例外 | E-05 L185, L194 | ○ |
| C-97 | newTrack: トラック作成 | E-05 L202-221 | ○ |
| C-98 | newTrack: NULL title例外 | E-05 L204, L219 | ○ |
| C-99 | deleteTrack: トラック削除 | E-05 L227-235 | ○ |
| C-100 | deleteTrack: NULL ID例外 | E-05 L229, L233 | ○ |
| C-101 | updateTrack: トラック更新 | E-05 L241-254 | ○ |

### Pages モデル（C-102 〜 C-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | __construct: 初期化 | E-06 L29-32 | ○ |
| C-103 | makeDate: 日付フォーマット処理 | E-06 L15-23 | ○ |
| C-104 | getFilter: authorパラメータ処理 | E-06 L43-55 | ○ |
| C-105 | getFilter: sortデフォルト値 | E-06 L59-61 | ○ |
| C-106 | fetchPages: ページネーター返却 | E-06 L84-140 | ○ |
| C-107 | fetchPages: authorフィルタ | E-06 L96-98 | ○ |
| C-108 | fetchPages: sortがslugの場合 | E-06 L108-109 | ○ |
| C-109 | fetchPage: 単一ページ取得 | E-06 L146-160 | ○ |
| C-110 | fetchPage: NULL ID例外 | E-06 L148, L158 | ○ |
| C-111 | newPage: ページ作成 | E-06 L166-181 | ○ |
| C-112 | newPage: NULL title例外 | E-06 L168, L179 | ○ |
| C-113 | newPage: 非数値author例外 | E-06 L168, L179 | ○ |
| C-114 | deletePage: ページ削除（カスケード） | E-06 L187-201 | ○ |
| C-115 | deletePage: NULL ID例外 | E-06 L189, L199 | ○ |
| C-116 | updatePage: ページ更新 | E-06 L207-237 | ○ |
| C-117 | updatePage: 検索インデックス更新 | E-06 L221-235 | ○ |
| C-118 | updatePageStatus: ステータス更新 | E-06 L243-251 | ○ |

### Rotators モデル（C-119 〜 C-132）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | __construct: 初期化 | E-07 L14-17 | ○ |
| C-120 | fetchRotators: ページネーター返却 | E-07 L24-54 | ○ |
| C-121 | fetchRotators: paramsがNULLの場合 | E-07 L24 | ○ |
| C-122 | fetchSlides: ページネーター返却 | E-07 L61-96 | ○ |
| C-123 | fetchSlides: rotatorフィルタ | E-07 L66-68 | ○ |
| C-124 | fetchRotator: 単一ローテーター取得 | E-07 L103-116 | ○ |
| C-125 | fetchRotator: NULL ID例外 | E-07 L105, L114 | ○ |
| C-126 | fetchSlide: 単一スライド取得 | E-07 L123-136 | ○ |
| C-127 | fetchSlide: NULL ID例外 | E-07 L125, L134 | ○ |
| C-128 | newSlide: スライド作成 | E-07 L142-159 | ○ |
| C-129 | newSlide: NULL title例外 | E-07 L144, L157 | ○ |
| C-130 | deleteSlide: スライド削除 | E-07 L165-173 | ○ |
| C-131 | deleteSlide: NULL ID例外 | E-07 L167, L171 | ○ |
| C-132 | updateSlide: スライド更新 | E-07 L179-190 | ○ |

### Search モデル（C-133 〜 C-143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | __construct: 初期化 | E-08 L14-17 | ○ |
| C-134 | stubTrim: 文字列切り詰め | E-08 L26-55 | ○ |
| C-135 | stubTrim: maxlen以下の場合 | E-08 L54 | ○ |
| C-136 | stubTrim: HTMLタグ除去 | E-08 L30 | ○ |
| C-137 | deleteEntry: エントリ削除 | E-08 L81-97 | ○ |
| C-138 | deleteEntry: NULL key例外 | E-08 L83, L94 | ○ |
| C-139 | newEntry: エントリ追加 | E-08 L103-110 | ○ |
| C-140 | newEntry: 非配列params例外 | E-08 L105, L108 | ○ |
| C-141 | updateEntry: エントリ更新 | E-08 L116-124 | ○ |
| C-142 | updateEntry: 非配列params例外 | E-08 L118, L122 | ○ |
| C-143 | createSiteIndex: インデックス作成 | E-08 L129-132 | ○ |

### Tags モデル（C-144 〜 C-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | __construct: 初期化 | E-09 L14-17 | ○ |
| C-145 | deleteTag: タグ削除 | E-09 L19-30 | ○ |
| C-146 | deleteTag: NULL ID例外 | E-09 L21, L27 | ○ |
| C-147 | deleteTag: 非数値ID例外 | E-09 L21, L27 | ○ |
| C-148 | deleteSlaveTag: 一括削除 | E-09 L32-43 | ○ |
| C-149 | deleteSlaveTag: NULL type例外 | E-09 L34, L40 | ○ |
| C-150 | deleteSlaveTag: 非数値slave例外 | E-09 L34, L40 | ○ |

### Twitter モデル（C-151 〜 C-153）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-151 | __construct: 初期化 | E-10 L14-20 | ○ |
| C-152 | fetchTweets: フィード取得 | E-10 L22-31 | ○ |
| C-153 | fetchTweets: countデフォルト値 | E-10 L24-28 | ○ |

### YouTube モデル（C-154 〜 C-168）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-154 | __construct: 初期化 | E-11 L29-36 | ○ |
| C-155 | makeDate: 日付フォーマット処理 | E-11 L15-23 | ○ |
| C-156 | getFilter: sortパラメータ処理 | E-11 L47-51 | ○ |
| C-157 | getFilter: sortデフォルト値 | E-11 L49-51 | ○ |
| C-158 | fetchVideosFeed: ページネーター返却 | E-11 L160-207 | ○ |
| C-159 | fetchVideosFeed: typeがallの場合 | E-11 L189-191 | ○ |
| C-160 | fetchVideoFeed: 動画取得（key指定） | E-11 L214-246 | ○ |
| C-161 | fetchVideoFeed: 動画取得（id指定） | E-11 L249-280 | ○ |
| C-162 | fetchVideoFeed: key/id両方NULL | E-11 L282-284 | ○ |
| C-163 | fetchLatestVideoFeed: 最新動画取得 | E-11 L294-302 | ○ |
| C-164 | fetchVideoComments: コメント取得 | E-11 L304-322 | ○ |
| C-165 | updateVideo: 動画更新 | E-11 L328-348 | ○ |
| C-166 | updateVideo: comments値変換 | E-11 L330-334 | ○ |
| C-167 | deleteVideo: 動画削除 | E-11 L354-365 | ○ |
| C-168 | deleteVideo: NULL ID例外 | E-11 L356, L363 | ○ |

### YouTube3 モデル（C-169 〜 C-178）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-169 | __construct: 初期化 | E-12 L29-35 | ○ |
| C-170 | makeDate: 日付フォーマット処理 | E-12 L15-23 | ○ |
| C-171 | getFilter: sortパラメータ処理 | E-12 L46-50 | ○ |
| C-172 | getFilter: sortデフォルト値 | E-12 L48-50 | ○ |
| C-173 | getFeed: フィード取得 | E-12 L59-74 | ○ |
| C-174 | getFeed: キャッシュ有効化 | E-12 L61-71 | ○ |
| C-175 | updateVideo: 動画更新 | E-12 L81-101 | ○ |
| C-176 | updateVideo: comments値変換 | E-12 L83-87 | ○ |
| C-177 | deleteVideo: 動画削除 | E-12 L107-118 | ○ |
| C-178 | deleteVideo: NULL ID例外 | E-12 L109, L116 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースについてソースコードから根拠を確認済み
- 外部API（YouTube、Twitter）のモック/スタブに関する実装方針は要確認

## 5) リスクフラグ（レビュー観点）
- **リスクレベル0（低リスク）**: 基本的なCRUD操作テスト（大半のテストケース）
- **リスクレベル1（中リスク）**:
  - カスケード削除を伴う処理（Articles::deleteArticle、Pages::deletePage、Mail::deleteMailなど）
  - デフォルト値への移動処理（Articles::deleteCategory、Mail::deleteGroup）
- **リスクレベル2（高リスク）**:
  - 検索インデックス操作（Search::createSiteIndex、Search::updateEntry）
  - 外部API連携（YouTube::fetchVideosFeed、Twitter::fetchTweets）

## 6) レビュアーチェックリスト（最小）
- [ ] 各モデルのpublicメソッドが網羅されているか確認
- [ ] 異常系テストケース（NULL、非数値入力）が十分か確認
- [ ] カスケード削除の関連テーブルが正しく特定されているか確認
- [ ] デフォルト値のテストケースが境界値として適切か確認
- [ ] 外部API連携テストのモック戦略を検討
- [ ] 検索インデックス（Zend_Search_Lucene）のテスト環境構築方針を検討
- [ ] DBトランザクション処理のテスト方針を検討
