---
generated_at: 2026-02-11 20:10:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：受入テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **UAT-043**: E2Eシナリオ - 記事公開完全フロー（フロントエンド確認部分の根拠不足）
  2. **UAT-045**: E2Eシナリオ - ページ公開完全フロー（フロントエンドURL確認部分の根拠不足）
  3. **UAT-046**: E2Eシナリオ - コメント管理フロー（フロントエンドコメント投稿部分の根拠不足）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/AuthController.php` - 認証機能（ログイン、ログアウト、パスワードリセット）
- E-02: `application/modules/admin/controllers/UsersController.php` - ユーザー管理機能（CRUD、ステータス変更、パスワードリセット）
- E-03: `application/modules/admin/controllers/ArticlesController.php` - 記事管理機能（CRUD、公開、カテゴリ管理）
- E-04: `application/modules/admin/controllers/PagesController.php` - ページ管理機能（CRUD、公開）
- E-05: `application/modules/admin/controllers/CommentsController.php` - コメント管理機能（一覧、承認、削除）
- E-06: `application/modules/admin/controllers/SettingsController.php` - 設定機能（プロフィール更新、パスワード変更）
- E-07: `library/CMS/Acl/Factory.php` - ACL（アクセス制御リスト）ファクトリー
- E-08: `database.sql` - データベーススキーマ（テーブル構造、ロール、権限定義）
- E-09: `README.md` - プロジェクト概要、インストール手順

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: 正常ログイン機能 | E-01 (loginAction L59-162) | ○ |
| C-02 | UAT-002: 無効パスワードでのログイン失敗 | E-01 (FAILURE_CREDENTIAL_INVALID L144-146) | ○ |
| C-03 | UAT-003: 存在しないメールでのログイン失敗 | E-01 (FAILURE_IDENTITY_NOT_FOUND L141-143) | ○ |
| C-04 | UAT-004: ログイン情報の記憶（Cookie） | E-01 (setcookie L131-136) | ○ |
| C-05 | UAT-005: ログアウト機能 | E-01 (logoutAction L164-169) | ○ |
| C-06 | UAT-006: パスワードリセットメール送信 | E-01 (passwordAction L171-256) | ○ |
| C-07 | UAT-007: 未登録メールでのリセット失敗 | E-01 (Zend_Validate_Db_RecordExists L188) | ○ |
| C-08 | UAT-008: ユーザー一覧表示（ページネーション15件） | E-02 (manageAction L181-184) | ○ |
| C-09 | UAT-009: ユーザー検索機能 | E-02 (manageAction L85, query検索ロジック) | ○ |
| C-10 | UAT-010: ロール別フィルタリング | E-02 (manageAction L94-163, role条件) | ○ |
| C-11 | UAT-011: ステータス別フィルタリング | E-02 (manageAction L94-171, status条件) | ○ |
| C-12 | UAT-012: 新規ユーザー作成 | E-02 (newAction L590-746) | ○ |
| C-13 | UAT-013: 重複メールアドレスでの作成失敗 | E-02 (Zend_Validate_Db_NoRecordExists L614) | ○ |
| C-14 | UAT-014: ユーザー情報編集 | E-02 (saveAction L345-507) | ○ |
| C-15 | UAT-015: ユーザーステータス変更 | E-02 (statusAction L209-258) | ○ |
| C-16 | UAT-016: 管理者によるパスワードリセット | E-02 (passwordAction L263-340) | ○ |
| C-17 | UAT-017: ロール権限編集 | E-02 (rolesaveAction L789-902) | ○ |
| C-18 | UAT-018: 新規ロール作成 | E-02 (rolenewAction L907-1006) | ○ |
| C-19 | UAT-019: ロール削除と所属ユーザー移行 | E-02 (roledeleteAction L1012-1096) | ○ |
| C-20 | UAT-020: 記事一覧表示 | E-03 (manageAction L30-50) | ○ |
| C-21 | UAT-021: 新規記事作成 | E-03 (newAction L336-402) | ○ |
| C-22 | UAT-022: 記事編集 | E-03 (saveAction L123-212) | ○ |
| C-23 | UAT-023: 記事公開 | E-03 (publishAction L217-310) | ○ |
| C-24 | UAT-024: 記事削除 | E-03 (deleteAction L78-118) | ○ |
| C-25 | UAT-025: 新規カテゴリ作成 | E-03 (categorynewAction L465-524) | ○ |
| C-26 | UAT-026: カテゴリ削除 | E-03 (categorydeleteAction L407-460) | ○ |
| C-27 | UAT-027: ページ一覧表示 | E-04 (manageAction L29-49) | ○ |
| C-28 | UAT-028: 新規ページ作成 | E-04 (newAction L335-394) | ○ |
| C-29 | UAT-029: ページ編集 | E-04 (saveAction L126-211) | ○ |
| C-30 | UAT-030: 重複スラッグでの保存失敗 | E-04 (Zend_Validate_Db_NoRecordExists L156-157) | ○ |
| C-31 | UAT-031: ページ公開 | E-04 (publishAction L216-308) | ○ |
| C-32 | UAT-032: ページ削除 | E-04 (deleteAction L81-121) | ○ |
| C-33 | UAT-033: コメント一覧表示 | E-05 (manageAction L53-124) | ○ |
| C-34 | UAT-034: コメント承認 | E-05 (approveAction L210-287, status='Y') | ○ |
| C-35 | UAT-035: コメント非承認 | E-05 (approveAction L250-276, status='N') | ○ |
| C-36 | UAT-036: コメント削除 | E-05 (deleteAction L165-205) | ○ |
| C-37 | UAT-037: プロフィール更新 | E-06 (profileAction L168-279) | ○ |
| C-38 | UAT-038: パスワード変更 | E-06 (passwordAction L40-163) | ○ |
| C-39 | UAT-039: 現在パスワード不一致での失敗 | E-06 (passwordAction L132-143) | ○ |
| C-40 | UAT-040: 新パスワード不一致での失敗 | E-06 (Zend_Validate_Identical L89-91) | ○ |
| C-41 | UAT-041: 権限のない画面へのアクセス制限 | E-07, E-08 (ACL Factory, users_privileges) | ○ |
| C-42 | UAT-042: 管理者の全機能アクセス | E-07, E-08 (role_id=3に全権限付与) | ○ |
| C-43 | UAT-043: 記事公開E2Eフロー | E-03 (部分的) | △ |
| C-44 | UAT-044: ユーザー登録E2Eフロー | E-02 (newAction, メール送信確認済み) | ○ |
| C-45 | UAT-045: ページ公開E2Eフロー | E-04 (部分的) | △ |
| C-46 | UAT-046: コメント管理E2Eフロー | E-05 (部分的) | △ |
| C-47 | UAT-047: 入力バリデーションメッセージ | E-01 (validators配列, messages) | ○ |
| C-48 | UAT-048: ページネーション動作 | E-02 (Zend_Paginator, ItemCountPerPage=15) | ○ |
| C-49 | UAT-049: 確認ダイアログ動作 | E-02, E-03 (confirm パラメータによる制御) | ○ |
| C-50 | UAT-050: 非アクティブユーザーのログイン制限 | E-01 (user_status = "active" 条件 L119) | ○ |

## 4) 不足情報（Unknown / Missing）

- **フロントエンドのビューテンプレート**: E2Eテストケースの一部で、実際の画面遷移やフロントエンド表示を確認するためのビューファイルが分析対象外
  - 候補：`application/modules/admin/views/` / `public/` 配下のテンプレートファイル

- **フロントエンド（公開側）コントローラー**: 記事・ページの公開後の閲覧確認に関するフロントエンドコントローラーが分析対象外
  - 候補：`application/modules/default/controllers/` 配下のコントローラー

- **メール送信の実際の動作確認**: テストケースではメール送信を期待結果としているが、実際のメールサーバー設定やテスト環境での確認方法は未検証
  - 候補：`application/config/config.ini` / メールテスト環境

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク**: UAT-047, UAT-048, UAT-049 - ユーザビリティテスト（基本的なUI動作確認）
- **1: 中リスク**: UAT-043, UAT-045, UAT-046 - E2Eシナリオ（フロントエンド確認部分の追加検証が必要）
- **2: 高リスク**: なし

## 6) レビュアーチェックリスト（最小）

- [ ] UAT-001〜007: 認証フローのテストケースがAuthController.phpの実装と一致しているか確認
- [ ] UAT-008〜019: ユーザー管理テストケースがUsersController.phpの権限制御と一致しているか確認
- [ ] UAT-020〜026: 記事管理テストケースがArticlesController.phpの実装と一致しているか確認
- [ ] UAT-027〜032: ページ管理テストケースがPagesController.phpの実装と一致しているか確認
- [ ] UAT-041〜042: 権限制御テストケースがACL Factoryとusers_privilegesテーブルの定義と一致しているか確認
- [ ] UAT-043, UAT-045, UAT-046: E2Eシナリオのフロントエンド確認部分を実際の環境で検証
- [ ] 全体: テストケースの優先度が業務要件の重要度と一致しているか確認
