---
document_type: 業務要件一覧
project_root: /Users/tomoka.baba/Work/legacycms-master
created_at: 2026-02-11
generator: code-to-docs-business-requirement-list
total_confidence_score: 82
analysis_depth: comprehensive
files_analyzed: 12
primary_sources:
  - application/modules/admin/controllers/ArticlesController.php
  - application/modules/admin/controllers/AuthController.php
  - application/modules/admin/controllers/UsersController.php
  - application/modules/admin/controllers/PagesController.php
  - application/modules/admin/controllers/EventsController.php
  - application/modules/admin/controllers/CommentsController.php
  - application/modules/admin/controllers/AssetsController.php
  - application/modules/admin/controllers/ResourcesController.php
  - application/modules/admin/controllers/RotatorsController.php
  - application/modules/admin/controllers/MailController.php
  - database.sql
  - README.md
---

# 信頼度レポート: 業務要件一覧

## 1. 概要

本レポートは、LEGACY CMSプロジェクトのコードベースから抽出した業務要件一覧の信頼度を報告するものです。

### 1.1 分析対象

- **プロジェクト**: LEGACY CMS (PHP CMS on Zend Framework)
- **バージョン**: 2.1
- **分析ファイル数**: 12ファイル
- **抽出要件数**: 28件

### 1.2 総合信頼度スコア

**82/100**

| カテゴリ | スコア | 説明 |
|---------|--------|------|
| コード網羅性 | 85/100 | 主要コントローラー全て分析済み |
| 要件明確性 | 80/100 | コードから業務ロジック抽出 |
| 証跡完全性 | 80/100 | ソースコード参照可能 |
| 推論妥当性 | 82/100 | 標準的CMSパターンに基づく |

## 2. 分析方法

### 2.1 情報収集プロセス

1. **コントローラー分析**: 管理画面の全コントローラーを読み込み、アクションメソッドから機能を特定
2. **データベーススキーマ分析**: database.sqlからテーブル構造とリレーションを把握
3. **ACL権限分析**: 各機能のアクセス制御ロジックから業務権限を抽出
4. **バリデーション分析**: Zend_Filter_Inputの定義から入力要件を特定

### 2.2 要件抽出基準

- コントローラーアクションから機能要件を抽出
- ACL権限チェックから権限要件を抽出
- データベーススキーマからデータ要件を抽出
- バリデーションルールから入力制約を抽出

## 3. 要件別信頼度

### 3.1 認証・ユーザー管理（BR-AUTH, BR-USER）

| 要件ID | 信頼度 | 根拠 |
|--------|--------|------|
| BR-AUTH-001 | 95% | AuthController.phpのloginAction/logoutAction明確 |
| BR-AUTH-002 | 90% | passwordAction/resetAction実装確認 |
| BR-USER-001 | 95% | UsersController.phpのCRUD操作全て確認 |
| BR-USER-002 | 90% | ACL権限定義とロールチェック確認 |

**証跡ファイル**:
- `application/modules/admin/controllers/AuthController.php`
- `application/modules/admin/controllers/UsersController.php`

### 3.2 記事管理（BR-ART）

| 要件ID | 信頼度 | 根拠 |
|--------|--------|------|
| BR-ART-001 | 95% | ArticlesController.phpのCRUD操作確認 |
| BR-ART-002 | 90% | article_status使用、publish処理確認 |
| BR-ART-003 | 85% | categorynewAction等カテゴリ操作確認 |
| BR-ART-004 | 80% | tagnewAction/tagdeleteAction確認 |

**証跡ファイル**:
- `application/modules/admin/controllers/ArticlesController.php`
- `database.sql` (articles, article_categories, article_tags テーブル)

### 3.3 ページ管理（BR-PAGE）

| 要件ID | 信頼度 | 根拠 |
|--------|--------|------|
| BR-PAGE-001 | 90% | PagesController.phpのCRUD操作確認 |
| BR-PAGE-002 | 85% | 公開ステータス管理確認 |

**証跡ファイル**:
- `application/modules/admin/controllers/PagesController.php`

### 3.4 イベント管理（BR-EVENT）

| 要件ID | 信頼度 | 根拠 |
|--------|--------|------|
| BR-EVENT-001 | 90% | EventsController.phpのCRUD操作確認 |
| BR-EVENT-002 | 85% | categorynewAction等確認 |
| BR-EVENT-003 | 75% | venueフィールド存在確認、詳細実装は限定的 |

**証跡ファイル**:
- `application/modules/admin/controllers/EventsController.php`

### 3.5 アセット管理（BR-ASSET）

| 要件ID | 信頼度 | 根拠 |
|--------|--------|------|
| BR-ASSET-001 | 95% | AssetsController.phpのアップロード処理確認 |
| BR-ASSET-002 | 90% | foldernewAction/foldermoveAction確認 |
| BR-ASSET-003 | 85% | PhpThumbFactory使用確認 |

**証跡ファイル**:
- `application/modules/admin/controllers/AssetsController.php`

### 3.6 コメント管理（BR-COMMENT）

| 要件ID | 信頼度 | 根拠 |
|--------|--------|------|
| BR-COMMENT-001 | 90% | CommentsController.phpの一覧・削除確認 |
| BR-COMMENT-002 | 90% | approveAction確認、Y/N状態管理 |

**証跡ファイル**:
- `application/modules/admin/controllers/CommentsController.php`

### 3.7 リソース管理（BR-RESOURCE）

| 要件ID | 信頼度 | 根拠 |
|--------|--------|------|
| BR-RESOURCE-001 | 85% | ResourcesController.phpのCRUD確認 |
| BR-RESOURCE-002 | 80% | カテゴリ関連アクション確認 |
| BR-RESOURCE-003 | 80% | ブランド関連アクション確認 |

**証跡ファイル**:
- `application/modules/admin/controllers/ResourcesController.php`

### 3.8 ローテーター管理（BR-ROTATOR）

| 要件ID | 信頼度 | 根拠 |
|--------|--------|------|
| BR-ROTATOR-001 | 85% | RotatorsController.phpの管理機能確認 |
| BR-ROTATOR-002 | 85% | slidenewAction/slideAction/slidedeleteAction確認 |

**証跡ファイル**:
- `application/modules/admin/controllers/RotatorsController.php`

### 3.9 共通基盤（BR-ACL, BR-SEARCH, BR-VALID, BR-PAGING）

| 要件ID | 信頼度 | 根拠 |
|--------|--------|------|
| BR-ACL-001 | 95% | 全コントローラーでisAllowed()使用確認 |
| BR-SEARCH-001 | 75% | Lucene参照あるが詳細実装未確認 |
| BR-VALID-001 | 90% | Zend_Filter_Input使用確認 |
| BR-PAGING-001 | 90% | Zend_Paginator使用確認 |

## 4. 制限事項と注意点

### 4.1 分析の制限

1. **フロントエンド未分析**: 公開側（front module）のコントローラーは詳細分析対象外
2. **モデル層未分析**: Models/ディレクトリのビジネスロジック詳細は未分析
3. **設定ファイル未分析**: ACL設定ファイルの詳細定義は未確認
4. **テストコード不在**: 自動テストがないため要件の正確性検証が困難

### 4.2 推論に基づく要件

以下の要件はコードパターンからの推論を含みます：

- **BR-SEARCH-001**: 検索インデックス管理 - Lucene参照はあるが詳細実装箇所未特定
- **BR-EVENT-003**: 会場管理 - フィールド存在のみ確認、専用CRUD未確認
- **BR-MAIL-001**: メール配信管理 - コントローラー存在確認、詳細未分析

### 4.3 潜在的な欠落要件

コードベースから特定できなかった可能性のある要件：

- バックアップ・リストア機能
- 多言語対応機能
- キャッシュ管理機能
- SEO設定機能
- サイト設定管理機能

## 5. 証跡マッピング

### 5.1 主要ソースファイルと要件の対応

| ソースファイル | 関連要件ID |
|---------------|-----------|
| AuthController.php | BR-AUTH-001, BR-AUTH-002 |
| UsersController.php | BR-USER-001, BR-USER-002 |
| ArticlesController.php | BR-ART-001, BR-ART-002, BR-ART-003, BR-ART-004 |
| PagesController.php | BR-PAGE-001, BR-PAGE-002 |
| EventsController.php | BR-EVENT-001, BR-EVENT-002, BR-EVENT-003 |
| AssetsController.php | BR-ASSET-001, BR-ASSET-002, BR-ASSET-003 |
| CommentsController.php | BR-COMMENT-001, BR-COMMENT-002 |
| ResourcesController.php | BR-RESOURCE-001, BR-RESOURCE-002, BR-RESOURCE-003 |
| RotatorsController.php | BR-ROTATOR-001, BR-ROTATOR-002 |
| 全コントローラー共通 | BR-ACL-001, BR-VALID-001, BR-PAGING-001 |

### 5.2 データベーステーブルと要件の対応

| テーブル名 | 関連要件ID |
|-----------|-----------|
| users | BR-AUTH-001, BR-USER-001, BR-USER-002 |
| articles | BR-ART-001, BR-ART-002 |
| article_categories | BR-ART-003 |
| tags, article_tags | BR-ART-004 |
| pages | BR-PAGE-001, BR-PAGE-002 |
| events | BR-EVENT-001, BR-EVENT-002, BR-EVENT-003 |
| assets | BR-ASSET-001, BR-ASSET-002 |
| comments | BR-COMMENT-001, BR-COMMENT-002 |
| resources | BR-RESOURCE-001, BR-RESOURCE-002, BR-RESOURCE-003 |
| rotators, rotator_slides | BR-ROTATOR-001, BR-ROTATOR-002 |

## 6. 推奨事項

### 6.1 信頼度向上のための追加分析

1. **モデル層の詳細分析**: ビジネスロジックの詳細を把握
2. **ACL設定ファイルの分析**: 権限定義の完全な把握
3. **フロントエンドモジュールの分析**: 公開側機能の把握
4. **ステークホルダーへのヒアリング**: 業務要件の妥当性確認

### 6.2 ドキュメント更新時の注意

- コード変更時は本業務要件一覧の更新を推奨
- 新機能追加時は要件IDの採番規則に従って追加
- 廃止機能は要件から削除または非活性化マーク

## 7. 変更履歴

| 日付 | バージョン | 変更内容 |
|-----|----------|---------|
| 2026-02-11 | 1.0 | 初版作成 |
