---
confidence_score: 0.90
evidence_strength: high
caveats:
  - フロントエンド（public）モジュールのコントローラーは詳細分析対象外
  - モデルクラス（Rotators, Articlesなど）の内部実装は未確認
  - ビュースクリプトの詳細は未確認のため、UI固有の機能が漏れている可能性あり
primary_sources:
  - application/modules/admin/controllers/ArticlesController.php
  - application/modules/admin/controllers/PagesController.php
  - application/modules/admin/controllers/UsersController.php
  - application/modules/admin/controllers/EventsController.php
  - application/modules/admin/controllers/AssetsController.php
  - application/modules/admin/controllers/MailController.php
  - application/modules/admin/controllers/ResourcesController.php
  - application/modules/admin/controllers/RotatorsController.php
  - application/modules/admin/controllers/CommentsController.php
  - application/modules/admin/controllers/TagsController.php
  - application/modules/admin/controllers/AttachmentsController.php
  - application/modules/admin/controllers/AuthController.php
  - database.sql
  - README.md
assumptions:
  - コントローラーのアクションメソッド名から機能を推定
  - ACL権限チェックのリソース名から機能の存在を確認
  - データベーススキーマからエンティティの関係性を把握
---

# 機能一覧 確信度レポート

## 概要

本レポートは、Legacy CMSプロジェクトのソースコードから抽出した機能一覧の確信度と根拠を示すものです。

## 確信度スコア: 0.90 (高)

### スコアの根拠

1. **コントローラー分析の完全性**: 管理画面（admin）モジュールの全12コントローラーを詳細に分析しました。
2. **コードの明確性**: Zend Framework 1.xの標準的なMVCパターンに従っており、アクションメソッドから機能を明確に特定できました。
3. **ACL定義の活用**: 各アクションに含まれるACL権限チェックにより、機能の存在と権限要件を確認しました。
4. **データベーススキーマとの整合性**: database.sqlのテーブル定義とコントローラーの操作が整合していることを確認しました。

## 証拠の強度: 高

### 一次情報源の分析詳細

| コントローラー | 機能数 | 確認方法 |
|----------------|--------|----------|
| AuthController | 4 | ソースコード直接確認 |
| ArticlesController | 6 | ソースコード直接確認 |
| PagesController | 5 | ソースコード直接確認 |
| UsersController | 5 | ソースコード直接確認 |
| EventsController | 6 | ソースコード直接確認 |
| AssetsController | 5 | ソースコード直接確認 |
| ResourcesController | 7 | ソースコード直接確認 |
| RotatorsController | 5 | ソースコード直接確認 |
| CommentsController | 5 | ソースコード直接確認 |
| TagsController | 5 | ソースコード直接確認 |
| AttachmentsController | 4 | ソースコード直接確認 |
| MailController | 2 | ソースコード直接確認 |
| 共通機能 | 4 | パターン分析 |

## 注意事項（Caveats）

### 1. フロントエンドモジュールの分析制限
- `application/modules/public/` 配下のコントローラーは詳細分析の対象外としました
- 公開サイト向けの表示機能が追加で存在する可能性があります

### 2. モデルクラスの実装詳細
- `Rotators`, `Articles`, `Pages` などのモデルクラスの内部実装は確認していません
- モデル内に追加のビジネスロジックが存在する可能性があります

### 3. ビュースクリプトの詳細
- `.phtml` ビューファイルの詳細は未確認です
- JavaScript/Dojoによるクライアントサイド機能が追加で存在する可能性があります

## 前提条件（Assumptions）

### 1. 命名規則に基づく機能推定
- `manageAction()` → 一覧表示機能
- `newAction()` → 新規作成機能
- `editAction()` → 編集機能
- `deleteAction()` → 削除機能
- `saveAction()` → 保存処理
- `publishAction()` → 公開/非公開切り替え

### 2. ACLリソースからの機能確認
コード内の `$this->view->acl->isAllowed()` チェックにより、以下の機能の存在を確認:
- `garticles`, `garticleedit`, `garticledelete` → 記事管理関連
- `gpages`, `gpageedit`, `gpagedelete` → ページ管理関連
- `gusers`, `guseredit`, `guserdelete` → ユーザー管理関連
- `gevents`, `geventedit`, `geventdelete` → イベント管理関連
- `gassets`, `gassetedit`, `gassetdelete` → アセット管理関連
- `rresources`, `rresourceedit`, `rresourcedelete` → リソース管理関連
- `rotrotators`, `rotrotatoredit` → ローテーター管理関連
- `gcomments`, `gcommentdelete`, `gcommentsstatus` → コメント管理関連

### 3. データベーススキーマとの整合性
以下のテーブルの存在を確認し、対応するCRUD機能を特定:
- `articles` → 記事管理
- `pages` → ページ管理
- `users` → ユーザー管理
- `events` → イベント管理
- `assets` → アセット管理
- `resources` → リソース管理
- `rotators`, `slides` → ローテーター管理
- `comments` → コメント管理
- `tags` → タグ管理
- `attachments` → 添付ファイル管理

## 機能カテゴリ別の確信度

| カテゴリ | 確信度 | 理由 |
|----------|--------|------|
| 認証 | 0.95 | AuthControllerを詳細に分析、標準的な認証フロー |
| 記事管理 | 0.90 | コントローラーとACL定義から確認 |
| ページ管理 | 0.90 | コントローラーとACL定義から確認 |
| ユーザー管理 | 0.90 | コントローラーとACL定義から確認 |
| イベント管理 | 0.90 | コントローラーとACL定義から確認 |
| アセット管理 | 0.90 | コントローラーとACL定義から確認 |
| リソース管理 | 0.92 | 詳細なソースコード分析を実施 |
| ローテーター管理 | 0.92 | 詳細なソースコード分析を実施 |
| コメント管理 | 0.92 | 詳細なソースコード分析を実施 |
| タグ管理 | 0.92 | 詳細なソースコード分析を実施 |
| 添付ファイル管理 | 0.92 | 詳細なソースコード分析を実施 |
| メール管理 | 0.85 | コントローラー確認済み、詳細は限定的 |
| 共通機能 | 0.88 | コード全体のパターンから抽出 |

## 結論

本機能一覧は、Legacy CMSの管理画面モジュールを中心に、ソースコードの直接分析に基づいて作成されました。Zend Framework 1.xの標準的なMVCパターンに従った実装であり、コントローラーのアクションメソッドとACL定義から機能を高い精度で特定できています。

ただし、モデルクラスの内部実装やビュースクリプトの詳細、フロントエンドモジュールについては分析対象外としているため、追加の機能が存在する可能性を考慮する必要があります。
