# 機能設計書 1-ログイン

## 概要

本ドキュメントは、LEGACY CMSにおけるログイン機能の設計を記述したものである。ユーザー名（メールアドレス）とパスワードによるシステム認証処理の仕様を定義する。

### 本機能の処理概要

**業務上の目的・背景**：CMSの管理画面およびユーザー専用機能へのアクセスを制御するために、適切な認証機構が必要である。本機能は、登録済みユーザーのみがシステムにアクセスできるようにするためのゲートウェイとして機能する。不正アクセスを防止し、ユーザーごとのアクセス権限に基づいた機能制御を可能にする。

**機能の利用シーン**：ユーザーが管理画面にアクセスする際、未認証状態であれば自動的にログイン画面へリダイレクトされる。ユーザーはメールアドレスとパスワードを入力し、認証を行う。認証成功後は管理ダッシュボードへ遷移し、ユーザーのロールに応じた機能が利用可能となる。

**主要な処理内容**：
1. ログインフォームの表示と入力値の受け取り
2. 入力値のバリデーション（メールアドレス形式、パスワード長）
3. データベースに対する認証処理（Zend_Auth使用）
4. 認証成功時のセッション作成とユーザー情報の保存
5. 「ログイン状態を保持」オプションによるCookie設定
6. 認証失敗時のエラーメッセージ表示

**関連システム・外部連携**：Zend Frameworkの認証コンポーネント（Zend_Auth）を使用し、データベースアダプターによる認証を行う。パスワードはサイト固有のキーとソルトを用いたMD5ハッシュで検証される。

**権限による制御**：ログイン機能自体はすべてのユーザーがアクセス可能である。ただし、認証成功後の遷移先（管理ダッシュボード）へのアクセスには`gadmin`権限が必要となる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | ログイン画面 | 主画面 | ユーザー認証処理を実行 |
| 33 | 管理者ログイン画面 | 主画面 | 管理者認証処理を実行 |

## 機能種別

認証処理 / セッション管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| email | string | Yes | ユーザーのメールアドレス | NotEmpty, EmailAddress, StringTrim, StringToLower |
| password | string | Yes | ユーザーのパスワード | NotEmpty, StringLength(min: 4) |
| remember | string | No | ログイン状態を保持するフラグ | allowEmpty, 値が'1'の場合Cookieを設定 |

### 入力データソース

画面入力（ログインフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| authenticated | boolean | 認証成功フラグ（ビューに渡される） |
| user | object | 認証済みユーザー情報（user_password, user_salt, user_keyを除く） |
| messages | array | バリデーションエラーまたは認証エラーメッセージ |

### 出力先

- セッションストレージ（Zend_Auth_Storage）
- Cookie（remember=1の場合、loginEmail, loginPasswordを7889231秒≒約3ヶ月保持）
- 画面表示（エラーメッセージ）

## 処理フロー

### 処理シーケンス

```
1. preDispatch実行
   └─ 既にログイン済みの場合、管理ダッシュボードへリダイレクト
2. loginAction実行
   └─ レイアウトをadmin-authに設定
3. リファラーページの設定
   └─ セッションからcurPageを取得、なければbaseUrlを設定
4. POSTリクエストの判定
   └─ GETの場合はフォーム表示のみ
5. 入力値のフィルタリング・バリデーション
   └─ Zend_Filter_Inputによる検証
6. 認証処理の実行
   └─ Zend_Auth_Adapter_DbTableによるDB認証
7. 認証結果の判定
   ├─ 成功: セッションにユーザー情報を保存、Cookie設定、ダッシュボードへリダイレクト
   └─ 失敗: エラーメッセージを設定してフォーム再表示
```

### フローチャート

```mermaid
flowchart TD
    A[ログイン画面アクセス] --> B{認証済み?}
    B -->|Yes| C[管理ダッシュボードへリダイレクト]
    B -->|No| D{POSTリクエスト?}
    D -->|No| E[ログインフォーム表示]
    D -->|Yes| F[入力値バリデーション]
    F --> G{バリデーション成功?}
    G -->|No| H[エラーメッセージ表示]
    H --> E
    G -->|Yes| I[DB認証実行]
    I --> J{認証成功?}
    J -->|Yes| K[セッション作成]
    K --> L{remember=1?}
    L -->|Yes| M[Cookie設定]
    L -->|No| N[Cookie削除]
    M --> C
    N --> C
    J -->|No| O[認証エラーメッセージ設定]
    O --> E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | アクティブユーザー認証 | user_statusが'active'のユーザーのみ認証可能 | 認証処理時 |
| BR-002 | パスワードハッシュ検証 | MD5(site_key + password + user_salt)で検証 | 認証処理時 |
| BR-003 | ログイン状態保持期間 | Cookieの有効期限は約3ヶ月（7889231秒） | remember=1の場合 |

### 計算ロジック

パスワード検証式: `MD5(CONCAT(site_key, password, user_salt))`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 認証 | users | SELECT | メールアドレスとパスワードによるユーザー検索 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_email | 入力されたメールアドレスと一致 | 認証条件1 |
| SELECT | user_password | MD5ハッシュ値と一致 | 認証条件2 |
| SELECT | user_status | 'active'と一致 | 認証条件3 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FAILURE_IDENTITY_NOT_FOUND | 認証エラー | メールアドレスが未登録 | 'Not Found'メッセージを表示 |
| FAILURE_CREDENTIAL_INVALID | 認証エラー | パスワードが不正 | 'Invalid'メッセージを表示 |
| IS_EMPTY (email) | バリデーションエラー | メールアドレス未入力 | 'E-mail address is required'を表示 |
| INVALID (email) | バリデーションエラー | メールアドレス形式不正 | 'Invalid e-mail address'を表示 |
| IS_EMPTY (password) | バリデーションエラー | パスワード未入力 | 'Password is required'を表示 |
| StringLength (password) | バリデーションエラー | パスワード4文字未満 | 'Password must be at least 4 characters long'を表示 |

### リトライ仕様

特になし（ユーザーによる再入力）

## トランザクション仕様

SELECT操作のみのため、トランザクション管理は不要

## パフォーマンス要件

- レスポンス時間: 通常1秒以内
- usersテーブルのuser_emailカラムにインデックスがあることが望ましい

## セキュリティ考慮事項

- パスワードはサイト固有のキーとユーザーごとのソルトを用いてMD5ハッシュ化（現代のセキュリティ基準では推奨されない方式）
- 認証情報（パスワード、ソルト、キー）はセッションストレージから除外
- Cookieにパスワードを平文で保存している（セキュリティリスク）
- 非アクティブユーザーは認証不可

## 備考

- Zend Framework 1.x系の認証機構を使用
- パスワードのMD5ハッシュは現代のセキュリティ基準では脆弱であり、bcryptなどへの移行が推奨される
- Cookieへのパスワード平文保存はセキュリティリスクが高い

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、認証に使用されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブルの構造（347-361行目）を確認。user_email, user_password, user_salt, user_statusが認証に使用される |

**読解のコツ**: usersテーブルでは、パスワードがMD5ハッシュ化されて保存され、user_saltがユーザーごとに異なるソルト値を保持している。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AuthController.php | `application/modules/admin/controllers/AuthController.php` | ログイン処理の中心。loginAction()が主要な処理 |

**主要処理フロー**:
1. **42-57行目**: preDispatch() - 認証状態のチェックとリダイレクト制御
2. **59-162行目**: loginAction() - ログイン処理本体
3. **71-101行目**: POSTリクエスト時のバリデーション設定
4. **108-153行目**: 認証処理と結果判定

#### Step 3: 親クラスを理解する

コントローラーの親クラスが提供する機能を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Auth.php | `library/CMS/Controller/Action/Auth.php` | preDispatch()でbaseUrlとユーザー情報をビューに設定 |

**主要処理フロー**:
- **11-26行目**: preDispatch() - 認証状態の確認とビューへの情報設定

#### Step 4: セキュリティ設定を理解する

認証後のアクセス制御に使用されるACL機構を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Factory.php | `library/CMS/Acl/Factory.php` | createGlobalAcl()でロールベースのアクセス制御リストを生成 |
| 4-2 | Admin.php | `library/CMS/Controller/Action/Admin.php` | 管理画面アクセス時の認証チェック（54-56行目で`gadmin`権限を確認） |

### プログラム呼び出し階層図

```
Admin_AuthController::loginAction()
    │
    ├─ Admin_AuthController::setLayout()
    │      └─ Zend_Layout::setLayout('admin-auth')
    │
    ├─ Zend_Filter_Input (バリデーション)
    │      ├─ StringTrim
    │      ├─ StringToLower
    │      ├─ NotEmpty
    │      └─ EmailAddress
    │
    ├─ Zend_Auth_Adapter_DbTable (認証)
    │      └─ Zend_Registry::getInstance()->db
    │
    ├─ Zend_Auth::authenticate()
    │      └─ Zend_Auth_Result
    │
    └─ Zend_Auth::getStorage()->write() (セッション保存)
```

### データフロー図

```
[入力]               [処理]                    [出力]

email          ───▶ Zend_Filter_Input    ───▶ 検証済みemail
password       ───▶ (バリデーション)      ───▶ 検証済みpassword
                           │
                           ▼
                    Zend_Auth_Adapter_DbTable
                           │
                           ▼
                    users テーブル
                    (SELECT認証)
                           │
                           ▼
               ┌───────────┴───────────┐
               ▼                       ▼
        認証成功                   認証失敗
               │                       │
               ▼                       ▼
        Zend_Auth_Storage          messages配列
        (セッション保存)            (エラー表示)
               │
               ▼
        Cookie設定（オプション）
               │
               ▼
        管理ダッシュボードへリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AuthController.php | `application/modules/admin/controllers/AuthController.php` | コントローラー | ログイン処理の実装 |
| Auth.php | `library/CMS/Controller/Action/Auth.php` | 親クラス | 認証コントローラーの基底クラス |
| Admin.php | `library/CMS/Controller/Action/Admin.php` | 親クラス | 管理画面コントローラーの基底クラス |
| Factory.php | `library/CMS/Acl/Factory.php` | ユーティリティ | ACLの生成 |
| database.sql | `database.sql` | DDL | usersテーブル定義 |
