# 機能設計書 11-ページ一覧表示

## 概要

本ドキュメントは、LEGACY CMSにおける固定ページの一覧表示機能について記述する。この機能は管理画面において、登録されているすべての固定ページをページネーション付きで一覧表示し、フィルタリングやソート機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：ウェブサイトの固定ページ（会社概要、利用規約、プライバシーポリシーなど）を効率的に管理するため、管理者がすべてのページを一覧形式で確認し、編集・削除操作への導線を提供する必要がある。本機能はCMS管理者が日常的にコンテンツを管理する際の起点となる重要な機能である。

**機能の利用シーン**：管理者がCMS管理画面にログインし、「Pages」メニューを選択した際に表示される。既存ページの確認、編集対象ページの選択、ページの公開状態確認、著者別・日付別の絞り込みなどに使用される。

**主要な処理内容**：
1. ユーザーの権限チェック（ppages権限の確認）
2. リクエストパラメータからフィルタ条件・ソート条件を取得
3. Pagesモデルを使用してデータベースからページ一覧を取得
4. Zend_Paginatorによるページネーション処理（15件/ページ）
5. ビューテンプレートへのデータ受け渡しと表示

**関連システム・外部連携**：特になし。内部データベースからの取得処理のみ。

**権限による制御**：`ppages`リソースへのアクセス権限が必要。権限がない場合は権限エラー画面（privileges）へフォワードされる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | ページ管理画面 | 主画面 | ページ一覧の表示、フィルタ適用 |
| 61 | ページ編集画面 | 遷移先画面 | 一覧からの編集画面への遷移 |
| 62 | ページ新規作成画面 | 遷移先画面 | 新規作成ダイアログへの遷移 |

## 機能種別

CRUD操作（Read）/ 一覧表示 / ページネーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| page | integer | No | 現在のページ番号 | 数値のみ、デフォルト1 |
| author | integer | No | 著者でフィルタリングするユーザーID | 数値のみ |
| sort | string | No | ソート対象カラム | date/page/author/slugのいずれか |
| order | string | No | ソート順序 | asc/descのいずれか、デフォルトdesc |
| items | integer | No | 1ページあたりの表示件数 | 数値のみ、デフォルト15 |
| range | integer | No | ページネーションの表示範囲 | 数値のみ、デフォルト5 |

### 入力データソース

- リクエストパラメータ（URL Query String）
- セッション（ログインユーザー情報、ACL情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pagesArray | Zend_Paginator | ページネーション済みのページ一覧 |
| filter | array | 適用中のフィルタ情報（author, sort, order） |

### ページ一覧の各項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| page_id | integer | ページID |
| page_title | string | ページタイトル |
| page_slug | string | URL用スラッグ |
| page_status | string | 公開ステータス（draft/published） |
| page_protected | string | 保護フラグ（Y/N） |
| page_date | datetime | 作成日時 |
| page_edit | datetime | 最終編集日時 |
| page_published | datetime | 公開日時 |
| page_user | integer | 著者ユーザーID |
| user_alias | string | 著者エイリアス名 |

### 出力先

管理画面ビューテンプレート（`application/modules/admin/views/scripts/pages/manage.phtml`）

## 処理フロー

### 処理シーケンス

```
1. indexAction()が呼び出される
   └─ manageActionへリダイレクト

2. manageAction()が実行される
   └─ 権限チェック（ppages）
      ├─ 権限なし → privileges画面へフォワード
      └─ 権限あり → 次のステップへ

3. リクエストパラメータの設定
   └─ items=15, range=5をデフォルト設定

4. Pagesモデルのインスタンス化
   └─ new Pages()

5. フィルタ条件の取得
   └─ $pages->getFilter($params)
      └─ 著者名、ソート条件、ソート順序を配列で返却

6. ページ一覧の取得
   └─ $pages->fetchPages($params)
      ├─ SELECTクエリの構築（pagesテーブル + usersテーブルのJOIN）
      ├─ フィルタ条件の適用
      ├─ ソート条件の適用
      └─ Zend_Paginatorでラップして返却

7. ビューへのデータ受け渡し
   └─ $this->view->pagesArray = ページネーター
   └─ $this->view->filter = フィルタ情報
```

### フローチャート

```mermaid
flowchart TD
    A[開始: manageAction] --> B{ppages権限あり?}
    B -->|No| C[privileges画面へフォワード]
    B -->|Yes| D[パラメータ取得]
    D --> E[Pagesモデル初期化]
    E --> F[getFilter: フィルタ条件取得]
    F --> G[fetchPages: ページ一覧取得]
    G --> H[Zend_Paginator生成]
    H --> I[ビューへデータ設定]
    I --> J[manage.phtml描画]
    J --> K[終了]
    C --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルトソート | 日付降順（最新順）でソート | sortパラメータ未指定時 |
| BR-02 | ページネーション | 1ページあたり15件表示 | 常時 |
| BR-03 | 保護ページ表示 | 保護フラグがYのページはロックアイコン表示 | page_protected='Y' |
| BR-04 | ドラフト表示 | 未公開ページは(draft)ラベルを表示 | page_status='draft' |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ一覧取得 | pages | SELECT | 全ページ情報を取得 |
| ページ一覧取得 | users | SELECT | 著者情報を結合取得 |

### テーブル別操作詳細

#### pagesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | page_id, page_title, page_slug, page_content, page_section, page_user, page_date, page_edit, page_published, page_status, page_protected | 全件または著者フィルタ条件 | JOINでusersテーブルと結合 |

#### usersテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_alias | p.page_user = u.user_id | 著者名表示用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | ppages権限なし | privileges画面へフォワード |
| - | データなし | ページが0件 | 「No Pages!」メッセージ表示 |

### リトライ仕様

特になし（読み取り専用操作のため）

## トランザクション仕様

読み取り専用操作のため、トランザクション管理は不要

## パフォーマンス要件

- ページネーションにより1回のリクエストで取得するデータは最大15件
- Zend_Paginatorが内部的にCOUNTクエリとLIMITクエリを発行

## セキュリティ考慮事項

- ACLによる権限チェック（ppagesリソース）
- XSS対策：ビューでのエスケープ処理（$this->escape()）
- SQLインジェクション対策：Zend_Db_Selectによるプリペアドステートメント使用

## 備考

- 管理画面レイアウト（admin.phtml）を使用
- Dojo Toolkitによるダイアログ・ボタンUIコンポーネント使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ページテーブルの構造とPagesモデルの役割を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | pagesテーブル定義（206-220行目）を確認し、カラム構成を把握 |
| 1-2 | Pages.php | `application/models/Pages.php` | モデルクラスの構造、コンストラクタでのレジストリ取得（29-32行目） |

**読解のコツ**: Zend Framework 1系ではZend_Registryがグローバルな依存性注入コンテナとして機能する。`$this->registry->db`でデータベースアダプタにアクセスしている。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PagesController.php | `application/modules/admin/controllers/PagesController.php` | コントローラーの全体構造を把握 |

**主要処理フロー**:
1. **22-24行目**: indexAction()からmanageActionへリダイレクト
2. **29-48行目**: manageAction()でACLチェックとデータ取得
3. **31行目**: `$this->view->acl->isAllowed()`による権限チェック
4. **38行目**: Pagesモデルのインスタンス化
5. **40-41行目**: フィルタ取得とページ一覧取得

#### Step 3: モデル層の処理を理解する

Pagesモデルのフェッチ処理を詳細に確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Pages.php | `application/models/Pages.php` | getFilter()とfetchPages()メソッド |

**主要処理フロー**:
- **39-77行目**: getFilter()でフィルタ条件の配列を構築
- **84-140行目**: fetchPages()でSELECTクエリ構築とページネーター生成
- **92-94行目**: pagesテーブルとusersテーブルのJOIN
- **100-114行目**: ソート条件の適用
- **134-137行目**: Zend_Paginatorの設定

#### Step 4: ビューテンプレートを理解する

表示処理とUIコンポーネントの実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | manage.phtml | `application/modules/admin/views/scripts/pages/manage.phtml` | 一覧表示のHTMLテンプレート |

**主要処理フロー**:
- **9-16行目**: Dojo Toolkitのrequire文
- **37行目**: 新規ページ作成ボタン（権限チェック付き）
- **58-131行目**: ページ一覧テーブルの描画
- **99-124行目**: foreachループでページを一行ずつ表示
- **136行目**: ページネーションコントロールの描画

### プログラム呼び出し階層図

```
PagesController::indexAction()
    │
    └─ PagesController::manageAction()
           │
           ├─ ACL::isAllowed() [権限チェック]
           │
           ├─ Pages::__construct() [モデル初期化]
           │
           ├─ Pages::getFilter($params)
           │      └─ Zend_Db_Select [著者名取得クエリ]
           │
           └─ Pages::fetchPages($params)
                  ├─ Zend_Db_Select [ページ取得クエリ構築]
                  └─ Zend_Paginator::factory() [ページネーター生成]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

リクエストパラメータ ───▶ PagesController        ───▶ ビューへ変数設定
(page, author,            ├─ ACL権限チェック            ├─ pagesArray
 sort, order)             ├─ Pages::getFilter()         └─ filter
                          └─ Pages::fetchPages()
                                    │
                                    ▼
                          Zend_Db_Select
                          (pages + users JOIN)
                                    │
                                    ▼
                          Zend_Paginator
                          (15件/ページ)
                                    │
                                    ▼
                          manage.phtml ───▶ HTML出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PagesController.php | `application/modules/admin/controllers/PagesController.php` | コントローラー | ページ管理のリクエスト処理 |
| Pages.php | `application/models/Pages.php` | モデル | ページデータのCRUD操作 |
| manage.phtml | `application/modules/admin/views/scripts/pages/manage.phtml` | ビュー | 一覧表示テンプレート |
| Admin.php | `library/CMS/Controller/Action/Admin.php` | 基底クラス | 管理画面コントローラーの基底クラス |
| database.sql | `database.sql` | スキーマ | pagesテーブル定義 |
| default.phtml | `application/modules/admin/views/scripts/_pagination/default.phtml` | ビュー | ページネーションUIテンプレート |
