# 機能設計書 16-ユーザー一覧表示

## 概要

本ドキュメントは、LEGACY CMSにおける登録ユーザーの一覧表示機能について記述する。この機能は管理画面において、システムに登録されているすべてのユーザーをページネーション付きで一覧表示し、ロール・ステータス・検索によるフィルタリング機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：システム管理者がユーザーアカウントを効率的に管理するため、登録ユーザーの一覧を確認し、ユーザー情報の編集、ステータス変更、パスワードリセットなどの操作への導線を提供する必要がある。ロール別・ステータス別の絞り込みにより、特定のユーザーグループの管理を容易にする。

**機能の利用シーン**：管理者がCMS管理画面にログインし、「Users」メニューを選択した際に表示される。ユーザーの確認、編集対象ユーザーの選択、ロール・ステータス別の絞り込み、名前・エイリアス・メールアドレスによる検索などに使用される。

**主要な処理内容**：
1. ユーザーの権限チェック（uusers権限の確認）
2. リクエストパラメータからフィルタ条件を取得（role, status, query）
3. 複数テーブル（users, users_profiles, users_roles）のJOINクエリ構築
4. Zend_Paginatorによるページネーション処理（15件/ページ）
5. ロール一覧の取得（フィルタUI用）
6. ビューテンプレートへのデータ受け渡しと表示

**関連システム・外部連携**：特になし。内部データベースからの取得処理のみ。

**権限による制御**：`uusers`リソースへのアクセス権限が必要。権限がない場合は権限エラー画面（privileges）へフォワードされる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | ユーザー管理画面 | 主画面 | ユーザー一覧の表示、フィルタ適用 |
| 42 | ユーザー編集画面 | 遷移先画面 | 一覧からの編集画面への遷移 |
| 43 | ユーザー新規作成画面 | 遷移先画面 | 新規作成ダイアログへの遷移 |
| 44 | ユーザー詳細画面 | 遷移先画面 | 詳細表示画面への遷移 |

## 機能種別

CRUD操作（Read）/ 一覧表示 / ページネーション / 検索

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| page | integer | No | 現在のページ番号 | 数値のみ、デフォルト1 |
| role | integer | No | ロールIDでフィルタリング | 数値のみ |
| status | string | No | ステータスでフィルタリング | active/inactive/suspended |
| query | string | No | 検索キーワード | エスケープ処理、trim |

### 入力データソース

- リクエストパラメータ（URL Query String）
- セッション（ログインユーザー情報、ACL情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| usersArray | Zend_Paginator | ページネーション済みのユーザー一覧 |
| roleArray | array | ロール一覧（フィルタUI用） |
| role | string | フィルタ中のロール名 |
| status | string | フィルタ中のステータス |
| query | string | フィルタ中の検索キーワード |
| page | integer | 現在のページ番号 |

### ユーザー一覧の各項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| user_id | integer | ユーザーID |
| user_alias | string | ユーザーエイリアス |
| user_email | string | メールアドレス |
| user_status | string | アカウントステータス |
| user_role | integer | ロールID |
| user_date | datetime | アカウント作成日時 |
| upro_first | string | 名 |
| upro_last | string | 姓 |
| upro_date | datetime | プロフィール更新日時 |
| role_id | integer | ロールID |
| role_title | string | ロール名 |

### 出力先

管理画面ビューテンプレート（`application/modules/admin/views/scripts/users/manage.phtml`）

## 処理フロー

### 処理シーケンス

```
1. indexAction()が呼び出される
   └─ manageActionへリダイレクト

2. manageAction()が実行される
   └─ 権限チェック（uusers）
      ├─ 権限なし → privileges画面へフォワード
      └─ 権限あり → 次のステップへ

3. レイアウト設定
   └─ setLayout() でadminレイアウトを設定

4. パラメータ取得
   ├─ role: ロールIDフィルタ
   ├─ status: ステータスフィルタ
   ├─ query: 検索キーワード（trim, escape処理）
   └─ page: ページ番号

5. SQLクエリ構築
   ├─ フィルタ条件の組み合わせに応じてWHERE句を構築
   │   └─ role×status×query の組み合わせで8パターン
   ├─ users + users_profiles + users_roles のJOIN
   └─ ORDER BY upro_last ASC

6. ページネーター生成
   ├─ Zend_Paginator::factory($select)
   ├─ setItemCountPerPage(15)
   └─ setPageRange(5)

7. ロール一覧取得（フィルタUI用）
   └─ SELECT FROM users_roles WHERE role_id != 2

8. ビューへのデータ受け渡し
   └─ usersArray, roleArray等を設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始: manageAction] --> B{uusers権限あり?}
    B -->|No| C[privileges画面へフォワード]
    B -->|Yes| D[パラメータ取得 role,status,query,page]
    D --> E[フィルタ条件の組み合わせ判定]
    E --> F[SELECTクエリ構築]
    F --> G[JOINクエリ実行 users+profiles+roles]
    G --> H[Zend_Paginator生成 15件/ページ]
    H --> I[ロール一覧取得]
    I --> J[ビューへデータ設定]
    J --> K[manage.phtml描画]
    K --> L[終了]
    C --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルトソート | 姓（upro_last）の昇順でソート | 常時 |
| BR-02 | ページネーション | 1ページあたり15件表示 | 常時 |
| BR-03 | ゲストロール除外 | ロール一覧からゲスト（role_id=2）を除外 | フィルタUI表示時 |
| BR-04 | 複合フィルタ | role, status, queryの組み合わせでフィルタリング可能 | フィルタ指定時 |
| BR-05 | ステータス表示 | active=緑旗、inactive=黄旗、suspended=赤旗 | 一覧表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー一覧取得 | users | SELECT | ユーザー情報取得 |
| ユーザー一覧取得 | users_profiles | SELECT | プロフィール情報結合取得 |
| ユーザー一覧取得 | users_roles | SELECT | ロール情報結合取得 |
| ロール一覧取得 | users_roles | SELECT | フィルタUI用ロール一覧 |

### テーブル別操作詳細

#### usersテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_id, user_alias, user_email, user_status, user_role, user_date | フィルタ条件に応じて | users_profiles, users_rolesとJOIN |

#### users_profilesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | upro_first, upro_last, upro_date等 | upro_userid = user_id | |

#### users_rolesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | role_id, role_title, role_colour | role_id = user_role | |
| SELECT | role_id, role_title | role_id != 2 | フィルタUI用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | uusers権限なし | privileges画面へフォワード |
| - | データなし | ユーザーが0件 | 「No Users!」メッセージ表示 |

### リトライ仕様

特になし（読み取り専用操作のため）

## トランザクション仕様

読み取り専用操作のため、トランザクション管理は不要

## パフォーマンス要件

- ページネーションにより1回のリクエストで取得するデータは最大15件
- 3テーブルのJOINクエリのため、インデックス設計が重要
- 検索クエリはLIKE句を使用（部分一致検索）

## セキュリティ考慮事項

- ACLによる権限チェック（uusersリソース）
- XSS対策：ビューでのエスケープ処理（$this->escape()）
- SQLインジェクション対策：Zend_Db_Selectによるプリペアドステートメント使用
- 検索クエリはtrimとescape処理を適用

## 備考

- 管理画面レイアウト（admin.phtml）を使用
- Dojo Toolkitによるダイアログ・ボタン・検索UIコンポーネント使用
- ロール管理機能（rolenew, roledelete, role）への導線も提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザー関連テーブルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブル（347-361行目）、users_profiles（457-477行目）、users_roles（576-581行目） |

**読解のコツ**: users、users_profiles、users_rolesの3テーブルがuser_id、upro_userid、role_idで関連している。

#### Step 2: エントリーポイントを理解する

コントローラーのmanageActionを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | manageAction（72-204行目） |

**主要処理フロー**:
1. **74行目**: uusers権限チェック
2. **79行目**: setLayout()でadminレイアウト設定
3. **81-85行目**: role, status, queryパラメータ取得
4. **94-178行目**: フィルタ条件の組み合わせに応じたSELECTクエリ構築
5. **181-184行目**: Zend_Paginator設定（15件/ページ、範囲5）
6. **190-196行目**: ロール一覧取得（role_id != 2）

#### Step 3: ビューテンプレートを理解する

表示処理とUIコンポーネントの実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | manage.phtml | `application/modules/admin/views/scripts/users/manage.phtml` | ユーザー一覧表示テンプレート |

**主要処理フロー**:
- **36-66行目**: Functions fieldset（Search, New User, New Roleボタン）
- **69-79行目**: Filter fieldset（適用中フィルタの表示）
- **85-120行目**: Account Status / Rolesフィールドセット
- **122-161行目**: ユーザー一覧テーブル
- **130-153行目**: foreachループでユーザーを一行ずつ表示
- **163-167行目**: ページネーションコントロール

### プログラム呼び出し階層図

```
UsersController::indexAction()
    │
    └─ UsersController::manageAction()
           │
           ├─ ACL::isAllowed() [権限チェック]
           │
           ├─ setLayout() [adminレイアウト設定]
           │
           ├─ getRole($roleid) [ロール名取得（フィルタ時）]
           │
           ├─ Zend_Db_Select [ユーザー取得クエリ構築]
           │      └─ users + users_profiles + users_roles JOIN
           │
           ├─ Zend_Paginator::factory() [ページネーター生成]
           │
           └─ Zend_Db_Select [ロール一覧取得]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

リクエストパラメータ ───▶ UsersController        ───▶ ビューへ変数設定
(page, role,              ├─ ACL権限チェック            ├─ usersArray
 status, query)           ├─ getRole()                  ├─ roleArray
                          └─ SELECTクエリ構築           ├─ role
                                    │                   ├─ status
                                    ▼                   └─ query
                          Zend_Db_Select
                          (users + profiles + roles)
                                    │
                                    ▼
                          Zend_Paginator
                          (15件/ページ)
                                    │
                                    ▼
                          manage.phtml ───▶ HTML出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | コントローラー | ユーザー管理のリクエスト処理 |
| manage.phtml | `application/modules/admin/views/scripts/users/manage.phtml` | ビュー | 一覧表示テンプレート |
| URoleCount.php | `application/modules/admin/views/helpers/URoleCount.php` | ヘルパー | ロール別ユーザー数カウント |
| UStatusCount.php | `application/modules/admin/views/helpers/UStatusCount.php` | ヘルパー | ステータス別ユーザー数カウント |
| MakeDate.php | `application/modules/admin/views/helpers/MakeDate.php` | ヘルパー | 日付フォーマット |
| database.sql | `database.sql` | スキーマ | users, users_profiles, users_rolesテーブル定義 |
| default.phtml | `application/modules/admin/views/scripts/_pagination/default.phtml` | ビュー | ページネーションUIテンプレート |
