# 機能設計書 19-ユーザー削除

## 概要

本ドキュメントは、LEGACY CMSにおけるユーザーアカウントの削除（ステータス変更）機能について記述する。この機能は管理画面において、ユーザーのステータスを「active」「inactive」「suspended」の間で変更する機能を提供する。物理削除ではなく、ステータス変更による論理的な無効化を行う。

### 本機能の処理概要

**業務上の目的・背景**：ユーザーアカウントの有効/無効を管理するため、アカウントの停止・再開機能が必要である。ユーザーデータを物理的に削除するのではなく、ステータスを変更することで、監査証跡の保持やアカウント復元を可能にしている。

**機能の利用シーン**：
- 退職・離職したユーザーのアカウント無効化
- 規約違反等によるアカウント停止
- 停止中アカウントの再有効化
- 一時的なアカウント停止と復元

**主要な処理内容**：
1. ユーザーの権限チェック（uusers + ustatus権限の複合確認）
2. 確認ダイアログ表示（Change/Cancelボタン）
3. 確認後、usersテーブルのuser_statusを更新
4. 完了メッセージ表示

**関連システム・外部連携**：特になし。内部データベースの更新のみ。

**権限による制御**：`uusers` + `ustatus` リソースへのアクセス権限が必要。権限がない場合は権限エラー画面（privileges）へフォワードされる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | ユーザー管理画面 | 呼び出し元画面 | ステータス変更ボタンからダイアログを呼び出し |
| - | ステータス変更ダイアログ | 主画面 | 確認ダイアログ表示（Ajaxダイアログ） |

## 機能種別

CRUD操作（Update）/ ステータス変更 / Ajax通信 / 確認ダイアログ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | 対象ユーザーID | 数値 |
| status | string | Yes | 変更先ステータス | active/inactive/suspended |
| confirm | string | No | 確認フラグ | '1'で実行 |

### 入力データソース

- URLパラメータ（id, status, confirm）
- セッション（ログインユーザー情報、ACL情報）

## 出力仕様

### 出力データ（確認ダイアログ）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTML | string | 確認メッセージとChange/Cancelボタン |

### 出力データ（処理完了時）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTML | string | 完了メッセージとCloseボタン |

### 出力先

Ajax応答（HTML直接出力）

## 処理フロー

### 処理シーケンス

```
1. statusAction()が呼び出される
   └─ 権限チェック（uusers + ustatus）
      ├─ 権限なし → privileges画面へフォワード
      └─ 権限あり → 次のステップへ

2. レイアウト/ビュー無効化
   ├─ disableLayout()
   └─ setNoRender(true)

3. パラメータ取得
   ├─ confirm: 確認フラグ
   ├─ id: 対象ユーザーID
   └─ status: 変更先ステータス

4. 確認フラグ判定
   ├─ confirm != '1' → 確認ダイアログ表示
   │   └─ "Are you sure you want to change this user's status?"
   │       + Change/Cancelボタン
   │
   └─ confirm == '1' && id && status → 次のステップへ

5. ステータス更新
   └─ UPDATE users SET user_status = ? WHERE user_id = ?

6. 完了メッセージ出力
   └─ "Status Changed" + Closeボタン
```

### フローチャート

```mermaid
flowchart TD
    A[開始: statusAction] --> B{uusers+ustatus権限あり?}
    B -->|No| C[privileges画面へフォワード]
    B -->|Yes| D[レイアウト/ビュー無効化]
    D --> E[パラメータ取得 id,status,confirm]
    E --> F{confirm='1' && id && status?}
    F -->|No| G[確認ダイアログ表示]
    G --> H[Change/Cancelボタン表示]
    H --> I[終了]
    F -->|Yes| J[UPDATE users SET user_status]
    J --> K[完了メッセージ出力]
    K --> L[Closeボタン表示]
    L --> I
    C --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 論理削除方式 | ユーザーは物理削除せずステータス変更で無効化 | 常時 |
| BR-02 | ステータス選択肢 | active/inactive/suspendedの3状態 | 常時 |
| BR-03 | 確認ダイアログ必須 | ステータス変更前に確認ダイアログを表示 | 常時 |
| BR-04 | 自己ステータス変更 | 自分自身のステータス変更は制限されない（コード上） | 要検討 |

### ステータスの意味

| ステータス | 表示色 | 意味 |
|-----------|-------|------|
| active | 緑旗 | 有効なアカウント、ログイン可能 |
| inactive | 黄旗 | 無効化されたアカウント、ログイン不可 |
| suspended | 赤旗 | 停止中のアカウント、ログイン不可 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ステータス更新 | users | UPDATE | user_statusカラム更新 |

### テーブル別操作詳細

#### usersテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | user_status | active/inactive/suspended | WHERE user_id = ? |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | uusers/ustatus権限なし | privileges画面へフォワード |

### リトライ仕様

特になし（ユーザー操作による再試行）

## トランザクション仕様

単一テーブルの単一UPDATE操作のため、トランザクション管理は不要

## パフォーマンス要件

- 単一レコードのUPDATE操作のため、パフォーマンス懸念なし
- user_idはPRIMARY KEYのため、インデックス最適化済み

## セキュリティ考慮事項

- ACLによる権限チェック（uusers + ustatusリソース）
- ステータス値のバリデーションなし（コード上は任意の文字列が設定可能）
  - **注意**：入力値の厳密なバリデーションが推奨される
- SQLインジェクション対策：ユーザーIDは直接クエリに埋め込まれている
  - **注意**：プリペアドステートメントの使用が推奨される

## 備考

- 物理削除機能は実装されていない（論理削除のみ）
- 自分自身のステータス変更に対する制限がないため、管理者が自身をinactive/suspendedにすることが可能
- ステータス変更後、一覧画面の即時更新は行われない（ダイアログを閉じると元の画面に戻る）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

usersテーブルのuser_statusカラムの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブル（347-361行目）、user_statusカラムの定義 |

**読解のコツ**: user_statusは'active'がデフォルト値。ENUM型ではなくVARCHAR型。

#### Step 2: エントリーポイントを理解する

コントローラーのstatusActionを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | statusAction（209-258行目） |

**主要処理フロー**:
1. **211行目**: uusers + ustatus権限チェック
2. **213-214行目**: レイアウト/ビュー無効化
3. **216-218行目**: confirm, id, statusパラメータ取得
4. **220行目**: 確認フラグとパラメータの存在チェック
5. **226-231行目**: usersテーブル更新（confirm='1'の場合）
6. **242-248行目**: 確認ダイアログ表示（confirm != '1'の場合）

#### Step 3: 呼び出し元を理解する

ユーザー一覧画面または詳細画面からの呼び出しを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | manage.phtml | `application/modules/admin/views/scripts/users/manage.phtml` | ステータス変更ボタンの実装 |

### プログラム呼び出し階層図

```
ユーザー一覧画面（manage.phtml）
    │
    └─ ステータスアイコンクリック
           │
           ▼
UsersController::statusAction()
    │
    ├─ ACL::isAllowed() [権限チェック uusers+ustatus]
    │
    ├─ disableLayout() / setNoRender()
    │
    ├─ パラメータ取得 (confirm, id, status)
    │
    ├─ confirm != '1' の場合
    │      └─ 確認ダイアログ出力
    │          └─ Changeボタン → statusAction?confirm=1 再呼び出し
    │
    └─ confirm == '1' の場合
           ├─ $registry->db->update('users') [ステータス更新]
           └─ 完了メッセージ出力
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ───────▶ UsersController::statusAction
(id, status)            ├─ ACL権限チェック
                        └─ confirm判定
                               │
              ┌────────────────┴────────────────┐
              │ confirm != '1'                   │ confirm == '1'
              ▼                                  ▼
        確認ダイアログ                      UPDATE users
        "Are you sure..."                   SET user_status = ?
              │                                  │
              ▼                                  ▼
        Change/Cancel                       完了メッセージ
        ボタン表示                          "Status Changed"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | コントローラー | statusAction（ステータス変更処理） |
| manage.phtml | `application/modules/admin/views/scripts/users/manage.phtml` | ビュー | ユーザー一覧（ステータス変更ボタン含む） |
| database.sql | `database.sql` | スキーマ | usersテーブル定義（user_statusカラム） |
