# 機能設計書 2-ログアウト

## 概要

本ドキュメントは、LEGACY CMSにおけるログアウト機能の設計を記述したものである。システムからのログアウト処理とセッションクリアの仕様を定義する。

### 本機能の処理概要

**業務上の目的・背景**：セキュリティ上の理由から、ユーザーがシステム利用を終了する際には適切にセッションを破棄し、認証状態を解除する必要がある。本機能は、共有端末での利用や長時間離席時のセキュリティリスクを軽減するために提供される。また、別のアカウントでログインし直す場合にも本機能が必要となる。

**機能の利用シーン**：ユーザーが管理画面での作業を終了する際に、ヘッダーやメニューに配置されたログアウトリンクをクリックして実行する。ログアウト完了後は、ログイン画面または管理ダッシュボード（再認証が必要）へリダイレクトされる。

**主要な処理内容**：
1. ログアウトリクエストの受信
2. レイアウト・ビューの無効化
3. Zend_Authのアイデンティティ（認証情報）のクリア
4. 管理ダッシュボードへのリダイレクト（未認証状態のため、ログイン画面に転送される）

**関連システム・外部連携**：Zend Frameworkの認証コンポーネント（Zend_Auth）を使用してセッション情報をクリアする。

**権限による制御**：ログアウト機能は認証済みユーザーのみが実行可能である。未認証状態でログアウトにアクセスしようとした場合は、ログイン画面へリダイレクトされる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 全管理画面（ヘッダー部分） | 主画面 | ログアウトリンクの配置 |
| 5 | ログイン画面 | 結果表示画面 | ログアウト後のリダイレクト先 |

## 機能種別

セッション管理 / 認証解除処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | ログアウトにはパラメータ不要 | - |

### 入力データソース

HTTPリクエスト（GET）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| なし | - | ログアウト処理は画面出力なし（リダイレクトのみ） |

### 出力先

- HTTPリダイレクト（/admin/index/index → 認証チェックにより /admin/auth/login へ）
- セッションストレージ（クリア）

## 処理フロー

### 処理シーケンス

```
1. preDispatch実行
   └─ 未認証状態の場合、ログイン画面へリダイレクト
2. logoutAction実行
   └─ レイアウトを無効化
3. Zend_Authのアイデンティティをクリア
   └─ clearIdentity()の呼び出し
4. 管理ダッシュボードへリダイレクト
   └─ 未認証のため、ログイン画面に再リダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[ログアウトリクエスト] --> B{認証済み?}
    B -->|No| C[ログイン画面へリダイレクト]
    B -->|Yes| D[レイアウト無効化]
    D --> E[Zend_Auth::clearIdentity]
    E --> F[セッションクリア]
    F --> G[管理ダッシュボードへリダイレクト]
    G --> H{認証チェック}
    H -->|未認証| C
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 認証必須 | ログアウトは認証済みユーザーのみ実行可能 | 常時 |
| BR-002 | セッション完全クリア | ログアウト時にすべての認証情報を破棄 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | ログアウト処理ではデータベース操作なし |

### テーブル別操作詳細

ログアウト処理ではデータベースへの操作は発生しない。セッションストレージ（メモリまたはファイル）のみが影響を受ける。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | リダイレクト | 未認証状態でアクセス | ログイン画面へ自動リダイレクト |

### リトライ仕様

特になし

## トランザクション仕様

データベース操作なしのため、トランザクション管理は不要

## パフォーマンス要件

- レスポンス時間: 即時（リダイレクトのみ）
- サーバー負荷: 最小限

## セキュリティ考慮事項

- セッション情報は完全にクリアされる
- ログアウト後は再認証が必要
- セッションIDの再生成は実装されていない（セッション固定攻撃対策として推奨）

## 備考

- シンプルな処理で、画面レンダリングなし
- ログアウト後の確認画面やメッセージ表示は実装されていない
- Cookieに保存されたログイン情報（remember機能）は、ログアウト時にはクリアされない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

ログアウト処理はシンプルなため、コントローラーのアクションメソッドから直接確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AuthController.php | `application/modules/admin/controllers/AuthController.php` | logoutAction()メソッド（164-169行目） |

**主要処理フロー**:
1. **166行目**: `$this->_helper->layout->disableLayout()` - レイアウトを無効化
2. **167行目**: `Zend_Auth::getInstance()->clearIdentity()` - 認証情報をクリア
3. **168行目**: `$this->_helper->redirector('index','index','admin')` - リダイレクト

#### Step 2: preDispatchによるアクセス制御を理解する

ログアウトへのアクセス制御ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AuthController.php | `application/modules/admin/controllers/AuthController.php` | preDispatch()メソッド（42-57行目） |

**主要処理フロー**:
- **44行目**: `Zend_Auth::getInstance()->hasIdentity()` - 認証状態の確認
- **47-48行目**: ログイン済みでlogout以外のアクションの場合、ダッシュボードへリダイレクト
- **53-54行目**: 未認証でlogoutアクションの場合、ログイン画面へリダイレクト

#### Step 3: Zend_Authの動作を理解する

Zend_Authコンポーネントの認証情報管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Zend_Auth（Zend Framework） | Zend/Auth.php | clearIdentity()メソッドがセッションストレージをクリアする |

**読解のコツ**: Zend_AuthはSingletonパターンで実装されており、`getInstance()`で取得したインスタンスの`clearIdentity()`を呼び出すことで、セッションに保存された認証情報がすべてクリアされる。

### プログラム呼び出し階層図

```
Admin_AuthController::logoutAction()
    │
    ├─ Zend_Controller_Action_Helper_ViewRenderer::disableLayout()
    │      └─ レイアウトの無効化
    │
    ├─ Zend_Auth::getInstance()
    │      └─ Zend_Auth::clearIdentity()
    │             └─ Zend_Auth_Storage::clear()
    │
    └─ Zend_Controller_Action_Helper_Redirector::redirector()
           └─ HTTP 302 Redirect
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト ───▶ logoutAction()      ───▶ HTTPリダイレクト
(GET /admin/         │                        (/admin/index/index)
 auth/logout)        │
                     ▼
              Zend_Auth::clearIdentity()
                     │
                     ▼
              セッションストレージ
              (認証情報クリア)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AuthController.php | `application/modules/admin/controllers/AuthController.php` | コントローラー | ログアウト処理の実装（164-169行目） |
| Auth.php | `library/CMS/Controller/Action/Auth.php` | 親クラス | 認証コントローラーの基底クラス |
