# 機能設計書 20-プロフィール表示

## 概要

本ドキュメントは、LEGACY CMSにおけるユーザープロフィールの表示機能について記述する。この機能は管理画面のユーザー編集画面内でAjax読み込みされ、ユーザーの基本情報（アカウント作成日、ステータス、最終更新日、コメント数）と操作ボタン（Save、Activate/Suspend、Reset Password、Users）を表示する。

### 本機能の処理概要

**業務上の目的・背景**：ユーザー編集画面において、対象ユーザーの概要情報を表示し、主要な操作（保存、ステータス変更、パスワードリセット）への導線を提供する。編集フォームとは別にユーザーの現在状態を確認できるようにする。

**機能の利用シーン**：ユーザー編集画面（edit.phtml）に遷移した際、自動的にAjax読み込みされて表示される。ユーザーの基本情報を確認しながら、編集作業や各種操作を行う際に使用される。

**主要な処理内容**：
1. ユーザーの権限チェック（uusers + uview権限の複合確認）
2. 対象ユーザー情報の取得（users + users_profiles + users_roles結合）
3. ユーザー詳細情報の表示（Details fieldset）
4. 操作ボタンの表示（Functions fieldset）

**関連システム・外部連携**：コメント管理機能との連携（CCountヘルパーでコメント数取得）

**権限による制御**：
- 表示自体：`uusers` + `uview` リソースへのアクセス権限が必要
- Saveボタン：`uedit` 権限がある場合のみ表示
- Activate/Suspendボタン：`uedit` 権限かつ自分以外のユーザーの場合のみ表示
- Reset Passwordボタン：`upassword` 権限がある場合のみ表示
- Commentsリンク：`gcomments` 権限がある場合のみ表示

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 44 | ユーザー詳細画面 | 主画面 | プロフィール情報表示 |
| 42 | ユーザー編集画面 | 呼び出し元画面 | Ajax読み込みで詳細表示 |

## 機能種別

CRUD操作（Read）/ 詳細表示 / Ajax通信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | 表示対象ユーザーID | 数値 |

### 入力データソース

- URLパラメータ（ユーザーID）
- セッション（ログインユーザー情報、ACL情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| userArray | array | 対象ユーザー情報（users + users_profiles + users_roles結合データ） |

### 表示項目（Details fieldset）

| 項目名 | データソース | フォーマット |
|--------|-------------|-------------|
| Account Created | userArray['user_date'] | d/m/Y形式 |
| Account Status | userArray['user_status'] | 先頭大文字化（ucwords） |
| Last Updated | userArray['upro_date'] | d/m/Y H:i形式 |
| Comments | CCountヘルパー | コメント数（リンク付き） |

### 表示項目（Functions fieldset）

| ボタン名 | 表示条件 | 呼び出し先 |
|---------|---------|-----------|
| Save | uedit権限あり | postDialog → /admin/users/save |
| Activate Account | uedit権限あり かつ 自分以外 かつ suspended/inactive | getDialog → /admin/users/status?status=active |
| Suspend Account | uedit権限あり かつ 自分以外 かつ active | getDialog → /admin/users/status?status=suspended |
| Reset Password | upassword権限あり | getDialog → /admin/users/password |
| Users | 常時表示 | goTo → /admin/users/ |

### 出力先

Ajax応答として`application/modules/admin/views/scripts/users/details.phtml`を描画

## 処理フロー

### 処理シーケンス

```
1. detailsAction()が呼び出される（Ajax）
   └─ 権限チェック（uusers + uview）
      ├─ 権限なし → privileges画面へフォワード
      └─ 権限あり → 次のステップへ

2. レイアウト無効化
   └─ disableLayout()

3. ユーザー情報取得
   ├─ パラメータからuser_id取得
   └─ SELECT FROM users
       JOIN users_profiles ON upro_userid = user_id
       JOIN users_roles ON role_id = user_role
       WHERE user_id = ?

4. ビューへのデータ設定
   └─ userArray: ユーザー情報

5. details.phtml描画
   ├─ Details fieldset: アカウント情報表示
   └─ Functions fieldset: 操作ボタン表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始: detailsAction Ajax呼び出し] --> B{uusers+uview権限あり?}
    B -->|No| C[privileges画面へフォワード]
    B -->|Yes| D[レイアウト無効化]
    D --> E[パラメータからuser_id取得]
    E --> F[SELECTクエリ実行 users+profiles+roles]
    F --> G[ビューへデータ設定]
    G --> H[details.phtml描画]
    H --> I[Details fieldset: アカウント情報]
    I --> J[Functions fieldset: 操作ボタン]
    J --> K[終了]
    C --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 自己ステータス変更禁止 | 自分自身のステータス変更ボタンは非表示 | Activate/Suspendボタン表示時 |
| BR-02 | ステータス別ボタン切替 | active→Suspend、suspended/inactive→Activateボタン | uedit権限あり時 |
| BR-03 | 日付フォーマット | 作成日=d/m/Y、更新日=d/m/Y H:i | MakeDateヘルパー使用 |
| BR-04 | コメントリンク | gcomments権限がある場合のみコメント数リンク表示 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー情報取得 | users | SELECT | 基本情報取得 |
| ユーザー情報取得 | users_profiles | SELECT | プロフィール情報結合取得 |
| ユーザー情報取得 | users_roles | SELECT | ロール情報結合取得 |

### テーブル別操作詳細

#### usersテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_id, user_date, user_status等 | WHERE user_id = ? | JOINで取得 |

#### users_profilesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | upro_date等 | WHERE upro_userid = user_id | JOINで取得 |

#### users_rolesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | role_id, role_title等 | WHERE role_id = user_role | JOINで取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | uusers/uview権限なし | privileges画面へフォワード |

### リトライ仕様

特になし（読み取り専用操作のため）

## トランザクション仕様

読み取り専用操作のため、トランザクション管理は不要

## パフォーマンス要件

- 単一ユーザーの取得のみ（3テーブルJOIN + LIMIT 1）
- CCountヘルパーで追加のSELECTが実行される可能性

## セキュリティ考慮事項

- ACLによる権限チェック（uusers + uviewリソース）
- 各操作ボタンの表示も権限ベースで制御
- 自己ステータス変更の禁止（表示レベルでの制限）
- SQLインジェクション対策：Zend_Db_Selectによるプリペアドステートメント使用

## 備考

- Ajax読み込みで表示されるため、レイアウトは無効化
- edit.phtmlのdetailsResponse ContentPaneに読み込まれる
- Dojo Toolkitのdijit.form.Buttonでボタンを構成
- MakeDateヘルパーで日付フォーマット、CCountヘルパーでコメント数取得

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザー関連テーブルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブル（347-361行目）、users_profiles（457-477行目）、users_roles（576-581行目） |

**読解のコツ**: user_date（作成日）、user_status（ステータス）、upro_date（更新日）の各カラムを確認。

#### Step 2: エントリーポイントを理解する

コントローラーのdetailsActionを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | detailsAction（559-588行目） |

**主要処理フロー**:
1. **561行目**: uusers + uview権限チェック
2. **563行目**: disableLayout()でレイアウト無効化
3. **565行目**: idパラメータからuser_id取得
4. **571-576行目**: users + users_profiles + users_roles JOIN SELECTクエリ構築
5. **581行目**: userArrayをビューに設定

#### Step 3: ビューテンプレートを理解する

詳細表示のUI実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | details.phtml | `application/modules/admin/views/scripts/users/details.phtml` | プロフィール表示テンプレート |

**主要処理フロー**:
- **13-19行目**: Details fieldset（アカウント情報表示）
- **15行目**: MakeDateヘルパーでuser_dateフォーマット
- **16行目**: ucwords()でuser_status先頭大文字化
- **17行目**: MakeDateヘルパーでupro_dateフォーマット
- **18行目**: CCountヘルパーでコメント数表示（gcomments権限チェック）
- **24-42行目**: Functions fieldset（操作ボタン）
- **28行目**: Saveボタン（uedit権限）
- **29-35行目**: Activate/Suspendボタン（uedit権限 かつ 自分以外）
- **36-38行目**: Reset Passwordボタン（upassword権限）
- **39行目**: Usersボタン（常時表示）

#### Step 4: 呼び出し元を理解する

編集画面からのAjax読み込みを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | edit.phtml | `application/modules/admin/views/scripts/users/edit.phtml` | 39行目のdetailsResponse ContentPane |

### プログラム呼び出し階層図

```
ユーザー編集画面（edit.phtml）
    │
    └─ detailsResponse ContentPane (Ajax読み込み)
           │
           ▼
UsersController::detailsAction()
    │
    ├─ ACL::isAllowed() [権限チェック uusers+uview]
    │
    ├─ disableLayout()
    │
    ├─ Zend_Db_Select [ユーザー情報取得]
    │      └─ users + users_profiles + users_roles JOIN
    │
    └─ View: details.phtml
           ├─ Details fieldset
           │      ├─ MakeDate() [日付フォーマット]
           │      └─ CCount() [コメント数取得]
           │
           └─ Functions fieldset
                  ├─ Save → postDialog → /admin/users/save
                  ├─ Activate/Suspend → getDialog → /admin/users/status
                  ├─ Reset Password → getDialog → /admin/users/password
                  └─ Users → goTo → /admin/users/
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ───────▶ UsersController::detailsAction
(id)                     ├─ ACL権限チェック
                         └─ SELECTクエリ構築
                                   │
                                   ▼
                         Zend_Db_Select
                         (users + profiles + roles)
                                   │
                                   ▼
                         ビューへ変数設定
                         └─ userArray
                                   │
                                   ▼
                         details.phtml
                         ├─ Details fieldset
                         │   ├─ Account Created
                         │   ├─ Account Status
                         │   ├─ Last Updated
                         │   └─ Comments (リンク)
                         │
                         └─ Functions fieldset
                             ├─ Save
                             ├─ Activate/Suspend
                             ├─ Reset Password
                             └─ Users
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | コントローラー | detailsAction（プロフィール取得） |
| details.phtml | `application/modules/admin/views/scripts/users/details.phtml` | ビュー | プロフィール表示テンプレート |
| edit.phtml | `application/modules/admin/views/scripts/users/edit.phtml` | ビュー | 呼び出し元（Ajax読み込み） |
| MakeDate.php | `application/modules/admin/views/helpers/MakeDate.php` | ヘルパー | 日付フォーマット |
| CCount.php | `application/modules/admin/views/helpers/CCount.php` | ヘルパー | コメント数取得 |
| database.sql | `database.sql` | スキーマ | users, users_profiles, users_rolesテーブル定義 |
