# 機能設計書 21-イベント一覧表示

## 概要

本ドキュメントは、LEGACY CMSにおけるイベント一覧表示機能の設計仕様を定義する。

### 本機能の処理概要

イベント一覧表示機能は、システムに登録されたイベント情報を一覧形式で表示し、ユーザーが効率的にイベントを閲覧・検索できるようにするための機能である。

**業務上の目的・背景**：イベント管理を行うCMSにおいて、登録されたイベント情報を一元的に把握し、管理・参照できる仕組みが必要である。本機能により、管理者は全イベントの状況を俯瞰的に確認でき、カテゴリや会場による絞り込みで特定イベントを素早く探し出すことができる。また、フロントエンド側では公開中のイベントを日付順に表示し、サイト訪問者にイベント情報を提供する。

**機能の利用シーン**：管理画面でのイベント管理作業時（イベントの編集・削除対象の特定）、フロントエンドでのイベント情報閲覧時（サイト訪問者が今後のイベントを確認）、特定カテゴリや会場に紐づくイベントの検索時に利用される。

**主要な処理内容**：
1. データベースからイベント情報を取得（会場・カテゴリ情報を結合）
2. フィルタ条件（カテゴリ、会場）による絞り込み
3. ページネーションによる分割表示（15件/ページ）
4. イベント日付のフォーマット表示

**関連システム・外部連携**：特になし

**権限による制御**：管理画面ではACLによるアクセス制御が適用され、「eevents」権限を持つロールのみがアクセス可能。フロントエンド側は公開イベントのみ表示され、権限チェックは不要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | イベント一覧画面 | 主画面 | 公開中のイベントを一覧表示 |
| 17 | カレンダー画面 | 主画面 | 月別カレンダー形式でイベントを表示 |
| 18 | イベント詳細画面 | 主画面 | イベントの詳細内容を表示 |
| 19 | カテゴリ別イベント一覧画面 | 主画面 | カテゴリでフィルタしたイベントを表示 |
| 20 | 会場別イベント一覧画面 | 主画面 | 会場でフィルタしたイベントを表示 |
| 48 | イベント管理画面 | 主画面 | 管理用のイベント一覧を表示 |

## 機能種別

CRUD操作（Read）/ データ検索 / ページネーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| page | int | No | 表示するページ番号 | 数値、デフォルト1 |
| category | int | No | カテゴリIDによるフィルタ | 数値 |
| venue | int | No | 会場IDによるフィルタ | 数値 |
| year | int | No | 年による絞り込み（カレンダー表示） | 数値（4桁） |
| month | int | No | 月による絞り込み（カレンダー表示） | 数値（1-12） |
| day | int | No | 日による絞り込み（カレンダー表示） | 数値（1-31） |

### 入力データソース

- URLパラメータ（GETリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| eventsArray | Zend_Paginator | イベント一覧（ページネーション適用済み） |
| event_id | int | イベントID |
| event_title | string | イベントタイトル |
| event_category | int | カテゴリID |
| ecat_title | string | カテゴリ名 |
| event_venue | int | 会場ID |
| venue_title | string | 会場名 |
| venue_city | string | 会場所在地（都市） |
| event_date | datetime | イベント開始日時 |
| event_end | datetime | イベント終了日時 |
| event_status | string | 公開ステータス（draft/published） |

### 出力先

- 画面表示（ビューテンプレートへのデータ受け渡し）

## 処理フロー

### 処理シーケンス

```
1. アクセス権限チェック
   └─ ACLで「eevents」権限を確認（管理画面のみ）
2. 入力パラメータ取得
   └─ page, category, venue, year, month, day を取得
3. SQLクエリ構築
   └─ フィルタ条件に応じてWHERE句を追加
4. データベースからイベント取得
   └─ events, events_categories, events_venues テーブルを結合
5. ページネーション適用
   └─ 15件/ページで分割
6. ビューへデータ受け渡し
   └─ eventsArray としてビューに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{管理画面?}
    B -->|Yes| C{eevents権限あり?}
    B -->|No| D[公開イベントのみ取得]
    C -->|Yes| E[パラメータ取得]
    C -->|No| F[権限エラー画面へ]
    E --> G{フィルタ条件あり?}
    D --> H[日付条件追加]
    G -->|Yes| I[フィルタ条件でクエリ構築]
    G -->|No| J[全件クエリ構築]
    H --> K[ページネーション適用]
    I --> K
    J --> K
    K --> L[ビューへ出力]
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-21-01 | 公開ステータスフィルタ | フロントエンドでは公開済み（published）のイベントのみ表示 | フロントエンド表示時 |
| BR-21-02 | 日付フィルタ | フロントエンドでは現在日時以降のイベントのみ表示 | フロントエンド表示時 |
| BR-21-03 | ソート順序 | フロントエンドはイベント日付昇順、管理画面はイベント日付降順 | 常時 |
| BR-21-04 | ページあたり表示件数 | 1ページあたり15件表示 | 常時 |

### 計算ロジック

- イベント日付フォーマット: `EDate()` メソッドにより、開始日時と終了日時を整形表示
  - 同日の場合: 開始日時 - 終了時刻
  - 異日の場合: 開始日時 - 終了日時

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| イベント一覧取得 | events | SELECT | イベント情報の取得 |
| イベント一覧取得 | events_categories | SELECT (JOIN) | カテゴリ情報の結合 |
| イベント一覧取得 | events_venues | SELECT (JOIN) | 会場情報の結合 |

### テーブル別操作詳細

#### events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | event_id, event_title, event_category, event_venue, event_date, event_end, event_status | フィルタ条件に応じて取得 | 主キーはevent_id |

#### events_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_id, ecat_title | event_category = ecat_id で結合 | - |

#### events_venues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | venue_id, venue_title, venue_city | event_venue = venue_id で結合 | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | eevents権限なしでアクセス | 権限エラー画面（privileges）へ転送 |
| - | 404エラー | カレンダー表示で必須パラメータ不足 | notfound画面へ転送 |

### リトライ仕様

特になし

## トランザクション仕様

読み取り専用のため、トランザクション制御は不要

## パフォーマンス要件

- 1ページあたり15件に制限することでレスポンス時間を確保
- Zend_Paginatorによる効率的なページング処理

## セキュリティ考慮事項

- 管理画面へのアクセスはACLによる権限チェック必須
- フロントエンドでは公開済みイベントのみ表示（非公開情報の漏洩防止）
- XSS対策としてビューでのエスケープ処理

## 備考

- 管理画面（Admin_EventsController::manageAction）とフロントエンド（EventsController::indexAction）で処理が分かれている
- カレンダー表示は別アクション（calendarAction）で実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベント、カテゴリ、会場の3テーブルの関係性を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | eventsテーブル | データベース | event_id, event_title, event_category, event_venue, event_date, event_end, event_status カラムを確認 |
| 1-2 | events_categoriesテーブル | データベース | ecat_id, ecat_title カラムを確認 |
| 1-3 | events_venuesテーブル | データベース | venue_id, venue_title, venue_city カラムを確認 |

**読解のコツ**: 3テーブルはevent_category → ecat_id、event_venue → venue_id で結合される。

#### Step 2: エントリーポイントを理解する

管理画面とフロントエンドの両方のコントローラーを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_EventsController.php | `application/modules/admin/controllers/EventsController.php` | 管理画面側のイベント一覧処理 |
| 2-2 | EventsController.php | `application/modules/default/controllers/EventsController.php` | フロントエンド側のイベント一覧処理 |

**主要処理フロー（Admin_EventsController::manageAction）**:
1. **116-118行目**: indexActionからmanageActionへリダイレクト
2. **123-194行目**: manageAction - イベント一覧取得のメイン処理
3. **125行目**: ACL権限チェック（eevents）
4. **133-134行目**: フィルタパラメータ取得（category, venue）
5. **137-142行目**: ページ番号取得（デフォルト1）
6. **144-177行目**: フィルタ条件に応じたSELECTクエリ構築
7. **179-183行目**: Zend_Paginatorによるページネーション設定
8. **186行目**: ビューへのデータ受け渡し

**主要処理フロー（EventsController::indexAction）**:
1. **28-60行目**: indexAction - フロントエンドイベント一覧
2. **44-50行目**: 公開済み・将来日付のイベントを取得するクエリ
3. **53-59行目**: ページネーション設定

#### Step 3: 補助処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Admin_EventsController.php | `application/modules/admin/controllers/EventsController.php` | EDate()メソッド（20-46行目）で日付フォーマット処理 |
| 3-2 | Admin_EventsController.php | `application/modules/admin/controllers/EventsController.php` | getVenue()（48-83行目）、getCategory()（85-111行目）でフィルタ表示用情報取得 |

**読解のコツ**: Zend Framework 1.x のMVCパターンに基づいており、Controllerでビジネスロジック、Viewでプレゼンテーションを分離している。

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | manage.phtml | `application/modules/admin/views/scripts/events/manage.phtml` | 管理画面のイベント一覧表示 |
| 4-2 | index.phtml | `application/modules/default/views/scripts/events/index.phtml` | フロントエンドのイベント一覧表示 |

**主要処理フロー（manage.phtml）**:
- **39-46行目**: 機能ボタン（新規イベント、新規会場、新規カテゴリ）
- **51-58行目**: フィルタ表示
- **71-98行目**: イベント一覧テーブル表示
- **100-107行目**: ページネーションコントロール

### プログラム呼び出し階層図

```
Admin_EventsController (管理画面)
    │
    ├─ manageAction()
    │      ├─ ACL権限チェック (isAllowed)
    │      ├─ getVenue() - 会場名取得
    │      ├─ getCategory() - カテゴリ名取得
    │      ├─ Zend_Db_Select - クエリ構築
    │      └─ Zend_Paginator - ページネーション
    │
    └─ EDate() - 日付フォーマット

EventsController (フロントエンド)
    │
    ├─ indexAction()
    │      ├─ Zend_Db_Select - クエリ構築
    │      └─ Zend_Paginator - ページネーション
    │
    └─ calendarAction()
           ├─ Zend_Db_Select - 日付フィルタ付きクエリ
           └─ Zend_Paginator - ページネーション
```

### データフロー図

```
[入力]                    [処理]                          [出力]

URLパラメータ           Admin_EventsController           ビュー(manage.phtml)
  page        ───▶      manageAction()         ───▶     eventsArray
  category              - クエリ構築                     (ページネーション済み)
  venue                 - DB検索
                        - ページネーション

HTTPリクエスト          EventsController                 ビュー(index.phtml)
  page        ───▶      indexAction()          ───▶     eventsArray
                        - 公開イベント取得               (ページネーション済み)
                        - ページネーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | コントローラー | 管理画面イベント処理 |
| EventsController.php | `application/modules/default/controllers/EventsController.php` | コントローラー | フロントエンドイベント処理 |
| Admin.php | `library/CMS/Controller/Action/Admin.php` | 親クラス | 認証・ACL基盤処理 |
| manage.phtml | `application/modules/admin/views/scripts/events/manage.phtml` | ビュー | 管理画面一覧表示 |
| index.phtml | `application/modules/default/views/scripts/events/index.phtml` | ビュー | フロントエンド一覧表示 |
| calendar.phtml | `application/modules/default/views/scripts/events/calendar.phtml` | ビュー | カレンダー表示 |
| categories.phtml | `application/modules/admin/views/scripts/events/categories.phtml` | ビュー | カテゴリ一覧（管理画面サイドパネル） |
| events.ini | `application/configs/events.ini` | 設定 | イベント表示設定（rows等） |
