# 機能設計書 22-イベント新規作成

## 概要

本ドキュメントは、LEGACY CMSにおけるイベント新規作成機能の設計仕様を定義する。

### 本機能の処理概要

イベント新規作成機能は、管理者が新しいイベントをシステムに登録するための機能である。2段階のウィザード形式で会場・カテゴリの選択後、イベント詳細を入力してデータベースに保存する。

**業務上の目的・背景**：イベント管理CMSにおいて、新規イベントを効率的に登録する仕組みが必要である。カテゴリに紐づくデフォルト設定（説明文テンプレート、デフォルト会場）を活用することで、入力作業を効率化し、一貫性のあるイベント情報を登録できる。

**機能の利用シーン**：管理者が新しいイベントを告知したい場合、イベント管理画面から「New Event」ボタンをクリックして新規作成ダイアログを開き、必要情報を入力してイベントを登録する。

**主要な処理内容**：
1. 第1段階: 会場とカテゴリの選択（newAction）
2. 第2段階: イベント詳細の入力とバリデーション（new2Action）
3. カテゴリのデフォルト設定を適用（デフォルト説明文、デフォルト会場）
4. イベントデータをデータベースに保存
5. 作成完了後、編集画面へ遷移

**関連システム・外部連携**：特になし

**権限による制御**：「eevents」権限と「eeventnew」権限の両方を持つロールのみがアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | イベント新規作成画面 | 主画面 | 新規イベントの作成処理 |

## 機能種別

CRUD操作（Create）/ フォーム入力 / バリデーション

## 入力仕様

### 入力パラメータ

#### 第1段階（newAction）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| eventvenue | int | Yes | 会場ID | NotEmpty |
| eventcategory | int | Yes | カテゴリID | NotEmpty |

#### 第2段階（new2Action）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| eventtitle | string | Yes | イベントタイトル | NotEmpty |
| eventvenue | int | Yes | 会場ID | NotEmpty |
| eventcategory | int | Yes | カテゴリID | NotEmpty |
| eventdatestart | string | Yes | 開始日 | NotEmpty |
| eventtimestart | string | Yes | 開始時刻 | NotEmpty |

### 入力データソース

- Ajaxダイアログ内のフォーム（POSTリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| event_id | int | 新規作成されたイベントID（lastInsertId） |
| 成功メッセージ | string | 「Event Created」 |
| エラーメッセージ | array | バリデーションエラーメッセージ |

### 出力先

- 画面表示（Ajaxダイアログ内）
- データベース（eventsテーブル）

## 処理フロー

### 処理シーケンス

```
1. 第1段階: 会場・カテゴリ選択
   └─ newAction
      ├─ ACL権限チェック（eevents, eeventnew）
      ├─ フォーム表示（初回アクセス時）
      ├─ 入力バリデーション（POST時）
      └─ 第2段階へリダイレクト

2. 第2段階: イベント詳細入力
   └─ new2Action
      ├─ ACL権限チェック（eevents, eeventnew）
      ├─ カテゴリのデフォルト設定取得
      ├─ フォーム表示（初回アクセス時）
      ├─ 入力バリデーション（POST時）
      ├─ 日付フォーマット変換
      ├─ デフォルト終了時刻設定（開始から2時間後）
      ├─ データベースINSERT
      └─ 成功メッセージ表示（編集画面へ遷移ボタン付き）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{権限チェック}
    B -->|権限なし| C[権限エラー]
    B -->|権限あり| D[第1段階: 会場・カテゴリ選択フォーム]
    D --> E{POST送信?}
    E -->|No| F[フォーム表示]
    E -->|Yes| G{バリデーション成功?}
    G -->|No| H[エラー表示]
    H --> F
    G -->|Yes| I[第2段階へリダイレクト]
    I --> J[第2段階: イベント詳細入力フォーム]
    J --> K{POST送信?}
    K -->|No| L[フォーム表示]
    K -->|Yes| M{バリデーション成功?}
    M -->|No| N[エラー表示]
    N --> L
    M -->|Yes| O[カテゴリデフォルト取得]
    O --> P[日付フォーマット変換]
    P --> Q[DB INSERT]
    Q --> R[成功メッセージ表示]
    R --> S[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-22-01 | デフォルト終了時刻 | 開始時刻から2時間後を終了時刻として設定 | 常時 |
| BR-22-02 | デフォルト会場適用 | 会場が0（未選択）の場合、カテゴリのデフォルト会場を適用 | 会場未選択時 |
| BR-22-03 | デフォルト説明文 | カテゴリに設定されたデフォルト説明文を初期値として設定 | 常時 |
| BR-22-04 | 初期ステータス | 新規作成時はdraft（下書き）ステータスで保存 | 常時 |

### 計算ロジック

- 開始日時: `date('Y-m-d H:i:s', strtotime($eventdatestart.' '.$eventtimestart))`
- 終了日時: `date('Y-m-d H:i:s', strtotime($formatstart.' + 2 hours'))`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カテゴリ情報取得 | events_categories | SELECT | デフォルト設定取得 |
| イベント作成 | events | INSERT | 新規イベントレコード作成 |

### テーブル別操作詳細

#### events_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_id, ecat_venue, ecat_default | WHERE ecat_id = ? | デフォルト会場・説明文取得 |

#### events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | event_title | 入力値 | イベントタイトル |
| INSERT | event_category | 入力値 | カテゴリID |
| INSERT | event_venue | 入力値またはカテゴリデフォルト | 会場ID |
| INSERT | event_description | カテゴリのecat_default | デフォルト説明文 |
| INSERT | event_date | フォーマット変換後の開始日時 | 開始日時 |
| INSERT | event_end | 開始+2時間 | 終了日時 |
| INSERT | event_user | ログインユーザーID | 作成者 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | eevents/eeventnew権限なし | 権限エラー画面へ転送 |
| - | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、フォーム再表示 |

### リトライ仕様

特になし（フォーム再入力による対応）

## トランザクション仕様

単一INSERT操作のため、明示的なトランザクション制御は不要

## パフォーマンス要件

- Ajaxダイアログでの表示のため、レスポンスは軽量であること

## セキュリティ考慮事項

- 管理画面へのアクセスはACLによる権限チェック必須（eevents + eeventnew）
- 入力値はZend_Filter_Inputによるバリデーション
- XSS対策としてビューでのエスケープ処理

## 備考

- 新規作成はdraft状態で保存され、別途publishAction（公開処理）が必要
- 作成完了後は編集画面へ遷移するボタンが表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベントテーブルとカテゴリテーブルの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | eventsテーブル | データベース | INSERT対象カラムの確認 |
| 1-2 | events_categoriesテーブル | データベース | ecat_venue, ecat_default カラムの役割 |

**読解のコツ**: カテゴリには「デフォルト会場(ecat_venue)」と「デフォルト説明文(ecat_default)」が設定されており、新規イベント作成時に自動適用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_EventsController.php | `application/modules/admin/controllers/EventsController.php` | newAction, new2Action |

**主要処理フロー（newAction - 第1段階）**:
1. **696-698行目**: 権限チェック（eevents, eeventnew）
2. **699行目**: レイアウト無効化（Ajaxダイアログ用）
3. **701-743行目**: POST処理
4. **707-718行目**: バリデーション定義（eventvenue, eventcategory必須）
5. **720行目**: Zend_Filter_Inputでバリデーション実行
6. **722-731行目**: バリデーション成功時、第2段階へリダイレクト

**主要処理フロー（new2Action - 第2段階）**:
1. **762-764行目**: 権限チェック
2. **767-769行目**: category, venueパラメータ取得
3. **771-803行目**: POST処理
4. **777-802行目**: バリデーション定義（eventtitle, eventdatestart, eventtimestart必須）
5. **805行目**: Zend_Filter_Inputでバリデーション実行
6. **807-820行目**: カテゴリデフォルト設定取得
7. **822-824行目**: 日付フォーマット変換、終了時刻計算（+2時間）
8. **826-830行目**: デフォルト会場適用ロジック
9. **832-841行目**: INSERTデータ配列作成
10. **844行目**: データベースINSERT
11. **846-851行目**: 成功メッセージ表示（編集画面遷移ボタン付き）

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.phtml | `application/modules/admin/views/scripts/events/new.phtml` | 第1段階フォーム |
| 3-2 | new2.phtml（推定） | `application/modules/admin/views/scripts/events/` | 第2段階フォーム |

### プログラム呼び出し階層図

```
Admin_EventsController
    │
    ├─ newAction() [第1段階]
    │      ├─ ACL権限チェック (isAllowed)
    │      ├─ Zend_Filter_Input - バリデーション
    │      └─ Redirector - new2Actionへ遷移
    │
    └─ new2Action() [第2段階]
           ├─ ACL権限チェック (isAllowed)
           ├─ Zend_Db_Select - カテゴリ情報取得
           ├─ Zend_Filter_Input - バリデーション
           ├─ date() - 日付フォーマット変換
           └─ Zend_Db_Adapter::insert() - DB保存
```

### データフロー図

```
[入力]                      [処理]                           [出力]

フォーム入力（第1段階）     newAction()
  eventvenue      ───▶      - バリデーション         ───▶   リダイレクト
  eventcategory             - パラメータ引き継ぎ            (new2Action)

フォーム入力（第2段階）     new2Action()
  eventtitle      ───▶      - バリデーション         ───▶   eventsテーブル
  eventdatestart            - カテゴリデフォルト取得        (INSERT)
  eventtimestart            - 日付フォーマット変換
                            - DB INSERT                     成功メッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | コントローラー | イベント新規作成処理 |
| Admin.php | `library/CMS/Controller/Action/Admin.php` | 親クラス | 認証・ACL基盤処理 |
| new.phtml | `application/modules/admin/views/scripts/events/new.phtml` | ビュー | 第1段階フォーム |
| manage.phtml | `application/modules/admin/views/scripts/events/manage.phtml` | ビュー | 新規作成ダイアログ呼び出し元 |
