# 機能設計書 23-イベント編集

## 概要

本ドキュメントは、LEGACY CMSにおけるイベント編集機能の設計仕様を定義する。

### 本機能の処理概要

イベント編集機能は、既存のイベント情報を編集・更新するための機能である。編集画面でイベントの各種情報を変更し、保存処理を実行することでデータベースを更新する。公開済みイベントの場合は検索インデックスも更新される。

**業務上の目的・背景**：登録済みイベントの情報修正（日時変更、内容更新、誤記修正等）が必要な場合に対応するため、編集機能が必要である。イベント情報は公開前後で頻繁に変更が発生するため、効率的な編集インターフェースが求められる。

**機能の利用シーン**：イベント管理画面から対象イベントを選択し、編集画面を開いて情報を修正する。日時・場所の変更、説明文の更新、コメント設定の変更などを行い、保存ボタンで確定する。

**主要な処理内容**：
1. 既存イベント情報のデータベースからの取得
2. 編集フォームでの入力・変更
3. 入力値のバリデーション
4. データベースの更新（UPDATE）
5. 公開済みの場合は検索インデックスの更新

**関連システム・外部連携**：Zend_Search_Luceneによる検索インデックス更新

**権限による制御**：「eevents」権限と「eeventedit」権限の両方を持つロールのみがアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | イベント編集画面 | 主画面 | イベントの編集・更新処理 |

## 機能種別

CRUD操作（Read/Update）/ フォーム入力 / バリデーション

## 入力仕様

### 入力パラメータ

#### 表示時（editAction）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | int | Yes | イベントID | 数値 |

#### 保存時（saveAction）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | int | Yes | イベントID | 数値 |
| title | string | Yes | イベントタイトル | NotEmpty |
| category | int | Yes | カテゴリID | NotEmpty |
| venue | int | Yes | 会場ID | NotEmpty |
| datestart | string | Yes | 開始日 | NotEmpty |
| timestart | string | Yes | 開始時刻 | NotEmpty |
| dateend | string | No | 終了日 | allowEmpty |
| timeend | string | No | 終了時刻 | allowEmpty |
| description | string | Yes | 説明文 | NotEmpty |
| url | string | No | 関連URL | allowEmpty |
| ticket | string | No | チケット情報 | allowEmpty |
| comments | string | No | コメント許可フラグ | Y/N |
| moderate | string | No | コメントモデレーションフラグ | Y/N |

### 入力データソース

- URLパラメータ（イベントID）
- 編集フォーム（POSTリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| eventArray | array | イベント詳細情報 |
| 成功メッセージ | string | 「Event Saved」 |
| エラーメッセージ | array | バリデーションエラーメッセージ |

### 出力先

- 画面表示（編集フォーム、Ajaxダイアログ）
- データベース（eventsテーブル）
- 検索インデックス（Lucene）

## 処理フロー

### 処理シーケンス

```
1. 編集画面表示（editAction）
   └─ ACL権限チェック（eevents, eeventedit）
   └─ イベント情報取得（events + users JOIN）
   └─ ビューへデータ受け渡し

2. 保存処理（saveAction）
   └─ ACL権限チェック（eevents, eeventedit）
   └─ 入力バリデーション
   └─ コメント/モデレーションフラグ処理
   └─ 日付フォーマット変換
   └─ データベースUPDATE
   └─ 公開済みの場合、検索インデックス更新
   └─ 成功メッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{権限チェック}
    B -->|権限なし| C[権限エラー]
    B -->|権限あり| D{アクション判定}
    D -->|editAction| E[イベント情報取得]
    E --> F{データ存在?}
    F -->|No| G[一覧画面へリダイレクト]
    F -->|Yes| H[編集フォーム表示]
    D -->|saveAction| I{イベントID指定あり?}
    I -->|No| J[エラー表示]
    I -->|Yes| K[入力バリデーション]
    K --> L{バリデーション成功?}
    L -->|No| M[エラーメッセージ表示]
    L -->|Yes| N[日付フォーマット変換]
    N --> O[DB UPDATE]
    O --> P{公開済み?}
    P -->|Yes| Q[検索インデックス更新]
    P -->|No| R[成功メッセージ表示]
    Q --> R
    R --> S[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-23-01 | コメントフラグ変換 | チェックボックス未チェック時は'N'、チェック時は'Y' | 保存時 |
| BR-23-02 | モデレーションフラグ変換 | チェックボックス未チェック時は'N'、チェック時は'Y' | 保存時 |
| BR-23-03 | 検索インデックス更新 | 公開済み(published)イベントのみ検索インデックスを更新 | 保存時 |
| BR-23-04 | 日付フォーマット | 'Y-m-d H:i:s'形式でデータベースに保存 | 保存時 |

### 計算ロジック

- 開始日時: `date('Y-m-d H:i:s', strtotime($datestart.' '.$timestart))`
- 終了日時: `date('Y-m-d H:i:s', strtotime($dateend.' '.$timeend))`
- 検索インデックスURL: `/events/event/{event_id}/{urlencode(title)}/`
- 検索インデックスdetails: イベント日時 + 会場情報

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| イベント情報取得 | events | SELECT | 編集対象イベント取得 |
| ユーザー情報取得 | users | SELECT (JOIN) | 作成者情報取得 |
| イベント更新 | events | UPDATE | イベント情報更新 |
| 会場情報取得 | events_venues | SELECT (JOIN) | 検索インデックス用会場情報取得 |

### テーブル別操作詳細

#### events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE event_id = ? | 編集対象取得 |
| UPDATE | event_title | 入力値 | タイトル更新 |
| UPDATE | event_category | 入力値 | カテゴリ更新 |
| UPDATE | event_venue | 入力値 | 会場更新 |
| UPDATE | event_date | フォーマット変換後 | 開始日時更新 |
| UPDATE | event_end | フォーマット変換後 | 終了日時更新 |
| UPDATE | event_description | html_entity_decode後 | 説明文更新 |
| UPDATE | event_user | ログインユーザーID | 更新者 |
| UPDATE | event_url | 入力値 | URL更新 |
| UPDATE | event_tickets | 入力値 | チケット情報更新 |
| UPDATE | event_comments | Y/N | コメント許可フラグ更新 |
| UPDATE | event_moderate | Y/N | モデレーションフラグ更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | eevents/eeventedit権限なし | 権限エラー画面へ転送 |
| - | データ不存在 | 指定イベントIDが存在しない | 一覧画面へリダイレクト |
| - | バリデーションエラー | 必須項目未入力 | エラーメッセージ表示 |
| - | パラメータエラー | イベントID未指定 | 「Event Not Specified!」エラー表示 |

### リトライ仕様

特になし（フォーム再入力による対応）

## トランザクション仕様

単一UPDATE操作のため、明示的なトランザクション制御は不要

## パフォーマンス要件

- 検索インデックス更新は公開済みイベントのみ実行（不要な処理を回避）

## セキュリティ考慮事項

- 管理画面へのアクセスはACLによる権限チェック必須（eevents + eeventedit）
- 入力値はZend_Filter_Inputによるバリデーション
- 説明文はhtml_entity_decode処理（HTMLタグ許可）
- XSS対策として表示時のエスケープ処理が必要

## 備考

- 編集画面ではタグ、コメント、添付ファイルのタブも表示される（別機能）
- event_userは更新のたびに現在のログインユーザーIDで上書きされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベントテーブルの全カラムと更新対象を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | eventsテーブル | データベース | UPDATE対象カラムの確認 |
| 1-2 | events_venuesテーブル | データベース | 検索インデックス用の会場情報 |

**読解のコツ**: event_statusが'published'の場合のみ検索インデックスが更新される点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_EventsController.php | `application/modules/admin/controllers/EventsController.php` | editAction, saveAction |

**主要処理フロー（editAction - 編集画面表示）**:
1. **625-627行目**: 権限チェック（eevents, eeventedit）
2. **629行目**: レイアウト設定
3. **631行目**: イベントIDパラメータ取得
4. **634行目**: レジストリ取得
5. **637-641行目**: イベント情報取得クエリ（events + users JOIN）
6. **644行目**: クエリ実行
7. **646行目**: ビューへデータ設定
8. **648-650行目**: データ不存在時はmanage画面へリダイレクト

**主要処理フロー（saveAction - 保存処理）**:
1. **257-259行目**: 権限チェック（eevents, eeventedit）
2. **261-262行目**: レイアウト無効化
3. **265行目**: イベントIDパラメータ取得
4. **267行目**: イベントID存在チェック
5. **270-281行目**: コメント/モデレーションフラグ処理（Y/N変換）
6. **287-332行目**: バリデーション定義
7. **334行目**: Zend_Filter_Inputでバリデーション実行
8. **340行目**: バリデーション成功判定
9. **342-344行目**: 日付フォーマット変換
10. **347-359行目**: UPDATEデータ配列作成
11. **362行目**: データベースUPDATE実行
12. **365-371行目**: 公開済みイベント情報再取得
13. **376行目**: 公開ステータス判定
14. **379-401行目**: 検索インデックス更新処理
15. **406-411行目**: 成功メッセージ表示

#### Step 3: 検索インデックス更新処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | searchIndexヘルパー | ライブラリ | update()メソッドの実装 |

**検索インデックス更新の処理内容（394-401行目）**:
- key: 'e' + event_id
- date: 公開日をYmd形式で
- title: イベントタイトル
- url: イベント詳細URL
- details: 日時 + 会場情報
- stub: 説明文
- contents: 説明文（重複）

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | edit.phtml | `application/modules/admin/views/scripts/events/edit.phtml` | 編集フォーム |
| 4-2 | details.phtml | `application/modules/admin/views/scripts/events/details.phtml` | 詳細情報表示（タブ） |

### プログラム呼び出し階層図

```
Admin_EventsController
    │
    ├─ editAction() [編集画面表示]
    │      ├─ ACL権限チェック (isAllowed)
    │      ├─ Zend_Db_Select - イベント情報取得
    │      └─ View設定
    │
    └─ saveAction() [保存処理]
           ├─ ACL権限チェック (isAllowed)
           ├─ Zend_Filter_Input - バリデーション
           ├─ date() - 日付フォーマット変換
           ├─ Zend_Db_Adapter::update() - DB更新
           ├─ Zend_Db_Select - 更新後イベント取得
           └─ searchIndex->update() - 検索インデックス更新
```

### データフロー図

```
[入力]                      [処理]                           [出力]

URLパラメータ               editAction()
  id              ───▶      - イベント情報取得       ───▶   ビュー(edit.phtml)
                            - ビュー設定                    (eventArray)

フォーム入力                saveAction()
  title           ───▶      - バリデーション         ───▶   eventsテーブル
  category                  - 日付フォーマット変換          (UPDATE)
  venue                     - DB UPDATE
  datestart/timestart       - 検索インデックス更新         Luceneインデックス
  dateend/timeend                                          (published時のみ)
  description
  comments/moderate                                        成功メッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | コントローラー | イベント編集処理 |
| Admin.php | `library/CMS/Controller/Action/Admin.php` | 親クラス | 認証・ACL基盤処理 |
| edit.phtml | `application/modules/admin/views/scripts/events/edit.phtml` | ビュー | 編集フォーム |
| details.phtml | `application/modules/admin/views/scripts/events/details.phtml` | ビュー | 詳細情報タブ |
| SearchIndex.php | ライブラリ | ヘルパー | 検索インデックス操作 |
