# 機能設計書 24-イベント削除

## 概要

本ドキュメントは、LEGACY CMSにおけるイベント削除機能の設計仕様を定義する。

### 本機能の処理概要

イベント削除機能は、不要になったイベントをデータベースから削除するための機能である。削除前に確認ダイアログを表示し、ユーザーの明示的な確認後に削除を実行する。イベント本体に加え、関連するコメントと検索インデックスも同時に削除される。

**業務上の目的・背景**：中止になったイベントや誤って登録されたイベント、古くなったイベント情報を整理するために削除機能が必要である。関連データ（コメント）も一括削除することで、データの整合性を維持する。

**機能の利用シーン**：イベント管理画面で対象イベントの「Delete」リンクをクリックすると、Ajaxダイアログで削除確認が表示される。「Delete」ボタンをクリックすると削除が実行され、完了メッセージが表示される。

**主要な処理内容**：
1. 削除確認ダイアログの表示
2. 確認後、イベントレコードの削除
3. 関連コメントの削除
4. 検索インデックスからの削除

**関連システム・外部連携**：Zend_Search_Luceneによる検索インデックス削除

**権限による制御**：「eevents」権限と「eeventdelete」権限の両方を持つロールのみがアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | イベント管理画面 | 遷移元画面 | イベント削除ダイアログへの遷移 |

## 機能種別

CRUD操作（Delete）/ 確認ダイアログ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | int | Yes | 削除対象イベントID | 数値 |
| confirm | string | No | 削除確認フラグ | '1'で確認済み |

### 入力データソース

- URLパラメータ（GETリクエスト）
- Ajaxダイアログからの呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 確認メッセージ | string | 「Are you sure you want to delete this event?」 |
| 成功メッセージ | string | 「Event Deleted」 |

### 出力先

- 画面表示（Ajaxダイアログ内）
- データベース（DELETE操作）
- 検索インデックス（削除）

## 処理フロー

### 処理シーケンス

```
1. 削除要求受付
   └─ ACL権限チェック（eevents, eeventdelete）

2. 確認フラグチェック
   ├─ confirm != '1' の場合
   │     └─ 確認ダイアログ表示
   └─ confirm == '1' かつ id設定ありの場合
         ├─ eventsテーブルからDELETE
         ├─ commentsテーブルから関連コメントDELETE
         ├─ 検索インデックスからDELETE
         └─ 成功メッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{権限チェック}
    B -->|権限なし| C[権限エラー]
    B -->|権限あり| D{confirm = '1' かつ id設定あり?}
    D -->|No| E[確認ダイアログ表示]
    E --> F{ユーザー操作}
    F -->|Delete| G[confirm=1で再リクエスト]
    F -->|Cancel| H[ダイアログ閉じる]
    G --> D
    D -->|Yes| I[eventsテーブルDELETE]
    I --> J[commentsテーブルDELETE]
    J --> K[検索インデックスDELETE]
    K --> L[成功メッセージ表示]
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-24-01 | 削除確認必須 | 削除実行前に必ず確認ダイアログを表示 | 常時 |
| BR-24-02 | 関連コメント削除 | イベント削除時に関連するコメントも削除 | 常時 |
| BR-24-03 | 検索インデックス削除 | イベント削除時に検索インデックスからも削除 | 常時 |
| BR-24-04 | 物理削除 | 論理削除ではなく物理削除を実行 | 常時 |

### 計算ロジック

- 検索インデックスキー: 'e' + event_id

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| イベント削除 | events | DELETE | イベントレコード削除 |
| コメント削除 | comments | DELETE | 関連コメント削除 |

### テーブル別操作詳細

#### events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE event_id = ? | 対象イベント削除 |

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE comment_type = 'E' AND comment_slave = ? | イベントに紐づくコメント削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | eevents/eeventdelete権限なし | 権限エラー画面へ転送 |

### リトライ仕様

特になし

## トランザクション仕様

events削除とcomments削除は連続して実行されるが、明示的なトランザクション制御は実装されていない。整合性を保証するためにはトランザクション制御の追加が推奨される。

## パフォーマンス要件

- Ajaxダイアログでの表示のため、レスポンスは軽量であること

## セキュリティ考慮事項

- 管理画面へのアクセスはACLによる権限チェック必須（eevents + eeventdelete）
- CSRF対策として確認フラグによる2段階処理
- 削除は物理削除のため、復旧不可であることをユーザーに明示

## 備考

- 論理削除ではなく物理削除のため、削除後のデータ復旧は不可
- 関連するタグや添付ファイルの削除は本機能では行われない（要確認）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

削除対象テーブルとその関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | eventsテーブル | データベース | 削除対象の主テーブル |
| 1-2 | commentsテーブル | データベース | comment_type='E', comment_slave=event_id で関連付け |

**読解のコツ**: commentsテーブルはcomment_typeで種別（E=Event, A=Article等）を区別し、comment_slaveで紐づく親レコードを特定する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_EventsController.php | `application/modules/admin/controllers/EventsController.php` | deleteAction |

**主要処理フロー（deleteAction）**:
1. **199-201行目**: 権限チェック（eevents, eeventdelete）
2. **203-204行目**: レイアウト・ビュー無効化（Ajax用）
3. **207-208行目**: パラメータ取得（confirm, id）
4. **211行目**: 確認フラグとイベントIDの存在チェック
5. **214行目**: レジストリ取得
6. **217行目**: eventsテーブルからDELETE実行
7. **220行目**: commentsテーブルからDELETE実行（type='E', slave=event_id）
8. **223行目**: 検索インデックスからDELETE（キー='e'+event_id）
9. **226-231行目**: 成功メッセージHTML出力
10. **235-242行目**: 確認ダイアログHTML出力（confirm != '1'の場合）

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | manage.phtml | `application/modules/admin/views/scripts/events/manage.phtml` | 削除リンクの実装 |

**呼び出し処理（manage.phtml 84行目）**:
```php
<a onClick="getDialog('/admin/events/delete/id/<?php echo $event['event_id']; ?>/','Delete Event')" style="cursor: pointer;">Delete</a>
```

### プログラム呼び出し階層図

```
manage.phtml
    │
    └─ getDialog() [JavaScript]
           │
           └─ Admin_EventsController::deleteAction()
                  │
                  ├─ [confirm != '1'] 確認ダイアログ表示
                  │
                  └─ [confirm == '1']
                         ├─ Zend_Db_Adapter::delete('events', ...)
                         ├─ Zend_Db_Adapter::delete('comments', ...)
                         └─ searchIndex->delete('e' + event_id)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

URLパラメータ               deleteAction()
  id              ───▶
  confirm                   [confirm != '1']
                            │
                            └───▶ 確認ダイアログHTML

URLパラメータ               deleteAction()
  id              ───▶      [confirm == '1']
  confirm='1'               │
                            ├─ DELETE events       ───▶   eventsテーブル
                            ├─ DELETE comments     ───▶   commentsテーブル
                            ├─ DELETE index        ───▶   Luceneインデックス
                            │
                            └───▶ 成功メッセージHTML
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | コントローラー | イベント削除処理 |
| Admin.php | `library/CMS/Controller/Action/Admin.php` | 親クラス | 認証・ACL基盤処理 |
| manage.phtml | `application/modules/admin/views/scripts/events/manage.phtml` | ビュー | 削除リンク（呼び出し元） |
| common.js | `public/_scripts/admin/common.js` | JavaScript | getDialog()関数 |
| SearchIndex.php | ライブラリ | ヘルパー | 検索インデックス操作 |
