# 機能設計書 26-イベントカテゴリ管理

## 概要

本ドキュメントは、LEGACY CMSにおけるイベントカテゴリ管理機能の設計仕様を定義する。

### 本機能の処理概要

イベントカテゴリ管理機能は、イベントを分類するためのカテゴリを管理（一覧表示、新規作成、編集、削除）するための機能である。カテゴリにはデフォルト会場とデフォルト説明文を設定でき、新規イベント作成時の入力効率化に活用される。

**業務上の目的・背景**：イベントを適切に分類・整理することで、ユーザーが目的のイベントを見つけやすくなる。また、カテゴリごとにデフォルト設定を持つことで、同種のイベントを効率的に登録できる。

**機能の利用シーン**：イベント管理画面のサイドパネルにカテゴリ一覧が表示され、新規カテゴリの作成、既存カテゴリの編集・削除が可能。各カテゴリをクリックすると、そのカテゴリに属するイベントのみがフィルタ表示される。

**主要な処理内容**：
1. カテゴリ一覧の表示（Ajaxパネル）
2. カテゴリ新規作成
3. カテゴリ編集
4. カテゴリ削除（イベントが紐づいていない場合のみ）

**関連システム・外部連携**：特になし

**権限による制御**：カテゴリ一覧表示は「eevents」権限、新規作成は「ecategorynew」権限、編集は「ecategoryedit」権限、削除は「ecategorydelete」権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | イベント管理画面 | 主画面 | カテゴリ一覧パネル表示 |

## 機能種別

CRUD操作（Create/Read/Update/Delete）/ マスタ管理

## 入力仕様

### 入力パラメータ

#### カテゴリ新規作成（categorynewAction）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| categorytitle | string | Yes | カテゴリ名 | NotEmpty |
| categoryvenue | int | No | デフォルト会場ID | 数値 |
| categorydefault | string | No | デフォルト説明文 | allowEmpty |

#### カテゴリ編集（categoryAction）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| category | int | Yes | カテゴリID | 数値 |
| categorytitle | string | Yes | カテゴリ名 | NotEmpty |
| categoryvenue | int | No | デフォルト会場ID | 数値 |
| categorydefault | string | No | デフォルト説明文 | allowEmpty |

#### カテゴリ削除（categorydeleteAction）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| category | int | Yes | カテゴリID | 数値 |
| confirm | string | No | 削除確認フラグ | '1'で確認済み |

### 入力データソース

- Ajaxダイアログ内のフォーム（POSTリクエスト）
- URLパラメータ（カテゴリID、確認フラグ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| categoriesArray | array | カテゴリ一覧 |
| categoryArray | array | カテゴリ詳細情報 |
| 成功メッセージ | string | 操作完了メッセージ |
| エラーメッセージ | array | バリデーションエラー/重複エラー |

### 出力先

- 画面表示（Ajaxパネル、ダイアログ）
- データベース（events_categoriesテーブル）

## 処理フロー

### 処理シーケンス

```
1. カテゴリ一覧表示（categoriesAction）
   └─ ACL権限チェック（eevents）
   └─ events_categoriesテーブルからSELECT（名前順）
   └─ ビューへデータ受け渡し

2. カテゴリ新規作成（categorynewAction）
   └─ ACL権限チェック（eevents, ecategorynew）
   └─ 入力バリデーション
   └─ 重複チェック（同名カテゴリ）
   └─ データベースINSERT
   └─ 成功メッセージ表示

3. カテゴリ編集（categoryAction）
   └─ ACL権限チェック（eevents, ecategoryedit）
   └─ 既存データ取得
   └─ 入力バリデーション
   └─ 重複チェック（同名カテゴリ、自身を除く）
   └─ データベースUPDATE
   └─ 成功メッセージ表示

4. カテゴリ削除（categorydeleteAction）
   └─ ACL権限チェック（eevents, ecategorydelete）
   └─ 確認ダイアログ表示
   └─ 関連イベント存在チェック
   └─ イベントなしの場合のみDELETE
   └─ 成功/エラーメッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    subgraph 削除処理
        D1{権限チェック} -->|権限なし| D2[権限エラー]
        D1 -->|権限あり| D3{confirm = '1'?}
        D3 -->|No| D4[確認ダイアログ表示]
        D3 -->|Yes| D5{関連イベントあり?}
        D5 -->|Yes| D6[削除不可エラー]
        D5 -->|No| D7[DB DELETE]
        D7 --> D8[成功メッセージ]
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-26-01 | カテゴリ名重複禁止 | 同名のカテゴリは登録不可 | 新規作成・編集時 |
| BR-26-02 | 関連イベント存在時削除禁止 | イベントが紐づいているカテゴリは削除不可 | 削除時 |
| BR-26-03 | デフォルト会場設定 | カテゴリにデフォルト会場を設定可能 | 新規作成・編集時 |
| BR-26-04 | デフォルト説明文設定 | カテゴリにデフォルト説明文を設定可能 | 新規作成・編集時 |
| BR-26-05 | 名前順ソート | カテゴリ一覧は名前昇順でソート | 一覧表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カテゴリ一覧取得 | events_categories | SELECT | 全カテゴリ取得 |
| カテゴリ新規作成 | events_categories | INSERT | カテゴリ登録 |
| カテゴリ編集 | events_categories | UPDATE | カテゴリ更新 |
| カテゴリ削除 | events_categories | DELETE | カテゴリ削除 |
| 関連イベント確認 | events | SELECT | 削除前確認 |

### テーブル別操作詳細

#### events_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_id, ecat_title, ecat_venue, ecat_default | ORDER BY ecat_title ASC | 一覧取得 |
| INSERT | ecat_title | 入力値 | カテゴリ名 |
| INSERT | ecat_venue | 入力値 | デフォルト会場ID |
| INSERT | ecat_default | 入力値 | デフォルト説明文 |
| UPDATE | ecat_title | 入力値 | カテゴリ名更新 |
| UPDATE | ecat_venue | 入力値 | デフォルト会場更新 |
| UPDATE | ecat_default | 入力値 | デフォルト説明文更新 |
| DELETE | - | WHERE ecat_id = ? | カテゴリ削除 |

#### events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | event_id | WHERE event_category = ? | 関連イベント存在確認 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 必要権限なし | 権限エラー画面へ転送 |
| - | 重複エラー | 同名カテゴリ存在 | エラーメッセージ表示 |
| - | 削除不可エラー | 関連イベントあり | 「Categories With Events Cannot Be Deleted」表示 |

### リトライ仕様

特になし

## トランザクション仕様

単一操作のため、明示的なトランザクション制御は不要

## パフォーマンス要件

- Ajaxパネルでの表示のため、レスポンスは軽量であること

## セキュリティ考慮事項

- 各操作に対して個別のACL権限チェック
- 入力値はZend_Filter_Inputによるバリデーション

## 備考

- カテゴリ一覧はイベント管理画面のサイドパネルにAjax読み込みで表示される
- カテゴリをクリックするとそのカテゴリでイベント一覧がフィルタされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events_categoriesテーブル | データベース | ecat_id, ecat_title, ecat_venue, ecat_default カラム |

**読解のコツ**: ecat_venueはデフォルト会場へのFK、ecat_defaultはHTML形式のデフォルト説明文を格納する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_EventsController.php | `application/modules/admin/controllers/EventsController.php` | categoriesAction, categorynewAction, categoryAction, categorydeleteAction |

**主要処理フロー（categoriesAction - 一覧表示）**:
1. **881-883行目**: 権限チェック（eevents）
2. **885行目**: レイアウト無効化
3. **888-889行目**: カテゴリ一覧SELECT（名前順）
4. **892行目**: ビューへデータ設定

**主要処理フロー（categorynewAction - 新規作成）**:
1. **899-901行目**: 権限チェック（eevents, ecategorynew）
2. **903行目**: レイアウト無効化
3. **905-922行目**: POST処理
4. **909-915行目**: バリデーション定義
5. **924行目**: バリデーション実行
6. **928-934行目**: 重複チェック
7. **938-946行目**: 重複なしの場合INSERT

**主要処理フロー（categoryAction - 編集）**:
1. **968-970行目**: 権限チェック（eevents, ecategoryedit）
2. **973行目**: カテゴリIDパラメータ取得
3. **976-979行目**: 既存データ取得
4. **983-1000行目**: POST処理
5. **1004-1010行目**: 重複チェック（自身除外）
6. **1014-1022行目**: 重複なしの場合UPDATE

**主要処理フロー（categorydeleteAction - 削除）**:
1. **1049-1051行目**: 権限チェック（eevents, ecategorydelete）
2. **1056行目**: 確認フラグとカテゴリIDチェック
3. **1059-1063行目**: 関連イベント存在確認SELECT
4. **1065行目**: イベントなしの場合DELETE
5. **1068-1073行目**: イベントありの場合エラー表示

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | categories.phtml | `application/modules/admin/views/scripts/events/categories.phtml` | カテゴリ一覧パネル |
| 3-2 | categorynew.phtml | `application/modules/admin/views/scripts/events/categorynew.phtml` | 新規作成フォーム |
| 3-3 | category.phtml | `application/modules/admin/views/scripts/events/category.phtml` | 編集フォーム |

### プログラム呼び出し階層図

```
Admin_EventsController
    │
    ├─ categoriesAction() [一覧表示]
    │      ├─ ACL権限チェック (eevents)
    │      └─ Zend_Db_Select - カテゴリ一覧取得
    │
    ├─ categorynewAction() [新規作成]
    │      ├─ ACL権限チェック (eevents, ecategorynew)
    │      ├─ Zend_Filter_Input - バリデーション
    │      ├─ Zend_Db_Select - 重複チェック
    │      └─ Zend_Db_Adapter::insert() - DB登録
    │
    ├─ categoryAction() [編集]
    │      ├─ ACL権限チェック (eevents, ecategoryedit)
    │      ├─ Zend_Db_Select - 既存データ取得
    │      ├─ Zend_Filter_Input - バリデーション
    │      ├─ Zend_Db_Select - 重複チェック
    │      └─ Zend_Db_Adapter::update() - DB更新
    │
    └─ categorydeleteAction() [削除]
           ├─ ACL権限チェック (eevents, ecategorydelete)
           ├─ Zend_Db_Select - 関連イベント確認
           └─ Zend_Db_Adapter::delete() - DB削除
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Ajaxリクエスト              categoriesAction()
                  ───▶      - カテゴリ一覧取得       ───▶   categories.phtml
                                                           (Ajaxパネル)

フォーム入力                categorynewAction()
  categorytitle   ───▶      - バリデーション
  categoryvenue             - 重複チェック           ───▶   events_categories
  categorydefault           - INSERT                       (INSERT)

フォーム入力                categoryAction()
  category        ───▶      - 既存データ取得
  categorytitle             - バリデーション
  categoryvenue             - 重複チェック           ───▶   events_categories
  categorydefault           - UPDATE                       (UPDATE)

URLパラメータ               categorydeleteAction()
  category        ───▶      - 関連イベント確認
  confirm                   - イベントなし→DELETE   ───▶   events_categories
                                                           (DELETE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | コントローラー | カテゴリ管理処理 |
| Admin.php | `library/CMS/Controller/Action/Admin.php` | 親クラス | 認証・ACL基盤処理 |
| categories.phtml | `application/modules/admin/views/scripts/events/categories.phtml` | ビュー | カテゴリ一覧 |
| categorynew.phtml | `application/modules/admin/views/scripts/events/categorynew.phtml` | ビュー | 新規作成フォーム |
| category.phtml | `application/modules/admin/views/scripts/events/category.phtml` | ビュー | 編集フォーム |
| manage.phtml | `application/modules/admin/views/scripts/events/manage.phtml` | ビュー | カテゴリパネル表示元 |
