# 機能設計書 27-アセット一覧表示

## 概要

本ドキュメントは、LEGACY CMSにおけるアセット一覧表示機能の設計仕様を定義する。

### 本機能の処理概要

アセット一覧表示機能は、システムにアップロードされたファイル（画像、動画、音声、その他）をフォルダ構造で管理・表示するための機能である。フォルダ階層をナビゲートしながら、アセットの閲覧・操作が可能。

**業務上の目的・背景**：CMSで使用する各種メディアファイル（画像、動画、ドキュメント等）を一元管理し、記事やイベントなどのコンテンツに簡単に添付・挿入できるようにする。フォルダによる整理機能により、大量のアセットを効率的に管理できる。

**機能の利用シーン**：管理画面のアセット管理セクションにアクセスすると、ルートフォルダまたは指定フォルダ内のサブフォルダとアセットが一覧表示される。フォルダをクリックして階層を移動し、アセットのアップロード、編集、削除などの操作を行う。また、エディタからアセットを挿入する際にも使用される。

**主要な処理内容**：
1. 指定フォルダ内のサブフォルダ一覧取得
2. 指定フォルダ内のアセット一覧取得
3. 親フォルダ情報の取得（パンくずリスト用）
4. アセットのサムネイル表示

**関連システム・外部連携**：特になし

**権限による制御**：「fassets」権限を持つロールのみがアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | アセット管理画面 | 主画面 | フォルダ・アセット一覧表示 |

## 機能種別

CRUD操作（Read）/ ファイル管理 / フォルダナビゲーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| folder | int | No | 表示するフォルダID | 数値、デフォルト0（ルート） |
| type | string | No | 絞り込みタイプ | image/video/audio等 |
| method | string | No | 呼び出し方法 | 使用コンテキスト識別用 |
| field | string | No | 対象フィールド | エディタ挿入時の対象識別用 |

### 入力データソース

- URLパラメータ（GETリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| folderArray | array | サブフォルダ一覧 |
| assetArray | array | アセット一覧 |
| parentArray | array | 親フォルダ情報 |
| folder | string | 現在のフォルダID |
| type | string | 絞り込みタイプ |

### 出力先

- 画面表示（ビューテンプレートへのデータ受け渡し）

## 処理フロー

### 処理シーケンス

```
1. アクセス権限チェック
   └─ ACLで「fassets」権限を確認
2. 入力パラメータ取得
   └─ folder, type, method, field を取得
3. 親フォルダ情報取得（ルート以外の場合）
   └─ assets_foldersテーブルから現在フォルダ情報取得
4. サブフォルダ一覧取得
   └─ folder_parentが現在フォルダのフォルダを検索
5. アセット一覧取得
   └─ asset_folderが現在フォルダのアセットを検索
6. ビューへデータ受け渡し
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{fassets権限チェック}
    B -->|権限なし| C[権限エラー]
    B -->|権限あり| D[パラメータ取得]
    D --> E{folder != 0?}
    E -->|Yes| F[親フォルダ情報取得]
    E -->|No| G[ルートフォルダとして処理]
    F --> H[サブフォルダ一覧取得]
    G --> H
    H --> I[アセット一覧取得]
    I --> J[ビューへ出力]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-27-01 | ルートフォルダ | folder_id = 0 をルートフォルダとして扱う | 常時 |
| BR-27-02 | フォルダソート | フォルダは名前昇順でソート | 常時 |
| BR-27-03 | アセットソート | アセットは名前昇順でソート | 常時 |
| BR-27-04 | アセットタイプ判定 | MIMEタイプに基づきimage/video/audio/flash/otherに分類 | サムネイル表示時 |

### 計算ロジック

- アセットタイプ判定（assetType関数）:
  - image: image/jpeg, image/gif, image/png, image/bmp
  - video: video/x-flv
  - audio: audio/mpeg
  - flash: application/x-shockwave-flash
  - other: 上記以外

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 親フォルダ取得 | assets_folders | SELECT | 現在フォルダ情報取得 |
| サブフォルダ取得 | assets_folders | SELECT | サブフォルダ一覧取得 |
| アセット取得 | assets | SELECT | アセット一覧取得 |

### テーブル別操作詳細

#### assets_folders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | folder_id, folder_name, folder_parent | WHERE folder_id = ? | 親フォルダ情報 |
| SELECT | folder_id, folder_name | WHERE folder_parent = ? ORDER BY folder_name ASC | サブフォルダ一覧 |

#### assets

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | asset_id, asset_key, asset_name, asset_extension, asset_mime, asset_size | WHERE asset_folder = ? ORDER BY asset_name ASC | アセット一覧 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | fassets権限なし | 権限エラー画面へ転送 |

### リトライ仕様

特になし

## トランザクション仕様

読み取り専用のため、トランザクション制御は不要

## パフォーマンス要件

- フォルダ・アセット数が多い場合でも高速に表示
- サムネイル画像のキャッシュ活用

## セキュリティ考慮事項

- 管理画面へのアクセスはACLによる権限チェック必須
- アセットファイルへの直接アクセスは別途制御

## 備考

- サムネイル表示はthumbActionで別途処理
- エディタからの挿入時はtypeパラメータでファイル種類を絞り込み可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アセットとフォルダのテーブル構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | assetsテーブル | データベース | asset_id, asset_folder, asset_key, asset_name, asset_extension, asset_mime, asset_size |
| 1-2 | assets_foldersテーブル | データベース | folder_id, folder_name, folder_parent |

**読解のコツ**: folder_id = 0 がルートフォルダ。folder_parentで親子関係を表現する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | indexAction |

**主要処理フロー（indexAction）**:
1. **61行目**: 権限チェック（fassets）
2. **63行目**: レイアウト設定（assetsレイアウト）
3. **65-68行目**: パラメータ取得（type, folder, method, field）
4. **70-72行目**: フォルダ未指定時はルート（'0'）を設定
5. **77-88行目**: 親フォルダ情報取得（folder != '0'の場合）
6. **93-96行目**: サブフォルダ一覧SELECT（名前順）
7. **99行目**: ビューへサブフォルダ設定
8. **102-105行目**: アセット一覧SELECT（名前順）
9. **108行目**: ビューへアセット設定

#### Step 3: 補助処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Admin_AssetsController.php | 同上 | assetType()メソッド（31-54行目） |
| 3-2 | Admin_AssetsController.php | 同上 | thumbAction()（260-424行目） |

**assetType()の処理**:
- MIMEタイプに基づきファイル種別を判定
- 画像: jpeg, gif, png, bmp
- 動画: x-flv
- 音声: mpeg
- Flash: x-shockwave-flash
- その他: 上記以外

**thumbAction()の処理**:
- アセットキーからサムネイル画像を生成
- PhpThumbFactoryでリサイズ処理
- キャッシュ済みサムネイルがあれば再利用

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | index.phtml | `application/modules/admin/views/scripts/assets/index.phtml` | アセット一覧表示 |

### プログラム呼び出し階層図

```
Admin_AssetsController
    │
    ├─ indexAction() [一覧表示]
    │      ├─ ACL権限チェック (fassets)
    │      ├─ Zend_Db_Select - 親フォルダ情報取得
    │      ├─ Zend_Db_Select - サブフォルダ一覧取得
    │      └─ Zend_Db_Select - アセット一覧取得
    │
    ├─ thumbAction() [サムネイル生成]
    │      ├─ Zend_Db_Select - アセット情報取得
    │      ├─ assetType() - ファイル種別判定
    │      ├─ PhpThumbFactory - サムネイル生成
    │      └─ Response - 画像出力
    │
    └─ assetType() [ファイル種別判定]
           └─ MIMEタイプからimage/video/audio/flash/otherを返却
```

### データフロー図

```
[入力]                    [処理]                          [出力]

URLパラメータ           indexAction()
  folder        ───▶      - 親フォルダ取得        ───▶   ビュー(index.phtml)
  type                    - サブフォルダ取得              folderArray
  method                  - アセット取得                  assetArray
  field                                                   parentArray

URLパラメータ           thumbAction()
  key           ───▶      - アセット情報取得      ───▶   サムネイル画像
  width                   - 種別判定                      (バイナリレスポンス)
  height                  - サムネイル生成/キャッシュ
  type
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | アセット管理処理 |
| Admin.php | `library/CMS/Controller/Action/Admin.php` | 親クラス | 認証・ACL基盤処理 |
| index.phtml | `application/modules/admin/views/scripts/assets/index.phtml` | ビュー | アセット一覧表示 |
| PhpThumb | ライブラリ | 外部ライブラリ | サムネイル生成 |
