# 機能設計書 29-アセット編集

## 概要

本ドキュメントは、LEGACY CMSにおけるアセット編集機能の設計仕様を定義する。

### 本機能の処理概要

アセット編集機能は、アップロード済みのアセット（ファイル）の情報を編集するための機能である。主にファイル名の変更が可能で、拡張子は変更されない。

**業務上の目的・背景**：アップロード後にファイル名を変更したい場合に対応するための機能。誤字修正や命名規則への統一など、ファイル名の管理を可能にする。

**機能の利用シーン**：アセット管理画面でアセットを選択し、「Edit」操作を実行すると編集ダイアログが表示される。新しいファイル名を入力して保存ボタンをクリックすると、ファイル名が更新される。

**主要な処理内容**：
1. 既存アセット情報の取得
2. 編集フォームの表示
3. ファイル名のバリデーション
4. 同名ファイルの重複チェック
5. データベースの更新（UPDATE）

**関連システム・外部連携**：特になし

**権限による制御**：「fassets」権限と「fassetedit」権限の両方を持つロールのみがアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 57 | アセット編集画面 | 主画面 | アセット情報の編集処理 |

## 機能種別

CRUD操作（Read/Update）/ フォーム入力 / バリデーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| asset | int | Yes | アセットID | 数値 |
| filename | string | Yes | 新しいファイル名（拡張子なし） | NotEmpty |

### 入力データソース

- URLパラメータ（アセットID）
- Ajaxダイアログ内のフォーム（POSTリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| asset | string | アセットID |
| filename | string | 現在のファイル名 |
| extension | string | 拡張子 |
| 成功メッセージ | string | 「Asset Edited」 |
| エラーメッセージ | array | バリデーションエラー/重複エラー |

### 出力先

- 画面表示（Ajaxダイアログ内）
- データベース（assetsテーブル UPDATE）

## 処理フロー

### 処理シーケンス

```
1. アセット情報取得
   └─ ACL権限チェック（fassets, fassetedit）
   └─ アセットIDからアセット情報取得
   └─ 編集フォーム表示

2. 保存処理（POST時）
   └─ 入力バリデーション（ファイル名必須）
   └─ 同名ファイル重複チェック（自身を除く）
   └─ 重複なしの場合、データベースUPDATE
   └─ 成功メッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{権限チェック}
    B -->|権限なし| C[権限エラー]
    B -->|権限あり| D[アセット情報取得]
    D --> E{POST?}
    E -->|No| F[編集フォーム表示]
    E -->|Yes| G[入力バリデーション]
    G --> H{バリデーション成功?}
    H -->|No| I[エラー表示]
    I --> F
    H -->|Yes| J[同名ファイル重複チェック]
    J --> K{重複あり?}
    K -->|Yes| L[重複エラー表示]
    L --> F
    K -->|No| M[DB UPDATE]
    M --> N[成功メッセージ表示]
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-29-01 | ファイル名必須 | ファイル名は空にできない | 常時 |
| BR-29-02 | 同名ファイル重複禁止 | 同一フォルダ内に同名ファイルは不可 | 常時 |
| BR-29-03 | 拡張子変更不可 | 拡張子はシステムが保持し変更できない | 常時 |
| BR-29-04 | 更新日時設定 | 編集時にasset_modifiedを現在日時で更新 | 常時 |

### 計算ロジック

- 重複チェック: 同一フォルダ内で、自身以外に同じファイル名が存在するか確認

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| アセット情報取得 | assets | SELECT | 編集対象アセット取得 |
| 重複チェック | assets | SELECT | 同名ファイル存在確認 |
| アセット更新 | assets | UPDATE | ファイル名更新 |

### テーブル別操作詳細

#### assets

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | asset_id, asset_name, asset_extension, asset_folder | WHERE asset_id = ? | 編集対象取得 |
| SELECT | asset_id | WHERE asset_folder = ? AND asset_id != ? AND asset_name = ? | 重複チェック |
| UPDATE | asset_name | 入力値 | ファイル名更新 |
| UPDATE | asset_modified | NOW() | 更新日時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | fassets/fassetedit権限なし | 権限エラー画面へ転送 |
| - | バリデーションエラー | ファイル名未入力 | エラーメッセージ表示 |
| - | 重複エラー | 同名ファイルが既に存在 | 「An asset with this filename already exists in this folder」表示 |

### リトライ仕様

特になし（フォーム再入力による対応）

## トランザクション仕様

単一UPDATE操作のため、明示的なトランザクション制御は不要

## パフォーマンス要件

- Ajaxダイアログでの表示のため、レスポンスは軽量であること

## セキュリティ考慮事項

- 管理画面へのアクセスはACLによる権限チェック必須
- 入力値はZend_Filter_Inputによるバリデーション
- 拡張子の変更は不可（実ファイルとの整合性保持）

## 備考

- 実ファイルのリネームは行わず、データベースのasset_nameのみ更新
- 拡張子は表示のみで編集不可

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | assetsテーブル | データベース | asset_name, asset_extension, asset_folder, asset_modified カラム |

**読解のコツ**: asset_nameはファイル名（拡張子なし）、asset_extensionは拡張子を別カラムで管理している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | assetAction |

**主要処理フロー（assetAction）**:
1. **520行目**: 権限チェック（fassets, fassetedit）
2. **522行目**: レイアウト無効化
3. **524行目**: アセットIDパラメータ取得
4. **526行目**: レジストリ取得
5. **529-531行目**: アセット情報取得SELECT
6. **534行目**: クエリ実行
7. **536行目**: インスタンス変数に設定
8. **538-539行目**: ビューにファイル名・拡張子設定
9. **541行目**: POST判定
10. **545-552行目**: バリデーション定義（filename必須）
11. **555行目**: Zend_Filter_Inputでバリデーション実行
12. **557行目**: バリデーション成功判定
13. **560-564行目**: 重複チェックSELECT（自身を除く）
14. **567行目**: 重複チェック結果
15. **569-574行目**: 重複判定
16. **576行目**: 重複なしの場合UPDATE処理
17. **578-581行目**: UPDATEデータ配列作成
18. **584行目**: データベースUPDATE実行
19. **586-591行目**: 成功メッセージ表示
20. **593-600行目**: 重複エラー表示

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | asset.phtml | `application/modules/admin/views/scripts/assets/asset.phtml` | 編集フォーム |

### プログラム呼び出し階層図

```
Admin_AssetsController
    │
    └─ assetAction() [アセット編集]
           ├─ ACL権限チェック (fassets, fassetedit)
           ├─ Zend_Db_Select - アセット情報取得
           ├─ Zend_Filter_Input - バリデーション
           ├─ Zend_Db_Select - 重複チェック
           └─ Zend_Db_Adapter::update() - DB更新
```

### データフロー図

```
[入力]                      [処理]                           [出力]

URLパラメータ               assetAction()
  asset           ───▶      - アセット情報取得       ───▶   ビュー(asset.phtml)
                            - フォーム表示                  filename, extension

フォーム入力                assetAction()
  filename        ───▶      - バリデーション
                            - 重複チェック
                            - [重複なし] UPDATE      ───▶   assetsテーブル
                                                           (UPDATE)

                                                           成功メッセージ
                                                     ───▶  「Asset Edited」
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | アセット編集処理 |
| Admin.php | `library/CMS/Controller/Action/Admin.php` | 親クラス | 認証・ACL基盤処理 |
| asset.phtml | `application/modules/admin/views/scripts/assets/asset.phtml` | ビュー | 編集フォーム |
| index.phtml | `application/modules/admin/views/scripts/assets/index.phtml` | ビュー | 編集ダイアログ呼び出し元 |
