# 機能設計書 3-パスワードリセット

## 概要

本ドキュメントは、LEGACY CMSにおけるパスワードリセット機能の設計を記述したものである。ユーザーがパスワードを忘れた場合に、新しいパスワードを生成してメールで送信する仕様を定義する。

### 本機能の処理概要

**業務上の目的・背景**：ユーザーがパスワードを忘れた場合でも、登録済みメールアドレスを通じて新しいパスワードを取得できるようにする。これにより、管理者への問い合わせを削減し、ユーザーの自己解決を可能にする。セキュリティを確保しつつ、ユーザビリティを向上させるための機能である。

**機能の利用シーン**：ユーザーがログイン画面でパスワードを思い出せない場合、「パスワードを忘れた方」リンクをクリックしてパスワードリセット画面にアクセスする。登録済みのメールアドレスを入力すると、システムが新しいパスワードを生成してメールで送信する。

**主要な処理内容**：
1. パスワードリセットフォームの表示
2. メールアドレスの入力とバリデーション
3. メールアドレスがデータベースに存在するか確認
4. 新しいパスワードとソルトの自動生成（8文字のランダム文字列）
5. データベースのパスワード情報を更新
6. 新しいパスワードをメールで送信

**関連システム・外部連携**：Zend_Mailを使用してSMTP経由でパスワードリセットメールを送信する。

**権限による制御**：パスワードリセット機能はすべてのユーザー（未認証状態）がアクセス可能である。ただし、登録済みメールアドレスの所有者のみが新しいパスワードを受け取れる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | パスワードリセット画面 | 主画面 | パスワードリセットメールを送信 |

## 機能種別

パスワード管理 / メール送信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| email | string | Yes | ユーザーの登録メールアドレス | NotEmpty, EmailAddress, Db_RecordExists, StringTrim, StringToLower |

### 入力データソース

画面入力（パスワードリセットフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| posted | string | 処理状態（'Y': 成功, 'N': 未処理/失敗） |
| messages | array | バリデーションエラーメッセージ |
| userArray | array | ユーザー情報（メール送信用） |

### 出力先

- メール送信（新しいパスワードを含むテキストメール）
- データベース更新（users.user_password, users.user_salt）
- 画面表示（処理結果メッセージ）

## 処理フロー

### 処理シーケンス

```
1. passwordAction実行
   └─ レイアウトをadmin-authに設定
2. POSTリクエストの判定
   └─ GETの場合はフォーム表示のみ
3. 入力値のフィルタリング・バリデーション
   └─ メールアドレスの形式チェックとDB存在確認
4. ユーザー情報の取得
   └─ users + users_profilesテーブルをJOIN
5. 新しいパスワードとソルトの生成
   └─ generatePassword()で8文字のランダム文字列
6. データベースの更新
   └─ MD5ハッシュ化したパスワードとソルトを保存
7. メール送信
   └─ Zend_Mailで新しいパスワードを送信
8. 処理結果の表示
   └─ posted = 'Y'を設定
```

### フローチャート

```mermaid
flowchart TD
    A[パスワードリセット画面アクセス] --> B{POSTリクエスト?}
    B -->|No| C[フォーム表示]
    B -->|Yes| D[入力値バリデーション]
    D --> E{バリデーション成功?}
    E -->|No| F[エラーメッセージ表示]
    F --> C
    E -->|Yes| G[ユーザー情報取得]
    G --> H[新しいパスワード生成]
    H --> I[新しいソルト生成]
    I --> J[パスワードをMD5ハッシュ化]
    J --> K[データベース更新]
    K --> L[メール送信]
    L --> M[成功メッセージ表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 登録メールアドレス検証 | 入力されたメールアドレスがDBに存在する必要がある | 常時 |
| BR-002 | パスワード自動生成 | 8文字のランダム文字列を新しいパスワードとして生成 | 常時 |
| BR-003 | ソルト再生成 | パスワードリセット時にソルトも新しく生成 | 常時 |

### 計算ロジック

パスワード生成アルゴリズム:
- 使用文字: `abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ023456789`（紛らわしい文字l, I, O, 1を除外）
- 長さ: 8文字
- 乱数: `srand((double)microtime()*1000000)` + `rand() % 57`

パスワードハッシュ: `MD5(site_key + password + salt)`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー情報取得 | users, users_profiles | SELECT | メールアドレスでユーザーを検索 |
| パスワード更新 | users | UPDATE | 新しいパスワードとソルトを保存 |

### テーブル別操作詳細

#### users（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_email | 入力されたメールアドレスと一致 | 検索条件 |
| SELECT | user_id | - | プロフィールとのJOIN用 |
| SELECT | 全カラム | - | ユーザー情報取得 |

#### users_profiles（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | upro_userid | users.user_idと一致 | JOIN条件 |
| SELECT | upro_first, upro_last | - | メール宛名用 |

#### users（UPDATE）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | user_password | MD5(site_key + 新パスワード + 新ソルト) | ハッシュ化して保存 |
| UPDATE | user_salt | generatePassword()で生成した8文字 | ランダム値 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IS_EMPTY | バリデーションエラー | メールアドレス未入力 | 'Missing E-mail Address'を表示 |
| INVALID | バリデーションエラー | メールアドレス形式不正 | 'Invalid E-mail Address'を表示 |
| ERROR_NO_RECORD_FOUND | バリデーションエラー | メールアドレスが未登録 | 'Invalid E-mail Address - entered e-mail address is not associated with an existing account'を表示 |

### リトライ仕様

メール送信失敗時のリトライ処理は実装されていない

## トランザクション仕様

明示的なトランザクション制御は実装されていない。UPDATE文の実行後にメール送信が失敗した場合、パスワードは更新されているがユーザーに通知されない状態となる可能性がある。

## パフォーマンス要件

- レスポンス時間: メール送信を含むため2-3秒程度
- user_emailカラムにインデックスがあることが望ましい

## セキュリティ考慮事項

- メールアドレスの存在確認により、登録済みメールアドレスの列挙攻撃が可能（エラーメッセージで判別可能）
- パスワードはMD5ハッシュ化（現代のセキュリティ基準では脆弱）
- 新しいパスワードはメール本文に平文で記載
- パスワードリセットのレート制限なし（ブルートフォース攻撃のリスク）
- 古いパスワードは即座に無効化される

## 備考

- 現代的なパスワードリセットでは、一時トークンを含むリセットリンクをメールで送信し、ユーザー自身が新しいパスワードを設定する方式が推奨される
- 乱数生成に`srand()`と`rand()`を使用しており、暗号学的に安全ではない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パスワードリセットに関連するテーブル構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブル（347-361行目）とusers_profilesテーブル（456-477行目）の構造 |

**読解のコツ**: user_password（ハッシュ化済みパスワード）とuser_salt（ソルト値）がパスワードリセット時に更新される。users_profilesはメール宛名取得用。

#### Step 2: エントリーポイントを理解する

パスワードリセット処理の中心となるコントローラーを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AuthController.php | `application/modules/admin/controllers/AuthController.php` | passwordAction()メソッド（171-256行目） |

**主要処理フロー**:
1. **173行目**: `$this->setLayout()` - レイアウト設定
2. **179-192行目**: バリデータの設定（EmailAddress, Db_RecordExists）
3. **194行目**: `Zend_Filter_Input`でバリデーション実行
4. **200-208行目**: ユーザー情報の取得（SELECTクエリ）
5. **212-213行目**: `generatePassword()`で新しいパスワードとソルトを生成
6. **216-219行目**: パスワードデータの準備
7. **222行目**: データベース更新
8. **224-235行目**: メール送信

#### Step 3: パスワード生成ロジックを理解する

ランダムパスワード生成のアルゴリズムを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AuthController.php | `application/modules/admin/controllers/AuthController.php` | generatePassword()メソッド（25-40行目） |

**主要処理フロー**:
- **27行目**: 使用文字の定義（紛らわしい文字を除外）
- **28行目**: `srand((double)microtime()*1000000)` - 乱数シードの初期化
- **32-36行目**: 8文字のランダム文字列を生成

### プログラム呼び出し階層図

```
Admin_AuthController::passwordAction()
    │
    ├─ Admin_AuthController::setLayout()
    │      └─ Zend_Layout::setLayout('admin-auth')
    │
    ├─ Zend_Filter_Input (バリデーション)
    │      ├─ StringTrim
    │      ├─ StringToLower
    │      ├─ NotEmpty
    │      ├─ EmailAddress
    │      └─ Zend_Validate_Db_RecordExists
    │
    ├─ Zend_Db::select() (ユーザー情報取得)
    │      └─ users JOIN users_profiles
    │
    ├─ Admin_AuthController::generatePassword() x 2
    │      └─ ランダム文字列生成（パスワード用、ソルト用）
    │
    ├─ Zend_Db::update() (パスワード更新)
    │      └─ users テーブル
    │
    └─ Zend_Mail::send()
           └─ SMTP経由でメール送信
```

### データフロー図

```
[入力]               [処理]                    [出力]

email          ───▶ Zend_Filter_Input    ───▶ 検証済みemail
                           │
                           ▼
                    Zend_Validate_Db_RecordExists
                    (users テーブル確認)
                           │
                           ▼
                    SELECT users + users_profiles
                    (ユーザー情報取得)
                           │
                           ▼
                    generatePassword() x 2
                    (パスワード + ソルト生成)
                           │
                           ▼
                    MD5(site_key + password + salt)
                    (ハッシュ化)
                           │
                    ┌──────┴──────┐
                    ▼             ▼
              UPDATE users   Zend_Mail::send()
              (DB更新)       (メール送信)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AuthController.php | `application/modules/admin/controllers/AuthController.php` | コントローラー | パスワードリセット処理の実装（25-40行目: generatePassword, 171-256行目: passwordAction） |
| database.sql | `database.sql` | DDL | usersテーブル定義（347-361行目）、users_profilesテーブル定義（456-477行目） |
