# 機能設計書 32-リソース一覧表示

## 概要

本ドキュメントは、LEGACY CMSにおけるリソース一覧表示機能の設計を記載したものである。リソース（書籍等）の一覧をページネーション付きで表示し、カテゴリやタイプでフィルタリングする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：CMSで管理するリソース（書籍、商品等）を効率的に一覧表示し、管理者が目的のリソースを素早く見つけられるようにする。書籍管理向けの機能として、ISBN・著者・イラストレーター等の情報を持つリソースを管理できる。

**機能の利用シーン**：管理者が管理画面にログインし、リソース管理メニューからリソース一覧画面を開く。大量のリソースがある場合でもページネーションにより15件ずつ表示され、カテゴリやタイプでフィルタリングして目的のリソースを探すことができる。

**主要な処理内容**：
1. リソース一覧のデータベースからの取得
2. カテゴリによるフィルタリング
3. タイプによるフィルタリング
4. ページネーションによる分割表示（15件/ページ）
5. カテゴリ名の結合表示

**関連システム・外部連携**：Zend_Paginatorを使用したページネーション処理。

**権限による制御**：`rresources`権限を持つユーザーのみリソース一覧表示機能を利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | リソース管理画面 | 主画面 | リソース一覧をページネーション付きで表示 |

## 機能種別

データ参照 / 一覧表示 / フィルタリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| page | integer | No | 現在のページ番号（デフォルト: 1） | 正の整数 |
| category | integer | No | フィルタするカテゴリID | 数値 |
| type | integer | No | フィルタするリソースタイプID | 数値 |

### 入力データソース

- URLパラメータ（page, category, type）
- データベース（resources, resources_categories, resources_types）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| resourcesArray | Zend_Paginator | ページネーション付きリソース一覧 |
| page | integer | 現在のページ番号 |
| type | string | フィルタ中のタイプ名（複数形） |
| category | string | フィルタ中のカテゴリ名 |

### 出力先

- HTMLビュー（リソース一覧テーブル、ページネーション）

## 処理フロー

### 処理シーケンス

```
1. リソース管理画面へのアクセス
   └─ /admin/resources/manage/ へリクエスト
2. 権限チェック
   └─ rresources権限の確認
3. パラメータ取得
   └─ page, category, type パラメータの取得
4. フィルタ条件に応じたクエリ構築
   └─ category + type: 両方でフィルタ
   └─ category のみ: カテゴリでフィルタ
   └─ type のみ: タイプでフィルタ
   └─ なし: 全件取得
5. カテゴリ情報の結合
   └─ resources_categoriesテーブルとJOIN
6. ページネーション処理
   └─ Zend_Paginator で15件/ページ、5ページ範囲
7. ビューへのデータ渡し
   └─ resourcesArray をビューに設定
```

### フローチャート

```mermaid
flowchart TD
    A[リソース管理画面アクセス] --> B{権限チェック}
    B -->|権限なし| C[エラー画面へ転送]
    B -->|権限あり| D[パラメータ取得]
    D --> E{フィルタ条件判定}
    E -->|category + type| F[両方でフィルタ]
    E -->|categoryのみ| G[カテゴリでフィルタ]
    E -->|typeのみ| H[タイプでフィルタ]
    E -->|なし| I[全件取得]
    F --> J[クエリ実行・JOIN]
    G --> J
    H --> J
    I --> J
    J --> K[Zend_Paginator作成]
    K --> L[15件/ページ設定]
    L --> M[ビュー表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-32-01 | ページネーション設定 | 1ページあたり15件、ページ範囲5 | 常時 |
| BR-32-02 | デフォルトページ | pageパラメータがない場合は1ページ目 | page未指定時 |
| BR-32-03 | ソート順 | 作成日降順（resource_date DESC） | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース一覧取得 | resources | SELECT | フィルタ条件に応じた一覧取得 |
| カテゴリ情報結合 | resources_categories | JOIN | カテゴリタイトル取得 |
| タイプ情報取得 | resources_types | SELECT | タイプ名（複数形）取得 |
| カテゴリ名取得 | resources_categories | SELECT | フィルタ表示用カテゴリ名 |

### テーブル別操作詳細

#### resources

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | resource_category = :category（オプション）, resource_type = :type（オプション） | resource_date DESC |

#### resources_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| JOIN | rcat_title | r.resource_category = c.rcat_id | - |
| SELECT | rcat_title | rcat_id = :categoryid | フィルタ表示用 |

#### resources_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | rtype_plural | rtype_id = :type | タイプ名（複数形） |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | rresources権限なし | privileges画面へ転送 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

読み取り専用のため、トランザクション管理は不要。

## パフォーマンス要件

- リソース一覧の表示は2秒以内
- ページネーションによりデータ量を制限

## セキュリティ考慮事項

- 権限チェック（rresources）によるアクセス制御

## 備考

- 書籍管理向けの機能として設計されている
- リソースタイプによってISBN・著者等のフィールドの使用有無が変わる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リソース関連のテーブル構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | manageAction()の69-135行目でテーブル構造を把握 |

**読解のコツ**: resources, resources_categories, resources_typesの3テーブルの関連を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | indexAction()はmanageへリダイレクト |
| 2-2 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | manageAction()がリソース一覧の起点 |

**主要処理フロー**:
1. **71行目**: 権限チェック（rresources）
2. **78-80行目**: パラメータ取得（category, type, page）
3. **84-88行目**: ページ番号のデフォルト値設定
4. **90-118行目**: フィルタ条件に応じたクエリ構築
5. **120-127行目**: Zend_Paginator設定と出力

#### Step 3: ヘルパーメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | getType()メソッド（17-30行目） |
| 3-2 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | getCategory()メソッド（32-56行目） |

**主要処理フロー**:
- **getType()**: resources_typesテーブルからrtype_plural（複数形名）を取得
- **getCategory()**: resources_categoriesテーブルからrcat_titleを取得

### プログラム呼び出し階層図

```
Admin_ResourcesController
    │
    ├─ indexAction() [リダイレクト]
    │      └─ _helper->redirector('manage')
    │
    └─ manageAction() [リソース一覧表示]
           ├─ setLayout()
           ├─ getType() [タイプ名取得]
           ├─ getCategory() [カテゴリ名取得]
           ├─ DBクエリ（resources + resources_categories JOIN）
           └─ Zend_Paginator::factory()
```

### データフロー図

```
[入力]                     [処理]                           [出力]

URLパラメータ         ┌─────────────────────┐
(page,category,     │ ResourcesController │
type)          ────▶│                     │
                    │  manageAction()     │────▶  ビュー(manage.phtml)
                    │  - 権限チェック      │       - リソース一覧
                    │  - フィルタ処理      │       - ページネーション
DBテーブル          │  - Paginator生成    │       - カテゴリ/タイプ名
(resources,    ────▶│                     │
resources_categories,└─────────────────────┘
resources_types)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | コントローラー | リソース管理の全アクション |
| setLayout() | 同上 | メソッド | レイアウト設定 |
| getType() | 同上 | メソッド | タイプ名取得 |
| getCategory() | 同上 | メソッド | カテゴリ名取得 |
