# 機能設計書 33-リソース新規作成

## 概要

本ドキュメントは、LEGACY CMSにおけるリソース新規作成機能の設計を記載したものである。新規リソースを作成し、ISBN・著者・イラストレーター等の書籍管理向け情報を設定する機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：書籍やその他のリソースを新規に登録する必要がある。新規作成時点ではタイトル・カテゴリ・タイプの最小限の情報のみを設定し、詳細情報は作成後の編集画面で入力する2段階方式を採用することで、スムーズな登録フローを実現する。

**機能の利用シーン**：管理者がリソース管理画面から「新規作成」ボタンをクリックし、Ajaxダイアログでタイトル・カテゴリ・タイプを入力して新規リソースを作成する。作成完了後、自動的に編集画面へ遷移して詳細情報を入力する。

**主要な処理内容**：
1. 新規作成ダイアログの表示
2. タイトル・カテゴリ・タイプの入力バリデーション
3. リソースレコードのデータベース挿入
4. 作成したリソースの編集画面への遷移

**関連システム・外部連携**：Dojo ToolkitのAjaxダイアログによるフォーム表示。Zend_Filter_Inputによる入力検証。

**権限による制御**：`rresources`および`rresourcenew`権限を持つユーザーのみリソース新規作成機能を利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | リソース新規作成ダイアログ | 主画面 | 新規リソースの基本情報入力 |
| - | リソース編集画面 | 遷移先画面 | 作成後の詳細情報入力 |

## 機能種別

CRUD操作（Create） / データ登録

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| resourcetitle | string | Yes | リソースタイトル | NotEmpty |
| resourcecategory | integer | Yes | カテゴリID | NotEmpty |
| resourcetype | integer | Yes | リソースタイプID | NotEmpty |

### 入力データソース

- フォーム入力（POST）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 作成完了メッセージ | HTML | 成功時のメッセージとボタン |
| エラーメッセージ | array | バリデーションエラー時 |
| lastInsertId | integer | 作成されたリソースのID |

### 出力先

- HTMLダイアログ（作成結果表示）
- リダイレクト（編集画面への遷移）

## 処理フロー

### 処理シーケンス

```
1. 新規作成ダイアログの表示
   └─ getDialog()で/admin/resources/new/を呼び出し
2. 権限チェック
   └─ rresources + rresourcenew権限の確認
3. フォーム表示（GET）または処理実行（POST）
   └─ POSTでない場合はフォーム表示のみ
4. 入力バリデーション
   └─ resourcetitle: NotEmpty
   └─ resourcecategory: NotEmpty
   └─ resourcetype: NotEmpty
5. データベース挿入
   └─ resourcesテーブルにINSERT
6. 成功メッセージ表示
   └─ 「Continue」ボタンで編集画面へ遷移
```

### フローチャート

```mermaid
flowchart TD
    A[新規作成ダイアログ表示] --> B{権限チェック}
    B -->|権限なし| C[エラー画面へ転送]
    B -->|権限あり| D{リクエスト種別}
    D -->|GET| E[空フォーム表示]
    D -->|POST| F[入力バリデーション]
    F --> G{バリデーション結果}
    G -->|失敗| H[エラーメッセージ表示]
    H --> E
    G -->|成功| I[DBインサート]
    I --> J[成功メッセージ表示]
    J --> K[Continueボタンクリック]
    K --> L[編集画面へ遷移]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-33-01 | 必須フィールド | タイトル、カテゴリ、タイプは必須 | 新規作成時 |
| BR-33-02 | デフォルトブランド | ブランドは'1'（デフォルト）で作成 | 新規作成時 |
| BR-33-03 | 作成者記録 | 作成したユーザーIDを記録 | 新規作成時 |
| BR-33-04 | 編集日時記録 | resource_editに現在日時を設定 | 新規作成時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース作成 | resources | INSERT | 新規リソースレコード挿入 |

### テーブル別操作詳細

#### resources

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | resource_title | $input->resourcetitle | フォーム入力値 |
| INSERT | resource_type | $input->resourcetype | フォーム入力値 |
| INSERT | resource_brand | '1' | デフォルト値 |
| INSERT | resource_category | $input->resourcecategory | フォーム入力値 |
| INSERT | resource_user | $this->view->user->user_id | ログインユーザーID |
| INSERT | resource_edit | NOW() | 現在日時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | rresources or rresourcenew権限なし | privileges画面へ転送 |
| - | バリデーションエラー | 必須フィールド未入力 | エラーメッセージ表示、フォーム再表示 |

### リトライ仕様

リトライ処理は実装されていない。フォームの再入力により対応。

## トランザクション仕様

単一INSERTのため、明示的なトランザクション管理は不要。

## パフォーマンス要件

- リソース作成処理は1秒以内

## セキュリティ考慮事項

- 権限チェック（rresources + rresourcenew）によるアクセス制御
- Zend_Filter_Inputによる入力サニタイズ

## 備考

- 作成直後はドラフト状態（未公開）
- 詳細情報（説明、コンテンツ、ISBN等）は編集画面で入力

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

新規作成時に設定されるフィールドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | newAction()の676-683行目でINSERTデータを確認 |

**読解のコツ**: 新規作成時は最小限のフィールドのみ設定。詳細フィールドは編集時に設定される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | newAction() 639-718行目 |

**主要処理フロー**:
1. **641行目**: 権限チェック（rresources + rresourcenew）
2. **643行目**: レイアウト無効化（ダイアログ表示用）
3. **645行目**: POSTリクエスト判定
4. **651-667行目**: バリデーター定義
5. **669行目**: Zend_Filter_Input作成
6. **671行目**: バリデーション実行
7. **676-683行目**: データ配列作成
8. **686行目**: DBインサート
9. **688-692行目**: 成功メッセージとContinueボタン表示

#### Step 3: バリデーション処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | 651-667行目のバリデーター定義 |

**主要処理フロー**:
- **resourcetitle**: NotEmpty必須、空の場合「Title is required」
- **resourcecategory**: NotEmpty必須、空の場合「Category is required」
- **resourcetype**: NotEmpty必須、空の場合「Type is required」

### プログラム呼び出し階層図

```
Admin_ResourcesController::newAction()
    │
    ├─ _helper->layout->disableLayout() [レイアウト無効化]
    │
    ├─ _request->isPost() [リクエスト種別判定]
    │
    ├─ Zend_Filter_Input [バリデーション]
    │      └─ isValid()
    │
    ├─ $registry->db->insert() [DB挿入]
    │
    └─ $registry->db->lastInsertId() [挿入ID取得]
```

### データフロー図

```
[入力]                     [処理]                           [出力]

POSTパラメータ        ┌─────────────────────┐
(resourcetitle,     │ ResourcesController │
resourcecategory,   │                     │
resourcetype)  ────▶│  newAction()        │────▶  成功: HTML
                    │  - 権限チェック      │       (メッセージ+ボタン)
                    │  - バリデーション    │
                    │  - DB挿入           │────▶  失敗: HTML
                    └─────────────────────┘       (エラー+フォーム)
                             │
                             ▼
                    ┌─────────────────────┐
                    │  resourcesテーブル   │
                    │  INSERT             │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | コントローラー | リソース管理の全アクション |
| new.phtml | `application/modules/admin/views/scripts/resources/new.phtml` | ビュー | 新規作成フォーム（推定） |
