# 機能設計書 34-リソース編集

## 概要

本ドキュメントは、LEGACY CMSにおけるリソース編集機能の設計を記載したものである。既存リソースの情報（タイトル、説明、コンテンツ、ISBN、著者、イラストレーター等）を編集・更新する機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：登録済みのリソース情報を更新する必要がある。書籍管理向け機能として、ISBN・著者・イラストレーター等の詳細情報や、説明文・本文コンテンツ、コメント設定等を編集できる。公開済みリソースの場合は検索インデックスも自動更新される。

**機能の利用シーン**：管理者がリソース一覧画面から編集したいリソースをクリックし、編集画面を開く。フォームでリソース情報を編集し、「Save」ボタンで保存する。保存処理はAjaxダイアログで実行され、成功メッセージが表示される。

**主要な処理内容**：
1. 編集画面の表示とリソース情報の読み込み
2. フォーム入力のバリデーション
3. リソースレコードのデータベース更新
4. 公開済みの場合は検索インデックスの更新
5. 成功/エラーメッセージの表示

**関連システム・外部連携**：Zend_Search_Luceneを使用した検索インデックス更新。Zend_Filter_Inputによる入力検証。

**権限による制御**：`rresources`および`rresourceedit`権限を持つユーザーのみリソース編集機能を利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | リソース編集画面 | 主画面 | リソース情報の編集フォーム |
| - | 保存結果ダイアログ | 結果表示 | 保存成功/失敗メッセージ |

## 機能種別

CRUD操作（Update） / データ更新 / 検索インデックス連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | リソースID | - |
| title | string | Yes | リソースタイトル | NotEmpty |
| category | integer | Yes | カテゴリID | NotEmpty |
| brand | integer | Yes | ブランドID | NotEmpty |
| author | string | No | 著者名 | allowEmpty |
| illustrator | string | No | イラストレーター名 | allowEmpty |
| isbn | string | No | ISBN | allowEmpty |
| description | string | Yes | 説明文 | NotEmpty |
| content | string | Yes | 本文コンテンツ | NotEmpty |
| asset | string | No | アセットキー | allowEmpty |
| comments | string | No | コメント許可（Y/N） | allowEmpty |
| moderate | string | No | コメントモデレート（Y/N） | allowEmpty |

### 入力データソース

- URLパラメータ（id）
- フォーム入力（POST）
- データベース（既存リソース情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| resourceArray | array | 編集対象リソース情報 |
| 保存結果メッセージ | HTML | 成功/エラーメッセージ |

### 出力先

- HTMLビュー（編集画面）
- HTMLダイアログ（保存結果）
- 検索インデックス（公開済みの場合）

## 処理フロー

### 処理シーケンス

```
1. 編集画面の表示
   └─ /admin/resources/edit/id/{id}/ へアクセス
2. 権限チェック
   └─ rresources + rresourceedit権限の確認
3. リソース情報の取得
   └─ resourcesテーブルからidで検索
4. フォーム表示
   └─ 既存データを初期値として設定
5. 保存処理の実行（別アクション: saveAction）
   └─ postDialog()でフォーム送信
6. 入力バリデーション
   └─ 必須フィールドの検証
7. コメント/モデレートチェックボックス変換
   └─ チェックなし→'N'、チェックあり→'Y'
8. リソースタイプ判定
   └─ タイプ1: ISBN等のフィールドを保存
   └─ その他: ISBN等はNULL
9. データベース更新
   └─ resourcesテーブルをUPDATE
10. 検索インデックス更新（公開済みの場合）
    └─ searchIndex->update()
11. 成功メッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    A[編集画面アクセス] --> B{権限チェック}
    B -->|権限なし| C[エラー画面へ転送]
    B -->|権限あり| D[リソース情報取得]
    D --> E{リソース存在?}
    E -->|No| F[一覧画面へリダイレクト]
    E -->|Yes| G[編集フォーム表示]
    G --> H[ユーザーが編集・保存]
    H --> I[saveAction呼び出し]
    I --> J[入力バリデーション]
    J --> K{バリデーション結果}
    K -->|失敗| L[エラーメッセージ表示]
    K -->|成功| M{リソースタイプ判定}
    M -->|タイプ1| N[全フィールド保存]
    M -->|その他| O[ISBN等はNULL]
    N --> P[DB更新]
    O --> P
    P --> Q{公開済み?}
    Q -->|Yes| R[検索インデックス更新]
    Q -->|No| S[成功メッセージ表示]
    R --> S
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-01 | タイプ別フィールド | タイプ1の場合のみISBN・著者・イラストレーター使用 | 保存時 |
| BR-34-02 | コメントフラグ変換 | チェックボックス値をY/Nに変換 | 保存時 |
| BR-34-03 | 検索インデックス更新 | 公開済みリソースは検索インデックスも更新 | 保存時 |
| BR-34-04 | HTMLエンティティデコード | contentフィールドはhtml_entity_decode適用 | 保存時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース取得 | resources | SELECT | idで編集対象取得 |
| リソース更新 | resources | UPDATE | 編集内容を保存 |

### テーブル別操作詳細

#### resources

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | resource_id = :id | 編集対象取得 |
| UPDATE | resource_title | $input->title | - |
| UPDATE | resource_brand | $input->brand | - |
| UPDATE | resource_category | $input->category | - |
| UPDATE | resource_author | $input->author（タイプ1）/ NULL | タイプ依存 |
| UPDATE | resource_illustrator | $input->illustrator（タイプ1）/ NULL | タイプ依存 |
| UPDATE | resource_ISBN | $input->isbn（タイプ1）/ NULL | タイプ依存 |
| UPDATE | resource_description | $input->description | - |
| UPDATE | resource_content | html_entity_decode($input->content) | HTMLデコード |
| UPDATE | resource_asset | $input->asset | - |
| UPDATE | resource_comments | Y/N | チェックボックス変換 |
| UPDATE | resource_moderate | Y/N | チェックボックス変換 |
| UPDATE | resource_edit | NOW() | 更新日時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | rresources or rresourceedit権限なし | privileges画面へ転送 |
| - | リソース未検出 | 指定idのリソースなし | manage画面へリダイレクト |
| - | バリデーションエラー | 必須フィールド未入力 | エラーメッセージ表示 |
| - | ID未指定 | idパラメータなし | 「Resource Not Specified!」表示 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

単一UPDATEのため、明示的なトランザクション管理は不要。

## パフォーマンス要件

- リソース更新処理は2秒以内
- 検索インデックス更新を含む場合は5秒以内

## セキュリティ考慮事項

- 権限チェック（rresources + rresourceedit）によるアクセス制御
- Zend_Filter_Inputによる入力サニタイズ
- html_entity_decodeによるコンテンツ処理

## 備考

- 編集画面表示はeditAction、保存処理はsaveActionで分離
- リッチテキストエディタで本文を編集

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

更新対象フィールドとタイプ別の分岐を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | saveAction()の319-353行目でデータ構造を確認 |

**読解のコツ**: resource_typeが'1'の場合とそれ以外でISBN等のフィールド処理が異なる。

#### Step 2: 編集画面表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | editAction() 140-172行目 |

**主要処理フロー**:
1. **142行目**: 権限チェック（rresources + rresourceedit）
2. **146行目**: idパラメータ取得
3. **152-155行目**: リソース情報取得クエリ
4. **160行目**: ビューにリソース配列を設定
5. **162-163行目**: リソース未検出時はリダイレクト

#### Step 3: 保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | saveAction() 234-415行目 |

**主要処理フロー**:
- **246-257行目**: コメント/モデレートチェックボックスの変換
- **276-308行目**: バリデーター定義
- **317行目**: タイプ判定（resource_type == '1'）
- **319-333行目**: タイプ1用データ配列
- **337-351行目**: その他タイプ用データ配列（ISBN等はNULL）
- **356行目**: DB更新
- **359-376行目**: 公開済みの場合の検索インデックス更新

### プログラム呼び出し階層図

```
Admin_ResourcesController
    │
    ├─ editAction() [編集画面表示]
    │      ├─ setLayout()
    │      └─ DBクエリ（resources）
    │
    └─ saveAction() [保存処理]
           ├─ Zend_Filter_Input [バリデーション]
           │      └─ isValid()
           ├─ $registry->db->update() [DB更新]
           └─ searchIndex->update() [検索インデックス更新]
```

### データフロー図

```
[入力]                     [処理]                           [出力]

URLパラメータ(id)     ┌─────────────────────┐
               ────▶ │ editAction()        │────▶  ビュー(edit.phtml)
                    │  - リソース取得      │       - 編集フォーム
                    └─────────────────────┘

POSTパラメータ        ┌─────────────────────┐
(title,category,    │  saveAction()       │
brand,等)      ────▶│  - バリデーション    │────▶  HTML(結果メッセージ)
                    │  - DB更新           │
                    │  - インデックス更新  │────▶  検索インデックス
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | コントローラー | リソース管理の全アクション |
| editAction() | 同上 | メソッド | 編集画面表示 |
| saveAction() | 同上 | メソッド | 保存処理 |
| detailsAction() | 同上 | メソッド | 詳細情報表示（ダイアログ） |
