# 機能設計書 35-リソース削除

## 概要

本ドキュメントは、LEGACY CMSにおけるリソース削除機能の設計を記載したものである。リソースをデータベースから削除し、関連するタグ・コメント・検索インデックスも同時に削除する機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：不要になったリソースをシステムから完全に削除する必要がある。削除時には関連データ（タグ、コメント）も同時に削除し、検索インデックスからも除去することで、データの一貫性を保つ。

**機能の利用シーン**：管理者がリソース管理画面でリソースの「Delete」リンクをクリックすると、確認ダイアログが表示される。確認ダイアログで「Delete」ボタンをクリックすると削除処理が実行される。

**主要な処理内容**：
1. 削除確認ダイアログの表示
2. 確認後の削除処理実行
3. リソースレコードの削除
4. 関連タグの削除（tagsテーブル）
5. 関連コメントの削除（commentsテーブル）
6. 検索インデックスからの削除

**関連システム・外部連携**：Zend_Search_Luceneを使用した検索インデックス削除。

**権限による制御**：`rresources`および`rresourcedelete`権限を持つユーザーのみリソース削除機能を利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | リソース管理画面 | 参照元画面 | 削除リンクのクリック |
| - | 削除確認ダイアログ | 主画面 | 削除確認と実行 |

## 機能種別

CRUD操作（Delete） / データ削除 / 検索インデックス連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | 削除対象リソースID | - |
| confirm | string | No | 削除確認フラグ（'1'で実行） | - |

### 入力データソース

- URLパラメータ（id, confirm）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 確認メッセージ | HTML | 削除確認ダイアログ |
| 完了メッセージ | HTML | 削除完了メッセージ |

### 出力先

- HTMLダイアログ（確認・結果表示）
- データベース（レコード削除）
- 検索インデックス（エントリ削除）

## 処理フロー

### 処理シーケンス

```
1. 削除ダイアログの表示
   └─ getDialog()で/admin/resources/delete/id/{id}/を呼び出し
2. 権限チェック
   └─ rresources + rresourcedelete権限の確認
3. 確認ダイアログ表示（confirm未指定時）
   └─ 「Delete」「Cancel」ボタン表示
4. 削除処理実行（confirm=1指定時）
   └─ 4-1. リソースレコード削除
   └─ 4-2. 関連タグ削除（tag_type='R', tag_slave=id）
   └─ 4-3. 関連コメント削除（comment_type='R', comment_slave=id）
   └─ 4-4. 検索インデックス削除（キー='r'+id）
5. 完了メッセージ表示
   └─ 「Close」ボタンでダイアログ閉じ、画面リロード
```

### フローチャート

```mermaid
flowchart TD
    A[削除ダイアログ表示] --> B{権限チェック}
    B -->|権限なし| C[エラー画面へ転送]
    B -->|権限あり| D{confirm=1?}
    D -->|No| E[確認ダイアログ表示]
    E --> F{ユーザー選択}
    F -->|Cancel| G[ダイアログ閉じる]
    F -->|Delete| H[confirm=1で再呼び出し]
    D -->|Yes| I[リソースレコード削除]
    I --> J[関連タグ削除]
    J --> K[関連コメント削除]
    K --> L[検索インデックス削除]
    L --> M[完了メッセージ表示]
    M --> N[Closeクリック]
    N --> O[ダイアログ閉じ、リロード]
    H --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-35-01 | 2段階確認 | 削除前に確認ダイアログを表示 | 常時 |
| BR-35-02 | 関連データ削除 | タグとコメントも同時削除 | 削除実行時 |
| BR-35-03 | インデックス削除 | 検索インデックスからも削除 | 削除実行時 |
| BR-35-04 | タグ識別子 | tag_type='R'がリソースのタグ | タグ削除時 |
| BR-35-05 | コメント識別子 | comment_type='R'がリソースのコメント | コメント削除時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース削除 | resources | DELETE | 指定IDのリソース削除 |
| タグ削除 | tags | DELETE | 関連タグ削除 |
| コメント削除 | comments | DELETE | 関連コメント削除 |

### テーブル別操作詳細

#### resources

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | resource_id = :id | - |

#### tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | tag_type = 'R' AND tag_slave = :id | Rはリソース |

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | comment_type = 'R' AND comment_slave = :id | Rはリソース |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | rresources or rresourcedelete権限なし | privileges画面へ転送 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

複数テーブルへの削除があるが、明示的なトランザクション管理は実装されていない。

## パフォーマンス要件

- 削除処理は2秒以内

## セキュリティ考慮事項

- 権限チェック（rresources + rresourcedelete）によるアクセス制御
- 2段階確認による誤削除防止

## 備考

- 削除は物理削除（論理削除ではない）
- 削除後のデータ復旧は不可

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 削除処理全体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | deleteAction() 177-229行目 |

**読解のコツ**: confirm パラメータの有無で確認ダイアログ表示と削除実行を分岐。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | deleteAction() 177-229行目 |

**主要処理フロー**:
1. **179行目**: 権限チェック（rresources + rresourcedelete）
2. **181-182行目**: レイアウト・ビュー無効化（ダイアログ表示用）
3. **184-185行目**: パラメータ取得（confirm, id）
4. **187行目**: confirm='1'かつid設定で削除実行
5. **193行目**: リソースレコード削除
6. **196行目**: 関連タグ削除
7. **199行目**: 関連コメント削除
8. **202行目**: 検索インデックス削除

#### Step 3: 関連データ削除を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | 196行目（タグ削除）、199行目（コメント削除） |

**主要処理フロー**:
- **196行目**: `$registry->db->delete('tags', array('tag_type = "R"','tag_slave = '.$this->view->resource));`
- **199行目**: `$registry->db->delete('comments', array('comment_type = "R"','comment_slave = '.$this->view->resource));`

### プログラム呼び出し階層図

```
Admin_ResourcesController::deleteAction()
    │
    ├─ _helper->layout()->disableLayout() [レイアウト無効化]
    │
    ├─ _helper->viewRenderer->setNoRender(true) [ビュー無効化]
    │
    ├─ $registry->db->delete('resources', ...) [リソース削除]
    │
    ├─ $registry->db->delete('tags', ...) [タグ削除]
    │
    ├─ $registry->db->delete('comments', ...) [コメント削除]
    │
    └─ _helper->searchIndex->delete() [インデックス削除]
```

### データフロー図

```
[入力]                     [処理]                           [出力]

URLパラメータ         ┌─────────────────────┐
(id, confirm)   ────▶│ deleteAction()      │
                    │                     │
                    │ confirm未指定:      │────▶  確認ダイアログHTML
                    │  確認ダイアログ表示  │
                    │                     │
                    │ confirm=1:          │────▶  完了メッセージHTML
                    │  削除処理実行       │
                    └─────────────────────┘
                             │
                             ▼
               ┌─────────────────────────────┐
               │ DELETE: resources           │
               │ DELETE: tags                │
               │ DELETE: comments            │
               │ DELETE: 検索インデックス    │
               └─────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | コントローラー | リソース管理の全アクション |
| deleteAction() | 同上 | メソッド | 削除処理 |
