# 機能設計書 36-リソース公開/非公開

## 概要

本ドキュメントは、LEGACY CMSにおけるリソース公開/非公開機能の設計を記載したものである。リソースの公開ステータスを切り替え、公開時には検索インデックスへの登録も行う機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：新規作成したリソースは下書き状態で保存され、内容が完成した時点で公開する必要がある。公開処理により、フロントエンドサイトでユーザーがリソースを閲覧できるようになり、検索インデックスにも登録されて検索可能になる。

**機能の利用シーン**：管理者がリソース編集画面で「Publish」ボタンをクリックすると、確認ダイアログが表示される。確認後、リソース情報のバリデーションを行い、問題なければ公開ステータスを「published」に変更し、検索インデックスに登録する。

**主要な処理内容**：
1. 公開確認ダイアログの表示
2. フォームデータのバリデーション
3. リソース情報の更新（公開ステータス、公開日時含む）
4. 検索インデックスへの登録

**関連システム・外部連携**：Zend_Search_Luceneを使用した検索インデックス登録。Zend_Filter_Inputによる入力検証。

**権限による制御**：`rresources`および`rresourcepublish`権限を持つユーザーのみリソース公開機能を利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | リソース編集画面 | 参照元画面 | Publishボタンクリック |
| - | 公開確認ダイアログ | 主画面 | 公開確認と実行 |

## 機能種別

ステータス管理 / 検索インデックス連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | リソースID | - |
| confirm | string | No | 公開確認フラグ（'1'で実行） | - |
| title | string | Yes | リソースタイトル | NotEmpty |
| category | integer | Yes | カテゴリID | NotEmpty |
| brand | integer | Yes | ブランドID | NotEmpty |
| author | string | No | 著者名 | allowEmpty |
| illustrator | string | No | イラストレーター名 | allowEmpty |
| isbn | string | No | ISBN | allowEmpty |
| description | string | Yes | 説明文 | NotEmpty |
| content | string | Yes | 本文コンテンツ | NotEmpty |
| asset | string | No | アセットキー | allowEmpty |
| comments | string | No | コメント許可（Y/N） | allowEmpty |
| moderate | string | No | コメントモデレート（Y/N） | allowEmpty |

### 入力データソース

- URLパラメータ（id, confirm）
- フォーム入力（POST）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 確認メッセージ | HTML | 公開確認ダイアログ |
| 完了メッセージ | HTML | 公開完了メッセージ |
| エラーメッセージ | HTML | バリデーションエラー時 |

### 出力先

- HTMLダイアログ（確認・結果表示）
- データベース（ステータス更新）
- 検索インデックス（エントリ登録）

## 処理フロー

### 処理シーケンス

```
1. 公開ダイアログの表示
   └─ postDialog()で/admin/resources/publish/id/{id}/を呼び出し
2. 権限チェック
   └─ rresources + rresourcepublish権限の確認
3. 確認ダイアログ表示（confirm未指定時）
   └─ 「Publish」「Close」ボタン表示
4. 公開処理実行（confirm=1指定時）
   └─ 4-1. 既存リソース情報取得
   └─ 4-2. フォームバリデーション
   └─ 4-3. リソースタイプ判定
   └─ 4-4. データベース更新（status='published', publish=NOW()）
   └─ 4-5. 検索インデックス登録
5. 完了メッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    A[Publishボタンクリック] --> B{権限チェック}
    B -->|権限なし| C[エラー画面へ転送]
    B -->|権限あり| D{confirm=1?}
    D -->|No| E[確認ダイアログ表示]
    E --> F{ユーザー選択}
    F -->|Close| G[ダイアログ閉じる]
    F -->|Publish| H[フォームPOSTでconfirm=1]
    D -->|Yes| I[既存リソース情報取得]
    I --> J[入力バリデーション]
    J --> K{バリデーション結果}
    K -->|失敗| L[エラーメッセージ表示]
    K -->|成功| M{リソースタイプ判定}
    M -->|タイプ1| N[全フィールド保存]
    M -->|その他| O[ISBN等はNULL]
    N --> P[DB更新 status=published]
    O --> P
    P --> Q[検索インデックス登録]
    Q --> R[完了メッセージ表示]
    H --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-36-01 | 公開ステータス | resource_status='published'に更新 | 公開実行時 |
| BR-36-02 | 公開日時記録 | resource_publishにNOW()を設定 | 公開実行時 |
| BR-36-03 | 検索インデックス登録 | searchIndex->add()で登録 | 公開実行時 |
| BR-36-04 | バリデーション必須 | 公開前にフォームデータの検証が必要 | 公開実行時 |

### 計算ロジック

検索インデックスキー: 'r' + resource_id

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース取得 | resources | SELECT | 公開対象リソース取得 |
| リソース更新 | resources | UPDATE | 公開ステータス・内容更新 |

### テーブル別操作詳細

#### resources

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | resource_id = :id | 既存データ取得 |
| UPDATE | resource_status | 'published' | 公開ステータス |
| UPDATE | resource_publish | NOW() | 公開日時 |
| UPDATE | resource_edit | NOW() | 編集日時 |
| UPDATE | その他フィールド | フォーム入力値 | 保存と同様 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | rresources or rresourcepublish権限なし | privileges画面へ転送 |
| - | バリデーションエラー | 必須フィールド未入力 | エラーメッセージ表示 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

単一UPDATEのため、明示的なトランザクション管理は不要。

## パフォーマンス要件

- 公開処理は3秒以内（検索インデックス登録含む）

## セキュリティ考慮事項

- 権限チェック（rresources + rresourcepublish）によるアクセス制御
- 公開前のバリデーションによるデータ品質確保

## 備考

- 公開後の非公開化機能は本機能には含まれない
- 編集時の保存（saveAction）とは別にpublishActionで公開

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 公開処理全体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | publishAction() 420-602行目 |

**読解のコツ**: saveActionと構造が似ているが、resource_statusとresource_publishの更新が追加されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | publishAction() 420-602行目 |

**主要処理フロー**:
1. **422行目**: 権限チェック（rresources + rresourcepublish）
2. **427-428行目**: confirm, idパラメータ取得
3. **430行目**: confirm='1'かつid設定で公開実行
4. **436-443行目**: 既存リソース情報取得
5. **463-495行目**: バリデーター定義（saveActionと同様）
6. **504-522行目**: タイプ1用データ配列（status='published', publish=NOW()追加）
7. **524-542行目**: その他タイプ用データ配列
8. **547行目**: DB更新
9. **555-562行目**: 検索インデックス登録（add）

#### Step 3: 検索インデックス登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | 555-562行目 |

**主要処理フロー**:
- **549-550行目**: 検索インデックス用URL生成
- **555-562行目**: searchIndex->add()呼び出し（key, date, title, url, details, stub, contents）

### プログラム呼び出し階層図

```
Admin_ResourcesController::publishAction()
    │
    ├─ _helper->layout()->disableLayout() [レイアウト無効化]
    │
    ├─ $registry->db->select() [既存リソース取得]
    │
    ├─ Zend_Filter_Input [バリデーション]
    │      └─ isValid()
    │
    ├─ $registry->db->update() [DB更新 status='published']
    │
    └─ _helper->searchIndex->add() [検索インデックス登録]
```

### データフロー図

```
[入力]                     [処理]                           [出力]

URLパラメータ         ┌─────────────────────┐
(id, confirm)   ────▶│ publishAction()     │
                    │                     │
POSTパラメータ  ────▶│ confirm未指定:      │────▶  確認ダイアログHTML
(フォームデータ)     │  確認ダイアログ表示  │
                    │                     │
                    │ confirm=1:          │────▶  完了メッセージHTML
                    │  - バリデーション    │
                    │  - DB更新           │────▶  resources UPDATE
                    │  - インデックス登録  │────▶  検索インデックス
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | コントローラー | リソース管理の全アクション |
| publishAction() | 同上 | メソッド | 公開処理 |
