# 機能設計書 37-リソースカテゴリ管理

## 概要

本ドキュメントは、LEGACY CMSにおけるリソースカテゴリ管理機能の設計を記載したものである。リソースのカテゴリを作成・編集・削除する機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：リソース（書籍等）を分類・整理するためにカテゴリが必要である。カテゴリを階層的に管理することで、ユーザーが目的のリソースを見つけやすくなる。カテゴリには説明文やコンテンツ、アセット（画像）を設定でき、フロントエンドでのカテゴリページ表示にも利用される。

**機能の利用シーン**：管理者がリソース編集画面のサイドバーや専用画面からカテゴリを管理する。新規カテゴリの作成、既存カテゴリの編集（タイトル、説明、コンテンツ、アセット）、不要カテゴリの削除を行う。カテゴリ削除時は関連リソースがデフォルトカテゴリに移動される。

**主要な処理内容**：
1. カテゴリ一覧の表示
2. 新規カテゴリの作成（タイトル入力）
3. カテゴリ情報の編集（タイトル、説明、コンテンツ、アセット）
4. カテゴリの公開
5. カテゴリの削除（関連リソースの移動）

**関連システム・外部連携**：Zend_Filter_Inputによる入力検証。Zend_Validate_Db_NoRecordExistsによる重複チェック。

**権限による制御**：`rresources`権限に加え、操作に応じて`rresourcenew`、`rcategoryedit`、`rcategorypublish`、`rresourcedelete`権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | カテゴリ一覧ダイアログ | 主画面 | カテゴリ一覧表示 |
| - | カテゴリ新規作成ダイアログ | 主画面 | 新規カテゴリ作成 |
| - | カテゴリ編集画面 | 主画面 | カテゴリ情報編集 |
| - | カテゴリ削除確認ダイアログ | 主画面 | カテゴリ削除確認 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ（新規作成）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| categorytitle | string | Yes | カテゴリタイトル | NotEmpty, Alnum, NoRecordExists |

### 入力パラメータ（編集）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | カテゴリID | - |
| title | string | Yes | カテゴリタイトル | NotEmpty |
| description | string | Yes | 説明文 | NotEmpty |
| content | string | Yes | コンテンツ | NotEmpty |
| asset | string | No | アセットキー | allowEmpty |

### 入力データソース

- URLパラメータ（id, confirm）
- フォーム入力（POST）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| categoryArray | array | カテゴリ一覧/詳細 |
| 成功/エラーメッセージ | HTML | 処理結果 |

### 出力先

- HTMLビュー/ダイアログ
- データベース

## 処理フロー

### 処理シーケンス（新規作成）

```
1. 新規作成ダイアログ表示
   └─ /admin/resources/categorynew/
2. 権限チェック
   └─ rresources + rresourcenew
3. フォーム入力
   └─ categorytitleを入力
4. バリデーション
   └─ NotEmpty, Alnum, 重複チェック
5. DBインサート
   └─ resources_categoriesテーブル
6. 成功メッセージ表示
```

### 処理シーケンス（編集）

```
1. 編集画面表示
   └─ /admin/resources/category/id/{id}/
2. 権限チェック
   └─ rresources + rcategoryedit
3. 既存カテゴリ情報取得
4. フォーム編集
5. 保存処理（categorysaveAction）
   └─ バリデーション
   └─ DBアップデート
6. 成功メッセージ表示
```

### 処理シーケンス（削除）

```
1. 削除確認ダイアログ表示
   └─ /admin/resources/categorydelete/id/{id}/
2. 権限チェック
   └─ rresources + rresourcedelete
3. 確認後、削除実行
   └─ 関連リソースをカテゴリ'1'に移動
   └─ カテゴリレコード削除
4. 成功メッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    A[カテゴリ管理開始] --> B{操作種別}
    B -->|一覧| C[categoriesAction]
    B -->|新規作成| D[categorynewAction]
    B -->|編集| E[categoryAction]
    B -->|保存| F[categorysaveAction]
    B -->|公開| G[categorypublishAction]
    B -->|削除| H[categorydeleteAction]

    D --> I{権限チェック}
    I -->|OK| J[フォーム表示/処理]
    I -->|NG| K[権限エラー]
    J --> L{バリデーション}
    L -->|成功| M[DB操作]
    L -->|失敗| N[エラー表示]

    H --> O{権限チェック}
    O -->|OK| P{confirm=1?}
    P -->|No| Q[確認ダイアログ]
    P -->|Yes| R[関連リソース移動]
    R --> S[カテゴリ削除]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-37-01 | タイトル重複禁止 | 同名カテゴリは作成不可 | 新規作成時 |
| BR-37-02 | 英数字のみ | タイトルは英数字（スペース許可）のみ | 新規作成時 |
| BR-37-03 | 削除時の移動先 | 削除カテゴリのリソースはカテゴリID=1に移動 | 削除時 |
| BR-37-04 | 公開ステータス | rcat_status='published'で公開 | 公開時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カテゴリ一覧取得 | resources_categories | SELECT | 全カテゴリ取得 |
| カテゴリ詳細取得 | resources_categories | SELECT | ID指定で取得 |
| カテゴリ作成 | resources_categories | INSERT | 新規カテゴリ |
| カテゴリ更新 | resources_categories | UPDATE | カテゴリ情報更新 |
| カテゴリ削除 | resources_categories | DELETE | カテゴリ削除 |
| リソース移動 | resources | UPDATE | カテゴリ変更 |

### テーブル別操作詳細

#### resources_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | ORDER BY rcat_title ASC | 一覧取得 |
| SELECT | 全項目 | rcat_id = :id | 詳細取得 |
| INSERT | rcat_title | $input->categorytitle | 新規作成 |
| UPDATE | rcat_title, rcat_description, rcat_content, rcat_asset | フォーム入力値 | 編集 |
| UPDATE | rcat_status | 'published' | 公開 |
| DELETE | - | rcat_id = :id | 削除 |

#### resources

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | resource_category | '1' | 削除カテゴリのリソースを移動 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 必要な権限なし | privileges画面へ転送 |
| - | 重複エラー | 同名カテゴリ存在 | エラーメッセージ表示 |
| - | バリデーションエラー | 必須フィールド未入力 | エラーメッセージ表示 |
| - | 不正文字エラー | 英数字以外の文字 | エラーメッセージ表示 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

カテゴリ削除時のリソース移動と削除は明示的なトランザクション管理なし。

## パフォーマンス要件

- カテゴリ一覧表示は1秒以内

## セキュリティ考慮事項

- 権限チェックによるアクセス制御
- Zend_Validate_Alnumによる入力検証

## 備考

- デフォルトカテゴリ（ID=1）は削除不可（移動先として使用）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: カテゴリ関連アクションの全体像を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | カテゴリ関連の各アクションを確認 |

**読解のコツ**: categoriesAction, categorynewAction, categoryAction, categorysaveAction, categorypublishAction, categorydeleteAction の6つのアクションがある。

#### Step 2: 一覧表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | categoriesAction() 1127-1150行目 |

**主要処理フロー**:
1. **1129行目**: 権限チェック（rresources）
2. **1137-1139行目**: 全カテゴリをタイトル昇順で取得
3. **1142行目**: ビューに配列を設定

#### Step 3: 新規作成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | categorynewAction() 792-859行目 |

**主要処理フロー**:
- **804-810行目**: バリデーター定義（NotEmpty, Alnum, NoRecordExists）
- **818-820行目**: データ配列作成
- **827行目**: DBインサート

#### Step 4: 削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | categorydeleteAction() 724-787行目 |

**主要処理フロー**:
- **740-743行目**: 関連リソースを取得
- **747-756行目**: 各リソースのカテゴリを'1'に更新
- **760行目**: カテゴリレコード削除

### プログラム呼び出し階層図

```
Admin_ResourcesController
    │
    ├─ categoriesAction() [一覧表示]
    │
    ├─ categorynewAction() [新規作成]
    │      └─ Zend_Validate_Db_NoRecordExists
    │
    ├─ categoryAction() [編集画面]
    │
    ├─ categorysaveAction() [保存処理]
    │
    ├─ categorypublishAction() [公開処理]
    │
    └─ categorydeleteAction() [削除処理]
           ├─ リソース移動
           └─ カテゴリ削除
```

### データフロー図

```
[入力]                     [処理]                           [出力]

categorytitle       ┌─────────────────────┐
               ────▶│ categorynewAction() │────▶  INSERT
                    │ - バリデーション     │       resources_categories
                    │ - 重複チェック       │
                    └─────────────────────┘

id, confirm         ┌─────────────────────┐
               ────▶│categorydeleteAction()│
                    │                     │────▶  UPDATE resources
                    │ - 関連リソース移動   │       (category='1')
                    │ - カテゴリ削除       │
                    └─────────────────────┘────▶  DELETE
                                                resources_categories
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | コントローラー | リソース管理の全アクション |
| categoriesAction() | 同上 | メソッド | カテゴリ一覧 |
| categorynewAction() | 同上 | メソッド | カテゴリ新規作成 |
| categoryAction() | 同上 | メソッド | カテゴリ編集画面 |
| categorydetailsAction() | 同上 | メソッド | カテゴリ詳細表示 |
| categorysaveAction() | 同上 | メソッド | カテゴリ保存 |
| categorypublishAction() | 同上 | メソッド | カテゴリ公開 |
| categorydeleteAction() | 同上 | メソッド | カテゴリ削除 |
