# 機能設計書 38-リソースブランド管理

## 概要

本ドキュメントは、LEGACY CMSにおけるリソースブランド管理機能の設計を記載したものである。リソースのブランド（出版社等）を作成・編集・削除する機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：書籍管理向け機能として、リソースにブランド（出版社、メーカー等）を関連付ける必要がある。ブランドにはタイトル、リンク（URL）、電話番号を設定でき、フロントエンドでのリソース詳細表示やブランド別一覧表示に利用される。

**機能の利用シーン**：管理者がリソース管理画面から「Brands」ボタンをクリックしてブランド一覧画面を開く。新規ブランドの作成、既存ブランドの編集（タイトル、リンク、電話番号）、不要ブランドの削除を行う。

**主要な処理内容**：
1. ブランド一覧のページネーション付き表示
2. 新規ブランドの作成
3. ブランド情報の編集
4. ブランドの削除

**関連システム・外部連携**：Zend_Paginatorによるページネーション。Zend_Filter_Inputによる入力検証。

**権限による制御**：`rresources`および`rbrands`権限に加え、操作に応じて`rbrandedit`、`rbranddelete`権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ブランド管理画面 | 主画面 | ブランド一覧表示（15件/ページ） |
| - | ブランド新規作成ダイアログ | 主画面 | 新規ブランド作成 |
| - | ブランド編集ダイアログ | 主画面 | ブランド情報編集 |
| - | ブランド削除確認ダイアログ | 主画面 | ブランド削除確認 |

## 機能種別

CRUD操作 / マスタ管理

## 入力仕様

### 入力パラメータ（新規作成・編集）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| brandtitle | string | Yes | ブランドタイトル | NotEmpty, NoRecordExists |
| brandlink | string | No | リンクURL | Regex（URL形式） |
| brandphone | string | No | 電話番号 | Regex（数字・スペースのみ） |

### 入力パラメータ（一覧表示）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| page | integer | No | ページ番号 | 正の整数 |

### 入力パラメータ（削除）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | ブランドID | - |
| confirm | string | No | 削除確認フラグ | - |

### 入力データソース

- URLパラメータ（page, id, confirm）
- フォーム入力（POST）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| brandsArray | Zend_Paginator | ブランド一覧（ページネーション付き） |
| brandArray | array | ブランド詳細（編集時） |
| 成功/エラーメッセージ | HTML | 処理結果 |

### 出力先

- HTMLビュー/ダイアログ
- データベース

## 処理フロー

### 処理シーケンス（一覧表示）

```
1. ブランド管理画面アクセス
   └─ /admin/resources/brands/
2. 権限チェック
   └─ rresources + rbrands
3. ブランド一覧取得
   └─ rbrand_id != '1' （デフォルトブランド除外）
4. ページネーション設定
   └─ 15件/ページ、5ページ範囲
5. ビュー表示
```

### 処理シーケンス（新規作成）

```
1. 新規作成ダイアログ表示
   └─ /admin/resources/brandnew/
2. フォーム入力
3. バリデーション
   └─ brandtitle: NotEmpty, NoRecordExists
   └─ brandlink: URL形式（オプション）
   └─ brandphone: 数字・スペース（オプション）
4. DBインサート
5. 成功メッセージ表示
```

### 処理シーケンス（編集）

```
1. 編集ダイアログ表示
   └─ /admin/resources/brand/id/{id}/
2. 権限チェック
   └─ rresources + rbrandedit
3. 既存ブランド情報取得
4. フォーム編集
5. バリデーション
   └─ 重複チェック（自分以外）
6. DB更新
7. 成功メッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    A[ブランド管理開始] --> B{操作種別}
    B -->|一覧| C[brandsAction]
    B -->|新規作成| D[brandnewAction]
    B -->|編集| E[brandAction]
    B -->|削除| F[branddeleteAction]

    C --> G{権限チェック}
    G -->|OK| H[ブランド一覧取得]
    H --> I[Paginator設定]
    I --> J[ビュー表示]

    D --> K[フォーム表示/処理]
    K --> L{バリデーション}
    L -->|成功| M[DB INSERT]
    L -->|失敗| N[エラー表示]

    F --> O{confirm=1?}
    O -->|No| P[確認ダイアログ]
    O -->|Yes| Q[DB DELETE]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-38-01 | タイトル重複禁止 | 同名ブランドは作成不可 | 新規作成・編集時 |
| BR-38-02 | デフォルト除外 | ID=1のブランドは一覧から除外 | 一覧表示時 |
| BR-38-03 | URL形式チェック | mailto, news, http(s), ftpで始まるURL | リンク入力時 |
| BR-38-04 | 電話番号形式 | 数字とスペースのみ | 電話番号入力時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ブランド一覧取得 | resources_brands | SELECT | デフォルト除外、タイトル昇順 |
| ブランド詳細取得 | resources_brands | SELECT | ID指定で取得 |
| ブランド作成 | resources_brands | INSERT | 新規ブランド |
| ブランド更新 | resources_brands | UPDATE | ブランド情報更新 |
| ブランド削除 | resources_brands | DELETE | ブランド削除 |

### テーブル別操作詳細

#### resources_brands

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | rbrand_id != '1' ORDER BY rbrand_title ASC | 一覧取得 |
| SELECT | 全項目 | rbrand_id = :id | 詳細取得 |
| INSERT | rbrand_title, rbrand_link, rbrand_phone | フォーム入力値 | 新規作成 |
| UPDATE | rbrand_title, rbrand_link, rbrand_phone | フォーム入力値 | 編集 |
| DELETE | - | rbrand_id = :id | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 必要な権限なし | privileges画面へ転送 |
| - | 重複エラー | 同名ブランド存在 | 「Duplicate Title」表示 |
| - | URL形式エラー | 不正なURL形式 | 「Invalid URL」表示 |
| - | 電話番号形式エラー | 不正な電話番号形式 | 「Invalid phone number」表示 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

単一操作のため、明示的なトランザクション管理は不要。

## パフォーマンス要件

- ブランド一覧表示は1秒以内

## セキュリティ考慮事項

- 権限チェックによるアクセス制御
- Zend_Validate_Regexによる入力検証

## 備考

- デフォルトブランド（ID=1）は削除不可（一覧から除外）
- ブランド削除時の関連リソースへの影響は未定義

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ブランド一覧表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | brandsAction() 1155-1191行目 |

**主要処理フロー**:
1. **1157行目**: 権限チェック（rresources + rbrands）
2. **1171-1174行目**: ブランド一覧取得（ID!=1、タイトル昇順）
3. **1177-1180行目**: Paginator設定（15件/ページ、5ページ範囲）

#### Step 2: 新規作成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | brandnewAction() 1196-1271行目 |

**主要処理フロー**:
- **1208-1226行目**: バリデーター定義
  - brandtitle: NotEmpty + NoRecordExists
  - brandlink: Regex（URL形式）
  - brandphone: Regex（数字・スペース）
- **1236-1240行目**: データ配列作成
- **1243行目**: DBインサート

#### Step 3: 編集処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | brandAction() 1324-1416行目 |

**主要処理フロー**:
- **1351-1368行目**: バリデーター定義（excludeで自分を除外した重複チェック）
- **1375-1378行目**: データ配列作成
- **1382行目**: DB更新

#### Step 4: 削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | branddeleteAction() 1276-1319行目 |

**主要処理フロー**:
- **1278行目**: 権限チェック（rresources + rbranddelete）
- **1286行目**: confirm=1で削除実行
- **1292行目**: DB削除

### プログラム呼び出し階層図

```
Admin_ResourcesController
    │
    ├─ brandsAction() [一覧表示]
    │      ├─ DBクエリ（rbrand_id != '1'）
    │      └─ Zend_Paginator
    │
    ├─ brandnewAction() [新規作成]
    │      ├─ Zend_Validate_Db_NoRecordExists
    │      └─ Zend_Validate_Regex
    │
    ├─ brandAction() [編集]
    │      └─ Zend_Validate_Db_NoRecordExists（exclude）
    │
    └─ branddeleteAction() [削除]
```

### データフロー図

```
[入力]                     [処理]                           [出力]

page                ┌─────────────────────┐
               ────▶│ brandsAction()      │────▶  ビュー
                    │ - ブランド一覧取得   │       (brandsArray)
                    │ - Paginator設定     │
                    └─────────────────────┘

brandtitle,         ┌─────────────────────┐
brandlink,     ────▶│ brandnewAction()    │────▶  INSERT
brandphone          │ - バリデーション     │       resources_brands
                    │ - 重複チェック       │
                    └─────────────────────┘

id, confirm         ┌─────────────────────┐
               ────▶│ branddeleteAction() │────▶  DELETE
                    │ - 確認処理          │       resources_brands
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ResourcesController.php | `application/modules/admin/controllers/ResourcesController.php` | コントローラー | リソース管理の全アクション |
| brandsAction() | 同上 | メソッド | ブランド一覧 |
| brandnewAction() | 同上 | メソッド | ブランド新規作成 |
| brandAction() | 同上 | メソッド | ブランド編集 |
| branddeleteAction() | 同上 | メソッド | ブランド削除 |
