# 機能設計書 39-ローテーター一覧表示

## 概要

本ドキュメントは、LEGACY CMSにおけるローテーター一覧表示機能の設計を記載したものである。バナーローテーターの一覧をページネーション付きで表示する機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：CMSで管理するバナーローテーター（スライドショー）を一覧表示し、管理者が各ローテーターの設定状況（サイズ、スライド数、ページング設定、遅延時間）を把握できるようにする。ローテーターはフロントエンドサイトでバナー画像のスライドショーとして表示される。

**機能の利用シーン**：管理者が管理画面のメニューから「Rotators」を選択してローテーター一覧画面を開く。一覧から編集したいローテーターを選択して編集画面へ遷移する。

**主要な処理内容**：
1. ローテーター一覧のデータベースからの取得
2. ページネーションによる分割表示（15件/ページ）
3. 各ローテーターのスライド数の取得・表示
4. 編集画面へのリンク提供

**関連システム・外部連携**：Zend_Paginatorを使用したページネーション処理。Dojo Toolkitによるメニュー・ダイアログ表示。

**権限による制御**：`rotrotators`権限を持つユーザーのみローテーター一覧表示機能を利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 87 | ローテーター管理画面 | 主画面 | ローテーター一覧を表示 |

## 機能種別

データ参照 / 一覧表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| page | integer | No | 現在のページ番号（デフォルト: 1） | 正の整数 |
| items | integer | No | 1ページあたりの件数（デフォルト: 15） | 正の整数 |
| range | integer | No | ページ範囲（デフォルト: 5） | 正の整数 |

### 入力データソース

- URLパラメータ（page）
- コントローラー設定（items, range）
- データベース（rotators）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| rotatorsArray | Zend_Paginator | ページネーション付きローテーター一覧 |

### 出力先

- HTMLビュー（ローテーター一覧テーブル、ページネーション）

## 処理フロー

### 処理シーケンス

```
1. ローテーター管理画面へのアクセス
   └─ /admin/rotators/manage/ または /admin/rotators/
2. 権限チェック
   └─ rotrotators権限の確認
3. パラメータ設定
   └─ items=15, range=5
4. ローテーター一覧の取得
   └─ Rotatorsモデル::fetchRotators()呼び出し
5. ページネーション処理
   └─ Zend_Paginator で設定適用
6. ビューへのデータ渡し
   └─ rotatorsArray をビューに設定
7. 各ローテーターのスライド数取得
   └─ rotSlideCountビューヘルパー使用
```

### フローチャート

```mermaid
flowchart TD
    A[ローテーター管理画面アクセス] --> B{権限チェック}
    B -->|権限なし| C[エラー画面へ転送]
    B -->|権限あり| D[パラメータ設定]
    D --> E[Rotators::fetchRotators呼び出し]
    E --> F[Zend_Paginator生成]
    F --> G[ページ設定適用]
    G --> H[ビュー表示]
    H --> I[各行でrotSlideCount取得]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-39-01 | ページネーション設定 | 1ページあたり15件、ページ範囲5 | 常時 |
| BR-39-02 | デフォルトページ | pageパラメータがない場合は1ページ目 | page未指定時 |
| BR-39-03 | ソート順 | ローテーター名昇順（rot_name ASC） | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ローテーター一覧取得 | rotators | SELECT | 全ローテーター取得 |

### テーブル別操作詳細

#### rotators

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | rot_id, rot_name, rot_width, rot_height, rot_paging, rot_delay | ORDER BY rot_name ASC | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | rotrotators権限なし | privileges画面へ転送 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

読み取り専用のため、トランザクション管理は不要。

## パフォーマンス要件

- ローテーター一覧の表示は1秒以内

## セキュリティ考慮事項

- 権限チェック（rotrotators）によるアクセス制御

## 備考

- Rotatorsモデルクラスでデータアクセスをカプセル化
- ビューヘルパーrotSlideCountでスライド数を取得・表示

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Rotatorsモデルクラスでテーブル構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Rotators.php | `application/models/Rotators.php` | fetchRotators()メソッドの24-53行目でクエリ構造を確認 |

**読解のコツ**: Rotatorsモデルはrotatorsテーブルとrotators_slidesテーブルを扱う。fetchRotatorsはローテーター一覧、fetchSlidesはスライド一覧を取得。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | indexAction()はmanageへリダイレクト |
| 2-2 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | manageAction() 29-47行目 |

**主要処理フロー**:
1. **31行目**: 権限チェック（rotrotators）
2. **33-34行目**: パラメータ設定（items=15, range=5）
3. **36行目**: パラメータ取得
4. **38行目**: Rotatorsモデルインスタンス生成
5. **40行目**: fetchRotators()呼び出し、結果をビューに設定

#### Step 3: モデル層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Rotators.php | `application/models/Rotators.php` | fetchRotators() 24-54行目 |

**主要処理フロー**:
- **26-28行目**: クエリ構築（rotators、rot_name ASC）
- **30-46行目**: パラメータ処理（page, items, range）
- **48-53行目**: Zend_Paginator生成・設定

#### Step 4: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | manage.phtml | `application/modules/admin/views/scripts/rotators/manage.phtml` | 一覧テーブル表示 |

**主要処理フロー**:
- **30-37行目**: テーブルヘッダー（Rotator, Dimensions, Slides, Paging, Delay）
- **39-57行目**: 各ローテーターの行表示
- **47行目**: rotSlideCountヘルパーでスライド数表示
- **67-71行目**: ページネーションコントロール

### プログラム呼び出し階層図

```
Admin_RotatorsController
    │
    ├─ indexAction() [リダイレクト]
    │      └─ _helper->redirector('manage')
    │
    └─ manageAction() [一覧表示]
           │
           └─ Rotators [モデル]
                  └─ fetchRotators($params)
                         ├─ $registry->db->select()
                         └─ Zend_Paginator::factory()
```

### データフロー図

```
[入力]                     [処理]                           [出力]

URLパラメータ         ┌─────────────────────┐
(page)          ────▶│ RotatorsController  │
                    │                     │
コントローラー設定   │  manageAction()     │
(items=15,     ────▶│  - 権限チェック      │
range=5)            │  - パラメータ設定    │
                    └─────────────────────┘
                             │
                             ▼
                    ┌─────────────────────┐
                    │  Rotators::         │
                    │  fetchRotators()    │────▶  ビュー(manage.phtml)
                    │  - クエリ構築       │       - ローテーター一覧
                    │  - Paginator生成    │       - ページネーション
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | コントローラー | ローテーター管理の全アクション |
| Rotators.php | `application/models/Rotators.php` | モデル | ローテーターデータアクセス |
| manage.phtml | `application/modules/admin/views/scripts/rotators/manage.phtml` | ビュー | ローテーター一覧表示 |
| rotSlideCount | ビューヘルパー（推定） | ヘルパー | スライド数取得 |
