# 機能設計書 4-パスワード変更

## 概要

本ドキュメントは、LEGACY CMSにおけるパスワード変更機能の設計を記述したものである。管理者が特定ユーザーのパスワードをリセットし、新しいパスワードをメールで送信する仕様を定義する。

### 本機能の処理概要

**業務上の目的・背景**：システム管理者がユーザーからのパスワードリセット依頼に対応したり、セキュリティ上の理由でユーザーのパスワードを強制的に変更する必要がある場合に使用する。パスワードリセット機能（No.3）がユーザー自身による操作であるのに対し、本機能は管理者による操作である点が異なる。

**機能の利用シーン**：管理者がユーザー管理画面から特定ユーザーを選択し、「パスワードリセット」ボタンをクリックして実行する。確認ダイアログが表示され、確認後に新しいパスワードが生成されてユーザーにメールで送信される。

**主要な処理内容**：
1. 管理者による対象ユーザーの選択
2. 確認ダイアログの表示
3. 新しいパスワードとソルトの自動生成（8文字のランダム文字列）
4. データベースのパスワード情報を更新
5. 新しいパスワードをユーザーにメールで送信
6. 管理者への完了通知表示

**関連システム・外部連携**：Zend_Mailを使用してSMTP経由でパスワードリセット通知メールを送信する。

**権限による制御**：`uusers`（ユーザーモジュールアクセス）および`upassword`（パスワードリセット）権限が必要。これらの権限がないユーザーは権限エラー画面へリダイレクトされる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 27 | パスワード変更画面 | 主画面 | パスワードの変更処理を実行 |
| 34 | 管理者パスワード変更画面 | 主画面 | 管理者パスワードの変更処理 |

## 機能種別

パスワード管理 / メール送信 / 管理機能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | int | Yes | 対象ユーザーのID | isset, is_numeric |
| confirm | string | Yes | 確認フラグ（'1'で実行） | 値が'1'の場合のみ処理実行 |

### 入力データソース

URLパラメータ（GETリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTML | string | Ajaxダイアログ用HTML（確認画面または完了画面） |

### 出力先

- メール送信（新しいパスワードを含むテキストメール）
- データベース更新（users.user_password, users.user_salt）
- Ajaxダイアログ（確認画面/完了画面）

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ uusers + upassword 権限を確認
2. パラメータ取得
   └─ id（ユーザーID）とconfirm（確認フラグ）
3. 確認フラグの判定
   ├─ confirm != '1': 確認ダイアログを表示
   └─ confirm == '1': パスワードリセット処理を実行
4. ユーザー情報の取得
   └─ users + users_profilesテーブルをJOIN
5. 新しいパスワードとソルトの生成
   └─ generatePassword()で8文字のランダム文字列
6. データベースの更新
   └─ MD5ハッシュ化したパスワードとソルトを保存
7. メール送信
   └─ Zend_Mailで新しいパスワードを送信
8. 完了画面の表示
```

### フローチャート

```mermaid
flowchart TD
    A[パスワード変更リクエスト] --> B{権限チェック}
    B -->|権限なし| C[権限エラー画面]
    B -->|権限あり| D{confirm == 1?}
    D -->|No| E[確認ダイアログ表示]
    E --> F[ユーザー操作]
    F -->|確認| G[confirm=1で再リクエスト]
    G --> D
    F -->|キャンセル| H[ダイアログを閉じる]
    D -->|Yes| I[ユーザー情報取得]
    I --> J[新しいパスワード生成]
    J --> K[新しいソルト生成]
    K --> L[MD5ハッシュ化]
    L --> M[データベース更新]
    M --> N[メール送信]
    N --> O[完了画面表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 権限必須 | uusers + upassword 権限が必要 | 常時 |
| BR-002 | 確認必須 | 実行前に確認ダイアログを表示 | 常時 |
| BR-003 | メール通知 | パスワード変更後、対象ユーザーにメールで通知 | 常時 |

### 計算ロジック

パスワード生成・ハッシュ化はNo.3と同様:
- 使用文字: `abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ023456789`
- 長さ: 8文字
- ハッシュ: `MD5(site_key + password + salt)`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー情報取得 | users, users_profiles | SELECT | ユーザーIDでユーザーを検索 |
| パスワード更新 | users | UPDATE | 新しいパスワードとソルトを保存 |

### テーブル別操作詳細

#### users（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_id | パラメータのidと一致 | 検索条件 |
| SELECT | user_email | - | メール送信先 |

#### users_profiles（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | upro_userid | users.user_idと一致 | JOIN条件 |
| SELECT | upro_first, upro_last | - | メール宛名用 |

#### users（UPDATE）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | user_password | MD5(site_key + 新パスワード + 新ソルト) | ハッシュ化して保存 |
| UPDATE | user_salt | generatePassword()で生成した8文字 | ランダム値 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | uusers または upassword 権限がない | 権限エラー画面へフォワード |
| - | パラメータエラー | ユーザーIDが未指定 | 確認ダイアログを再表示 |

### リトライ仕様

メール送信失敗時のリトライ処理は実装されていない

## トランザクション仕様

明示的なトランザクション制御は実装されていない

## パフォーマンス要件

- レスポンス時間: メール送信を含むため2-3秒程度

## セキュリティ考慮事項

- 管理者権限（uusers + upassword）が必要
- 確認ダイアログによる誤操作防止
- パスワードはMD5ハッシュ化（現代のセキュリティ基準では脆弱）
- 新しいパスワードはメール本文に平文で記載
- メールには「管理者によってリセットされた」旨を記載

## 備考

- Ajaxダイアログとして実装されており、画面遷移なしで操作可能
- Dojo Toolkitを使用したUIコンポーネント

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パスワード変更に関連するテーブル構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブル（347-361行目）とusers_profilesテーブル（456-477行目）の構造 |

#### Step 2: エントリーポイントを理解する

パスワード変更処理の中心となるコントローラーを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | passwordAction()メソッド（263-340行目） |

**主要処理フロー**:
1. **265行目**: 権限チェック（`uusers` + `upassword`）
2. **267-268行目**: レイアウトとビューの無効化（Ajaxダイアログ用）
3. **270-271行目**: パラメータ取得（confirm, id）
4. **273行目**: 確認フラグの判定
5. **278-287行目**: ユーザー情報の取得
6. **289-290行目**: 新しいパスワードとソルトの生成
7. **292-295行目**: パスワードデータの準備
8. **297行目**: データベース更新
9. **299-310行目**: メール送信
10. **312-320行目**: 完了画面HTML出力

#### Step 3: パスワード生成ロジックを理解する

ランダムパスワード生成のアルゴリズムを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | generatePassword()メソッド（44-59行目） |

### プログラム呼び出し階層図

```
Admin_UsersController::passwordAction()
    │
    ├─ ACL権限チェック
    │      └─ $this->view->acl->isAllowed()
    │
    ├─ Zend_Db::select() (ユーザー情報取得)
    │      └─ users JOIN users_profiles
    │
    ├─ Admin_UsersController::generatePassword() x 2
    │      └─ ランダム文字列生成（パスワード用、ソルト用）
    │
    ├─ Zend_Db::update() (パスワード更新)
    │      └─ users テーブル
    │
    └─ Zend_Mail::send()
           └─ SMTP経由でメール送信
```

### データフロー図

```
[入力]               [処理]                    [出力]

id (ユーザーID) ───▶ SELECT users         ───▶ ユーザー情報
confirm (確認)        + users_profiles
                           │
                           ▼
                    generatePassword() x 2
                    (パスワード + ソルト生成)
                           │
                           ▼
                    MD5(site_key + password + salt)
                    (ハッシュ化)
                           │
                    ┌──────┴──────┐
                    ▼             ▼
              UPDATE users   Zend_Mail::send()
              (DB更新)       (メール送信)
                                  │
                                  ▼
                           Ajaxダイアログ
                           (完了画面HTML)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | コントローラー | パスワード変更処理の実装（44-59行目: generatePassword, 263-340行目: passwordAction） |
| Admin.php | `library/CMS/Controller/Action/Admin.php` | 親クラス | 管理画面コントローラーの基底クラス |
| Factory.php | `library/CMS/Acl/Factory.php` | ユーティリティ | ACLの生成 |
| database.sql | `database.sql` | DDL | usersテーブル定義 |
