# 機能設計書 40-ローテーター編集

## 概要

本ドキュメントは、LEGACY CMSにおけるローテーター編集機能の設計を記載したものである。ローテーターの詳細表示、およびスライドの新規作成・編集・削除を行う機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：CMSで管理するバナーローテーター（スライドショー）のスライドコンテンツを管理する。各スライドにはタイトル、キャプション、リンクURL、表示優先度、画像アセットを設定できる。フロントエンドサイトでのバナースライドショー表示に使用される。

**機能の利用シーン**：管理者がローテーター一覧画面から編集対象のローテーターを選択し、編集画面を開く。スライド一覧が表示され、新規スライドの作成、既存スライドの編集、不要スライドの削除を行う。

**主要な処理内容**：
1. ローテーター詳細情報の表示（名前、サイズ、ページング設定、遅延時間）
2. スライド一覧のページネーション付き表示
3. 新規スライドの作成（Ajaxダイアログ）
4. スライド情報の編集（Ajaxダイアログ）
5. スライドの削除（2段階確認）

**関連システム・外部連携**：Zend_Paginatorを使用したページネーション処理。Dojo Toolkitによるダイアログ表示（dijit.Dialog）。アセット管理機能との連携（画像選択）。

**権限による制御**：`rotrotators`および`rotrotatoredit`権限を持つユーザーのみローテーター編集機能を利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | ローテーター編集画面 | 主画面 | ローテーター詳細・スライド一覧表示 |
| - | スライド新規作成ダイアログ | サブ画面 | スライド新規作成 |
| - | スライド編集ダイアログ | サブ画面 | スライド情報編集 |
| - | スライド削除確認ダイアログ | サブ画面 | スライド削除確認 |

## 機能種別

CRUD操作 / スライド管理

## 入力仕様

### 入力パラメータ（編集画面アクセス）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | ローテーターID | 数値チェック |
| page | integer | No | スライド一覧のページ番号 | 正の整数 |

### 入力パラメータ（スライド新規作成・編集）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| slidetitle | string | Yes | スライドタイトル | NotEmpty |
| slidedescription | string | No | スライドキャプション | allowEmpty |
| slidelink | string | Yes | リンクURL | NotEmpty |
| slidepriority | string | Yes | 表示優先度 | NotEmpty |
| asset | integer | Yes | 画像アセットID | NotEmpty |

### 入力パラメータ（スライド削除）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | スライドID | - |
| confirm | string | No | 削除確認フラグ（'1'で実行） | - |

### 入力データソース

- URLパラメータ（id, page, confirm）
- フォーム入力（POST）
- アセット管理画面からの画像選択

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| rotatorArray | array | ローテーター詳細情報 |
| slidesArray | Zend_Paginator | スライド一覧（ページネーション付き） |
| slideArray | array | スライド詳細（編集時） |
| 成功/エラーメッセージ | HTML | 処理結果 |

### 出力先

- HTMLビュー（編集画面）
- Ajaxダイアログ（スライド操作）
- データベース

## 処理フロー

### 処理シーケンス（編集画面表示）

```
1. ローテーター編集画面アクセス
   └─ /admin/rotators/edit/id/{id}/
2. 権限チェック
   └─ rotrotators + rotrotatoredit
3. ローテーター詳細取得
   └─ Rotators::fetchRotator($id)
4. 存在チェック
   └─ 存在しない場合は一覧へリダイレクト
5. スライド一覧取得
   └─ Rotators::fetchSlides(rotator => $id)
6. ビュー表示
   └─ 詳細情報 + スライド一覧
```

### 処理シーケンス（スライド新規作成）

```
1. 新規作成ダイアログ表示
   └─ /admin/rotators/slidenew/rotator/{rotator}/
2. レイアウト無効化
3. フォーム入力
4. バリデーション
   └─ slidetitle, slidelink, slidepriority, asset: NotEmpty
5. スライド作成
   └─ Rotators::newSlide()
6. 成功メッセージ表示
```

### 処理シーケンス（スライド編集）

```
1. 編集ダイアログ表示
   └─ /admin/rotators/slide/id/{id}/
2. 権限チェック
   └─ rotrotators + rotrotatoredit
3. レイアウト無効化
4. スライド詳細取得
   └─ Rotators::fetchSlide($id)
5. フォーム編集
6. バリデーション
7. スライド更新
   └─ Rotators::updateSlide()
8. 成功メッセージ表示
```

### 処理シーケンス（スライド削除）

```
1. 削除確認ダイアログ表示
   └─ /admin/rotators/slidedelete/id/{id}/
2. 権限チェック
   └─ rotrotators + rotrotatoredit
3. confirm=1の場合
   └─ Rotators::deleteSlide($id)
4. 結果メッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    A[ローテーター編集開始] --> B{操作種別}
    B -->|編集画面| C[editAction]
    B -->|スライド新規| D[slidenewAction]
    B -->|スライド編集| E[slideAction]
    B -->|スライド削除| F[slidedeleteAction]

    C --> G{権限チェック}
    G -->|OK| H[ローテーター詳細取得]
    H --> I{存在確認}
    I -->|存在| J[スライド一覧取得]
    J --> K[ビュー表示]
    I -->|不存在| L[一覧へリダイレクト]
    G -->|NG| M[権限エラー]

    D --> N[フォーム表示/処理]
    N --> O{バリデーション}
    O -->|成功| P[newSlide実行]
    O -->|失敗| Q[エラー表示]

    E --> R{権限チェック}
    R -->|OK| S[スライド詳細取得]
    S --> T{POST?}
    T -->|Yes| U[バリデーション]
    U -->|成功| V[updateSlide実行]
    T -->|No| W[編集フォーム表示]

    F --> X{権限チェック}
    X -->|OK| Y{confirm=1?}
    Y -->|Yes| Z[deleteSlide実行]
    Y -->|No| AA[確認ダイアログ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-40-01 | スライドタイトル必須 | スライドにはタイトルが必須 | 新規作成・編集時 |
| BR-40-02 | リンク必須 | スライドにはリンクURLが必須 | 新規作成・編集時 |
| BR-40-03 | 優先度必須 | スライドには表示優先度（数値）が必須 | 新規作成・編集時 |
| BR-40-04 | 画像アセット必須 | スライドには画像アセットが必須 | 新規作成・編集時 |
| BR-40-05 | 削除2段階確認 | スライド削除はconfirm=1で実行 | 削除時 |
| BR-40-06 | スライド一覧ソート | タイトル昇順（rots_title ASC） | 一覧表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ローテーター詳細取得 | rotators | SELECT | ID指定で取得 |
| スライド一覧取得 | rotators_slides | SELECT | ローテーターID指定、タイトル昇順 |
| スライド詳細取得 | rotators_slides | SELECT | ID指定で取得 |
| スライド作成 | rotators_slides | INSERT | 新規スライド |
| スライド更新 | rotators_slides | UPDATE | スライド情報更新 |
| スライド削除 | rotators_slides | DELETE | スライド削除 |

### テーブル別操作詳細

#### rotators

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | rot_id, rot_name, rot_width, rot_height, rot_paging, rot_delay | rot_id = :id LIMIT 1 | 詳細取得 |

#### rotators_slides

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | rots_rotator = :rotator ORDER BY rots_title ASC | 一覧取得 |
| SELECT | 全項目 | rots_id = :id LIMIT 1 | 詳細取得 |
| INSERT | rots_title, rots_rotator, rots_description, rots_link, rots_order, rots_asset | フォーム入力値 | 新規作成 |
| UPDATE | rots_title, rots_description, rots_link, rots_order, rots_asset | フォーム入力値 WHERE rots_id = :id | 編集 |
| DELETE | - | rots_id = :id | 削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|-
| - | 権限エラー | rotrotators/rotrotatoredit権限なし | privileges画面へ転送 |
| - | 不存在エラー | 指定IDのローテーターが存在しない | 一覧画面へリダイレクト |
| - | タイトル未入力 | slidetitleが空 | 「Title is required」表示 |
| - | リンク未入力 | slidelinkが空 | 「Link is required」表示 |
| - | 優先度未入力 | slidepriorityが空 | 「Priority is required」表示 |
| - | アセット未選択 | assetが空 | 「Asset is required」表示 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

単一操作のため、明示的なトランザクション管理は不要。

## パフォーマンス要件

- ローテーター編集画面の表示は1秒以内
- スライド操作（作成/編集/削除）は0.5秒以内

## セキュリティ考慮事項

- 権限チェック（rotrotators + rotrotatoredit）によるアクセス制御
- Zend_Filter_Inputによる入力バリデーション
- スライド削除の2段階確認

## 備考

- ローテーター自体の設定（名前、サイズ等）はこの画面では編集不可（表示のみ）
- スライド操作はすべてAjaxダイアログで行い、操作後にページリロード
- 画像アセットはアセット管理画面から選択

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Rotatorsモデルクラスでテーブル構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Rotators.php | `application/models/Rotators.php` | 全体構造、テーブル操作メソッド |

**読解のコツ**: Rotatorsモデルは`rotators`テーブルと`rotators_slides`テーブルを扱う。fetchRotator()でローテーター詳細、fetchSlides()でスライド一覧、fetchSlide()でスライド詳細を取得。newSlide()、updateSlide()、deleteSlide()でスライドのCRUD操作を行う。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | editAction() 53-80行目 |

**主要処理フロー**:
1. **55行目**: 権限チェック（rotrotators + rotrotatoredit）
2. **57-58行目**: パラメータ設定（items=15, range=5）
3. **62行目**: ローテーターID取得
4. **66行目**: fetchRotator()でローテーター詳細取得
5. **68-70行目**: 存在チェック、なければリダイレクト
6. **72行目**: fetchSlides()でスライド一覧取得

#### Step 3: スライド作成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | slidenewAction() 85-166行目 |

**主要処理フロー**:
- **87行目**: レイアウト無効化
- **97-123行目**: バリデーター定義（slidetitle, slidelink, slidepriority, asset: NotEmpty）
- **127行目**: バリデーション実行
- **129-136行目**: newSlide()呼び出し
- **138-143行目**: 成功メッセージ出力

#### Step 4: スライド編集処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | slideAction() 171-257行目 |

**主要処理フロー**:
- **173行目**: 権限チェック
- **175行目**: レイアウト無効化
- **181行目**: fetchSlide()でスライド詳細取得
- **189-215行目**: バリデーター定義
- **221-227行目**: updateSlide()呼び出し

#### Step 5: スライド削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | slidedeleteAction() 262-302行目 |

**主要処理フロー**:
- **264行目**: 権限チェック
- **266-267行目**: レイアウト・ビュー無効化
- **272行目**: confirm=1の確認
- **275行目**: deleteSlide()呼び出し
- **286-292行目**: 確認ダイアログ表示

#### Step 6: モデル層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | Rotators.php | `application/models/Rotators.php` | fetchRotator() 103-116行目 |
| 6-2 | Rotators.php | `application/models/Rotators.php` | fetchSlides() 61-96行目 |
| 6-3 | Rotators.php | `application/models/Rotators.php` | fetchSlide() 123-136行目 |
| 6-4 | Rotators.php | `application/models/Rotators.php` | newSlide() 142-159行目 |
| 6-5 | Rotators.php | `application/models/Rotators.php` | updateSlide() 179-190行目 |
| 6-6 | Rotators.php | `application/models/Rotators.php` | deleteSlide() 165-173行目 |

**主要処理フロー**:
- **fetchRotator**: rot_id指定でrotatorsから1件取得
- **fetchSlides**: rots_rotator指定でrotators_slidesからページネーション付き取得
- **newSlide**: rotators_slidesへINSERT
- **updateSlide**: rotators_slidesをUPDATE
- **deleteSlide**: rotators_slidesからDELETE

#### Step 7: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 7-1 | edit.phtml | `application/modules/admin/views/scripts/rotators/edit.phtml` | 編集画面 |
| 7-2 | slidenew.phtml | `application/modules/admin/views/scripts/rotators/slidenew.phtml` | 新規作成フォーム |
| 7-3 | slide.phtml | `application/modules/admin/views/scripts/rotators/slide.phtml` | 編集フォーム |

**主要処理フロー**:
- **edit.phtml 35-41行目**: Functionsボタン（新規スライド、一覧へ戻る）
- **edit.phtml 46-58行目**: ローテーター詳細表示（名前、サイズ、ページング、遅延）
- **edit.phtml 64-93行目**: スライド一覧テーブル
- **slidenew.phtml 11-114行目**: 新規作成フォーム（タイトル、キャプション、リンク、優先度、画像）
- **slide.phtml 11-114行目**: 編集フォーム

### プログラム呼び出し階層図

```
Admin_RotatorsController
    │
    ├─ editAction() [編集画面表示]
    │      │
    │      └─ Rotators [モデル]
    │             ├─ fetchRotator($id)
    │             │      └─ $registry->db->select() -> fetchall()
    │             └─ fetchSlides($params)
    │                    ├─ $registry->db->select()
    │                    └─ Zend_Paginator::factory()
    │
    ├─ slidenewAction() [スライド新規作成]
    │      │
    │      ├─ Zend_Filter_Input [バリデーション]
    │      └─ Rotators::newSlide()
    │             └─ $registry->db->insert()
    │
    ├─ slideAction() [スライド編集]
    │      │
    │      ├─ Rotators::fetchSlide($id)
    │      ├─ Zend_Filter_Input [バリデーション]
    │      └─ Rotators::updateSlide()
    │             └─ $registry->db->update()
    │
    └─ slidedeleteAction() [スライド削除]
           │
           └─ Rotators::deleteSlide($id)
                  └─ $registry->db->delete()
```

### データフロー図

```
[入力]                     [処理]                           [出力]

id（ローテーターID）  ┌─────────────────────┐
                ────▶│ editAction()        │
page（ページ番号）    │                     │
                ────▶│  - 権限チェック      │────▶  ビュー(edit.phtml)
                     │  - ローテーター取得   │       - 詳細表示
                     │  - スライド一覧取得   │       - スライド一覧
                     └─────────────────────┘

rotator,             ┌─────────────────────┐
slidetitle,     ────▶│ slidenewAction()    │────▶  INSERT
slidedescription,    │  - バリデーション    │       rotators_slides
slidelink,           │  - newSlide()       │
slidepriority,       └─────────────────────┘
asset

id,                  ┌─────────────────────┐
slidetitle,     ────▶│ slideAction()       │────▶  UPDATE
slidedescription,    │  - fetchSlide()     │       rotators_slides
slidelink,           │  - バリデーション    │
slidepriority,       │  - updateSlide()    │
asset                └─────────────────────┘

id,                  ┌─────────────────────┐
confirm         ────▶│ slidedeleteAction() │────▶  DELETE
                     │  - 確認チェック      │       rotators_slides
                     │  - deleteSlide()    │
                     └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | コントローラー | ローテーター管理の全アクション |
| Rotators.php | `application/models/Rotators.php` | モデル | ローテーター・スライドデータアクセス |
| edit.phtml | `application/modules/admin/views/scripts/rotators/edit.phtml` | ビュー | ローテーター編集画面 |
| slidenew.phtml | `application/modules/admin/views/scripts/rotators/slidenew.phtml` | ビュー | スライド新規作成フォーム |
| slide.phtml | `application/modules/admin/views/scripts/rotators/slide.phtml` | ビュー | スライド編集フォーム |
