# 機能設計書 41-スライド新規作成

## 概要

本ドキュメントは、LEGACY CMSのローテーター管理機能における「スライド新規作成」機能の設計仕様を定義する。

### 本機能の処理概要

ローテーター（バナースライダー）に新しいスライドを追加するための機能である。管理者はAjaxダイアログを通じてスライドのタイトル、説明文、リンクURL、表示優先度、および画像アセットを設定し、ローテーターに新規スライドを登録できる。

**業務上の目的・背景**：Webサイトのトップページやサイドバーなどに表示されるバナーローテーターは、サイトの視覚的な訴求力を高める重要な要素である。新しいプロモーション、お知らせ、特集コンテンツなどを効果的にユーザーに伝えるため、管理者が容易にスライドを追加できる機能が必要となる。本機能により、技術的な知識がなくても視覚的なコンテンツを柔軟に管理できる。

**機能の利用シーン**：新製品の告知バナーを追加する場合、季節のキャンペーン情報を掲載する場合、イベントの宣伝用スライドを作成する場合など、サイトのビジュアルコンテンツを更新する際に使用される。ローテーター編集画面から「New Slide」ボタンをクリックすることでAjaxダイアログが開き、スライド情報を入力する。

**主要な処理内容**：
1. Ajaxダイアログでスライド作成フォームを表示
2. 入力値（タイトル、説明、リンク、優先度、画像）のバリデーション
3. rotators_slidesテーブルへの新規レコード挿入
4. 作成完了メッセージの表示とダイアログクローズ

**関連システム・外部連携**：アセット管理システムと連携し、スライド画像の選択機能を提供する。Dojo Toolkitを使用したAjaxダイアログでユーザーインターフェースを実現している。

**権限による制御**：`rotrotators`（ローテーターモジュールアクセス権限）と`rotrotatoredit`（ローテーター編集権限）の両方を持つユーザーのみがスライドを作成できる。権限がない場合は権限エラー画面に遷移する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 90 | スライド新規作成画面 | 主画面 | 新規スライドの作成処理 |
| 88 | ローテーター編集画面 | 遷移元画面 | 「New Slide」ボタンからダイアログを開く |
| 83 | 画像挿入画面 | 参照画面 | スライド画像の選択 |

## 機能種別

CRUD操作（Create） / Ajaxダイアログ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| rotator | integer | Yes | 対象ローテーターのID | URLパラメータから取得 |
| slidetitle | string | Yes | スライドのタイトル | NotEmpty、空文字不可 |
| slidedescription | string | No | スライドの説明文（キャプション） | allowEmpty: true |
| slidelink | string | Yes | クリック時の遷移先URL | NotEmpty、空文字不可 |
| slidepriority | integer | Yes | 表示優先度（数値） | NotEmpty、空文字不可 |
| asset | string | Yes | 画像アセットのキー | NotEmpty、空文字不可 |

### 入力データソース

- rotator: URLパラメータから取得（/admin/rotators/slidenew/rotator/{id}/）
- その他: POSTリクエストのフォームデータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 成功メッセージ | HTML | 「Slide Created」のメッセージと閉じるボタン |
| エラーメッセージ | array | バリデーションエラー時のメッセージ配列 |

### 出力先

- Ajaxダイアログ内にHTMLレスポンスとして出力
- rotators_slidesテーブルに新規レコードを挿入

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ slidenewActionがコールされる
2. レイアウト無効化
   └─ Ajaxダイアログ用にレイアウトを無効化
3. POSTリクエスト判定
   └─ POSTでない場合はフォームを表示
4. バリデーション実行
   └─ Zend_Filter_Inputでフォーム入力を検証
5. バリデーション結果判定
   └─ 失敗時: エラーメッセージを設定してフォーム再表示
   └─ 成功時: 次のステップへ
6. データベース挿入
   └─ Rotators::newSlide()でrotators_slidesに挿入
7. 成功レスポンス出力
   └─ 「Slide Created」メッセージとCloseボタンを表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[レイアウト無効化]
    B --> C{POSTリクエスト?}
    C -->|No| D[フォーム表示]
    C -->|Yes| E[バリデーション実行]
    E --> F{バリデーション成功?}
    F -->|No| G[エラーメッセージ設定]
    G --> D
    F -->|Yes| H[newSlide実行]
    H --> I[rotators_slides INSERT]
    I --> J[成功メッセージ出力]
    J --> K[終了]
    D --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-41-01 | タイトル必須 | スライドのタイトルは必須入力 | 常時 |
| BR-41-02 | リンク必須 | 遷移先URLは必須入力 | 常時 |
| BR-41-03 | 優先度必須 | 表示順序を決める優先度は必須 | 常時 |
| BR-41-04 | 画像必須 | スライド画像は必須選択 | 常時 |
| BR-41-05 | 権限チェック | rotrotatorsとrotrotatoredit権限が必要 | 常時 |

### 計算ロジック

特になし。優先度(rots_order)は数値として保存され、一覧表示時のソート順序に使用される。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スライド作成 | rotators_slides | INSERT | 新規スライドレコードを挿入 |

### テーブル別操作詳細

#### rotators_slides

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | rots_title | フォーム入力値(slidetitle) | スライドタイトル |
| INSERT | rots_rotator | URLパラメータ(rotator) | 所属ローテーターID |
| INSERT | rots_description | フォーム入力値(slidedescription) | キャプション |
| INSERT | rots_link | フォーム入力値(slidelink) | 遷移先URL |
| INSERT | rots_order | フォーム入力値(slidepriority) | 表示優先度 |
| INSERT | rots_asset | フォーム入力値(asset) | 画像アセットキー |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | タイトルが空 | 「Title is required」メッセージ表示 |
| - | バリデーションエラー | リンクが空 | 「Link is required」メッセージ表示 |
| - | バリデーションエラー | 優先度が空 | 「Priority is required」メッセージ表示 |
| - | バリデーションエラー | アセットが空 | 「Asset is required」メッセージ表示 |
| Exception | パラメータ不正 | titleがNULL | 「Invalid parameters」例外をスロー |

### リトライ仕様

特になし。バリデーションエラー時は入力値を保持してフォームを再表示する。

## トランザクション仕様

単一のINSERT操作のため、明示的なトランザクション制御は行っていない。

## パフォーマンス要件

- Ajaxダイアログのレスポンス時間: 1秒以内
- レイアウトを無効化することでレスポンスサイズを最小化

## セキュリティ考慮事項

- ACLによるアクセス制御（rotrotators, rotrotatoredit権限の確認）
- Zend_Filter_Inputによる入力値のサニタイズ
- StringTrimフィルターは明示的に定義されていないが、Dojoウィジェットでtrim="true"を設定

## 備考

- Dojo Toolkitのdijit.form.ValidationTextBoxを使用したクライアントサイドバリデーションも実装されている
- 画像選択はアセット管理機能と連携し、openAssetMan()関数でポップアップ表示される
- 作成完了後、location.reload(true)でページ全体をリロードしてスライド一覧を更新する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、スライドデータの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | rotators_slidesテーブルの構造を確認（320-329行目） |

**読解のコツ**: rotators_slidesテーブルは親テーブルrotatorsとrots_rotatorカラムで関連付けられている。rots_assetはassetsテーブルのasset_keyと関連する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | slidenewActionメソッド（85-166行目） |

**主要処理フロー**:
1. **85-89行目**: アクションの開始、レイアウト無効化、rotatorパラメータ取得
2. **91-123行目**: POSTリクエスト時のバリデータ定義
3. **125行目**: Zend_Filter_Inputでバリデーション実行
4. **127-143行目**: バリデーション成功時の処理（newSlide呼び出し、成功メッセージ出力）
5. **145-157行目**: バリデーション失敗時の処理（エラーメッセージ設定、入力値保持）

#### Step 3: モデル層を理解する

データベース操作を行うモデルクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Rotators.php | `application/models/Rotators.php` | newSlideメソッド（142-159行目） |

**主要処理フロー**:
- **144行目**: タイトルの存在チェック
- **146-153行目**: 挿入データ配列の構築
- **155行目**: rotators_slidesテーブルへのINSERT実行

#### Step 4: ビュー層を理解する

フォーム表示を行うビューファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | slidenew.phtml | `application/modules/admin/views/scripts/rotators/slidenew.phtml` | フォームHTML構造（11-114行目） |

**主要処理フロー**:
- **11行目**: Dojoフォームの開始
- **14-25行目**: タイトル入力フィールド（ValidationTextBox）
- **43-54行目**: リンク入力フィールド
- **58-70行目**: 優先度入力フィールド（正規表現バリデーション）
- **84-95行目**: アセット選択フィールドとブラウズボタン
- **101-106行目**: 送信ボタン（doDialog関数呼び出し）

### プログラム呼び出し階層図

```
Admin_RotatorsController::slidenewAction()
    │
    ├─ $this->_helper->layout->disableLayout()
    │      └─ レイアウト無効化
    │
    ├─ new Zend_Filter_Input()
    │      └─ POSTデータのバリデーション
    │
    └─ Rotators::newSlide()
           └─ $registry->db->insert('rotators_slides', $data)
                  └─ MySQLへのINSERT実行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

POSTデータ            RotatorsController            rotators_slides
  - slidetitle    ─────▶  ::slidenewAction()   ─────▶  テーブル
  - slidedescription      │                           │
  - slidelink             ├─ バリデーション            ├─ rots_title
  - slidepriority         │                           ├─ rots_description
  - asset                 └─ Rotators::newSlide()     ├─ rots_link
                                │                      ├─ rots_order
URLパラメータ                    │                      ├─ rots_asset
  - rotator       ─────────────┘                      └─ rots_rotator
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | コントローラー | スライド新規作成アクションの定義 |
| Rotators.php | `application/models/Rotators.php` | モデル | スライドのCRUD操作 |
| slidenew.phtml | `application/modules/admin/views/scripts/rotators/slidenew.phtml` | ビュー | スライド作成フォームのHTML |
| database.sql | `database.sql` | スキーマ | rotators_slidesテーブル定義 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | doDialog関数等の共通処理 |
