# 機能設計書 43-スライド削除

## 概要

本ドキュメントは、LEGACY CMSのローテーター管理機能における「スライド削除」機能の設計仕様を定義する。

### 本機能の処理概要

ローテーターから不要になったスライドを削除するための機能である。管理者はAjaxダイアログで削除確認を行い、確認後にスライドをデータベースから完全に削除する。削除操作は2段階（確認→実行）で行われ、誤操作を防止する。

**業務上の目的・背景**：キャンペーン終了後の告知バナーや、期限切れのプロモーションスライドなど、不要になったコンテンツをローテーターから削除する必要がある。放置された古いスライドは、ユーザーに誤った情報を伝える可能性があるため、適切なタイミングで削除できる機能が重要である。

**機能の利用シーン**：キャンペーン終了後のバナー削除、イベント終了後の告知スライド削除、リンク切れスライドの整理、デザイン刷新に伴う古いスライドの一括整理など、不要になったスライドを管理画面から削除する際に使用される。

**主要な処理内容**：
1. 削除対象スライドの確認ダイアログを表示
2. 「Delete」ボタン押下で削除を確定
3. rotators_slidesテーブルから対象レコードを削除
4. 削除完了メッセージの表示とダイアログクローズ

**関連システム・外部連携**：Dojo Toolkitを使用したAjaxダイアログで確認・削除インターフェースを実現している。画像アセット自体は削除されず、スライドとの紐付けのみが解除される。

**権限による制御**：`rotrotators`（ローテーターモジュールアクセス権限）と`rotrotatoredit`（ローテーター編集権限）の両方を持つユーザーのみがスライドを削除できる。権限がない場合は権限エラー画面に遷移する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | ローテーター編集画面 | 主画面 | スライド削除ダイアログへの遷移 |
| - | 削除確認ダイアログ | 補助画面 | 削除確認と実行 |

## 機能種別

CRUD操作（Delete） / Ajaxダイアログ処理 / 確認ダイアログ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | 対象スライドのID | URLパラメータから取得、数値チェック |
| confirm | string | No | 削除確認フラグ | '1'の場合に削除実行 |

### 入力データソース

- id: URLパラメータから取得（/admin/rotators/slidedelete/id/{id}/）
- confirm: URLパラメータから取得（/admin/rotators/slidedelete/id/{id}/confirm/1/）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 確認メッセージ | HTML | 「Are you sure you want to delete this slide?」メッセージと削除/キャンセルボタン |
| 完了メッセージ | HTML | 「Slide Deleted」のメッセージと閉じるボタン |

### 出力先

- Ajaxダイアログ内にHTMLレスポンスとして出力
- rotators_slidesテーブルから対象レコードを削除

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ slidedeleteActionがコールされる
2. 権限チェック
   └─ rotrotators, rotrotatoredit権限を確認
3. レイアウト・ビュー無効化
   └─ Ajaxレスポンス用に無効化
4. パラメータ取得
   └─ id, confirmパラメータを取得
5. 確認フラグ判定
   └─ confirm='1'でない場合: 確認ダイアログを表示
   └─ confirm='1'の場合: 次のステップへ
6. データベース削除
   └─ Rotators::deleteSlide()でrotators_slidesから削除
7. 完了レスポンス出力
   └─ 「Slide Deleted」メッセージとCloseボタンを表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{権限チェック}
    B -->|NG| C[権限エラー画面へ]
    B -->|OK| D[レイアウト・ビュー無効化]
    D --> E[パラメータ取得]
    E --> F{confirm='1'?}
    F -->|No| G[確認ダイアログ表示]
    G --> H[ユーザー選択待ち]
    H -->|Cancel| I[ダイアログクローズ]
    H -->|Delete| J[confirm=1で再リクエスト]
    J --> F
    F -->|Yes| K{IDが有効?}
    K -->|No| L[エラー]
    K -->|Yes| M[deleteSlide実行]
    M --> N[rotators_slides DELETE]
    N --> O[完了メッセージ出力]
    O --> P[終了]
    I --> P
    C --> P
    L --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-43-01 | 削除確認必須 | 削除前に確認ダイアログを表示する | 常時 |
| BR-43-02 | 権限チェック | rotrotatorsとrotrotatoredit権限が必要 | 常時 |
| BR-43-03 | ID必須 | 削除対象のスライドIDは必須 | 常時 |
| BR-43-04 | 確認後削除 | confirm=1の場合のみ実際に削除を実行 | 削除実行時 |
| BR-43-05 | アセット保持 | スライド削除時、関連アセットは削除しない | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スライド削除 | rotators_slides | DELETE | 対象スライドレコードを削除 |

### テーブル別操作詳細

#### rotators_slides

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE rots_id = {id} | 対象レコードを完全削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | rotrotators/rotrotatoredit権限なし | privileges画面へフォワード |
| Exception | IDエラー | IDが未設定または非数値 | 「Invalid slide id」例外をスロー |

### リトライ仕様

特になし。削除操作は冪等性を持たないため、1回限りの操作となる。

## トランザクション仕様

単一のDELETE操作のため、明示的なトランザクション制御は行っていない。

## パフォーマンス要件

- Ajaxダイアログのレスポンス時間: 1秒以内
- レイアウトとビューを無効化することでレスポンスサイズを最小化

## セキュリティ考慮事項

- ACLによるアクセス制御（rotrotators, rotrotatoredit権限の確認）
- 2段階削除による誤操作防止（確認→実行）
- IDパラメータの数値チェック（is_numeric）

## 備考

- 削除完了後、location.reload(true)でページ全体をリロードしてスライド一覧を更新する
- 画像アセット自体はassetsテーブルに残り、削除されない
- 物理削除のため、削除後のデータ復旧は不可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、スライドデータの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | rotators_slidesテーブルの構造を確認（320-329行目） |

**読解のコツ**: rots_idが主キーであり、削除時はこのカラムで対象を特定する。rots_assetはassetsテーブルへの参照だが、CASCADE DELETEは設定されていない。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | slidedeleteActionメソッド（262-302行目） |

**主要処理フロー**:
1. **264行目**: ACL権限チェック（rotrotators AND rotrotatoredit）
2. **266-267行目**: レイアウト・ビューレンダラー無効化
3. **269-270行目**: confirm, idパラメータ取得
4. **272行目**: confirm='1' AND idが設定されているかの判定
5. **274-275行目**: 削除実行（deleteSlide呼び出し）
6. **277-282行目**: 削除完了メッセージ出力
7. **286-292行目**: 確認ダイアログの表示（confirm未設定時）

#### Step 3: モデル層を理解する

データベース操作を行うモデルクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Rotators.php | `application/models/Rotators.php` | deleteSlideメソッド（165-173行目） |

**主要処理フロー**:
- **167行目**: IDの存在確認と数値チェック
- **169行目**: DELETEクエリ実行
- **171行目**: IDが不正な場合の例外スロー

### プログラム呼び出し階層図

```
Admin_RotatorsController::slidedeleteAction()
    │
    ├─ $this->view->acl->isAllowed()
    │      └─ 権限チェック
    │
    ├─ $this->_helper->layout()->disableLayout()
    │      └─ レイアウト無効化
    │
    ├─ $this->_helper->viewRenderer->setNoRender(true)
    │      └─ ビューレンダラー無効化
    │
    ├─ [confirm != '1'] echo 確認ダイアログHTML
    │      └─ 削除確認メッセージ表示
    │
    └─ [confirm == '1'] Rotators::deleteSlide($id)
           └─ $registry->db->delete('rotators_slides', 'rots_id = '.$id)
                  └─ MySQLへのDELETE実行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ            RotatorsController
  - id            ─────▶  ::slidedeleteAction()  ─────▶ rotators_slides
  - confirm               │                            テーブル
                          │                            │
                          ├─ [confirm != '1']          └─ DELETE WHERE
                          │   └─ 確認ダイアログ表示       rots_id = {id}
                          │
                          └─ [confirm == '1']
                              └─ deleteSlide($id)
                                  └─ DELETE実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RotatorsController.php | `application/modules/admin/controllers/RotatorsController.php` | コントローラー | スライド削除アクションの定義 |
| Rotators.php | `application/models/Rotators.php` | モデル | スライドの削除操作 |
| database.sql | `database.sql` | スキーマ | rotators_slidesテーブル定義 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | getDialog関数等の共通処理 |
