# 機能設計書 44-コメント一覧表示

## 概要

本ドキュメントは、LEGACY CMSのコメント管理機能における「コメント一覧表示」機能の設計仕様を定義する。

### 本機能の処理概要

システムに投稿されたすべてのコメントをページネーション付きで一覧表示する機能である。管理者は投稿者、コンテンツタイプ、紐づくコンテンツでフィルタリングしながらコメントを確認・管理できる。コメントの承認状態が視覚的に区別され、承認・非承認・削除の操作へ遷移できる。

**業務上の目的・背景**：CMSでは記事、ページ、イベントなど様々なコンテンツに対してユーザーがコメントを投稿できる。これらのコメントを一元的に管理し、不適切なコメントの削除やモデレーション（承認管理）を行う必要がある。コメント一覧機能により、管理者はサイト全体のコメント状況を把握し、迅速に対応できる。

**機能の利用シーン**：投稿されたコメントの確認、スパムコメントの検出と削除、未承認コメントの承認作業、特定ユーザーのコメント履歴の確認、特定記事へのコメント状況の把握など、コメント管理業務全般で使用される。

**主要な処理内容**：
1. フィルター条件の取得（著者、タイプ、スレーブID）
2. コメントデータの取得とユーザー情報のJOIN
3. ページネーション処理（15件/ページ）
4. コメント一覧の表示（承認状態を視覚的に区別）

**関連システム・外部連携**：ユーザー管理システムと連携し、コメント投稿者の情報（エイリアス、ロール）を表示する。記事、ページ、イベントなど複数のコンテンツタイプのコメントを横断的に管理する。

**権限による制御**：`gcomments`（コメントモジュールアクセス権限）を持つユーザーのみがコメント一覧を表示できる。権限がない場合は権限エラー画面に遷移する。追加で`gcommentsstatus`権限があれば承認操作、`gcommentdelete`権限があれば削除操作が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 85 | コメント管理画面 | 主画面 | コメント一覧を表示 |
| 13 | 記事詳細画面 | 参照元画面 | 記事に紐づくコメントを表示 |
| 23 | 静的ページ画面 | 参照元画面 | ページに紐づくコメントを表示 |
| 51 | イベント詳細画面 | 参照元画面 | イベントに紐づくコメントを表示 |

## 機能種別

CRUD操作（Read） / 一覧表示 / ページネーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| type | string | No | コンテンツタイプ（A:記事, P:ページ, E:イベント, U:ユーザー） | 1文字のタイプコード |
| slave | integer | No | 紐づくコンテンツのID | 数値 |
| author | integer | No | 投稿者のユーザーID | 数値 |
| page | integer | No | ページ番号（デフォルト: 1） | 数値 |

### 入力データソース

- type, slave, author, page: リクエストパラメータから取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| commentArray | Paginator | コメント一覧（ページネーション付き） |
| type | string | フィルター中のコンテンツタイプ |
| slave | integer | フィルター中のコンテンツID |
| author | string | フィルター中の著者名 |
| page | integer | 現在のページ番号 |

### 出力先

- 管理画面のコメント一覧ビュー（manage.phtml）

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ manageActionがコールされる
2. 権限チェック
   └─ gcomments権限を確認
3. レイアウト設定
   └─ 管理画面レイアウトを適用
4. パラメータ取得
   └─ type, slave, author, pageパラメータを取得
5. クエリ構築
   └─ フィルター条件に応じてSELECT文を構築
6. データ取得
   └─ comments + users + users_rolesをJOINして取得
7. ページネーション設定
   └─ 15件/ページ、5ページ範囲
8. ビューへデータ渡し
   └─ commentArrayとフィルター情報を設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{権限チェック}
    B -->|NG| C[権限エラー画面へ]
    B -->|OK| D[レイアウト設定]
    D --> E[パラメータ取得]
    E --> F{フィルター条件?}
    F -->|type+slave+author| G[3条件でクエリ構築]
    F -->|authorのみ| H[著者条件でクエリ構築]
    F -->|type+slave| I[タイプ+スレーブでクエリ構築]
    F -->|条件なし| J[全件クエリ構築]
    G --> K[JOINでユーザー情報取得]
    H --> K
    I --> K
    J --> K
    K --> L[Paginator作成]
    L --> M[ビューへ渡す]
    M --> N[終了]
    C --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-44-01 | 権限チェック | gcomments権限が必要 | 常時 |
| BR-44-02 | ページネーション | 1ページ15件、ページ範囲5 | 常時 |
| BR-44-03 | 承認状態表示 | 未承認コメントは視覚的に区別 | 常時 |
| BR-44-04 | 日付順ソート | 投稿日時の降順で表示 | 常時 |
| BR-44-05 | フィルター組み合わせ | type+slave、authorは組み合わせ可能 | フィルター使用時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コメント一覧取得 | comments | SELECT | コメント一覧を取得 |
| ユーザー情報取得 | users | JOIN | 投稿者情報を取得 |
| ロール情報取得 | users_roles | JOIN | 投稿者のロール情報を取得 |
| 著者名取得 | users | SELECT | フィルター用の著者名を取得 |

### テーブル別操作詳細

#### comments（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | comment_id | - | コメントID |
| SELECT | comment_type | WHERE comment_type = {type} | コンテンツタイプ（フィルター） |
| SELECT | comment_slave | WHERE comment_slave = {slave} | 紐づくコンテンツID（フィルター） |
| SELECT | comment_user | WHERE comment_user = {author} | 投稿者ID（フィルター） |
| SELECT | comment_date | ORDER BY DESC | 投稿日時（ソート） |
| SELECT | comment_content | - | コメント本文 |
| SELECT | comment_approved | - | 承認状態（Y/N） |

#### users（JOIN）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| JOIN | user_id | comment_user = user_id | JOINキー |
| SELECT | user_alias | - | 投稿者のエイリアス名 |
| SELECT | user_role | - | ロールID |

#### users_roles（JOIN）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| JOIN | role_id | user_role = role_id | JOINキー |
| SELECT | role_colour | - | ロールの表示色 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | gcomments権限なし | privileges画面へフォワード |
| - | データなし | コメントが0件 | 「No Comments!」メッセージ表示 |

### リトライ仕様

特になし。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。

## パフォーマンス要件

- 一覧表示のレスポンス時間: 2秒以内
- ページネーションにより1回の取得件数を制限（15件）

## セキュリティ考慮事項

- ACLによるアクセス制御（gcomments権限の確認）
- XSS対策: コメント内容の表示時にエスケープ処理

## 備考

- コメントタイプ: A=Article（記事）, P=Page（ページ）, E=Event（イベント）, U=User（ユーザー）
- フィルターはタグ形式で表示され、クリックで解除可能
- 承認状態によってコメントの背景色が変わる（notapprovedクラス）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コメントとユーザーのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | commentsテーブルの構造を確認（87-97行目） |
| 1-2 | database.sql | `database.sql` | usersテーブルの構造を確認（347-361行目） |
| 1-3 | database.sql | `database.sql` | users_rolesテーブルの構造を確認（576-581行目） |

**読解のコツ**: comment_typeは1文字のコード（A/P/E/U）、comment_slaveは紐づくコンテンツのID、comment_approvedはY/Nの文字列。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | manageActionメソッド（53-124行目） |

**主要処理フロー**:
1. **55行目**: ACL権限チェック（gcomments）
2. **57行目**: setLayout()でadminレイアウト設定
3. **59-70行目**: type, slave, author, pageパラメータ取得
4. **75-107行目**: フィルター条件に応じたSELECTクエリ構築
5. **109-113行目**: Paginator設定（15件/ページ、5ページ範囲）
6. **116行目**: ビューにcommentArray渡し

#### Step 3: モデル層を理解する

コメントのCRUD操作を行うモデルクラスを確認する（ただしこの機能ではコントローラーで直接クエリ構築）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Comments.php | `application/models/Comments.php` | fetchCommentsメソッド（24-79行目）※この機能では未使用 |

**読解のコツ**: manageActionではCommentsモデルを使わず、コントローラー内で直接クエリを構築している。fetchCommentsメソッドは別の機能（フロントエンド表示）で使用される。

#### Step 4: ビュー層を理解する

一覧表示を行うビューファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | manage.phtml | `application/modules/admin/views/scripts/comments/manage.phtml` | コメント一覧HTML構造（31-85行目） |

**主要処理フロー**:
- **31-38行目**: フィルタータグの表示（クリックで解除可能）
- **40-73行目**: コメント一覧のループ表示
- **42行目**: 承認状態による背景色の切り替え（notapprovedクラス）
- **43-55行目**: 権限に応じた承認/削除ボタンの表示
- **78-82行目**: ページネーションコントロールの表示

### プログラム呼び出し階層図

```
Admin_CommentsController::manageAction()
    │
    ├─ $this->view->acl->isAllowed()
    │      └─ 権限チェック（gcomments）
    │
    ├─ $this->setLayout()
    │      └─ adminレイアウト設定
    │
    ├─ $this->getAuthor($authorid)
    │      └─ 著者名取得（フィルター用）
    │
    ├─ $registry->db->select()
    │      ├─ ->from('comments')
    │      ├─ ->join('users')
    │      ├─ ->where() [フィルター条件]
    │      └─ ->order('comment_date DESC')
    │
    └─ Zend_Paginator::factory($select)
           ├─ setCurrentPageNumber()
           ├─ setItemCountPerPage(15)
           └─ setPageRange(5)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

リクエストパラメータ       CommentsController            ビュー
  - type           ─────▶  ::manageAction()      ─────▶ manage.phtml
  - slave                  │                            │
  - author                 ├─ SELECT構築                ├─ コメント一覧
  - page                   │   + JOIN users             ├─ ページネーション
                           │   + JOIN users_roles       └─ フィルタータグ
                           │
                           └─ Paginator作成
                               └─ 15件/ページ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | コントローラー | コメント一覧アクションの定義 |
| Comments.php | `application/models/Comments.php` | モデル | コメントのCRUD操作 |
| manage.phtml | `application/modules/admin/views/scripts/comments/manage.phtml` | ビュー | コメント一覧のHTML |
| database.sql | `database.sql` | スキーマ | comments, users, users_rolesテーブル定義 |
| comments.js | `public/_scripts/admin/comments.js` | JavaScript | コメント操作の共通処理 |
| CommentCount.php | `application/modules/admin/views/helpers/CommentCount.php` | ヘルパー | コメント数カウント |
